<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/> 
<uix:document> 

	<uix:metaContainer>
		<uix:head titleBinding="title@defaultBean@servletRequest"/>
	</uix:metaContainer>

	<uix:body>
	<uix:form name="listenerForm" method="post" destinationBinding="defaultControllerURL@defaultBean@servletRequest">
		<uix:formValue name="pageName" value="/net/listener/applyOption"/>

	<uix:pageLayout title="">
	<%@ include file="/oemGlobal.jspf" %>
	<uix:header icon="/em/images/confirmation.gif" textBinding="header@defaultBean@pageContext">

	        <oem:messageBox messageType = "error" msgBundleBinding="ListenerMsg@servletRequest" errorTableBinding="errors@servletRequest"
		                      titleTextKey="titleText" mainTextKey="mainText"/>
  	        <uix:flowLayout>
 	        <uix:spacer width="5"/>				
		<uix:tableLayout cellSpacing="5" >
          	   <uix:rowLayout>
			<uix:stackLayout>
	        	      <uix:styledText styleClass="OraInstructionText" textBinding="restartTip@defaultBean@servletRequest"/>
        	         <uix:switcher childNameBinding ="targetChange@defaultBean@servletRequest" >
			 <uix:case name="true">
	        	      <uix:styledText styleClass="OraInstructionText" textBinding="targetChangeTip@defaultBean@servletRequest"/>
		 	 </uix:case>
        	        </uix:switcher>

        	        <uix:switcher childNameBinding ="listenerState@defaultBean@servletRequest" >
			<uix:case name="true">
	        	     <uix:styledText styleClass="OraInstructionText" textBinding="APPLY_OPTION_DESC@ListenerBundle@servletRequest"  />
		 	 </uix:case>
        	        </uix:switcher>

			</uix:stackLayout>
          	   </uix:rowLayout>

          	   <uix:rowLayout>
			<uix:stackLayout>

	        	        <uix:switcher childNameBinding ="listenerState@defaultBean@servletRequest" >
        			<uix:case name="true">
				<uix:tableLayout cellSpacing="5">
                		  <uix:rowLayout>
					<uix:stackLayout>
					 <oem:radioButton
					          name="startListener"
					          textBinding="RESTART_LSN_OPTION@ListenerBundle@servletRequest"
					          selectedValueBinding="startListener@defaultBean@servletRequest"
					          value="true"/>
					</uix:stackLayout>
                		  </uix:rowLayout>

                		  <uix:rowLayout>
					  <uix:stackLayout>	
					  <oem:radioButton
					          name="startListener"
					          textBinding="NO_RESTART_LSN_OPTION@ListenerBundle@servletRequest"
					          selectedValueBinding="startListener@defaultBean@servletRequest"
					          value="false"/>
			                    <uix:messageText messageType="info" messageBinding="NO_RESTART_LSN_OPTION_TIP@ListenerBundle@servletRequest"/>
					  </uix:stackLayout>	
                		  </uix:rowLayout>
				</uix:tableLayout>

        			</uix:case>
	        	        </uix:switcher>
			</uix:stackLayout>
             	</uix:rowLayout>
		</uix:tableLayout>
	    </uix:flowLayout>
	</uix:header> 

	<uix:pageButtons>
		<uix:pageButtonBar>
    	          <uix:submitButton textBinding="CANCEL@defaultMsgBundle@servletRequest" 
				  	name="event" value="cancel" shortDescBinding="CANCEL@defaultMsgBundle@servletRequest"/>
    	          <uix:submitButton textBinding="OK@defaultMsgBundle@servletRequest" 
				  	name="event" value="apply" shortDescBinding="OK@defaultMsgBundle@servletRequest"/>
		</uix:pageButtonBar>
	</uix:pageButtons>

	</uix:pageLayout> 

	  </uix:form>
	</uix:body>

 </uix:document> 
</uix:renderingContext> 

