<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.db.rsc.net.NetMsg" %>
<%
request.setAttribute("netBundle", new BundleDataObject(NLSUtil.getBundle(NetMsg.class.getName(), request)));
%>
<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/> 
<uix:document> 

	<uix:metaContainer>
		<uix:head titleBinding="TITLE@servletRequest"/>
	</uix:metaContainer>

       <uix:body>
	<uix:form name="listenerForm" method="post" destinationBinding="defaultControllerURL@defaultBean@servletRequest">
		<uix:formValue name="pageName" value="/net/listener/authenticationTab"/>

		<uix:pageLayout titleBinding="header@defaultBean@servletRequest">
		      <%@ include file="/oemGlobal.jspf" %>


		        <oem:messageBox messageType = "error" msgBundleBinding="ListenerMsg@servletRequest" errorTableBinding="errors@servletRequest"
		                      titleTextKey="titleText" mainTextKey="mainText"/>
		        <uix:subTabLayout>
				<uix:subTabs>
				 <uix:subTabBar selectedIndexBinding="subTabBarSelectedIndex@mainNetBean@servletRequest">
					  <uix:link textBinding="GENERAL_TAB@ListenerBundle@servletRequest" 
					            onClick="submitForm('listenerForm', true, {event:'generalTab'})" />
					  <uix:link textBinding="AUTHENTICATION_TAB@ListenerBundle@servletRequest" 
					            onClick="submitForm('listenerForm', true, {event:'authenticationTab'})" />
					  <uix:link textBinding="LOG_TRACE_TAB@ListenerBundle@servletRequest" 
					            onClick="submitForm('listenerForm', true, {event:'logTraceTab'})" />
					  <uix:link textBinding="DB_SERVICES_TAB@ListenerBundle@servletRequest" 
					            onClick="submitForm('listenerForm', true, {event:'dbServiceTab'})" />
					  <uix:link textBinding="OTHER_SERVICES_TAB@ListenerBundle@servletRequest" 
					            onClick="submitForm('listenerForm', true, {event:'otherServiceTab'})" />
				 </uix:subTabBar>
				</uix:subTabs>



			<uix:tableLayout cellSpacing="5">
			  <uix:rowLayout>
	     	          <uix:cellFormat hAlign="left" >
			  <uix:stackLayout>
					  <oem:radioButton
					          name="passwordReqdStatus"
					          selectedValueBinding="passwordReqdStatus@defaultBean@servletRequest"
					          shortDescBinding="NO_PASS_RQD@ListenerBundle@servletRequest"
							  textBinding="NO_PASS_RQD@ListenerBundle@servletRequest"
						onClick="submitForm('listenerForm', true,{'event':'authStatusChanged'})"
						  value="false"/>
					  <oem:radioButton
					          name="passwordReqdStatus"
					          selectedValueBinding="passwordReqdStatus@defaultBean@servletRequest"
					          shortDescBinding="PASS_RQD@ListenerBundle@servletRequest"
							  textBinding="PASS_RQD@ListenerBundle@servletRequest"
						  onClick="submitForm('listenerForm', true,{'event':'authStatusChanged'})"
						  value="true"/>
<%--
					  <oem:radioButton
					          name="passwordReqdStatus"
					          selectedValueBinding="passwordReqdStatus@defaultBean@servletRequest"
					          textBinding="NO_PASS_RQD@ListenerBundle@servletRequest"
						  value="false"/>
					  <oem:radioButton
					          name="passwordReqdStatus"
					          selectedValueBinding="passwordReqdStatus@defaultBean@servletRequest"
					          textBinding="PASS_RQD@ListenerBundle@servletRequest"
						  value="true"/>

--%>
	 	               <uix:switcher childNameBinding ="passwordReqdStatus@defaultBean@servletRequest" >
       			       <uix:case name="true">
		 	               <uix:switcher childNameBinding ="oldPasswordDisabled@defaultBean@servletRequest" >
        			       <uix:case name="true">
					         <uix:styledText styleClass="OraInstructionText" textBinding="PROVIDE_NEW_PASSWORD_HDR@ListenerBundle@servletRequest"  />
        			       </uix:case>
        			       <uix:case name="false">
					      <uix:stackLayout>
	 				                <uix:styledText styleClass="OraInstructionText" textBinding="PROVIDE_NEW_PASSWORD_HDR@ListenerBundle@servletRequest"  />
		  			                <uix:labeledFieldLayout labelWidth="75%" fieldWidth="50%" width="100%">
				                 	<uix:messagePrompt 
										promptBinding="OLD_PASSWORD@ListenerBundle@servletRequest" 
										labeledNodeId="secretOldPassword" required="yes" />
							<uix:stackLayout>
							       <uix:textInput id="secretOldPassword"
								   		shortDescBinding="OLD_PASSWORD@ListenerBundle@servletRequest" 
										name="secretOldPassword" secret="true" noAutoComplete="true" 
										textBinding="secretOldPassword@defaultBean@servletRequest" 
										columns="25"/>
							       <uix:formValue name="id" valueBinding="secretOldPassword@defaultBean@servletRequest" />
							       <uix:messageText messageType="error" messageBinding="OLD_PASSWORD@errors@servletRequest"/>
							</uix:stackLayout>
		 			                </uix:labeledFieldLayout>
					      </uix:stackLayout>
        			       </uix:case>
		 	               </uix:switcher>
       			       </uix:case>
		               </uix:switcher>

	 	               <uix:switcher childNameBinding ="passwordReqdStatus@defaultBean@servletRequest" >
       			       <uix:case name="true">
   			                <uix:labeledFieldLayout labelWidth="75%" fieldWidth="50%" width="100%">
			                      <uix:messagePrompt 
								  	promptBinding="NEW_PASSWORD@ListenerBundle@servletRequest" 
									labeledNodeId="secretNewPassword" required="yes" />
					      <uix:stackLayout>
 					         	<uix:textInput id="secretNewPassword"
										shortDescBinding="NEW_PASSWORD@ListenerBundle@servletRequest" 
										name="secretNewPassword" secret="true" noAutoComplete="true" 
										textBinding="secretNewPassword@defaultBean@servletRequest" 
										columns="25"/>
					        	<uix:formValue name="id" valueBinding="secretNewPassword@defaultBean@servletRequest" />
					       		<uix:messageText messageType="error" messageBinding="NEW_PASSWORD@errors@servletRequest"/>
					      </uix:stackLayout>

  			                      <uix:messagePrompt 
								  	promptBinding="CONFM_PASSWORD@ListenerBundle@servletRequest" 
									labeledNodeId="secretConfirmPassword" required="yes" />
					      <uix:stackLayout>
					         	<uix:textInput id="secretConfirmPassword"
									shortDescBinding="CONFM_PASSWORD@ListenerBundle@servletRequest" 
									name="secretConfirmPassword" secret="true" noAutoComplete="true" 
									textBinding="secretConfirmPassword@defaultBean@servletRequest" 
									columns="25"/>
					        	<uix:formValue name="id" valueBinding="secretConfirmPassword@defaultBean@servletRequest" />
					       		<uix:messageText messageType="error" messageBinding="CONFM_PASSWORD@errors@servletRequest"/>
					      </uix:stackLayout>
 			                </uix:labeledFieldLayout>
       			       </uix:case>
		               </uix:switcher>

			</uix:stackLayout>
		    </uix:cellFormat>
		  </uix:rowLayout>
                </uix:tableLayout>


	               </uix:subTabLayout>

			<uix:pageButtons>
			<uix:pageButtonBar>

                        <uix:contents>
	    	          <uix:submitButton textBinding="CANCEL@defaultMsgBundle@servletRequest" 
					  	name="event" value="cancel" shortDescBinding="CANCEL@netBundle@servletRequest"/>
	    	          <uix:submitButton textBinding="OK@defaultMsgBundle@servletRequest" 
					  	name="event" value="apply" shortDescBinding="OK@netBundle@servletRequest"/>
	        	</uix:contents>

			</uix:pageButtonBar>
			</uix:pageButtons>

		</uix:pageLayout> 
	  </uix:form>
	</uix:body>

 </uix:document> 
</uix:renderingContext> 

