<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.db.rsc.net.NetMsg" %>
<%
request.setAttribute("netBundle", new BundleDataObject(NLSUtil.getBundle(NetMsg.class.getName(), request)));
%>
<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/> 
<uix:document> 

	<uix:metaContainer>
		<uix:head titleBinding="TITLE@servletRequest"/>
	</uix:metaContainer>
	<uix:body>	
	<uix:form name="protocolForm" method="post" destinationBinding="defaultControllerURL@defaultBean@servletRequest">
		<uix:formValue name="pageName" value="/net/listener/dbService"/>

		<uix:pageLayout titleBinding="header@defaultBean@servletRequest">
		        <%@ include file="/oemGlobal.jspf" %>

        		<oem:messageBox messageType = "error" msgBundleBinding="ListenerMsg@servletRequest" errorTableBinding="errors@servletRequest"
		                      titleTextKey="titleText" mainTextKey="mainText"/>

		        <uix:tableLayout cellSpacing="5">

			  <uix:rowLayout>
			    <uix:cellFormat hAlign="right">
				      <uix:messagePrompt promptBinding = "GLOBAL_DATABASE_NAME@ListenerBundle@servletRequest" 
					  		labeledNodeId="GDBName" required="yes" />
			    </uix:cellFormat>
			    <uix:cellFormat  hAlign="left">
			      <uix:stackLayout>
				         <uix:textInput 
						 	shortDescBinding="GLOBAL_DATABASE_NAME@ListenerBundle@servletRequest" 
							name="GDBName" id="GDBName"
							textBinding="GDBName@defaultBean@servletRequest" 
							columns="28"/>
				        <uix:formValue name="id" valueBinding="GDBName@defaultBean@servletRequest" />
				       <uix:messageText messageType="error" messageBinding="GLOBAL_DATABASE_NAME@errors@servletRequest"/>
			      </uix:stackLayout>
			    </uix:cellFormat>
			  </uix:rowLayout>

			  <uix:rowLayout>
			    <uix:cellFormat hAlign="right">
			      <uix:messagePrompt promptBinding = "ORACLE_HOME@ListenerBundle@servletRequest" 
				  		labeledNodeId="oracleHome" required="yes" />
			    </uix:cellFormat>
			    <uix:cellFormat  hAlign="left">
			      <uix:stackLayout>
				         <uix:textInput shortDescBinding="ORACLE_HOME@ListenerBundle@servletRequest" 
						 		name="oracleHome" id="oracleHome"
								textBinding="oracleHome@defaultBean@servletRequest" 
								columns="28"/>
				        <uix:formValue name="id" valueBinding="oracleHome@defaultBean@servletRequest" />
				       <uix:messageText messageType="error" messageBinding="ORACLE_HOME@errors@servletRequest"/>
			      </uix:stackLayout>
			    </uix:cellFormat>
			  </uix:rowLayout>

			  <uix:rowLayout>
			    <uix:cellFormat hAlign="right">
			      <uix:messagePrompt promptBinding = "SID@ListenerBundle@servletRequest" 
				  		labeledNodeId="SID" required="yes" />
			    </uix:cellFormat>
			    <uix:cellFormat  hAlign="left">
			      <uix:stackLayout>
				         <uix:textInput shortDescBinding="SID@ListenerBundle@servletRequest" 
						 		name="SID" id="SID"
								textBinding="SID@defaultBean@servletRequest" 
								columns="28"/>
				        <uix:formValue name ="id" valueBinding="SID@defaultBean@servletRequest" />
				       <uix:messageText messageType="error" messageBinding="SID@errors@servletRequest"/>
			      </uix:stackLayout>
			    </uix:cellFormat>
			  </uix:rowLayout>

			</uix:tableLayout>

		    <uix:pageButtons>
        	      <uix:pageButtonBar>
	                        <uix:contents>
		    	          <uix:submitButton textBinding="CANCEL@defaultMsgBundle@servletRequest" 
						  	name="event" value="cancel" shortDescBinding="CANCEL@netBundle@servletRequest"/>
		    	          <uix:submitButton textBinding="OK@defaultMsgBundle@servletRequest" 
						  	name="event" value="apply" shortDescBinding="OK@netBundle@servletRequest"/>
		        	</uix:contents>
	              </uix:pageButtonBar>
	            </uix:pageButtons>

		</uix:pageLayout> 
     </uix:form>
     </uix:body>	
 </uix:document> 
</uix:renderingContext> 

