<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.db.rsc.DBObjectMsg" %>
<%@page import="oracle.sysman.db.rsc.net.NetMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<%
  request.setAttribute("dbObjBundle", new BundleDataObject(NLSUtil.getBundle(DBObjectMsg.class.getName(), request)));
  request.setAttribute("netBundle", new BundleDataObject(NLSUtil.getBundle(NetMsg.class.getName(), request )));
%>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/> 
<uix:document> 

    <uix:metaContainer>
      <!-- <uix:head titleBinding="title@mainNetBean@servletRequest"/> -->
      <uix:head titleBinding="TITLE@servletRequest" />
    </uix:metaContainer>

     <uix:body>	
      <uix:form name="listenerForm" method="post" destinationBinding="defaultControllerURL@defaultBean@servletRequest">
      <uix:formValue name="pageName" value="/net/listener/dbServiceTab"/>

	<uix:pageLayout titleBinding="header@mainNetBean@servletRequest">	
        <%@ include file="/oemGlobal.jspf" %>
        <oem:messageBox messageType = "error" msgBundleBinding="ListenerMsg@servletRequest" errorTableBinding="errors@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>

        <uix:subTabLayout>
          <uix:subTabs>
                 <uix:subTabBar selectedIndexBinding="subTabBarSelectedIndex@mainNetBean@servletRequest">
			  <uix:link textBinding="GENERAL_TAB@ListenerBundle@servletRequest" 
			            onClick="submitForm('listenerForm', true, {event:'generalTab'})" />
			  <uix:link textBinding="AUTHENTICATION_TAB@ListenerBundle@servletRequest" 
			            onClick="submitForm('listenerForm', true, {event:'authenticationTab'})" />
			  <uix:link textBinding="LOG_TRACE_TAB@ListenerBundle@servletRequest" 
			            onClick="submitForm('listenerForm', true, {event:'logTraceTab'})" />
			  <uix:link textBinding="DB_SERVICES_TAB@ListenerBundle@servletRequest" 
			            onClick="submitForm('listenerForm', true, {event:'dbServiceTab'})" />
			  <uix:link textBinding="OTHER_SERVICES_TAB@ListenerBundle@servletRequest" 
			            onClick="submitForm('listenerForm', true, {event:'otherServiceTab'})" />
                 </uix:subTabBar>
             </uix:subTabs>

           <uix:styledText styleClass="OraInstructionText" textBinding="STATIC_SERVICE_REG_DESC@ListenerBundle@servletRequest"  />
          <uix:tableLayout width="100%">
	      	  <uix:rowLayout>
	           <uix:cellFormat hAlign="right">
			<uix:submitButton textBinding="ADD@defaultMsgBundle@servletRequest" name="event" value="addDBService" shortDescBinding="ADD@netBundle@servletRequest"/>
	           </uix:cellFormat>
        	  </uix:rowLayout>

	          <uix:rowLayout>
		 <uix:cellFormat >
	              <oem:table name="DBServicesUI" 
				  			width="100%" 
							blockSize="25" 
							summaryBinding="SERVICED_DATABASES_LIST@netBundle@servletRequest"
							shortDescBinding="SERVICED_DATABASES_LIST@netBundle@servletRequest"
                          	formSubmitted="true"
	  	          			alternateTextBinding="NO_ITEMS_FOUND@defaultMsgBundle@servletRequest"
							dataSourceProp="DBServicesUI">
                      <uix:tableSelection>
                        <uix:singleSelection shortDescBinding="SELECT@dbObjBundle@servletRequest" selectedIndexBinding="selectedIndex@DBServicesUI@defaultBean@servletRequest" >
		      <uix:pageButtonBar>
        	          <uix:submitButton textBinding="EDIT@defaultMsgBundle@servletRequest" name="event" value="editDBService" shortDescBinding="EDIT@netBundle@servletRequest"/>
       	        	  <uix:submitButton textBinding="REMOVE@defaultMsgBundle@servletRequest" name="event" value="deleteDBService" shortDescBinding="REMOVE@netBundle@servletRequest"/>
		      </uix:pageButtonBar>
	               </uix:singleSelection>
                      </uix:tableSelection>
        	      </oem:table>
            </uix:cellFormat>
	    </uix:rowLayout>
	    </uix:tableLayout>

          </uix:subTabLayout>


	    <uix:pageButtons>
	      <uix:pageButtonBar>

                        <uix:contents>
	    	          <uix:submitButton textBinding="CANCEL@defaultMsgBundle@servletRequest" name="event" value="cancel" shortDescBinding="CANCEL@netBundle@servletRequest"/>
	    	          <uix:submitButton textBinding="OK@defaultMsgBundle@servletRequest" name="event" value="apply" shortDescBinding="OK@netBundle@servletRequest"/>
	        	</uix:contents>

	      </uix:pageButtonBar>
	    </uix:pageButtons>

   </uix:pageLayout> 
  </uix:form>
  </uix:body>	
 </uix:document> 
</uix:renderingContext> 



