<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.db.rsc.DBObjectMsg" %>
<%@ page import="oracle.sysman.db.rsc.net.NetMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<%
  request.setAttribute("dbObjBundle", new BundleDataObject(NLSUtil.getBundle(DBObjectMsg.class.getName(), request)));
  request.setAttribute("netBundle", new BundleDataObject(NLSUtil.getBundle(NetMsg.class.getName(), request)));
%>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/> 
<uix:document> 

    <uix:metaContainer>
      <uix:head titleBinding="TITLE@servletRequest"/>
    </uix:metaContainer>


     <uix:body>	
      <uix:form name="listenerForm" method="post" destinationBinding="defaultControllerURL@defaultBean@servletRequest">
      <uix:formValue name="pageName" value="/net/listener/generalPage"/>


     
	<uix:pageLayout titleBinding="header@defaultBean@servletRequest">	
        <%@ include file="/oemGlobal.jspf" %>
        <oem:messageBox messageType = "error" msgBundleBinding="ListenerMsg@servletRequest" errorTableBinding="errors@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>

        <uix:subTabLayout>
          <uix:subTabs>
                 <uix:subTabBar selectedIndexBinding="subTabBarSelectedIndex@mainNetBean@servletRequest">
			  <uix:link textBinding="GENERAL_TAB@ListenerBundle@servletRequest" 
			            onClick="submitForm('listenerForm', true, {event:'generalTab'})" />
			  <uix:link textBinding="AUTHENTICATION_TAB@ListenerBundle@servletRequest" 
			            onClick="submitForm('listenerForm', true, {event:'authenticationTab'})" />
			  <uix:link textBinding="LOG_TRACE_TAB@ListenerBundle@servletRequest" 
			            onClick="submitForm('listenerForm', true, {event:'logTraceTab'})" />
			  <uix:link textBinding="DB_SERVICES_TAB@ListenerBundle@servletRequest" 
			            onClick="submitForm('listenerForm', true, {event:'dbServiceTab'})" />
			  <uix:link textBinding="OTHER_SERVICES_TAB@ListenerBundle@servletRequest" 
			            onClick="submitForm('listenerForm', true, {event:'otherServiceTab'})" />
                 </uix:subTabBar>
             </uix:subTabs>
<%--
                <uix:switcher childNameBinding ="creating@mainNetBean@servletRequest" >
        	<uix:case name="true">
--%>
                 <uix:tableLayout cellSpacing="5">
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="left">
                      <uix:messagePrompt promptBinding="NAME_FIELD@ListenerBundle@servletRequest" 
					  		labeledNodeId="objectName" required="yes" />
                    </uix:cellFormat>
                    <uix:cellFormat>
                      <uix:stackLayout>
                        <uix:textInput shortDescBinding="NAME_FIELD@ListenerBundle@servletRequest" 
								name="objectName"
								id="objectName"
					 			textBinding="objectName@defaultBean@servletRequest"/>
		                <uix:formValue name="id" valueBinding="objectName@defaultBean@servletRequest" />
		               <uix:messageText messageType="error" messageBinding="NAME_FIELD@errors@servletRequest"/>
                      </uix:stackLayout>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  </uix:tableLayout>
    
   <%--
             </uix:case>
               </uix:switcher>
--%>

          <uix:header textBinding="ADDRESSES_HDR@ListenerBundle@servletRequest">
          <uix:styledText styleClass="OraInstructionText"
                         textBinding="ADDRESS_DESC@ListenerBundle@servletRequest" />
          <uix:tableLayout width="100%">
	      	  <uix:rowLayout>
	           <uix:cellFormat hAlign="right">
	                <uix:contents>
						<uix:submitButton textBinding="ADD@defaultMsgBundle@servletRequest" 
							name="event" value="addAddress" shortDescBinding="ADD@netBundle@servletRequest"/>
	                </uix:contents>
	           </uix:cellFormat>
        	  </uix:rowLayout>
	          <uix:rowLayout>
		 <uix:cellFormat >
	              <oem:table name="addressesUI" 
				  			width="100%" 
							blockSize="10" 
							summaryBinding="CONNECT_DATAS_LIST@netBundle@servletRequest"
							shortDescBinding="CONNECT_DATAS_LIST@netBundle@servletRequest"
                          	formSubmitted="true"
	  	          			alternateTextBinding="NO_ITEMS_FOUND@defaultMsgBundle@servletRequest"
		        			dataSourceKey="addresses" 
							dataSourceProp="addressesUI">
                      <uix:tableSelection>
                        <uix:singleSelection shortDescBinding="SELECT@dbObjBundle@servletRequest" 
								selectedIndexBinding="selectedIndex@addressesUI@addresses@servletRequest" >
		      <uix:pageButtonBar>
                  <uix:contents>
	        	  <uix:submitButton textBinding="EDIT@defaultMsgBundle@servletRequest" 
				  		name="event" value="editAddress" shortDescBinding="EDIT@netBundle@servletRequest"/>
		          <uix:submitButton textBinding="REMOVE@defaultMsgBundle@servletRequest" 
				  		name="event" value="deleteAddress" shortDescBinding="REMOVE@netBundle@servletRequest"/>
                  </uix:contents>
		      </uix:pageButtonBar>
	               </uix:singleSelection>
                      </uix:tableSelection>
              </oem:table>
            </uix:cellFormat>
	    </uix:rowLayout>
	    </uix:tableLayout>

           <uix:messageText messageType="error" messageBinding="NO_ADDRESS_KEY@errors@servletRequest"/>
           <uix:spacer height="5"/>
           </uix:header>
		
          </uix:subTabLayout>


	    <uix:pageButtons>
	      <uix:pageButtonBar>
               <uix:contents>
	    	      <uix:submitButton textBinding="CANCEL@defaultMsgBundle@servletRequest" 
				  		name="event" value="cancel" shortDescBinding="CANCEL@netBundle@servletRequest"/>
	    	      <uix:submitButton textBinding="OK@defaultMsgBundle@servletRequest" 
				  		name="event" value="apply" shortDescBinding="OK@netBundle@servletRequest"/>
	        	</uix:contents>
	      </uix:pageButtonBar>
	    </uix:pageButtons>

   </uix:pageLayout> 
  </uix:form>
 </uix:body>	
 </uix:document> 
</uix:renderingContext> 



