<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.db.rsc.DBObjectMsg" %>
<%@ page import="oracle.sysman.db.rsc.net.NetMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<%
  request.setAttribute("dbObjBundle", new BundleDataObject(NLSUtil.getBundle(DBObjectMsg.class.getName(), request)));
  request.setAttribute("netBundle", new BundleDataObject(NLSUtil.getBundle(NetMsg.class.getName(), request)));
%>

<uix:renderingContext id="renderingContext">
<uix:bundle name="lsnrMsg" class="oracle.sysman.db.rsc.net.lsnr.ListenerMsg"/>

<oem:setURLEncoder id="renderingContext"/> 
<uix:document> 

    <uix:metaContainer>
    <uix:head titleBinding="TITLE@servletRequest"/>
    </uix:metaContainer>


  <uix:pageLayout>	
   <%@ include file="/oemGlobal.jspf" %>
     <uix:contents>
     <uix:body>	
     <uix:form name="listenersForm"  method="post" destinationBinding="defaultControllerURL@controllerIDBean@servletRequest">
     <uix:formValue name="pageName" value="/net/listener/listenersList"/>
      <uix:contents>
 	  <oem:messageBox messageTypeBinding = "messageType@servletRequest" msgBundleBinding="ListenerMsg@servletRequest" errorTableBinding="errors@servletRequest"
                      destTableBinding="msgUrls@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
          
        <uix:header  textBinding="header@listenersUI@defaultBean@servletRequest">

		<uix:tableLayout width="100%" >
			<uix:rowLayout vAlign="top">
				<uix:cellFormat width="2%"  hAlign="right">
					<uix:spacer height="2"/>
				</uix:cellFormat>
				<uix:cellFormat width="98%"  hAlign="left">
					<uix:spacer height="2"/>
				</uix:cellFormat>
			</uix:rowLayout>
			<uix:rowLayout vAlign="top">
				<uix:cellFormat width="2%"  hAlign="right">
					<uix:spacer height="2"/>
				</uix:cellFormat>
					<uix:cellFormat width="98%"  hAlign="left">
					<uix:styledText styleClass="OraInstructionText" textBinding="LISTENER_DOWN_LIST_PAGE_TIP@lsnrMsg"/>
				</uix:cellFormat>
			</uix:rowLayout>
			<uix:rowLayout vAlign="top">
				<uix:cellFormat width="2%"  hAlign="right">
					<uix:spacer height="5"/>
				</uix:cellFormat>
				<uix:cellFormat width="98%"  hAlign="left">
					<uix:spacer height="5"/>
				</uix:cellFormat>
			</uix:rowLayout>
		</uix:tableLayout>

		  <uix:tableLayout width="100%">

	<%-- Listener Search field   --%>
 <uix:rowLayout>
                 <uix:cellFormat hAlign="left">
                 	<uix:spacer height="10" width="10"/>
                 </uix:cellFormat>
         </uix:rowLayout>

	 <uix:rowLayout>
		<uix:cellFormat>
         		<uix:messagePrompt promptBinding="NAME_FIELD@ListenerBundle@servletRequest" required="no"
						labeledNodeId="listenerToSearch"/>
               		<uix:textInput 
						name="listenerToSearch" columns="30" 
						id="listenerToSearch" 
					 	textBinding="listenerToSearch@defaultBean@servletRequest" 
						shortDescBinding="NAME_FIELD@ListenerBundle@servletRequest"/>
         		<uix:submitButton textBinding="GO@defaultMsgBundle@servletRequest" name="event"  value="search" shortDescBinding="GO@netBundle@servletRequest"/>
            	</uix:cellFormat>
          </uix:rowLayout>
	<%-- Listener Search field   --%>

	      	  <uix:rowLayout>
	           <uix:cellFormat hAlign="right">
		           <uix:submitButton textBinding="CREATE@defaultMsgBundle@servletRequest" 
				   name="event" value="add" shortDescBinding="CREATE@netBundle@servletRequest"/>
	           </uix:cellFormat>
        	 </uix:rowLayout>

	          <uix:rowLayout>
		 <uix:cellFormat >
	              <oem:table name="listenersUI" width="100%" blockSize="5" 
				  summaryBinding="LISTENER@netBundle@servletRequest" 
				  shortDescBinding="LISTENER@netBundle@servletRequest" 
 		          beanKey="defaultBean" 
	  	          alternateTextBinding="NO_ITEMS_FOUND@defaultMsgBundle@servletRequest"
                          formSubmitted="true"
                          dataSourceProp="listenersUI">
                      <uix:tableSelection>
                        <uix:singleSelection shortDescBinding="SELECT@dbObjBundle@servletRequest" selectedIndexBinding="selectedIndex@listenersUI@defaultBean@servletRequest" >
 		        <uix:pageButtonBar>
                          <uix:contents>
        	          <uix:submitButton textBinding="EDIT@defaultMsgBundle@servletRequest" name="event" value="edit" shortDescBinding="EDIT@netBundle@servletRequest"/>
                	  <uix:submitButton textBinding="DELETE@defaultMsgBundle@servletRequest" name="event" value="delete" shortDescBinding="DELETE@netBundle@servletRequest"/>
					  	<uix:cellFormat wrappingDisabled="true" height="20" width="60">
						  <uix:contents>
				              <uix:styledText styleClass="OraPromptText" textBinding="ACTIONS@defaultMsgBundle@servletRequest"/>
							</uix:contents>
						  </uix:cellFormat>

						<uix:choice name="actionType"
										selectedValueBinding="actionType@defaultBean@servletRequest"
										shortDescBinding="ACTIONS@defaultMsgBundle@servletRequest">
							<uix:contents childDataBinding="actionTypes@defaultBean@servletRequest">
								<uix:option textBinding="text"
											valueBinding="value"/>
							</uix:contents>
						</uix:choice>

  			  <uix:submitButton textBinding="GO@defaultMsgBundle@servletRequest" 
			  	name="event" value="action" shortDescBinding="GO@defaultMsgBundle@servletRequest"/>
                          </uix:contents>
 		        </uix:pageButtonBar>
	               </uix:singleSelection>
                      </uix:tableSelection>
	            </oem:table>
            </uix:cellFormat>
	    </uix:rowLayout>
	    </uix:tableLayout>

        </uix:header>
     </uix:contents>
     </uix:form>
     </uix:body>	

    </uix:contents>	

   </uix:pageLayout> 
 </uix:document> 
</uix:renderingContext> 





