<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%@ page import="oracle.sysman.eml.PageNames" %>
<%@ page import="oracle.sysman.emSDK.eml.EmlConstants" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:bundle name="MultiTargetResourceBundle" class="oracle.sysman.eml.rsc.target.MultiTargetMsg"/>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <uix:contents>
        <uix:form name="lsnrActionProcessing" method="post">

		  <uix:formValue
              name="<%= EmlConstants.PAGE_NAME_PAGE_PROPERTY %>"
              value="net/listener/lsnrActionProcessing"/>

          <uix:pageLayout>
			<%@ include file="/enablePPR.jspf" %> 
            <%@ include file="/oemGlobal.jspf" %>


          <uix:messages>
              <oem:messageBox
                  messageTypeBinding="messageType@servletRequest"
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
            </uix:messages>

            <uix:header
                textBinding="procPageHeader@lsnrSegmentBean@servletRequest"
                icon="/em/images/processl.gif">

              <uix:borderLayout>
                <uix:left>
                  <uix:styledText
                      styleClass="OraDataText"
					  renderedBinding="showCancelInstr@lsnrSegmentBean@servletRequest"
                      textBinding="procPageInstrWait@lsnrSegmentBean@servletRequest"/>
                </uix:left>
                <uix:right>
                  <uix:tableLayout width="100%">
                    <uix:rowLayout hAlign="right">
                      <uix:submitButton
                          name="event"
                          value="cancelProcessing"
		  				  renderedBinding="showCancelInstr@lsnrSegmentBean@servletRequest"
                          textBinding="CANCEL@MultiTargetResourceBundle"
						  shortDescBinding="CANCEL@MultiTargetResourceBundle"/>
                    </uix:rowLayout>
                  </uix:tableLayout>
                </uix:right>
              </uix:borderLayout>

              <uix:tableLayout width="100%" hAlign="center">
                <uix:rowLayout>
                  <uix:borderLayout>
                  <uix:left>
                    <uix:styledText
                        styleClass="OraInstructionText"
						renderedBinding="showCancelInstr@lsnrSegmentBean@servletRequest"
                        textBinding="procPageInstrCancel@lsnrSegmentBean@servletRequest"/>
                  </uix:left>
                  </uix:borderLayout>
                </uix:rowLayout>

                <uix:rowLayout>
                  <uix:spacer height="20"/>
                </uix:rowLayout>

                <uix:rowLayout hAlign="center">
                  <uix:cellFormat hAlign="center">
                    <uix:stackLayout>
                      <uix:contents>
                        <uix:processing
                            id="executeProcessingControl"
                            timeIntervalBinding="refreshRate@lsnrSegmentBean@servletRequest">
                        </uix:processing>
                      </uix:contents> 
                    </uix:stackLayout>
                  </uix:cellFormat>
                </uix:rowLayout>

              </uix:tableLayout>
            </uix:header>

            <uix:contentFooter>
              <uix:pageButtonBar>
                <uix:submitButton
                    name="event"
                    value="cancelProcessing"
					renderedBinding="showCancelInstr@lsnrSegmentBean@servletRequest"
                    textBinding="CANCEL@MultiTargetResourceBundle"
					shortDescBinding="CANCEL@MultiTargetResourceBundle"/>
              </uix:pageButtonBar>
            </uix:contentFooter>

          </uix:pageLayout>
        </uix:form>
      </uix:contents>
    </uix:body>
  </uix:document>
</uix:renderingContext>
