<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%@ page import="oracle.sysman.eml.ecm.util.table.UIXDataSource" %>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.db.rsc.net.NetMsg" %>
<%@ page import="oracle.sysman.db.rsc.net.lsnr.ListenerMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<%@ page import="oracle.cabo.ui.partial.PartialPageUtils"%>

<%@ include file="/oemNoscript.jspf" %>

<%
  request.setAttribute("netBundle", new BundleDataObject(NLSUtil.getBundle(NetMsg.class.getName(), request)));
  request.setAttribute("lsnrBundle", new BundleDataObject(NLSUtil.getBundle(ListenerMsg.class.getName(), request)));
%>

<uix:renderingContext id="renderingContext" >
<oem:setURLEncoder id="renderingContext"/>

<uix:bundle name="SDKUIResourceBundle" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
<uix:bundle name="JobsResourceBundle" class="oracle.sysman.resources.eml.jobs.JobsResource"/>
<uix:bundle name="MntrResourceBundle" class="oracle.sysman.resources.MntrResourceBundle"/>
<uix:bundle name="MultiTargetResourceBundle" class="oracle.sysman.eml.rsc.target.MultiTargetMsg"/>

<%
  String dest = (String)request.getSession().getAttribute("processingDoneDestination");
  if (dest != null)
  {
    PartialPageUtils.forceRedirectURL(renderingContext, dest);
    request.getSession().removeAttribute("processingDoneDestination");
  }
%>

<uix:document>
	
	<%@ include file="/oemTitle.jspf" %>

    <uix:body>
    <!-- main contents -->
    <uix:contents>
	  <uix:form name="lsnrSegment" method="post">

		<uix:pageLayout titleBinding="title@lsnrSegmentBean@servletRequest">
            <%@ include file="/enablePPR.jspf" %>
			<%@ include file="/database/global.jspf" %>

			<uix:messages>
              <oem:messageBox
                  messageTypeBinding="messageType@servletRequest"
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
            </uix:messages>
			
			<uix:spacer height="10" />

			<%--  BEGINNING OF CREDENTIALS INPUT FIELDS --%>
            <uix:header
                  textBinding="credHeader@lsnrSegmentBean@servletRequest">
                  <uix:tableLayout width="100%" cellSpacing="1">
                    <uix:rowLayout>
                      <uix:cellFormat wrappingDisabled="true">
                        <uix:radioButton
                            name="prefCredOption"
                            textBinding="USE_PREF_CRED@JobsResourceBundle"
                            selectedValueBinding="prefCredOption@lsnrSegmentBean@servletRequest"
                            onClick="submitForm('lsnrSegment', true, {'event':'usePrefCredsClicked'})"
                            value="USE_PREF_CRED"/>
                        <uix:radioButton
                            name="prefCredOption"
                            textBinding="OVERRIDE_PREF_CRED@JobsResourceBundle"
                            selectedValueBinding="prefCredOption@lsnrSegmentBean@servletRequest"
                            onClick="submitForm('lsnrSegment', true, {'event':'overridePrefCredsClicked'})"
                            value="OVERRIDE_PREF_CRED"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                    <uix:rowLayout>
                      <uix:labeledFieldLayout labelWidth="30%">
                        <uix:messageChoice
                            name="prefCredType"
                            renderedBinding="prefCredClicked@lsnrSegmentBean@servletRequest"
                            promptBinding="PREF_CRED_TYPE@JobsResourceBundle"
                            selectedValueBinding="prefCredType@lsnrSegmentBean@servletRequest">
                          <uix:option
                              value="NORMAL"
                              textBinding="PREF_CRED_LEVEL_NORMAL@JobsResourceBundle"/>
                          <uix:option
                              value="PRIV"
                              textBinding="prefCredPrivText@lsnrSegmentBean@servletRequest"/>
                        </uix:messageChoice>
                        <uix:messageTextInput
                            name="hostUsername"
                            renderedBinding="overrideCredClicked@lsnrSegmentBean@servletRequest"
                            columns="20" noAutoComplete="true" 
                            textBinding="hostUsername@lsnrSegmentBean@servletRequest"
                            promptBinding="HOST_USERNAME@JobsResourceBundle"
                            messageBinding="(HOST_USERNAME@JobsResourceBundle)@messages@servletRequest"
                            messageTypeBinding="(HOST_USERNAME@JobsResourceBundle)@messageTypes@servletRequest"/>
                        <uix:messageTextInput
                            name="hostPasswordSecret"
                            renderedBinding="overrideCredClicked@lsnrSegmentBean@servletRequest"
                            columns="20"
                            secret="true" noAutoComplete="true"
                            textBinding="hostPasswordSecret@lsnrSegmentBean@servletRequest"
                            promptBinding="HOST_PASSWORD@JobsResourceBundle"
                            messageBinding="(HOST_PASSWORD@JobsResourceBundle)@messages@servletRequest"
                            messageTypeBinding="(HOST_PASSWORD@JobsResourceBundle)@messageTypes@servletRequest"/>
                      </uix:labeledFieldLayout>
                    </uix:rowLayout>
                  </uix:tableLayout>
                </uix:header>

			<%-- END OF CREDENTIALS INPUT FIELDS  --%>
			<uix:spacer width="20"/>
			
			<%-- BEGINING OF INSTRUCTION TEXT  --%>
			<uix:styledText styleClass="OraInstructionText"
                       textBinding="instructionText@lsnrSegmentBean@servletRequest" />
			<%-- END OF INSTRUCTION TEXT  --%>
			
			<%-- BEGINING OF TIP TEXT bug 4591830 TODO: Remove the HARD-CODING of text here. --%>
			<uix:spacer width="11"/>
			<uix:tip text="Status UNAVAILABLE means that we could not ascertain the status of this listener target within our 'timeout' period." />
			<%-- END OF INSTRUCTION TEXT bug 4591830 --%>

			<%-- BEGIN OF START/STOP/VIEW CONFIGURATION BUTTON  --%>
		    <uix:tableLayout width="100%">
	        <uix:rowLayout hAlign="right">
              <uix:cellFormat>
					<uix:switcher childNameBinding="event@servletRequest"> 
				    <uix:case name="start">
						<uix:submitButton
							textBinding="START@netBundle@servletRequest"
							shortDescBinding="START@netBundle@servletRequest"
                            name="event"
                            value="start"/>
			         </uix:case>
					 <uix:case name="stop">
						<uix:submitButton
                            textBinding="STOP@netBundle@servletRequest"
							shortDescBinding="STOP@netBundle@servletRequest"
                            name="event"
                            value="stop"/>
					</uix:case>
					<uix:case name="viewConfDetails">
						<uix:submitButton
                            textBinding="VIEW_CONF_DETAILS@lsnrBundle@servletRequest"
							shortDescBinding="VIEW_CONF_DETAILS@lsnrBundle@servletRequest"
                            name="event"
                            value="viewConfDetails"/>
					 </uix:case>
			         </uix:switcher>
			 </uix:cellFormat>
		   </uix:rowLayout>
		   </uix:tableLayout>
		   <%-- END OF START/STOP/VIEW CONFIGURATION BUTTON  --%>

			<!-- Listener targets table -->
			<uix:dataScope currentDataBinding="lsnrTargetsTable@lsnrSegmentBean@servletRequest">
			<uix:table 
				 id="Targets"
                 name="lsnrTargetTable" 
                 formSubmitted="true"
                 partialRenderMode="self"
                 minValue="1"
                 showAll="no"
                 width="100%"
                 allDetailsEnabledBinding="renderShowAllHideAllDetailsLinks"                        detailDisclosureBinding="detailDisclosureList"
				 tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                 valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                 maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                 blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>"
                 alternateTextBinding="NO_TARGETS_FOUND@MultiTargetResourceBundle">

					 <!--- Start/Stop/View config details button -->

					<!-- Detail -->
					<uix:detail>
                        <uix:tableLayout width="100%">
                          <uix:rowLayout>
                            <uix:cellFormat hAlign="left">
                              <uix:rawText text="<pre>"/>
                                <uix:text
                                    textBinding="results"/>
                              <uix:rawText text="</pre>"/>
                            </uix:cellFormat>
                          </uix:rowLayout>
                          <uix:rowLayout renderedBinding="renderDetailsColumnShowMore">
                            <uix:cellFormat hAlign="left">
                              <uix:styledText
                                  text=". . ."
                                  shortDescBinding="RESULTS_TRUNCATED@MultiTargetResourceBundle"
                                  styleClass="OraInstructionTextStrong"/>
                              <uix:spacer width="20"/>
                              <uix:link
                                  textBinding="COMPLETE_EXECUTION_RESULTS@MultiTargetResourceBundle"
                                  destinationBinding="detailsColumnShowMoreDestination"/>
                            </uix:cellFormat>
                          </uix:rowLayout>
                        </uix:tableLayout>
                      </uix:detail>


                     <%-- Listener Name column --%>
                      <uix:column>
                        <uix:columnHeader>
                          <uix:sortableHeader 
                              textBinding="NAME@SDKUIResourceBundle"
                              sortableBinding="listenerColumnSortable"/>
                        </uix:columnHeader> 
                        <uix:columnFormat columnDataFormat="textFormat"/>
                        <uix:messageStyledText
                            textBinding="listenerColumn"
							destinationBinding="listenerColumnDestination">
                        </uix:messageStyledText>
                      </uix:column>
				
  					  <%-- Availability column --%>
					  <uix:column>
                        <uix:columnHeader>
							<uix:sortableHeader 
	                          	textBinding="STATUS@MntrResourceBundle"
                                sortableBinding="availabilityColumnSortable"/>
                        </uix:columnHeader> 
                        <uix:columnFormat columnDataFormat="textFormat"/>
                        <uix:messageStyledText
                            textBinding="availabilityColumn">
                        </uix:messageStyledText>
                      </uix:column>

                    <%-- Host column  --%>
                    <uix:column>
                        <uix:columnHeader>
                          <uix:sortableHeader 
                              textBinding="HOST@MultiTargetResourceBundle"
                              sortableBinding="hostColumnSortable"/>
                        </uix:columnHeader> 
                        <uix:columnFormat columnDataFormat="textFormat"/>
                        <uix:messageStyledText
                            textBinding="hostColumn"
                            destinationBinding="hostColumnDestination"
                            messageBinding="hostColumnMessage"
                            messageTypeBinding="hostColumnMessageType">
                        </uix:messageStyledText>
                    </uix:column>
					
                     <%-- Execution Status column display for start/stop--%>
                     <uix:column renderedBinding="renderExecutionStatusColumn">
                        <uix:columnHeader>
                          <uix:sortableHeader 
                              textBinding="EXECUTION_STATUS@MultiTargetResourceBundle"/>
                        </uix:columnHeader> 
                        <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                        <uix:image
                            shortDescBinding="executionStatusColumn"
                            sourceBinding="executionStatusColumnIcon"
                            destinationBinding="executionStatusColumnDestination"
                            textBinding="NO_EXECUTION_CONDUCTED@MultiTargetResourceBundle"/>
                     </uix:column>

                     <%-- Elapsed Time column display for start/stop--%>
                     <uix:column renderedBinding="renderElapsedTimeColumn">
                        <uix:columnHeader>
                          <uix:sortableHeader 
                              textBinding="EXEC_TABLE_RUNNING_TIME_COLUMN@JobsResourceBundle"
                              sortableBinding="elapsedTimeColumnSortable"/>
                        </uix:columnHeader> 
                        <uix:columnFormat columnDataFormat="numberFormat"/>
                        <uix:messageStyledText
                            textBinding="elapsedTimeColumn">
                        </uix:messageStyledText>
                     </uix:column>

					 <%-- Remove column --%>
                      <uix:column>
                        <uix:columnHeader>
                          <uix:sortableHeader 
                              textBinding="REMOVE@SDKUIResourceBundle"/>
                        </uix:columnHeader> 
                        <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                        <uix:image
                            shortDescBinding="REMOVE@SDKUIResourceBundle"
                            sourceBinding="removeColumnIcon"
                            onClickBinding="removeColumnDestination"/>
                      </uix:column>
			 </uix:table> 
			</uix:dataScope>

			<!-- Return Button to Group's Administration Page-->
            <uix:pageButtons>
            <uix:pageButtonBar>
			    <uix:button textBinding="RETURN_BUTTON@MntrResourceBundle"
							destinationBinding="returnDestination@lsnrSegmentBean@servletRequest"					shortDescBinding="RETURN_BUTTON@MntrResourceBundle"/>
            </uix:pageButtonBar>
	        </uix:pageButtons>
			</uix:pageLayout>
		</uix:form>
  </uix:contents>
  </uix:body>    
</uix:document>
</uix:renderingContext>
