<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.db.rsc.net.NetMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<%
  request.setAttribute("netBundle", new BundleDataObject(NLSUtil.getBundle(NetMsg.class.getName(), request)));
%>
<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/> 
<uix:document> 

	<uix:metaContainer>
		<uix:head titleBinding="TITLE@servletRequest"/>
	</uix:metaContainer>
	<uix:body>
	<uix:form name="protocolForm" method="post" destinationBinding="defaultControllerURL@defaultBean@servletRequest">
		<uix:formValue name="pageName" value="/net/listener/otherService"/>
		<uix:pageLayout titleBinding="header@defaultBean@servletRequest">
        		<%@ include file="/oemGlobal.jspf" %>
	
	        	<oem:messageBox messageType = "error" msgBundleBinding="ListenerMsg@servletRequest" errorTableBinding="errors@servletRequest"
		                      titleTextKey="titleText" mainTextKey="mainText"/>
	
		        <uix:tableLayout cellSpacing="5">

			  <uix:rowLayout>
			    <uix:cellFormat hAlign="right">
				      <uix:messagePrompt promptBinding = "PROGRAM_NAME@ListenerBundle@servletRequest" 
					  		labeledNodeId="programName" required="yes" />
			    </uix:cellFormat>
			    <uix:cellFormat  hAlign="left">
			      <uix:stackLayout>
				         <uix:textInput shortDescBinding="PROGRAM_NAME@ListenerBundle@servletRequest" 
						 	name="programName" id="programName"
							textBinding="programName@defaultBean@servletRequest" 
							columns="16"/>
				        <uix:formValue name="id" valueBinding="programName@defaultBean@servletRequest" />
				       <uix:messageText messageType="error" messageBinding="PROGRAM_NAME@errors@servletRequest"/>
			      </uix:stackLayout>
			    </uix:cellFormat>
			  </uix:rowLayout>

			  <uix:rowLayout>
			    <uix:cellFormat hAlign="right">
			      <uix:messagePrompt promptBinding = "GLOBAL_DATABASE_NAME@ListenerBundle@servletRequest" 
				  		labeledNodeId="GDBName"/>
			    </uix:cellFormat>
			    <uix:cellFormat  hAlign="left">
			      <uix:stackLayout>
				         <uix:textInput shortDescBinding="GLOBAL_DATABASE_NAME@ListenerBundle@servletRequest"
						 		name="GDBName" id="GDBName"
								textBinding="GDBName@defaultBean@servletRequest" 
								columns="16"/>
				        <uix:formValue name="id" valueBinding="GDBName@defaultBean@servletRequest" />
				       <uix:messageText messageType="error" messageBinding="GLOBAL_DATABASE_NAME@errors@servletRequest"/>
			      </uix:stackLayout>
			    </uix:cellFormat>
			  </uix:rowLayout>

			  <uix:rowLayout>
			    <uix:cellFormat hAlign="right">
			      <uix:messagePrompt promptBinding = "ORACLE_HOME@ListenerBundle@servletRequest" 
				  		labeledNodeId="oracleHome"/>
			    </uix:cellFormat>
			    <uix:cellFormat  hAlign="left">
			      <uix:stackLayout>
				         <uix:textInput shortDescBinding="ORACLE_HOME@ListenerBundle@servletRequest" 
						 		name="oracleHome" id="oracleHome"
								textBinding="oracleHome@defaultBean@servletRequest" 
								columns="50"/>
				        <uix:formValue name="id" valueBinding="oracleHome@defaultBean@servletRequest" />
				       <uix:messageText messageType="error" messageBinding="ORACLE_HOME@errors@servletRequest"/>
			      </uix:stackLayout>
			    </uix:cellFormat>
			  </uix:rowLayout>

			  <uix:rowLayout>
			    <uix:cellFormat hAlign="right">
			      <uix:messagePrompt promptBinding = "SID@ListenerBundle@servletRequest" 
				  		labeledNodeId="SID"/>
			    </uix:cellFormat>
			    <uix:cellFormat  hAlign="left">
			      <uix:stackLayout>
				         <uix:textInput shortDescBinding="SID@ListenerBundle@servletRequest" 
						 		name="SID" id="SID"
								textBinding="SID@defaultBean@servletRequest" 
								columns="16"/>
				        <uix:formValue name="id" valueBinding="SID@defaultBean@servletRequest" />
				       <uix:messageText messageType="error" messageBinding="SID@errors@servletRequest"/>
			      </uix:stackLayout>
			    </uix:cellFormat>
			  </uix:rowLayout>

			  <uix:rowLayout>
			    <uix:cellFormat hAlign="right">
			      <uix:messagePrompt promptBinding = "PROGRAM_ARG_ZERO@ListenerBundle@servletRequest"
				  		labeledNodeId="programArgZero" />
			    </uix:cellFormat>
			    <uix:cellFormat  hAlign="left">
			      <uix:stackLayout>
				         <uix:textInput shortDescBinding="PROGRAM_ARG_ZERO@ListenerBundle@servletRequest" 
						 		name="programArgZero" id="programArgZero"
								textBinding="programArgZero@defaultBean@servletRequest" 
								columns="16"/>
				        <uix:formValue name="id" valueBinding="programArgZero@defaultBean@servletRequest" />
				       <uix:messageText messageType="error" messageBinding="PROGRAM_ARG_ZERO@errors@servletRequest"/>
			      </uix:stackLayout>
			    </uix:cellFormat>
			  </uix:rowLayout>

			  <uix:rowLayout>
			    <uix:cellFormat hAlign="right">
			      <uix:messagePrompt promptBinding = "PROGRAM_ARGS@ListenerBundle@servletRequest" 
				  		labeledNodeId="programArgs"/>
			    </uix:cellFormat>
			    <uix:cellFormat  hAlign="left">
			      <uix:stackLayout>
				         <uix:textInput shortDescBinding="PROGRAM_ARGS@ListenerBundle@servletRequest" 
						 		name="programArgs" id="programArgs"
								textBinding="programArgs@defaultBean@servletRequest" 
								columns="50"/>
				        <uix:formValue name="id" valueBinding="programArgs@defaultBean@servletRequest" />
				       <uix:messageText messageType="error" messageBinding="PROGRAM_ARGS@errors@servletRequest"/>
			      </uix:stackLayout>
			    </uix:cellFormat>
			  </uix:rowLayout>

			</uix:tableLayout>

	       	     <uix:header textBinding="ENV_HDR@ListenerBundle@servletRequest" >
			<uix:styledText styleClass="OraInstructionText"
                         textBinding="ENV_VAR_DESC@ListenerBundle@servletRequest" />
		              <oem:table name="dataSource" 
					  			width="100%" 
								blockSize="25" 
								summaryBinding="ENV_VAR_LIST@netBundle@servletRequest"
								shortDescBinding="ENV_VAR_LIST@netBundle@servletRequest"
		                        formSubmitted="true"
		                        dataSourceKey="otherServiceEnvsList" dataSourceProp="dataSource"/>
			     <uix:submitButton textBinding="ADD_ANOTHER_ROW@defaultMsgBundle@servletRequest"  name="event" value="addAnotherEnvsRow" shortDescBinding="ADD_ANOTHER_ROW@netBundle@servletRequest"/>
 	       	     </uix:header>


		    <uix:pageButtons>
	              <uix:pageButtonBar>
		    	          <uix:submitButton textBinding="CANCEL@defaultMsgBundle@servletRequest" 
						  	name="event" value="cancel" shortDescBinding="CANCEL@netBundle@servletRequest"/>
		    	          <uix:submitButton textBinding="OK@defaultMsgBundle@servletRequest" 
						  	name="event" value="apply" shortDescBinding="OK@netBundle@servletRequest"/>
	              </uix:pageButtonBar>
        	    </uix:pageButtons>

		</uix:pageLayout> 
     </uix:form>
    </uix:body>
 </uix:document> 
</uix:renderingContext> 

