<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.db.rsc.net.NetMsg" %>
<%
request.setAttribute("netBundle", new BundleDataObject(NLSUtil.getBundle(NetMsg.class.getName(), request)));
%>
<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/> 
<uix:document> 

	<uix:metaContainer>
		<uix:head titleBinding="TITLE@servletRequest"/>
	</uix:metaContainer>

	<uix:body>
	<uix:form name="listenerForm" method="post" destinationBinding="defaultControllerURL@defaultBean@servletRequest">
		<uix:formValue name="pageName" value="/net/listener/traceLogPage"/>

		<uix:pageLayout titleBinding="header@defaultBean@servletRequest">
		      <%@ include file="/oemGlobal.jspf" %>

		        <oem:messageBox messageType = "error" msgBundleBinding="ListenerMsg@servletRequest" errorTableBinding="errors@servletRequest"
		                      titleTextKey="titleText" mainTextKey="mainText"/>
		        <uix:subTabLayout>
				<uix:subTabs>
				 <uix:subTabBar selectedIndexBinding="subTabBarSelectedIndex@mainNetBean@servletRequest">
					  <uix:link textBinding="GENERAL_TAB@ListenerBundle@servletRequest" 
					            onClick="submitForm('listenerForm', true, {event:'generalTab'})" />
					  <uix:link textBinding="AUTHENTICATION_TAB@ListenerBundle@servletRequest" 
					            onClick="submitForm('listenerForm', true, {event:'authenticationTab'})" />
					  <uix:link textBinding="LOG_TRACE_TAB@ListenerBundle@servletRequest" 
					            onClick="submitForm('listenerForm', true, {event:'logTraceTab'})" />
					  <uix:link textBinding="DB_SERVICES_TAB@ListenerBundle@servletRequest" 
					            onClick="submitForm('listenerForm', true, {event:'dbServiceTab'})" />
					  <uix:link textBinding="OTHER_SERVICES_TAB@ListenerBundle@servletRequest" 
					            onClick="submitForm('listenerForm', true, {event:'otherServiceTab'})" />
				 </uix:subTabBar>
				</uix:subTabs>

			        <uix:header textBinding="LOGGING@ListenerBundle@servletRequest">
	  				  <uix:stackLayout>

					  <oem:radioButton
					          name="loggingStatus"
					          selectedValueBinding="loggingStatus@defaultBean@servletRequest"
					          shortDescBinding="LOG_DISABLED@ListenerBundle@servletRequest"
							  textBinding="LOG_DISABLED@ListenerBundle@servletRequest"
						  value="false"/>
					  <oem:radioButton
					          name="loggingStatus"
					          selectedValueBinding="loggingStatus@defaultBean@servletRequest"
					          shortDescBinding="LOG_ENABLED@ListenerBundle@servletRequest"
							  textBinding="LOG_ENABLED@ListenerBundle@servletRequest"
						  value="true"/>

   			                <uix:labeledFieldLayout labelWidth="10%" fieldWidth="100%" width="100%">
						 <uix:messagePrompt promptBinding="LOG_FILE@ListenerBundle@servletRequest" 
						 	labeledNodeId="logFile" required="yes"/>
						<uix:stackLayout>
						    <uix:textInput shortDescBinding="LOG_FILE@ListenerBundle@servletRequest" 
								name="logFile" id="logFile"
								textBinding="logFile@defaultBean@servletRequest" 
								columns="80"/>
						        <uix:formValue name="id" valueBinding="logFile@defaultBean@servletRequest" />
						       <uix:messageText messageType="error" messageBinding="LOG_FILE@errors@servletRequest"/>
						</uix:stackLayout>
	  			         </uix:labeledFieldLayout>

					</uix:stackLayout>
				</uix:header>

				<uix:header textBinding="TRACING@ListenerBundle@servletRequest">
					<uix:stackLayout>

					  <oem:radioButton
					          name="tracingStatus"
					          selectedValueBinding="tracingStatus@defaultBean@servletRequest"
					          shortDescBinding="TRACE_DISABLED@ListenerBundle@servletRequest"
							  textBinding="TRACE_DISABLED@ListenerBundle@servletRequest"
						  value="false"/>
					  <oem:radioButton
					          name="tracingStatus"
					          selectedValueBinding="tracingStatus@defaultBean@servletRequest"
					          shortDescBinding="TRACE_ENABLED@ListenerBundle@servletRequest"
							  textBinding="TRACE_ENABLED@ListenerBundle@servletRequest"
						  value="true"/>

   			                <uix:labeledFieldLayout labelWidth="10%" fieldWidth="100%" width="100%">
	 		                 <uix:styledText styleClass=""  />
	 		                 <uix:styledText styleClass="OraInstructionText" 
							 	textBinding="TRACE_LEVEL_DESC@ListenerBundle@servletRequest"  />

	 		                 <uix:styledText styleClass=""  />
					<uix:tableLayout >
				                  <uix:rowLayout>
					           <uix:stackLayout>
				                    <oem:radioButton name="traceLevelStr"
				                         textBinding="TRACE_LEVEL_USER@ListenerBundle@servletRequest"
				                         shortDescBinding="TRACE_LEVEL_DESC@ListenerBundle@servletRequest"
										 valueBinding="TRACE_LEVEL_USER@ListenerBundle@servletRequest"
				                         selectedValueBinding="traceLevelStr@defaultBean@servletRequest"/>
				                    <uix:messageText messageType="info" messageBinding="TRACE_LEVEL_DESC_USER@ListenerBundle@servletRequest"/>
					           </uix:stackLayout>
				                  </uix:rowLayout>

				                  <uix:rowLayout>
					           <uix:stackLayout>
				                    <oem:radioButton name="traceLevelStr"
				                         textBinding="TRACE_LEVEL_ADMIN@ListenerBundle@servletRequest"
				                         shortDescBinding="TRACE_LEVEL_DESC@ListenerBundle@servletRequest"
										 valueBinding="TRACE_LEVEL_ADMIN@ListenerBundle@servletRequest"
				                         selectedValueBinding="traceLevelStr@defaultBean@servletRequest"/>
				                    <uix:messageText messageType="info" messageBinding="TRACE_LEVEL_DESC_ADMIN@ListenerBundle@servletRequest"/>
					           </uix:stackLayout>
				                  </uix:rowLayout>

				                  <uix:rowLayout>
					           <uix:stackLayout>
				                    <oem:radioButton name="traceLevelStr"
				                         textBinding="TRACE_LEVEL_SUPPORT@ListenerBundle@servletRequest"
				                         shortDescBinding="TRACE_LEVEL_DESC@ListenerBundle@servletRequest"
										 valueBinding="TRACE_LEVEL_SUPPORT@ListenerBundle@servletRequest"
				                         selectedValueBinding="traceLevelStr@defaultBean@servletRequest"/>
				                    <uix:messageText messageType="info" messageBinding="TRACE_LEVEL_DESC_SUPPORT@ListenerBundle@servletRequest"/>
					           </uix:stackLayout>
				                  </uix:rowLayout>
					</uix:tableLayout>

					        <uix:messagePrompt promptBinding="TRACE_FILE@ListenerBundle@servletRequest" 
								labeledNodeId="traceFile" required="yes"/>
					        <uix:stackLayout>
						    <uix:textInput shortDescBinding="TRACE_FILE@ListenerBundle@servletRequest" 
									name="traceFile" id="traceFile"
									textBinding="traceFile@defaultBean@servletRequest" 
									columns="80"/>
						    <uix:formValue name="id" valueBinding="traceFile@defaultBean@servletRequest" />
						    <uix:messageText messageType="error" messageBinding="TRACE_FILE@errors@servletRequest"/>
					        </uix:stackLayout>

					</uix:labeledFieldLayout>

				</uix:stackLayout>
			</uix:header>

		          </uix:subTabLayout>

			<uix:pageButtons>
			<uix:pageButtonBar>

                        <uix:contents>
	    	          <uix:submitButton textBinding="CANCEL@defaultMsgBundle@servletRequest" 
					  		name="event" value="cancel" shortDescBinding="CANCEL@netBundle@servletRequest"/>
	    	          <uix:submitButton textBinding="OK@defaultMsgBundle@servletRequest" 
					  		name="event" value="apply" shortDescBinding="OK@netBundle@servletRequest"/>
	        	</uix:contents>

			</uix:pageButtonBar>
			</uix:pageButtons>

		</uix:pageLayout> 
	  </uix:form>
	</uix:body>

 </uix:document> 
</uix:renderingContext> 

