<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%@ page import="oracle.sysman.eml.ecm.util.table.UIXDataSource" %>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.db.rsc.net.NetMsg" %>
<%@ page import="oracle.sysman.db.rsc.net.lsnr.ListenerMsg" %>
<%@ page import="oracle.sysman.emSDK.eml.SDKUIMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<%@ page import="oracle.cabo.ui.partial.PartialPageUtils"%>

<%
  request.setAttribute("netBundle", new BundleDataObject(NLSUtil.getBundle(NetMsg.class.getName(), request)));
  request.setAttribute("lsnrBundle", new BundleDataObject(NLSUtil.getBundle(ListenerMsg.class.getName(), request)));
  request.setAttribute("SDKUIResourceBundle", new BundleDataObject(NLSUtil.getBundle(SDKUIMsg.class.getName(), request)));
%>

<uix:renderingContext id="renderingContext">
	<oem:setURLEncoder id="renderingContext"/>

	<%
	  String dest = (String)request.getSession().getAttribute("processingDoneDestination");
	  if (dest != null)
	  {
		PartialPageUtils.forceRedirectURL(renderingContext, dest);
	    request.getSession().removeAttribute("processingDoneDestination");
	  }
	%>

	<uix:document>
	
	<%@ include file="/oemTitle.jspf" %>

    <%-- main contents --%>
    <uix:contents>
		<uix:form name="viewConfigDetails" method="post">
			<uix:pageLayout titleBinding="title@lsnrSegmentBean@servletRequest">
		        <%@ include file="/enablePPR.jspf" %>
				<%@ include file="/database/global.jspf" %>

				<%-- BEGINING OF INSTRUCTION TEXT  --%>
				<uix:styledText styleClass="OraInstructionText"
                       textBinding="confDetailsText@lsnrSegmentBean@servletRequest"/>
				<uix:spacer width="10"/>
				<%-- END OF INSTRUCTION TEXT  --%>

				<%-- Configuration Details table --%>
				<uix:dataScope currentDataBinding="lsnrTargetsTable@lsnrSegmentBean@servletRequest">
				<uix:table
					id="viewConf"
					name="viewConfDetailsTable" 
	                formSubmitted="true"
					minValue="1"
					width="100%"
					tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
					valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
					maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
					blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>"
					alternateTextBinding="NO_TARGETS_FOUND@MultiTargetResourceBundle">
				


			        <%-- Listener Name column --%>
                      <uix:column>
                        <uix:columnHeader>
                          <uix:sortableHeader 
                              textBinding="NAME@SDKUIResourceBundle@servletRequest"/>
                        </uix:columnHeader> 
                        <uix:columnFormat columnDataFormat="textFormat" width="25"/>
                        <uix:messageStyledText
                            textBinding="listenerColumn"
							destinationBinding="listenerColumnDestination">
                        </uix:messageStyledText>
                      </uix:column>

  			         <%-- LogFile Location  --%>
                      <uix:column>
                        <uix:columnHeader>
                          <uix:sortableHeader 
                              textBinding="LOG_FILE@lsnrBundle@servletRequest"/>
                        </uix:columnHeader> 
                        <uix:columnFormat columnDataFormat="textFormat"   width="25"/>
                        <uix:messageStyledText
                            textBinding="logFileColumn">
                        </uix:messageStyledText>
                      </uix:column>

  			         <%-- LogFile  Status --%>
                      <uix:column>
                        <uix:columnHeader>
                          <uix:sortableHeader 
                              textBinding="LOG_STATUS@lsnrBundle@servletRequest"/>
                        </uix:columnHeader> 
                        <uix:columnFormat columnDataFormat="textFormat"   width="25"/>
                        <uix:messageStyledText
                            textBinding="logStatusColumn">
                        </uix:messageStyledText>
                      </uix:column>

  			         <%-- TraceFile Location  --%>
                      <uix:column>
                        <uix:columnHeader>
                          <uix:sortableHeader 
                              textBinding="TRACE_FILE@lsnrBundle@servletRequest"/>
                        </uix:columnHeader> 
                        <uix:columnFormat columnDataFormat="textFormat"   width="25"/>
                        <uix:messageStyledText
                            textBinding="traceFileColumn">
                        </uix:messageStyledText>
                      </uix:column>

  			         <%-- Trace Level --%>
                      <uix:column>
                        <uix:columnHeader>
                          <uix:sortableHeader 
                              textBinding="TRACE_LEVEL@lsnrBundle@servletRequest"/>
                        </uix:columnHeader> 
                        <uix:columnFormat columnDataFormat="textFormat"  width="25"/>
                        <uix:messageStyledText
                            textBinding="traceStatusColumn">
                        </uix:messageStyledText>
                      </uix:column>

  			         <%-- Services  --%>
                      <uix:column>
                        <uix:columnHeader>
                          <uix:sortableHeader 
                              textBinding="LSNR_SERVICE_NAMES@lsnrBundle@servletRequest"/>
                        </uix:columnHeader> 
                        <uix:columnFormat columnDataFormat="textFormat"   width="25"/>
                        <uix:messageStyledText
                            textBinding="serviceNamesColumn">
                        </uix:messageStyledText>
                      </uix:column>

				</uix:table>
				</uix:dataScope>


				<%-- Return Button --%>
				<uix:pageButtons>
				<uix:pageButtonBar>
	              <uix:submitButton textBinding="OK@netBundle@servletRequest" name="event" value="return" shortDescBinding="OK@netBundle@servletRequest"/>
				</uix:pageButtonBar>
				</uix:pageButtons> 

			</uix:pageLayout>
		</uix:form>	
	</uix:contents>
	</uix:document>
</uix:renderingContext>
