<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ page import="oracle.sysman.emSDK.creds.CredsBean" %>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.db.rsc.net.NetMsg" %>

<%
request.setAttribute("netBundle", new BundleDataObject(NLSUtil.getBundle(NetMsg.class.getName(), request)));
%>
<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/> 
<uix:document> 

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="TITLE@servletRequest"/>
    </uix:metaContainer>


    <uix:body>
    <uix:form name="loginForm" method="POST" destinationBinding="defaultControllerURL@defaultBean@servletRequest">
    <uix:formValue name="pageName" value="/net/login"/>

      <uix:pageLayout titleBinding="header@defaultBean@servletRequest" >
       <%@ include file="/oemGlobal.jspf" %>

           <oem:messageBox messageType="error" msgBundleBinding="defaultMsgBundleName@servletRequest" errorTableBinding="errors@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>
<%
if(request.getAttribute(CredsBean.CREDS_BEAN_JSP_NAME) != null)
{
%>
        <uix:labeledFieldLayout width="68%">
 	  <uix:messagePrompt promptBinding="contextType@defaultBean@servletRequest" />
          <uix:styledText styleClass="OraDataText" textBinding="contextValue@defaultBean@servletRequest"/>
        </uix:labeledFieldLayout>
        <uix:labeledFieldLayout width="68%">
	  <uix:messagePrompt promptBinding="ORACLE_HOME@defaultMsgBundle@servletRequest" />
          <uix:styledText styleClass="OraDataText" textBinding="OHOME@servletRequest"/>
        </uix:labeledFieldLayout>
		
		<uix:formValue name="ORACLE_HOME" valueBinding="OHOME@servletRequest"/>
		<uix:formValue name="HOST_NAME" valueBinding="contextValue@defaultBean@servletRequest"/>		

       <%@ include file="/credentials.jspf" %>
             <uix:pageButtons>
	     <uix:pageButtonBar>
	              <uix:submitButton textBinding="CANCEL@defaultMsgBundle@servletRequest" 
				  		name="event" value="cancel" shortDescBinding="CANCEL@netBundle@servletRequest"/>
	              <uix:submitButton textBinding="LOGIN@defaultMsgBundle@servletRequest"  
				  		name="event" value="apply" shortDescBinding="LOGIN@netBundle@servletRequest"/> 
              </uix:pageButtonBar>
	      </uix:pageButtons>
<%
}
else
{
%>

	   <uix:labeledFieldLayout width="80%">
        	  <uix:messagePrompt required="yes" labeledNodeId="userName"
				promptBinding="userNameLabel@defaultBean@servletRequest" />
		      <uix:stackLayout>
                <uix:textInput name="userName" id="userName"
					shortDescBinding="userNameLabel@defaultBean@servletRequest"  
					noAutoComplete="true"
					textBinding="userName@defaultBean@servletRequest"/>
		        <uix:formValue name="id" valueBinding="userName@defaultBean@servletRequest" />
		        <uix:messageText messageType="error" messageBinding="NET_LOGIN_USERNAME@errors@servletRequest"/>
		      </uix:stackLayout>

              <uix:messagePrompt required="yes" labeledNodeId="secretPassword"
					promptBinding="NET_LOGIN_PSWD@defaultMsgBundle@servletRequest" />
		      <uix:stackLayout>
	        	   <uix:textInput name="secretPassword" id="secretPassword"
				   		shortDescBinding="NET_LOGIN_PSWD@defaultMsgBundle@servletRequest" 
						secret="true" 
						noAutoComplete="true" 
						textBinding="secretPassword@defaultBean@servletRequest"/>
		    	   <uix:formValue name="id" valueBinding="secretPassword@defaultBean@servletRequest" />
		    	   <uix:messageText messageType="error" messageBinding="NET_LOGIN_PSWD@errors@servletRequest"/>
		      </uix:stackLayout>

                  <uix:messagePrompt promptBinding="contextType@defaultBean@servletRequest" />
	              <uix:styledText styleClass="OraDataText" textBinding="contextValue@defaultBean@servletRequest"/>
	     </uix:labeledFieldLayout> 
             <uix:pageButtons>
	     <uix:pageButtonBar>
	              <uix:submitButton textBinding="CANCEL@defaultMsgBundle@servletRequest" 
				  		name="event" value="cancel" shortDescBinding="CANCEL@netBundle@servletRequest"/>
	              <uix:submitButton textBinding="LOGIN@defaultMsgBundle@servletRequest" 
				  		name="event" value="apply" shortDescBinding="LOGIN@netBundle@servletRequest"/> 
              </uix:pageButtonBar>
	      </uix:pageButtons>
<%
}
%>
	   </uix:pageLayout> 

     </uix:form>
    </uix:body>
 </uix:document> 
</uix:renderingContext> 



