<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.db.rsc.net.NetMsg" %>
<%@ page import="oracle.sysman.db.rsc.net.lsnr.ListenerMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<%@ page import="oracle.sysman.db.net.listener.LsnrHomePageModel" %>

<uix:document>

	<db:form name="performanceSubTab" method="post" 
		destination="/em/console/net/lsnr/performanceSubTab" copyParams="target,type">
		
	<uix:pageLayout>

		<uix:contents>

		<uix:formValue name="pageName" value="/net/lsnr/performanceSubTab"/>
		<uix:formValue name="event" value="changeRange"/>

		<uix:buildTree nodeID="pagePlugin">

			<uix:spacer height = "10"  width="10" />

			<uix:tableLayout hAlign="right">
				<uix:rowLayout>
					<uix:cellFormat>
						<uix:styledText styleClass="OraPromptText" labeledNodeId="selectedRange"
							textBinding="VIEW@ListenerBundle@servletRequest"/>
						<uix:spacer height = "10"  width="5" />
					</uix:cellFormat>

				<uix:cellFormat>
					<uix:choice name="selectedRange" id="selectedRange"
								selectedValueBinding="selectedRange@viewModel@servletRequest"
								shortDescBinding="VIEW@ListenerBundle@servletRequest"
								onChange="submitForm('performanceSubTab', true, {'event':'changeRange'})">

						<uix:contents childDataBinding="selectedRanges@viewModel@servletRequest">
							<uix:option textBinding="textKey" valueBinding="valueKey"/>
						</uix:contents>
					</uix:choice>
				<uix:spacer height = "10"  width="50" />

				<%--
				To mimic switcher effect i.e. if the selected range is "7 days" , the X axis label should be "Date"
				for rest "Time" , used JSP declaration as well as expression
				--%>

				<%!
						String value = "2";
				%>
				<%
						LsnrHomePageModel modelLsnr = (LsnrHomePageModel)request.getAttribute("viewModel");
						if(modelLsnr != null)
							value = modelLsnr.getSelectedRange();
						else
							value = request.getParameter("selectedRange");
						
						if(value == null)
						{
							value = "2";
						}						
				%>

						</uix:cellFormat>

					</uix:rowLayout>
				</uix:tableLayout>

				<uix:tableLayout>
					<uix:rowLayout>
						<uix:cellFormat>
							<oem:chart 	shadowEffect="shadow" 
										titleBinding="CHART@ListenerBundle@servletRequest"
										shortDescBinding="CHART@ListenerBundle@servletRequest"
										chartType="timeSeriesChart" legendVisible="external"
										width="350" height="270" orientation="vertical" 
										yAxisLabelBinding="YAXIS@ListenerBundle@servletRequest"
										xAxisLabelBinding =
							"<%= (value.equals(\"7*24\")?\"DATE@ListenerBundle@servletRequest\":\"TIME@ListenerBundle@servletRequest\") %>" >
								<oem:sqlChartDataSource sqlResultSetBinding="CHART_RESULTSET@servletRequest" />

								<oem:chartColumn 	displayLabelBinding = "ESTCONNS@ListenerBundle@servletRequest"
																sourceIndex="0" itemColor="#663366"/>
								<oem:chartColumn 	displayLabelBinding = "REFCONNS@ListenerBundle@servletRequest"
																sourceIndex="1" itemColor="#9999FF" />
								<oem:chartColumn isTimeColumn="true"  displayLabel="Time" sourceIndex="2" />
							</oem:chart>
						</uix:cellFormat>
					</uix:rowLayout>

				</uix:tableLayout>

		</uix:buildTree>

		<%@include  file="/sdk/pageTemplate.jspf" %>
		</uix:contents>
	</uix:pageLayout>
	</db:form>
</uix:document>

