<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>

<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.db.rsc.DBObjectMsg" %>
<%@ page import="oracle.sysman.db.rsc.net.NetMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<%
  request.setAttribute("dbObjBundle", new BundleDataObject(NLSUtil.getBundle(DBObjectMsg.class.getName(), request)));
  request.setAttribute("netBundle", new BundleDataObject(NLSUtil.getBundle(NetMsg.class.getName(), request)));
%>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/> 
<uix:document> 

    <uix:metaContainer>
      <uix:head titleBinding="TITLE@servletRequest"/>
    </uix:metaContainer>


  <uix:pageLayout>	
   <%@ include file="/oemGlobal.jspf" %>
     <uix:contents>

    <uix:body>
    <uix:form name="listeners" method="post" destinationBinding="defaultControllerURL@controllerIDBean@servletRequest">
    <uix:formValue name="pageName" value="/net/netAdmin"/>

      <uix:contents>

	  <oem:messageBox messageTypeBinding = "messageType@servletRequest" msgBundleBinding="defaultMsgBundleName@servletRequest" errorTableBinding="errors@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>

          
        <uix:header textBinding="header@defaultBean@servletRequest">
			<uix:styledText styleClass="OraInstructionText"
                         textBinding="NET_SERVICE_ADMIN_DESC@defaultMsgBundle@servletRequest" />

			<uix:bulletedList>
				<uix:styledText styleClass="OraInstructionText"
                         textBinding="LSNR_DESC@defaultMsgBundle@servletRequest" />
				<uix:styledText styleClass="OraInstructionText"
                         textBinding="DIR_NAMING_DESC@defaultMsgBundle@servletRequest" />
				<uix:styledText styleClass="OraInstructionText"
                         textBinding="LOCAL_NAMING_DESC@defaultMsgBundle@servletRequest" />
				<uix:styledText styleClass="OraInstructionText"
                         textBinding="PROFILE_DESC@defaultMsgBundle@servletRequest" />				
				<uix:styledText styleClass="OraInstructionText"
                         textBinding="FILE_LOC_DESC@defaultMsgBundle@servletRequest" />
				
			</uix:bulletedList>

			<uix:styledText styleClass="OraInstructionText"
                         textBinding="NET_ADMIN_END_DESC@defaultMsgBundle@servletRequest" />

	   		<oem:table width="100%" 
						summaryBinding="ORACLE_HOME_LIST@netBundle@servletRequest"
						shortDescBinding="ORACLE_HOME_LIST@netBundle@servletRequest"
    	              	alternateTextBinding="NO_OHS_FOUND@defaultMsgBundle@servletRequest"
						blockSize="25"
						name="oracleHomesList" 
						formSubmitted="true"
						beanKey = "defaultBean"	
						dataSourceProp="oracleHomesList">

                      <uix:tableSelection>
                        <uix:singleSelection shortDescBinding="SELECT@dbObjBundle@servletRequest" selectedIndexBinding="selectedIndex@defaultBean@servletRequest" >
                          <uix:contents>
	                         <uix:styledText styleClass="OraPromptText" labeledNodeId="configOperation"
								textBinding="ADMINISTER@defaultMsgBundle@servletRequest"/>
							 <uix:choice name="configOperation" id="configOperation"
								selectedValueBinding="configOperation@defaultBean@servletRequest" 
								shortDescBinding="ADMINISTER@defaultMsgBundle@servletRequest">
							 <uix:contents childDataBinding="configOperations@defaultBean@servletRequest">
								<uix:option textBinding="text"
											valueBinding="value"/>
							</uix:contents>
					</uix:choice>
	       		         <uix:submitButton textBinding="GO@defaultMsgBundle@servletRequest" 
						 		name="event" value="configure" shortDescBinding="GO@netBundle@servletRequest"/>
                          </uix:contents>
                        </uix:singleSelection>
                      </uix:tableSelection>
             </oem:table>


     </uix:header>

     </uix:contents>
     </uix:form>
    </uix:body>
    </uix:contents>	
   </uix:pageLayout> 
 </uix:document> 
</uix:renderingContext> 



