<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.db.rsc.DBObjectMsg" %>
<%@ page import="oracle.sysman.db.rsc.net.NetMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<%
  request.setAttribute("dbObjBundle", new BundleDataObject(NLSUtil.getBundle(DBObjectMsg.class.getName(), request)));
  request.setAttribute("netBundle", new BundleDataObject(NLSUtil.getBundle(NetMsg.class.getName(), request )));
%>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/> 
<uix:document> 

    <uix:metaContainer>
      <uix:head titleBinding="TITLE@servletRequest"/>
    </uix:metaContainer>

     <uix:body> 
     <uix:form name="servicesForm"  method="post" destinationBinding="defaultControllerURL@controllerIDBean@servletRequest">
     <uix:formValue name="pageName" value="/net/netService/addImportNetService"/>
     <uix:pageLayout titleBinding="header@defaultBean@servletRequest">		
        <%@ include file="/oemGlobal.jspf" %>
     <oem:messageBox messageTypeBinding = "messageType@servletRequest" msgBundleBinding="ServiceMsg@servletRequest" errorTableBinding="errors@servletRequest"
                     titleTextKey="titleText" mainTextKey="mainText"/>

          <uix:styledText styleClass="OraInstructionText" textBinding="description@defaultBean@servletRequest"/>
          <uix:tableLayout width="100%">
	  <uix:rowLayout>
	     <uix:cellFormat >
	        <oem:table name="netServicesImportUI" 
						width="100%" 
						blockSize="25" 
						summaryBinding="NET_SERVICES_LIST@netBundle@servletRequest"
						shortDescBinding="NET_SERVICES_LIST@netBundle@servletRequest"
	  	          		alternateTextBinding="NO_SEARCH_RES@defaultMsgBundle@servletRequest"
                        formSubmitted="true"
		          		beanKey="defaultBean"
                        dataSourceProp="netServicesImportUI">
		            <uix:tableSelection>
		              <uix:multipleSelection shortDescBinding="SELECT@dbObjBundle@servletRequest"
		                selectionBinding="selection@defaultBean@servletRequest"
		                selectedBinding="selected"/>
		            </uix:tableSelection>
                 </oem:table>
            </uix:cellFormat>
	    </uix:rowLayout>

           </uix:tableLayout>

	    <uix:pageButtons>
	      <uix:pageButtonBar>
    	          <uix:submitButton textBinding="CANCEL@defaultMsgBundle@servletRequest" name="event" value="cancel"
		  shortDescBinding="CANCEL@netBundle@servletRequest"/>
    	          <uix:submitButton textBinding="OK@defaultMsgBundle@servletRequest" name="event" value="apply"
		  shortDescBinding="OK@netBundle@servletRequest"/>
	      </uix:pageButtonBar>
	    </uix:pageButtons>

   </uix:pageLayout> 
   </uix:form>
   </uix:body> 
 </uix:document> 
</uix:renderingContext> 	    

