<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.db.rsc.DBObjectMsg" %>
<%@ page import="oracle.sysman.db.rsc.net.NetMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<%
  request.setAttribute("netBundle", new BundleDataObject(NLSUtil.getBundle(NetMsg.class.getName(), request)));
%>
<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/> 
<uix:document> 
    <%@ include file="/oemTitle.jspf" %>
    <uix:metaContainer>
      <uix:head titleBinding="TITLE@servletRequest"/>
    </uix:metaContainer>

      <uix:body>
      <uix:form name="addressForm" method="post" destinationBinding="defaultControllerURL@defaultBean@servletRequest">
          <uix:pageLayout titleBinding="header@defaultBean@servletRequest">	
	    <%@ include file="/oemGlobal.jspf" %>
	    <uix:formValue name="pageName" value="/net/netService/addressPage"/>

	    <uix:pageButtons>
              <uix:pageButtonBar>
	    	      <uix:submitButton textBinding="CANCEL@defaultMsgBundle@servletRequest" 
				  		name="event" value="cancel" shortDescBinding="CANCEL@netBundle@servletRequest"/>
	    	      <uix:submitButton textBinding="OK@defaultMsgBundle@servletRequest" 
				  		name="event" value="apply" shortDescBinding="OK@netBundle@servletRequest"/>
              </uix:pageButtonBar>
            </uix:pageButtons>

           <oem:messageBox messageType = "error" msgBundleBinding="CommonMsg@servletRequest" errorTableBinding="errors@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
	
	    <uix:switcher childNameBinding="creating@defaultBean@servletRequest">
	    <uix:case name="true">
	        <uix:labeledFieldLayout labelWidth="25%" fieldWidth="100%" width="80%">
                <uix:messagePrompt promptBinding="PROTOCOL_FIELD@defaultMsgBundle@servletRequest"
						labeledNodeId="selectedProtocolID"/>
                <uix:choice name="selectedProtocolID" id="selectedProtocolID"
						selectedValueBinding="selectedProtocolID@mainNetBean@servletRequest"
						shortDescBinding="PROTOCOL_FIELD@defaultMsgBundle@servletRequest"
						onChange="submitForm('addressForm', true,{'event':'changeProtocol'})" >
                  <uix:contents childDataBinding="protocolsChoiceInfo@mainNetBean@servletRequest">
                    <uix:option textBinding="netTextKey"
                                valueBinding="netValueKey"/>
                  </uix:contents>
			</uix:choice>
	        </uix:labeledFieldLayout>
	    </uix:case>
	    <uix:case name="false">
	        <uix:labeledFieldLayout labelWidth="25%" fieldWidth="100%" width="80%">
		    <uix:switcher childNameBinding="protocol@protAddress@servletRequest">
			    <uix:case name="TCP">
			            <uix:styledText styleClass="OraDataText" textBinding="TCP@CommonBundle@servletRequest"/>
			    </uix:case>
			    <uix:case name="TCPS">
			            <uix:styledText styleClass="OraDataText" textBinding="TCPS@CommonBundle@servletRequest"/>
			    </uix:case>
			    <uix:case name="SDP">
			            <uix:styledText styleClass="OraDataText" textBinding="SDP@CommonBundle@servletRequest"/>
			    </uix:case>
			    <uix:case name="IPC">
			            <uix:styledText styleClass="OraDataText" textBinding="IPC@CommonBundle@servletRequest"/>
			    </uix:case>
			    <uix:case name="NMP">
			            <uix:styledText styleClass="OraDataText" textBinding="NAMED_PIPES@CommonBundle@servletRequest"/>
			    </uix:case>
		    </uix:switcher>
	        </uix:labeledFieldLayout>
	    </uix:case>
	    </uix:switcher>


	    <uix:switcher childNameBinding="protocol@protAddress@servletRequest">
		    <uix:case name="TCPS">
			  <%@ include file="../addr/addressTCP.jsp" %>
		    </uix:case>
		    <uix:case name="TCP">
			  <%@ include file="../addr/addressTCP.jsp" %>
		    </uix:case>
		    <uix:case name="IPC">
			  <%@ include file="../addr/addressIPC.jsp" %>
		    </uix:case>
		    <uix:case name="NMP">
			  <%@ include file="../addr/addressNMP.jsp" %>
		    </uix:case>
		    <uix:case name="SDP">
			  <%@ include file="../addr/addressTCP.jsp" %>
		    </uix:case>
	    </uix:switcher>

          </uix:pageLayout>
  </uix:form>
  </uix:body>
 </uix:document> 
</uix:renderingContext> 


