<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.db.rsc.net.NetMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<%
  request.setAttribute("netBundle", new BundleDataObject(NLSUtil.getBundle(NetMsg.class.getName(), request)));
%>

<uix:renderingContext id="renderingContext">

<oem:setURLEncoder id="renderingContext"/> 

<uix:document>

    <uix:metaContainer>

      <uix:head titleBinding="TITLE@servletRequest"/>

    </uix:metaContainer>

      <uix:body> 

      <uix:form name="serviceForm" method="post" destinationBinding="defaultControllerURL@defaultBean@servletRequest">

      <uix:formValue name="pageName" value="/net/netService/advancePage"/>


	<uix:pageLayout titleBinding="header@defaultBean@servletRequest">	

        <%@ include file="/oemGlobal.jspf" %>

        <oem:messageBox messageType = "error" msgBundleBinding="ServiceMsg@servletRequest" errorTableBinding="errors@servletRequest"

                      titleTextKey="titleText" mainTextKey="mainText"/>


        <uix:subTabLayout>

          <uix:subTabs>

                 <uix:subTabBar selectedIndexBinding="subTabBarSelectedIndex@defaultBean@servletRequest">

			  <uix:link textBinding="GENERAL_TAB@NetServiceBundle@servletRequest" 

			            onClick="submitForm('serviceForm', true, {event:'generalTab'})" />

			  <uix:link textBinding="ADVANCE_TAB@NetServiceBundle@servletRequest"

			            onClick="submitForm('serviceForm', true, {event:'advanceTab'})" />

                 </uix:subTabBar>

             </uix:subTabs>


        <uix:tableLayout cellSpacing="5">


        <uix:switcher childNameBinding ="serviceNameUsed@defaultBean@servletRequest" >

	<uix:case name="true">

	  <uix:rowLayout>

	    <uix:cellFormat hAlign="right">

	      <uix:messagePrompt promptBinding = "INSTANCE_NAME@NetServiceBundle@servletRequest" 
		  		labeledNodeId="instanceName" />

	    </uix:cellFormat>

	    <uix:cellFormat>

	      <uix:stackLayout>

             <uix:textInput name="instanceName" 
			 		id="instanceName" 
			 		shortDescBinding="INSTANCE_NAME@NetServiceBundle@servletRequest" 
					textBinding="instanceName@defaultBean@servletRequest"
					columns="16"/>			

	               <uix:messageText messageType="error" messageBinding="INSTANCE_NAME@errors@servletRequest"/>

	      </uix:stackLayout>

	    </uix:cellFormat>

	  </uix:rowLayout>

	</uix:case>

        </uix:switcher>



	  <uix:rowLayout>

	    <uix:cellFormat hAlign="right" vAlign="top">

	      <uix:messagePrompt promptBinding = "SDU@NetServiceBundle@servletRequest" 
		  		labeledNodeId="SDU"/>

	    </uix:cellFormat>

	    <uix:cellFormat>

	      <uix:stackLayout>

            <uix:textInput name="SDU" id="SDU" shortDescBinding="SDU@NetServiceBundle@servletRequest"
            			textBinding="SDU@defaultBean@servletRequest" columns="16"/>

	               <uix:messageText messageType="error" messageBinding="SDU@errors@servletRequest"/>

	      </uix:stackLayout>

	    </uix:cellFormat>

	  </uix:rowLayout>


	  <uix:rowLayout>

	    <uix:cellFormat hAlign="left" vAlign="top">

                  <uix:checkBox

	                name="heterSrvcUsed"

			disabledBinding="DBService@defaultBean@servletRequest"	

        	        checkedBinding="heterSrvcUsed@defaultBean@servletRequest"

        	        textBinding="USE_FOR_HETER_SRVC@NetServiceBundle@servletRequest" 
					shortDescBinding="USE_FOR_HETER_SRVC@NetServiceBundle@servletRequest"
					/>

	    </uix:cellFormat>

	  </uix:rowLayout>


	</uix:tableLayout>

<%---------------------------- Start of TAF Impl -------------------------------------------%>
<%--
<uix:header textBinding="TAF_HEADER@NetServiceBundle@servletRequest">

   <uix:tableLayout cellSpacing="5">

    <uix:rowLayout>

        <uix:cellFormat hAlign="right">
           <uix:messagePrompt promptBinding = "TAF_BACKUP_NETSRVC@NetServiceBundle@servletRequest" />
        </uix:cellFormat>

        <uix:cellFormat  hAlign="left">

          <uix:stackLayout>
            <uix:textInput name="bkpNetSrvcTAF"
	    	textBinding="bkpNetSrvcTAF@currentAttributes@defaultBean@servletRequest" columns="30"/>
          </uix:stackLayout>

        </uix:cellFormat>

    </uix:rowLayout>

    <uix:rowLayout>

        <uix:cellFormat hAlign="right">
           <uix:messagePrompt promptBinding = "TAF_FAILOVER_TYPE@NetServiceBundle@servletRequest" />
        </uix:cellFormat>

        <uix:cellFormat hAlign="left">

	 <oem:choice name="failOverTypeTAF"
   		optionsBinding="failOverTypes@currentAttributes@defaultBean@servletRequest"
   		selectedValueBinding = "selectedFailOverType@currentAttributes@defaultBean@servletRequest"
	 />

        </uix:cellFormat>

    </uix:rowLayout>

    <uix:rowLayout>

        <uix:cellFormat hAlign="right">

           <uix:messagePrompt promptBinding= "TAF_FAILOVER_METHOD@NetServiceBundle@servletRequest"/>

        </uix:cellFormat>

        <uix:cellFormat hAlign="left">

            <oem:choice name="failOverMethodTAF"
   		optionsBinding="failOverMethods@currentAttributes@defaultBean@servletRequest"
   		selectedValueBinding = "selectedFailOverMethod@currentAttributes@defaultBean@servletRequest"
	    />

        </uix:cellFormat>

    </uix:rowLayout>

    <uix:rowLayout>

         <uix:cellFormat hAlign="right">

              <uix:messagePrompt promptBinding = "TAF_RETRIES@NetServiceBundle@servletRequest" />

         </uix:cellFormat>

         <uix:cellFormat  hAlign="left">

              <uix:stackLayout>

                  <uix:textInput name="retriesTAF"
		  	textBinding="retriesTAF@currentAttributes@defaultBean@servletRequest" columns="30"/>

              </uix:stackLayout>

         </uix:cellFormat>

    </uix:rowLayout>

    <uix:rowLayout>
                              
         <uix:cellFormat hAlign="right">
                                  
                <uix:messagePrompt promptBinding = "TAF_TIME_DELAY@NetServiceBundle@servletRequest" />

         </uix:cellFormat>

         <uix:cellFormat  hAlign="left">
                                  
              <uix:stackLayout>
                                    
                   <uix:textInput name="timeOutTAF"
		   	textBinding = "timeOutTAF@currentAttributes@defaultBean@servletRequest"  columns="30"/>
                                    
              </uix:stackLayout>
                                  
         </uix:cellFormat>
                              
    </uix:rowLayout>

  </uix:tableLayout>

</uix:header>
--%>
<%---------------------------- End of TAF Impl -------------------------------------------%>

  	    <uix:header textBinding="RDB_SETTINGS@NetServiceBundle@servletRequest">

	        <uix:tableLayout cellSpacing="5">

		  <uix:rowLayout>

		    <uix:cellFormat hAlign="right" vAlign="top">

		      <uix:messagePrompt promptBinding = "RDB_DB@NetServiceBundle@servletRequest" 
			  		labeledNodeId="RDB_DATABASE"	/>

		    </uix:cellFormat>

		    <uix:cellFormat>

		      <uix:stackLayout>

                <uix:textInput name="RDB_DATABASE" id="RDB_DATABASE" 
						shortDescBinding="RDB_DB@NetServiceBundle@servletRequest"
				        textBinding="RDB_DATABASE@defaultBean@servletRequest"
						disabledBinding="DBService@defaultBean@servletRequest"	
						columns="16"/>			

		               <uix:messageText messageType="error" messageBinding="RDB_DB@errors@servletRequest"/>

		      </uix:stackLayout>

		    </uix:cellFormat>

		  </uix:rowLayout>


		  <uix:rowLayout>

		    <uix:cellFormat hAlign="right" vAlign="top">

		      <uix:messagePrompt promptBinding = "TYPE_OF_SRVC@NetServiceBundle@servletRequest" 
			  		labeledNodeId="typeOfService"/>

		    </uix:cellFormat>

		    <uix:cellFormat>

		      <uix:stackLayout>

                  <uix:textInput name="typeOfService" id="typeOfService" 
				  		shortDescBinding="TYPE_OF_SRVC@NetServiceBundle@servletRequest"
				        textBinding="typeOfService@defaultBean@servletRequest"
						disabledBinding="DBService@defaultBean@servletRequest"	columns="16"/>			

		               <uix:messageText messageType="error" messageBinding="TYPE_OF_SRVC@errors@servletRequest"/>

		      </uix:stackLayout>

		    </uix:cellFormat>

		  </uix:rowLayout>


		  <uix:rowLayout>

		    <uix:cellFormat hAlign="right" vAlign="top">

		      <uix:messagePrompt promptBinding = "GLOBAL_DB_NAME@NetServiceBundle@servletRequest" 
			  		labeledNodeId="GDBName"/>

		    </uix:cellFormat>

		    <uix:cellFormat>

		      <uix:stackLayout>

                 <uix:textInput name="GDBName" id="GDBName"
				 		shortDescBinding="GLOBAL_DB_NAME@NetServiceBundle@servletRequest"
						textBinding="GDBName@defaultBean@servletRequest"
						disabledBinding="DBService@defaultBean@servletRequest"	columns="16"/>			

		               <uix:messageText messageType="error" messageBinding="GLOBAL_DB_NAME@errors@servletRequest"/>

		      </uix:stackLayout>

		    </uix:cellFormat>

		  </uix:rowLayout>

        </uix:tableLayout>


  	 </uix:header>

           </uix:subTabLayout>


	    <uix:pageButtons>

	      <uix:pageButtonBar>

    	          <uix:submitButton textBinding="CANCEL@defaultMsgBundle@servletRequest" 
				  	name="event" value="cancel" shortDescBinding="CANCEL@netBundle@servletRequest"/>

    	          <uix:submitButton textBinding="OK@defaultMsgBundle@servletRequest" 
				  	name="event" value="apply" shortDescBinding="OK@netBundle@servletRequest"/>

	      </uix:pageButtonBar>

	    </uix:pageButtons>


   </uix:pageLayout> 

  </uix:form>

 </uix:body> 

 </uix:document> 

</uix:renderingContext> 
