<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.db.rsc.net.NetMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<%
  request.setAttribute("netBundle", new BundleDataObject(NLSUtil.getBundle(NetMsg.class.getName(), request)));
%>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/> 
<uix:document> 

    <uix:metaContainer>
      <uix:head titleBinding="TITLE@servletRequest"/>
    </uix:metaContainer>


     <uix:body> 
      <uix:form name="aliasForm" method="post" destinationBinding="defaultControllerURL@defaultBean@servletRequest">
      <uix:formValue name="pageName" value="/net/netService/aliasGeneralPage"/>

     
	<uix:pageLayout titleBinding="header@defaultBean@servletRequest">	
        <%@ include file="/oemGlobal.jspf" %>
        <oem:messageBox messageType = "error" msgBundleBinding="ServiceMsg@servletRequest" errorTableBinding="errors@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>


	<uix:tableLayout cellSpacing="5">

		<uix:rowLayout>
     	          <uix:cellFormat hAlign="left">
		      <uix:messagePrompt promptBinding = "ALIAS_NAME@NetServiceBundle@servletRequest" 
			  		labeledNodeId="objectName" required="yes" />
		  </uix:cellFormat>
		  <uix:cellFormat>
		      <uix:stackLayout>
                  <uix:textInput name="objectName" id="objectName"
						shortDescBinding="ALIAS_NAME@NetServiceBundle@servletRequest"
				 		textBinding="objectName@defaultBean@servletRequest" columns="16"/>
		               <uix:messageText messageType="error" messageBinding="ALIAS_NAME@errors@servletRequest"/>
		      </uix:stackLayout>
		    </uix:cellFormat>
		  </uix:rowLayout>
		  
	</uix:tableLayout>

        <uix:header textBinding="ALIAS_SERVICE_HDR@NetServiceBundle@servletRequest">

	<uix:styledText styleClass="OraInstructionText" textBinding="ALIAS_SERVICE_DESC@NetServiceBundle@servletRequest" />
  	  <uix:tableLayout cellSpacing="5">

		  <uix:rowLayout>
     	          <uix:cellFormat hAlign="left">
		      <uix:messagePrompt promptBinding = "ORACLE_CONTEXT@NetServiceBundle@servletRequest" 
			  		required="yes" />
		    </uix:cellFormat>
		    <uix:cellFormat>
		      <uix:stackLayout>
	               <uix:flowLayout>
			 		<oem:choice 	name="oracleContext"
						optionsBinding = "oracleContexts@defaultBean@servletRequest" 
						shortDescBinding= "ORACLE_CONTEXT@NetServiceBundle@servletRequest" 
						selectedValueBinding = "oracleContext@defaultBean@servletRequest" />
		               <uix:messageText messageType="error" messageBinding="ORACLE_CONTEXT@errors@servletRequest"/>
	    	          <uix:submitButton textBinding="GO@defaultMsgBundle@servletRequest" name="event" value="contextSwitch" shortDescBinding="GO@netBundle@servletRequest"/>
	               </uix:flowLayout>
		                <uix:messageText messageType="info" messageBinding="CTRL_CHANGE_EVENT_HINT@defaultMsgBundle@servletRequest" />
		      </uix:stackLayout>
		    </uix:cellFormat>
		  </uix:rowLayout>

		  <uix:rowLayout>
     	          <uix:cellFormat hAlign="left">
		      <uix:messagePrompt promptBinding = "REF_SERVICE_NAME@NetServiceBundle@servletRequest" required="yes" />
		    </uix:cellFormat>
		    <uix:cellFormat>
		      <uix:stackLayout>
			 	<oem:choice 	name="aliasedName"
					optionsBinding = "aliasedNames@defaultBean@servletRequest" 
					shortDescBinding="REF_SERVICE_NAME@NetServiceBundle@servletRequest"
					selectedValueBinding = "aliasedName@defaultBean@servletRequest" />
		         <uix:messageText messageType="error" messageBinding="REF_SERVICE_NAME@errors@servletRequest"/>
		      </uix:stackLayout>
		    </uix:cellFormat>
		  </uix:rowLayout>

           </uix:tableLayout>
        </uix:header>

	    <uix:pageButtons>
	      <uix:pageButtonBar>
    	          <uix:submitButton textBinding="CANCEL@defaultMsgBundle@servletRequest" 
				  		name="event" value="cancel" shortDescBinding="CANCEL@netBundle@servletRequest"/>
    	          <uix:submitButton textBinding="OK@defaultMsgBundle@servletRequest" 
				  		name="event" value="apply" shortDescBinding="OK@netBundle@servletRequest"/>
	      </uix:pageButtonBar>
	    </uix:pageButtons>

   </uix:pageLayout> 
  </uix:form>
  </uix:body> 
 </uix:document> 
</uix:renderingContext> 
