<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.db.rsc.DBObjectMsg" %>
<%@ page import="oracle.sysman.db.rsc.net.NetMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<%
  request.setAttribute("dbObjBundle", new BundleDataObject(NLSUtil.getBundle(DBObjectMsg.class.getName(), request)));
  request.setAttribute("netBundle", new BundleDataObject(NLSUtil.getBundle(NetMsg.class.getName(), request)));
%>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/> 
<uix:document> 

    <uix:metaContainer>
      <uix:head titleBinding="TITLE@servletRequest"/>
    </uix:metaContainer>

      <uix:body> 
      <uix:form name="serviceForm" method="post" destinationBinding="defaultControllerURL@defaultBean@servletRequest">
      <uix:formValue name="pageName" value="/net/netService/generalPage"/>


     
	<uix:pageLayout titleBinding="header@defaultBean@servletRequest">	
        <%@ include file="/oemGlobal.jspf" %>
        <oem:messageBox messageType = "error" msgBundleBinding="ServiceMsg@servletRequest" errorTableBinding="errors@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>

        <uix:subTabLayout>
          <uix:subTabs>
                 <uix:subTabBar selectedIndexBinding="subTabBarSelectedIndex@defaultBean@servletRequest">
			  <uix:link textBinding="GENERAL_TAB@NetServiceBundle@servletRequest" 
			            onClick="submitForm('serviceForm', true, {event:'generalTab'})" />
			  <uix:link textBinding="ADVANCE_TAB@NetServiceBundle@servletRequest" 
			            onClick="submitForm('serviceForm', true, {event:'advanceTab'})" />
                 </uix:subTabBar>
             </uix:subTabs>


	<uix:tableLayout cellSpacing="5">

		<uix:rowLayout>
	     	        <uix:cellFormat hAlign="left">
	        	    <uix:switcher childNameBinding ="DBService@defaultBean@servletRequest" >
        			<uix:case name="false">
				      <uix:messagePrompt required="yes" labeledNodeId="objectName"
					  	promptBinding ="NET_SERVICE_NAME_FIELD@NetServiceBundle@servletRequest"  />
        			</uix:case>
        			<uix:case name="true">
				      <uix:messagePrompt labeledNodeId="objectName" promptBinding =
				           "DB_SERVICE_NAME_FIELD@NetServiceBundle@servletRequest" required="yes" />
        			</uix:case>
	        	   </uix:switcher>
			</uix:cellFormat>

			<uix:cellFormat>
			      <uix:stackLayout>
	                  <uix:textInput name="objectName" id="objectName" shortDesc="Object Name"
						 textBinding="objectName@defaultBean@servletRequest" columns="16"/>
		        	        <uix:switcher childNameBinding ="DBService@defaultBean@servletRequest" >
	        				<uix:case name="false">
				               		<uix:messageText messageType="error"
								 messageBinding="NET_SERVICE_NAME_FIELD@errors@servletRequest"/>
	        				</uix:case>
	        				<uix:case name="true">
				               		<uix:messageText messageType="error"
								 messageBinding="DB_SERVICE_NAME_FIELD@errors@servletRequest"/>
	        				</uix:case>
		        	        </uix:switcher>
			      	</uix:stackLayout>
			</uix:cellFormat>
		</uix:rowLayout>

	</uix:tableLayout>

 	    <uix:header textBinding="SERVICE_DETAIL_HEADER@NetServiceBundle@servletRequest">
		      <uix:stackLayout>
			<uix:styledText styleClass="OraInstructionText" 
					textBinding="SID_OR_SRVC_NAME_DESC@NetServiceBundle@servletRequest" />
			<uix:tableLayout cellSpacing="5">
			  <uix:rowLayout>
	     	          <uix:cellFormat hAlign="left" width ="100%">
			      <uix:stackLayout>
				<oem:radioButton
				  name="serviceNameUsed"
				  selectedValueBinding="serviceNameUsed@defaultBean@servletRequest"
				  textBinding="USE_SERVICE_NAME@NetServiceBundle@servletRequest"
				  shortDescBinding="USE_SERVICE_NAME@NetServiceBundle@servletRequest"
				  value="true"/>

		                <uix:labeledFieldLayout>
			           <uix:contents>
				      <uix:messagePrompt labeledNodeId="serviceName" 
					  		promptBinding = "SERVICE_NAME@NetServiceBundle@servletRequest"/>
				      <uix:stackLayout>
	                	<uix:textInput name="serviceName" id="serviceName"
								shortDescBinding="SERVICE_NAME@NetServiceBundle@servletRequest" 
								textBinding="serviceName@defaultBean@servletRequest"
								columns="40"/>			
			        	       <uix:messageText messageType="error" messageBinding="SERVICE_NAME@errors@servletRequest"/>
				      </uix:stackLayout>
			           </uix:contents>
		                </uix:labeledFieldLayout >
			      </uix:stackLayout>
			    </uix:cellFormat>

			  </uix:rowLayout>

			  <uix:rowLayout>
	     	          <uix:cellFormat hAlign="left" width ="100%">
			      <uix:stackLayout>
				<oem:radioButton
				  name="serviceNameUsed"
				  selectedValueBinding="serviceNameUsed@defaultBean@servletRequest"
				  shortDescBinding="USE_SID@NetServiceBundle@servletRequest"
				  textBinding="USE_SID@NetServiceBundle@servletRequest"
				  value="false"/>
		                <uix:labeledFieldLayout labelWidth="25%" fieldWidth="100%" width="80%">
			           <uix:contents>
				      <uix:messagePrompt labeledNodeId="SID" 
					  		promptBinding = "SID@NetServiceBundle@servletRequest"/>
				      <uix:stackLayout>
		               <uix:textInput name="SID" id="SID"
					   		shortDescBinding="SID@NetServiceBundle@servletRequest" 
							textBinding="SID@defaultBean@servletRequest"
							columnsBinding="SIDColBinding@defaultBean@servletRequest"/>			
				               <uix:messageText messageType="error" messageBinding="SID@errors@servletRequest"/>
				      </uix:stackLayout>
			           </uix:contents>
		                </uix:labeledFieldLayout >
			      </uix:stackLayout>

			    </uix:cellFormat>
			  </uix:rowLayout>

			  <uix:rowLayout>
	     	          <uix:cellFormat hAlign="left" columnSpan ="2">
			      <uix:stackLayout>
		              	<uix:messagePrompt promptBinding= "CONN_TYPE_DESC@NetServiceBundle@servletRequest" />
					<uix:tableLayout cellSpacing="5">
			                  <uix:rowLayout>
				           <uix:stackLayout>
			                    <oem:radioButton name="connectionType"
			                         textBinding="DB_DEFAULT_CONN_TYPE@NetServiceBundle@servletRequest"
									 shortDescBinding= "DB_DEFAULT_CONN_TYPE@NetServiceBundle@servletRequest"
			                         valueBinding="DB_DEFAULT_CONN_TYPE@NetServiceBundle@servletRequest"
			                         selectedValueBinding="connectionType@defaultBean@servletRequest"/>
			                    <uix:messageText messageType="info" messageBinding="DB_DEFAULT_CONN_TYPE_TIP@NetServiceBundle@servletRequest"/>
				           </uix:stackLayout>
			                  </uix:rowLayout>

			                  <uix:rowLayout>
				           <uix:stackLayout>
			                    <oem:radioButton name="connectionType"
			                         textBinding="DEDICATED_CONN_TYPE@NetServiceBundle@servletRequest"
									 shortDescBinding= "DEDICATED_CONN_TYPE@NetServiceBundle@servletRequest"
			                         valueBinding="DEDICATED_CONN_TYPE@NetServiceBundle@servletRequest"
			                         selectedValueBinding="connectionType@defaultBean@servletRequest"/>
			                    <uix:messageText messageType="info" messageBinding="DEDICATED_CONN_TYPE_TIP@NetServiceBundle@servletRequest"/>
				           </uix:stackLayout>
			                  </uix:rowLayout>

			                  <uix:rowLayout>
				           <uix:stackLayout>
			                    <oem:radioButton name="connectionType"
			                         textBinding="SHARED_CONN_TYPE@NetServiceBundle@servletRequest"
									 shortDescBinding= "SHARED_CONN_TYPE@NetServiceBundle@servletRequest"
			                         valueBinding="SHARED_CONN_TYPE@NetServiceBundle@servletRequest"
			                         selectedValueBinding="connectionType@defaultBean@servletRequest"/>
			                    <uix:messageText messageType="info" messageBinding="SHARED_CONN_TYPE_TIP@NetServiceBundle@servletRequest"/>
				           </uix:stackLayout>
			                  </uix:rowLayout>
				        </uix:tableLayout>

			      </uix:stackLayout>
			    </uix:cellFormat>
			  </uix:rowLayout>

	           </uix:tableLayout>
        </uix:stackLayout>


	</uix:header>
  	    <uix:header textBinding="SERVICE_ADDR_HEADER@NetServiceBundle@servletRequest">
        	  <uix:tableLayout width="100%">
	      	  <uix:rowLayout>
	           <uix:cellFormat hAlign="right">
			<uix:submitButton textBinding="ADD@defaultMsgBundle@servletRequest" 
				name="event" value="addAddress" shortDescBinding="ADD@netBundle@servletRequest"/>
	           </uix:cellFormat>
        	  </uix:rowLayout>

	          <uix:rowLayout>
		 <uix:cellFormat >
	              <oem:table name="addressesUI" 
				  			width="100%" 
							blockSize="10" 
							summaryBinding="SERVICES_LIST@netBundle@servletRequest"
							shortDescBinding="SERVICES_LIST@netBundle@servletRequest"
                          	formSubmitted="true"
	  	          			alternateTextBinding="NO_ITEMS_FOUND@defaultMsgBundle@servletRequest"
		        			beanKey="addresses" 
							dataSourceProp="addressesUI">
                      <uix:tableSelection>
                        <uix:singleSelection shortDescBinding="SELECT@dbObjBundle@servletRequest" selectedIndexBinding="selectedIndex@addressesUI@addresses@servletRequest" >

			  
			  <uix:pageButtonBar>
                <uix:contents>
						  
	        	          <uix:submitButton textBinding="EDIT@defaultMsgBundle@servletRequest" 
						  	name="event" value="editAddress" shortDescBinding="EDIT@netBundle@servletRequest"/>
        	        	  <uix:submitButton textBinding="REMOVE@defaultMsgBundle@servletRequest" 
						  	name="event" value="deleteAddress" shortDescBinding="REMOVE@netBundle@servletRequest"/>
					
			<uix:cellFormat wrappingDisabled="true" height="20" width="50">
			  <uix:contents>

                       <uix:styledText styleClass="OraPromptText" textBinding="REORDER@NetServiceBundle@servletRequest"/>
					    
				</uix:contents>
			  </uix:cellFormat>

					<uix:choice name="actionType"
							selectedValueBinding="actionType@defaultBean@servletRequest"
							shortDescBinding="REORDER@NetServiceBundle@servletRequest">
						<uix:contents childDataBinding="actionTypes@defaultBean@servletRequest">
							<uix:option textBinding="text"
										valueBinding="value"/>
						</uix:contents>
					</uix:choice>

  					<uix:submitButton disabledBinding = "showReorderOption@defaultBean@servletRequest" 
			  					textBinding="GO@defaultMsgBundle@servletRequest" 
								name="event" value="reorder" 
								shortDescBinding="GO@defaultMsgBundle@servletRequest"/>

                          </uix:contents>
		       </uix:pageButtonBar>

				
	               </uix:singleSelection>
                      </uix:tableSelection>
	              </oem:table>
	            </uix:cellFormat>
       		  </uix:rowLayout>


	          </uix:tableLayout>

              <uix:messageText messageType="error" messageBinding="SERVICE_ADDR_HEADER@errors@servletRequest"/>

   	       <uix:header textBinding="FAILOVER_LOAD_BALANCE_HDR@NetServiceBundle@servletRequest">

	      <uix:stackLayout>
		<uix:styledText styleClass="OraInstructionText" 
			textBinding="FAILOVER_LOAD_BALANCE_DESC@NetServiceBundle@servletRequest" />


		<uix:tableLayout cellSpacing="5">
                  <uix:rowLayout>
                    <oem:radioButton name="failOverAndLoadBalance"
                             textBinding="EACH_ADDR_IN_ORDER@NetServiceBundle@servletRequest"
                             valueBinding="EACH_ADDR_IN_ORDER@NetServiceBundle@servletRequest"
							 shortDescBinding="EACH_ADDR_IN_ORDER@NetServiceBundle@servletRequest"
                             selectedValueBinding="failOverAndLoadBalance@defaultBean@servletRequest"/>
                  </uix:rowLayout>

                  <uix:rowLayout>
                    <oem:radioButton name="failOverAndLoadBalance"
                             textBinding="EACH_ADDR_RANDOM@NetServiceBundle@servletRequest"
                             valueBinding="EACH_ADDR_RANDOM@NetServiceBundle@servletRequest"
							 shortDescBinding="EACH_ADDR_RANDOM@NetServiceBundle@servletRequest"
                             selectedValueBinding="failOverAndLoadBalance@defaultBean@servletRequest"/>
                  </uix:rowLayout>

                  <uix:rowLayout>
                    <oem:radioButton name="failOverAndLoadBalance"
                             textBinding="ONE_ADDR_RANDOM@NetServiceBundle@servletRequest"
                             valueBinding="ONE_ADDR_RANDOM@NetServiceBundle@servletRequest"
							 shortDescBinding="ONE_ADDR_RANDOM@NetServiceBundle@servletRequest"
                             selectedValueBinding="failOverAndLoadBalance@defaultBean@servletRequest"/>
                  </uix:rowLayout>

                  <uix:rowLayout>
                    <oem:radioButton name="failOverAndLoadBalance"
                             textBinding="EACH_ADDR_UNTIL_REACH@NetServiceBundle@servletRequest"
                             valueBinding="EACH_ADDR_UNTIL_REACH@NetServiceBundle@servletRequest"
							 shortDescBinding="EACH_ADDR_UNTIL_REACH@NetServiceBundle@servletRequest"
                             selectedValueBinding="failOverAndLoadBalance@defaultBean@servletRequest"/>
                  </uix:rowLayout>

                  <uix:rowLayout>
                    <oem:radioButton name="failOverAndLoadBalance"
                             textBinding="USE_FIRST_ADDR@NetServiceBundle@servletRequest"
                             valueBinding="USE_FIRST_ADDR@NetServiceBundle@servletRequest"
							 shortDescBinding="USE_FIRST_ADDR@NetServiceBundle@servletRequest"
                             selectedValueBinding="failOverAndLoadBalance@defaultBean@servletRequest"/>
                  </uix:rowLayout>

                </uix:tableLayout>
	      </uix:stackLayout>

   	    </uix:header>

  	    </uix:header>
          </uix:subTabLayout>


	    <uix:pageButtons>
	      <uix:pageButtonBar>
    	          <uix:submitButton textBinding="CANCEL@defaultMsgBundle@servletRequest" 
				  	name="event" value="cancel" shortDescBinding="CANCEL@netBundle@servletRequest"/>
    	          <uix:submitButton textBinding="OK@defaultMsgBundle@servletRequest" 
				  	name="event" value="apply" shortDescBinding="OK@netBundle@servletRequest"/>
	      </uix:pageButtonBar>
	    </uix:pageButtons>

   </uix:pageLayout> 
  </uix:form>
  </uix:body> 
 </uix:document> 
</uix:renderingContext> 



