<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.db.rsc.DBObjectMsg" %>
<%@ page import="oracle.sysman.db.rsc.net.NetMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<%
  request.setAttribute("dbObjBundle", new BundleDataObject(NLSUtil.getBundle(DBObjectMsg.class.getName(), request)));
  request.setAttribute("netBundle", new BundleDataObject(NLSUtil.getBundle(NetMsg.class.getName(), request)));
%>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/> 
<uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="TITLE@servletRequest"/>
    </uix:metaContainer>


     <uix:body> 
     <uix:form name="servicesForm"  method="post" destinationBinding="defaultControllerURL@controllerIDBean@servletRequest">
     <uix:formValue name="pageName" value="/net/netService/importSrvcs"/>
     <uix:pageLayout titleBinding="header@ldapServices@servletRequest">
        <%@ include file="/oemGlobal.jspf" %>
 	  <oem:messageBox messageTypeBinding = "messageType@servletRequest" msgBundleBinding="ServiceMsg@servletRequest" errorTableBinding="errors@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>

      <uix:styledText styleClass="OraInstructionText" textBinding="description@selSrvcsImportUI@servletRequest"/>
      <uix:header textBinding="NET_SRVC_NAME_LOC@NetServiceBundle@servletRequest">
        	<uix:tableLayout cellSpacing="5">
        		<uix:rowLayout>
        			<uix:cellFormat hAlign="left">
        			  <uix:messageTextInput 
					  		promptBinding="NET_SRVC_NAME_FILE_LOC@NetServiceBundle@servletRequest"
							shortDescBinding="NET_SRVC_NAME_FILE_LOC@NetServiceBundle@servletRequest"
				      		columns="35" name= "tnsAdmin" id="tnsAdmin"
					    	textBinding="TNSAdmin@localServices@servletRequest"
							tipBinding="NET_SRVC_NAME_LOC_TIP@NetServiceBundle@servletRequest" />
        			</uix:cellFormat>
        		</uix:rowLayout>
        	</uix:tableLayout>
        </uix:header>

      <uix:header textBinding="DESTINATION_DIRECTORY_HDR@NetServiceBundle@servletRequest">
          <uix:tableLayout hAlign="center" width="100%">
	    <uix:contents>
                <uix:rowLayout>
                   <uix:cellFormat hAlign="right">
                      <uix:styledText styleClass="OraPromptText" textBinding="OID@NetServiceBundle@servletRequest"/>
			      <uix:spacer width="5"/>
                   </uix:cellFormat>
                   <uix:cellFormat > 
                      <uix:styledText styleClass="OraDataText" textBinding="directoryServer@ldapServices@servletRequest"/>
			      <uix:spacer width="5"/>
                   </uix:cellFormat>
                </uix:rowLayout>
	        <uix:rowLayout>
		    <uix:contents>
	           <uix:cellFormat hAlign="right">
                  <uix:styledText styleClass="OraFieldText" 
				  		textBinding="ORACLE_CONTEXT@NetServiceBundle@servletRequest"/>
		 		<uix:spacer width="5"/>
	           	</uix:cellFormat>
               	<uix:cellFormat hAlign="left">
			 		<oem:choice 	name="context"
						optionsBinding = "contexts@ldapSearchBean@servletRequest"
						shortDescBinding="ORACLE_CONTEXT@NetServiceBundle@servletRequest"
						selectedValueBinding = "context@ldapSearchBean@servletRequest" />
        	    </uix:cellFormat>
		    </uix:contents>
            </uix:rowLayout>

	    </uix:contents>
         </uix:tableLayout>

      </uix:header>


      <uix:header  textBinding="IMPORT_NET_SERVICES_HDR@NetServiceBundle@servletRequest">
          <uix:styledText styleClass="OraInstructionText" textBinding="NET_SERVICE_ADD_BTN_DESC@NetServiceBundle@servletRequest"/>
          <uix:tableLayout width="100%">
	  <uix:rowLayout>
            <uix:cellFormat hAlign="right">
		<uix:submitButton textBinding="ADD@defaultMsgBundle@servletRequest" name="event"
		value="addImprtNetSrvc" shortDescBinding="ADD@netBundle@servletRequest"/>
            </uix:cellFormat>
	  </uix:rowLayout>
	
	  <uix:rowLayout>
	     <uix:cellFormat >
            <uix:stackLayout>
	        	<oem:table name="netServicesImportUI" 
							width="100%" 
							blockSize="25" 
							summaryBinding="NET_SERVICES_LIST@netBundle@servletRequest"
							shortDescBinding="NET_SERVICES_LIST@netBundle@servletRequest"
	  	          			alternateTextBinding="NO_SEARCH_RES@defaultMsgBundle@servletRequest"
                          	formSubmitted="true"
		          			beanKey="selSrvcsImportUI"
                          	dataSourceProp="netServicesImportUI">
                      <uix:tableSelection>
	                <uix:singleSelection shortDescBinding="SELECT@dbObjBundle@servletRequest" selectedIndexBinding="selectedIndex@selSrvcsImportUI@servletRequest" >
 		        <uix:pageButtonBar>
	    	    	     <uix:submitButton textBinding="REMOVE@defaultMsgBundle@servletRequest" name="event"
			     value="remImprtNetSrvc" shortDescBinding="REMOVE@netBundle@servletRequest"/>
 		        </uix:pageButtonBar>
	               </uix:singleSelection>
                      </uix:tableSelection>
                 </oem:table>
	         <uix:messageText messageType="error" messageBinding="INVALID_NAME_FOR_LDAP_KEY@errors@servletRequest"/>
	         <uix:messageText messageType="error" messageBinding="DUPLICATE_NAMES_KEY@errors@servletRequest"/>
               </uix:stackLayout>
            </uix:cellFormat>
	    </uix:rowLayout>

           </uix:tableLayout>
	</uix:header>


	    <uix:pageButtons>
	      <uix:pageButtonBar>
    	          <uix:submitButton textBinding="CANCEL@defaultMsgBundle@servletRequest" name="event" value="cancel"
		  shortDescBinding="CANCEL@netBundle@servletRequest"/>
    	          <uix:submitButton textBinding="OK@defaultMsgBundle@servletRequest" name="event" value="apply"
		  shortDescBinding="OK@netBundle@servletRequest"/>
	      </uix:pageButtonBar>
	    </uix:pageButtons>

   </uix:pageLayout> 
  </uix:form>
 </uix:body> 
 </uix:document> 
</uix:renderingContext> 	    
