<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.db.rsc.DBObjectMsg" %>
<%@ page import="oracle.sysman.db.rsc.net.NetMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<%
  request.setAttribute("dbObjBundle", new BundleDataObject(NLSUtil.getBundle(DBObjectMsg.class.getName(), request)));
  request.setAttribute("netBundle", new BundleDataObject(NLSUtil.getBundle(NetMsg.class.getName(), request)));
%>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/> 
<uix:document> 

    <uix:metaContainer>
      <uix:head titleBinding="TITLE@servletRequest"/>
    </uix:metaContainer>

     <uix:body> 
     <uix:form name="localServicesForm"  method="post" destinationBinding="defaultControllerURL@controllerIDBean@servletRequest">
     <uix:formValue name="pageName" value="/net/netService/localServicesList"/>
	<uix:pageLayout titleBinding="header@services@servletRequest">		
        <%@ include file="/oemGlobal.jspf" %>
 	  <oem:messageBox messageTypeBinding = "messageType@servletRequest" msgBundleBinding="ServiceMsg@servletRequest" 			errorTableBinding="errors@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>

         <uix:styledText styleClass="OraInstructionText" textBinding="description@services@servletRequest" />

	 <uix:header  textBinding="SEARCH@defaultMsgBundle@servletRequest">
 	  </uix:header>

          <uix:tableLayout width="100%">
	<%--
	  <uix:spacer height="5" width="5"/>
	--%>
          <uix:rowLayout>
            <uix:cellFormat>
              <uix:messagePrompt promptBinding="NET_SERVICE_NAME_FIELD@NetServiceBundle@servletRequest" 
			  		required="no" labeledNodeId="searchID" />
              <uix:textInput name="searchID" id="searchID" columns="25" 
			  		textBinding="searchID@services@servletRequest" 
					shortDescBinding="NET_SERVICE_NAME_FIELD@NetServiceBundle@servletRequest"/>
					
              <uix:submitButton textBinding="GO@defaultMsgBundle@servletRequest" 
			  	name="event"  value="search" shortDescBinding="GO@netBundle@servletRequest"/>
            </uix:cellFormat>             
          </uix:rowLayout>

      	  <uix:rowLayout>
           <uix:cellFormat hAlign="right">
	          <uix:submitButton textBinding="CREATE@defaultMsgBundle@servletRequest" 
			  	name="event" value="add" shortDescBinding="CREATE@netBundle@servletRequest"/>
           </uix:cellFormat>
	  </uix:rowLayout>

	  <uix:rowLayout>
	     <uix:cellFormat >
	        <oem:table name="servicesUI" 
					width="100%" 
					blockSize="25" 
					summaryBinding="SERVICES_LIST@netBundle@servletRequest"
					shortDescBinding="SERVICES_LIST@netBundle@servletRequest" 
	  	          	alternateTextBinding="NO_SEARCH_RES@defaultMsgBundle@servletRequest"
                    formSubmitted="true"
  		          	beanKey="services" 
                    dataSourceProp="servicesUI">
                      <uix:tableSelection>
	                <uix:singleSelection shortDescBinding="SELECT@dbObjBundle@servletRequest" selectedIndexBinding="selectedIndex@servicesUI@servletRequest" >
 		        <uix:pageButtonBar>
		          <uix:submitButton textBinding="TEST_CONN_BTN@NetServiceBundle@servletRequest" name="event" value="testConn" shortDescBinding="TEST_CONN_BTN@NetServiceBundle@servletRequest"/>
		          <uix:submitButton textBinding="CREATE_LIKE@defaultMsgBundle@servletRequest" name="event" value="createLike" shortDescBinding="CREATE_LIKE@netBundle@servletRequest"/>
       	          <uix:submitButton textBinding="EDIT@defaultMsgBundle@servletRequest" name="event" value="edit" shortDescBinding="EDIT@netBundle@servletRequest"/>
               	  <uix:submitButton textBinding="DELETE@defaultMsgBundle@servletRequest" name="event" value="delete" shortDescBinding="DELETE@netBundle@servletRequest"/>
 		        </uix:pageButtonBar>
	               </uix:singleSelection>
                      </uix:tableSelection>
                 </oem:table>
            </uix:cellFormat>
	    </uix:rowLayout>
           </uix:tableLayout>

   </uix:pageLayout> 
   </uix:form>
   </uix:body> 
 </uix:document> 
</uix:renderingContext> 
