<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.db.rsc.DBObjectMsg" %>
<%@ page import="oracle.sysman.db.rsc.net.NetMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<%
  request.setAttribute("dbObjBundle", new BundleDataObject(NLSUtil.getBundle(DBObjectMsg.class.getName(), request)));
  request.setAttribute("netBundle", new BundleDataObject(NLSUtil.getBundle(NetMsg.class.getName(), request)));
%>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/> 
<uix:document> 

    <uix:metaContainer>
      <uix:head titleBinding="title@defaultBean@servletRequest"/>
    </uix:metaContainer>


     <uix:body> 
      <uix:form name="listenerForm" method="post" destinationBinding="defaultControllerURL@defaultBean@servletRequest">
      <uix:formValue name="pageName" value="/net/netService/netServicePage"/>


     
	<uix:pageLayout titleBinding="header@defaultBean@servletRequest">	
        <%@ include file="/oemGlobal.jspf" %>
        <oem:messageBox messageType = "error" errorTableBinding="errors@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>

                <uix:switcher childNameBinding ="creating@mainNetBean@servletRequest" >
        	<uix:case name="true">
                 <uix:tableLayout cellSpacing="5">
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="left">
                      <uix:messagePrompt promptBinding="NET_SERVICE_NAME_FIELD@NetServiceBundle@servletRequest" 
					  		labeledNodeId="objectName" required="yes" />
                    </uix:cellFormat>
                    <uix:cellFormat>
                      <uix:stackLayout>
                          <uix:textInput name="objectName" id="objectName"
								shortDescBinding="NET_SERVICE_NAME_FIELD@NetServiceBundle@servletRequest" 
								textBinding="objectName@defaultBean@servletRequest"/>
		                <uix:formValue name="id" valueBinding="objectName@defaultBean@servletRequest" />
		               <uix:messageText messageType="error" messageBinding="NAME_FIELD@errors@servletRequest"/>
                      </uix:stackLayout>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  </uix:tableLayout>
               </uix:case>

                <uix:case name="false">
                 <uix:tableLayout cellSpacing="5">
	           <uix:rowLayout>
                    <uix:cellFormat hAlign="left">
                      <uix:messagePrompt promptBinding="NET_SERVICE_NAME_FIELD@NetServiceBundle@servletRequest"/>
                    </uix:cellFormat>
                    <uix:cellFormat>
	              <uix:styledText styleClass="OraDataText" textBinding="objectName@defaultBean@servletRequest"  />
                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:tableLayout>
                  </uix:case>
                  </uix:switcher>

  	    <uix:header textBinding="SERVICES_HEADER@NetServiceBundle@servletRequest">

          <uix:tableLayout width="100%">
        	  <uix:rowLayout>
	            <uix:cellFormat hAlign="right">
			<uix:submitButton textBinding="ADD@defaultMsgBundle@servletRequest" 
				name="event" value="addConnectData" shortDescBinding="ADD@defaultMsgBundle@servletRequest"/>
	            </uix:cellFormat>
		  </uix:rowLayout>
        	  <uix:rowLayout>
	            <uix:cellFormat >

              <oem:table name="connectDatasUI" 
			  			width="100%" 
						blockSize="10" 
						summaryBinding="CONNECT_DATAS_LIST@netBundle@servletRequest"
						shortDescBinding="CONNECT_DATAS_LIST@netBundle@servletRequest"
                        formSubmitted="true"
   	                	alternateTextBinding="NO_ITEMS_FOUND@defaultMsgBundle@servletRequest"
		        		beanKey="connectDatas" 
						dataSourceProp="connectDatasUI">
                      <uix:tableSelection>
	                <uix:singleSelection  shortDescBinding="SELECT@dbObjBundle@servletRequest" selectedIndex="0" >
 		        <uix:pageButtonBar>
                          <uix:contents>
	        	          <uix:submitButton textBinding="EDIT@defaultMsgBundle@servletRequest" 
						  	name="event" value="editConnectData" shortDescBinding="EDIT@defaultMsgBundle@servletRequest"/>
        	        	  <uix:submitButton textBinding="REMOVE@defaultMsgBundle@servletRequest" 
						  	name="event" value="deleteConnectData" shortDescBinding="REMOVE@defaultMsgBundle@servletRequest"/>
                          </uix:contents>
 		        </uix:pageButtonBar>
	               </uix:singleSelection>
                      </uix:tableSelection>
              </oem:table>

            </uix:cellFormat>
     	 </uix:rowLayout>
	 </uix:tableLayout>

	  </uix:header>	

	    <uix:pageButtons>
	      <uix:pageButtonBar>

                  <uix:switcher childNameBinding ="creating@mainNetBean@servletRequest" >
                    <uix:case name="true">
                      <uix:flowLayout>
                        <uix:contents>
	    	          <uix:submitButton textBinding="CANCEL@defaultMsgBundle@servletRequest" 
					  name="event" value="cancel" shortDescBinding="CANCEL@defaultMsgBundle@servletRequest"/>
                          <uix:spacer width="3"/>
	    	          <uix:submitButton textBinding="CREATE@defaultMsgBundle@servletRequest" 
					  	name="event" value="apply" shortDescBinding="CREATE@defaultMsgBundle@servletRequest"/>
                        </uix:contents>
                      </uix:flowLayout>
                    </uix:case>
                    <uix:case name="false">
                      <uix:flowLayout>
                        <uix:contents>
	    	          <uix:submitButton textBinding="CANCEL@defaultMsgBundle@servletRequest" 
					  	name="event" value="cancel" shortDescBinding="CANCEL@defaultMsgBundle@servletRequest"/>
                          <uix:spacer width="3"/>
	    	          <uix:submitButton textBinding="APPLY@defaultMsgBundle@servletRequest" 
					  	name="event" value="apply" shortDescBinding="APPLY@defaultMsgBundle@servletRequest"/>
                        </uix:contents>
                      </uix:flowLayout>
                    </uix:case>
                  </uix:switcher>

	      </uix:pageButtonBar>
	    </uix:pageButtons>

   </uix:pageLayout> 
  </uix:form>
  </uix:body> 
 </uix:document> 
</uix:renderingContext> 



