<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.db.rsc.DBObjectMsg" %>
<%@ page import="oracle.sysman.db.rsc.net.NetMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<%
  request.setAttribute("dbObjBundle", new BundleDataObject(NLSUtil.getBundle(DBObjectMsg.class.getName(), request)));
  request.setAttribute("netBundle", new BundleDataObject(NLSUtil.getBundle(NetMsg.class.getName(), request)));
%>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/> 
<uix:document> 

    <uix:metaContainer>
      <uix:head titleBinding="TITLE@servletRequest"/>
    </uix:metaContainer>


    <uix:body>
     <uix:form name="servicesForm" method="post" destinationBinding="defaultControllerURL@controllerIDBean@servletRequest">
     <uix:formValue name="pageName" value="/net/netService/servicesList"/>
	<uix:pageLayout titleBinding="header@services@servletRequest">		
        <%@ include file="/oemGlobal.jspf" %>

 	  <oem:messageBox messageTypeBinding = "messageType@servletRequest" msgBundleBinding="ServiceMsg@servletRequest" errorTableBinding="errors@servletRequest"
                      destTableBinding="msgUrls@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>

           <uix:switcher childNameBinding ="directoryServerServices@services@servletRequest" >
	     <uix:case name="true">
                <uix:tableLayout hAlign="center" width="70%">
                        <uix:rowLayout>
                           <uix:cellFormat hAlign="right">
                              <uix:styledText styleClass="OraInstructionText" textBinding="OID@NetServiceBundle@servletRequest"/>
 			      <uix:spacer width="5"/>
                           </uix:cellFormat>
                           <uix:cellFormat > 
                              <uix:styledText styleClass="OraDataText" textBinding="directoryServer@services@servletRequest"/>
 			      <uix:spacer width="5"/>
                           </uix:cellFormat>
                        </uix:rowLayout>
                        <uix:rowLayout>
                           <uix:cellFormat hAlign="right">
                              <uix:styledText styleClass="OraInstructionText" textBinding="OID_USER@defaultMsgBundle@servletRequest"/>
 			      <uix:spacer width="5"/>
                           </uix:cellFormat>
                           <uix:cellFormat > 
                              <uix:styledText styleClass="OraDataText" textBinding="directoryUser@services@servletRequest"/>
 			      <uix:spacer width="5"/>
                              <uix:submitButton textBinding="CHANGE_USER@NetServiceBundle@servletRequest" name="event" value="changeDirectoryUser" shortDescBinding="CHANGE_USER@NetServiceBundle@servletRequest"/>
                           </uix:cellFormat>
                        </uix:rowLayout>
               </uix:tableLayout>
	     </uix:case>
           </uix:switcher>
        <uix:subTabLayout>
          <uix:subTabs>
                 <uix:subTabBar selectedIndexBinding="selectedServiceIndex@directoryServices@servletRequest">
			  <uix:link textBinding="NET_SERVICE_TAB@NetServiceBundle@servletRequest" 
			            onClick="submitForm('servicesForm', true, {event:'netServiceTab'})" />
			  <uix:link textBinding="DB_SERVICE_TAB@NetServiceBundle@servletRequest" 
			            onClick="submitForm('servicesForm', true, {event:'dbServiceTab'})" />
			  <uix:link textBinding="ALIAS_TAB@NetServiceBundle@servletRequest" 
			            onClick="submitForm('servicesForm', true, {event:'aliasTab'})" />
                 </uix:subTabBar>
             </uix:subTabs>



	<uix:switcher childNameBinding ="selectedServiceIndex@directoryServices@servletRequest">
		<uix:case name="0"> <%-- database service tab , no options for creation--%>
		        <%@ include file="netServiceSearch.jsp" %>
		</uix:case > 
		<uix:case name="1"> <%-- Net Service Creation--%>
		        <%@ include file="netServiceSearch.jsp" %>
		</uix:case>
		<uix:case name="2"> <%-- Alias creation--%>
		        <%@ include file="aliasSearch.jsp" %>
		</uix:case>
        </uix:switcher>


        <uix:header  textBinding="SEARCH_RESULTS@defaultMsgBundle@servletRequest">
          <uix:tableLayout width="100%">

	      	  <uix:rowLayout>
	           <uix:cellFormat hAlign="right">
		      <uix:pageButtonBar>
			<uix:switcher childNameBinding ="selectedServiceIndex@directoryServices@servletRequest">
				<uix:case name="1"> <%-- database service tab , no options for creation--%>
				</uix:case > 
				<uix:case name="0"> <%-- Net Service Creation--%>
				      <uix:pageButtonBar>
				          <uix:submitButton textBinding="CREATE@defaultMsgBundle@servletRequest" 
						  		name="event" value="add" shortDescBinding="CREATE@netBundle@servletRequest"/>
				          <uix:submitButton textBinding="SAVE_TO_TNSNAMES@NetServiceBundle@servletRequest"
						  	 name="event" value="saveToFile" shortDescBinding="SAVE_TO_TNSNAMES@NetServiceBundle@servletRequest"/>
				      </uix:pageButtonBar>
				</uix:case>
				<uix:case name="2"> <%-- Alias creation--%>
				   <uix:flowLayout>
				          <uix:submitButton textBinding="CREATE@defaultMsgBundle@servletRequest" 
						  	name="event" value="add" shortDescBinding="CREATE@netBundle@servletRequest"/>
				   </uix:flowLayout>
				</uix:case>
		        </uix:switcher>
		      </uix:pageButtonBar>
	           </uix:cellFormat>
        	  </uix:rowLayout>


	     <uix:rowLayout>
	     <uix:cellFormat >
	        <oem:table name="servicesUI" 
						width="100%" 
						blockSize="25" 
						summaryBinding="SERVICES_LIST@netBundle@servletRequest"
						shortDescBinding="SERVICES_LIST@netBundle@servletRequest"
	  	          		alternateTextBinding="NO_SEARCH_CONDUCTED@netBundle@servletRequest"
                        formSubmitted="true"
  		          		beanKey="defaultBean" 
                        dataSourceProp="servicesUI">
                      <uix:tableSelection>
	                <uix:singleSelection shortDescBinding="SELECT@dbObjBundle@servletRequest" selectedIndexBinding="selectedIndex@servicesUI@servletRequest" >
			      <uix:pageButtonBar>
				<uix:switcher childNameBinding ="selectedServiceIndex@directoryServices@servletRequest">
					<uix:case name="1"> <%-- database service tab , no options for creation--%>
					</uix:case > 
					<uix:case name="0"> <%-- Net Service Creation--%>
			      <uix:pageButtonBar>
					  <uix:submitButton textBinding="TEST_CONN_BTN@NetServiceBundle@servletRequest" 
						name="event" value="testConn" shortDescBinding="TEST_CONN_BTN@NetServiceBundle@servletRequest"/>
					  <uix:submitButton textBinding="CREATE_LIKE@defaultMsgBundle@servletRequest" 
						name="event" value="createLike" shortDescBinding="CREATE_LIKE@netBundle@servletRequest"/>
			      </uix:pageButtonBar>
					</uix:case>
					<uix:case name="2"> <%-- Alias creation--%>
					  <uix:submitButton textBinding="CREATE_LIKE@defaultMsgBundle@servletRequest" 
						name="event" value="createLike" shortDescBinding="CREATE_LIKE@netBundle@servletRequest"/>
					</uix:case>
        		        </uix:switcher>
						 <uix:submitButton textBinding="EDIT@defaultMsgBundle@servletRequest" 
						 	name="event" value="edit" shortDescBinding="EDIT@netBundle@servletRequest"/>
	    	    	     <uix:submitButton textBinding="DELETE@defaultMsgBundle@servletRequest" 
						 	name="event" value="delete" shortDescBinding="DELETE@netBundle@servletRequest"/>
			    </uix:pageButtonBar>
	               </uix:singleSelection>
                      </uix:tableSelection>
                 </oem:table>
            </uix:cellFormat>
	    </uix:rowLayout>
          </uix:tableLayout>

	</uix:header>

        		 <uix:switcher childNameBinding ="selectedServiceIndex@directoryServices@servletRequest">
		 <uix:case name="0"> <%-- Net Service Creation--%>
                   <uix:header textBinding="RELATED_LINK@defaultMsgBundle@servletRequest">
		   <uix:flowLayout>
	                   <uix:link textBinding="IMPORT_SRVCS@NetServiceBundle@servletRequest"
                                   destination="/console/net/srvc/directoryServices?event=importNetSrvcs"  />
		   </uix:flowLayout>
                   </uix:header>
		 </uix:case>
	         </uix:switcher>
	
        </uix:subTabLayout>
        <uix:spacer height="10" />
   </uix:pageLayout> 
     </uix:form>
    </uix:body>
 </uix:document> 
</uix:renderingContext> 





