<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.db.rsc.net.NetMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<%
  request.setAttribute("netBundle", new BundleDataObject(NLSUtil.getBundle(NetMsg.class.getName(), request)));
%>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/> 
<uix:document> 

    <uix:metaContainer>
      <uix:head titleBinding="TITLE@servletRequest"/>
    </uix:metaContainer>


    <uix:body> 
     <uix:form name="testConnection"  method="post" destinationBinding="defaultControllerURL@controllerIDBean@servletRequest">
     <uix:formValue name="pageName" value="/net/netService/testConnection"/>
     <uix:pageLayout titleBinding="header@defaultBean@servletRequest">		
        <%@ include file="/oemGlobal.jspf" %>
     <oem:messageBox messageTypeBinding = "messageType@servletRequest" msgBundleBinding="NetMsg@servletRequest" errorTableBinding="errors@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>

      <uix:header  textBinding="CONN_TEST_LOGIN_HDR@NetServiceBundle@servletRequest">
	     <uix:stackLayout> 
		  <uix:styledText styleClass="OraInstructionText" textBinding="CONN_TEST_LOGIN_DESC@NetServiceBundle@servletRequest"  />
                    <uix:tableLayout cellSpacing="5" >
                      <uix:contents>
			  <uix:rowLayout>
			    <uix:cellFormat hAlign="left">
                    <uix:messagePrompt required="yes" labeledNodeId="user" 
						promptBinding="NET_LOGIN_USERNAME@defaultMsgBundle@servletRequest" />
			    </uix:cellFormat>
			    <uix:cellFormat>
			      <uix:stackLayout>
                    <uix:textInput name="user" id="user" noAutoComplete="true" 
							shortDescBinding="NET_LOGIN_USERNAME@defaultMsgBundle@servletRequest" 
							textBinding="user@defaultBean@servletRequest"/>
		                <uix:formValue name="id" valueBinding="user@defaultBean@servletRequest" />
		               <uix:messageText messageType="error" messageBinding="NET_LOGIN_USERNAME@errors@servletRequest"/>
			      </uix:stackLayout>
			    </uix:cellFormat>
			  </uix:rowLayout>

			  <uix:rowLayout>
			    <uix:cellFormat hAlign="left">
                    <uix:messagePrompt required="yes" labeledNodeId="secretPassword"
						promptBinding="NET_LOGIN_PSWD@defaultMsgBundle@servletRequest" />
			    </uix:cellFormat>
			    <uix:cellFormat>
			      <uix:stackLayout>
	                   <uix:textInput name="secretPassword" id="secretPassword"
					   		shortDescBinding="NET_LOGIN_PSWD@defaultMsgBundle@servletRequest" 
							secret="true" noAutoComplete="true" 
							textBinding="secretPassword@defaultBean@servletRequest"/>
	                   <uix:formValue name="id" valueBinding="secretPassword@defaultBean@servletRequest" />
			           <uix:messageText messageType="error" messageBinding="NET_LOGIN_PSWD@errors@servletRequest"/>
			      </uix:stackLayout>
			    </uix:cellFormat>
			  </uix:rowLayout>
                      </uix:contents>
                    </uix:tableLayout>
    	           <uix:submitButton textBinding="TEST@NetServiceBundle@servletRequest" 
				   		name="event" value="apply" shortDescBinding="TEST@NetServiceBundle@servletRequest"/>
	     </uix:stackLayout> 

	</uix:header>

     <uix:switcher childNameBinding ="testedOnce@defaultBean@servletRequest" >
     <uix:case name="true">
	      <uix:header textBinding="CONN_TEST_OUTPUT_HDR@NetServiceBundle@servletRequest">
			<uix:textInput shortDescBinding="CONN_TEST_OUTPUT_HDR@NetServiceBundle@servletRequest" 
				textBinding="testOutput@defaultBean@pageContext" 
				wrap = "hard" columns="120" rows="8" readOnly="true"/>
	      </uix:header>
     </uix:case>
     </uix:switcher>

	    <uix:pageButtons>
	      <uix:pageButtonBar>
    	          <uix:submitButton textBinding="OK@defaultMsgBundle@servletRequest" 
				  	name="event" value="cancel" shortDescBinding="OK@netBundle@servletRequest"/>
	      </uix:pageButtonBar>
	    </uix:pageButtons>

   </uix:pageLayout> 
  </uix:form>
  </uix:body> 
 </uix:document> 
</uix:renderingContext> 	    
