<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/> 
<uix:document> 

    <uix:metaContainer>
      <uix:head titleBinding="TITLE_NET_SRVC_NAME@NetServiceBundle@servletRequest"/>
    </uix:metaContainer>


    <uix:body>
	<uix:pageLayout titleBinding="TITLE_NET_SRVC_NAME@NetServiceBundle@servletRequest">

	<%@ include file="/oemGlobal.jspf" %>
	      <oem:messageBox messageType="info" 
                           errorTableBinding="info@servletRequest"
                           titleTextKey="titleText" mainTextKey="mainText"/>
	      <oem:messageBox messageType="error"
                           errorTableBinding="errors@servletRequest"
                           titleTextKey="titleText" mainTextKey="mainText"/>
      <uix:contents>
       <uix:form name="wizardForm" method="post" destination="/em/console/net/srvc/netService">
       <uix:formValue name="pageName" value="/net/netService/wizardNamePage"/>

          <uix:contents>
            <uix:train selectedIndexBinding="selectedIndex@defaultBean@servletRequest">
              <uix:contents childDataBinding="trainLinks@defaultBean@servletRequest">
                <uix:link textBinding="."/>
              </uix:contents>
            </uix:train>


     
	        <uix:styledText styleClass="OraInstructionText" textBinding="NET_SERVICE_NAME_DESC@NetServiceBundle@servletRequest"  />
		<uix:tableLayout cellSpacing="5">
		  <uix:rowLayout>
			    <uix:cellFormat>
			      <uix:messagePrompt promptBinding = "NET_SERVICE_NAME_FIELD@NetServiceBundle@servletRequest" required="yes" />
			    </uix:cellFormat>
			    <uix:cellFormat>
			      <uix:stackLayout>
                        	       <uix:textInput name="name" shortDescBinding="NET_SERVICE_NAME_FIELD@NetServiceBundle@servletRequest" textBinding="name@defaultBean@servletRequest"
					columns="16"/>			
			               <uix:messageText messageType="error" messageBinding="NET_SERVICE_NAME_FIELD@errors@servletRequest"/>
			      </uix:stackLayout>
			    </uix:cellFormat>
		  </uix:rowLayout>
		</uix:tableLayout>

     	              <uix:submitButton textBinding="CANCEL@defaultMsgBundle@servletRequest" name="event" value="cancel"/>

	    <uix:pageButtons>
              <uix:contents>
	      <uix:pageButtonBar>
     	              <uix:submitButton formName="wizardForm" textBinding="CANCEL@defaultMsgBundle@servletRequest" name="event" value="cancel"/>
	              <uix:contents>
		                  <uix:navigationBar
	        	            name="netNav"
	                	    blockSize="-1"
		                    formSubmitted="true"
		                    formName="wizardForm"
	        	            maxValueBinding="navMaxValue@defaultBean@servletRequest"
	                	    minValue="1"
		                    valueBinding="navValue@defaultBean@servletRequest"/>
	              </uix:contents>
	      </uix:pageButtonBar>
              </uix:contents>
	    </uix:pageButtons>

     </uix:contents>
  </uix:form>
  </uix:contents>
 </uix:pageLayout> 
 </uix:body>
 </uix:document> 
</uix:renderingContext> 



