<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/> 
<uix:document> 

    <uix:metaContainer>
      <uix:head titleBinding="PROTOCOL_DESC@NetServiceBundle@servletRequest"/>
    </uix:metaContainer>


      <uix:form name="wizardForm" method="post" destinationBinding="defaultControllerURL@controllerIDBean@servletRequest">
      <uix:formValue name="pageName" value="/net/netService/wizardProtDetailPage"/>
	<uix:pageLayout titleBinding="PROTOCOL_DESC@NetServiceBundle@servletRequest">	
        <%@ include file="/oemGlobal.jspf" %>
	      <oem:messageBox messageType="info" 
	                           errorTableBinding="info@servletRequest"
	                           titleTextKey="titleText" mainTextKey="mainText"/>
	      <oem:messageBox messageType="error"
	                           errorTableBinding="errors@servletRequest"
	                           titleTextKey="titleText" mainTextKey="mainText"/>

            <uix:train selectedIndexBinding="selectedIndex@defaultBean@servletRequest">
              <uix:contents childDataBinding="trainLinks@defaultBean@servletRequest">
                <uix:link textBinding="."/>
              </uix:contents>
            </uix:train>


     
	    <uix:switcher childNameBinding="protocol@protAddress@servletRequest">
		    <uix:case name="TCPS">
			  <%@ include file="wizTCPPage.jsp" %>
		    </uix:case>
		    <uix:case name="TCP">
			  <%@ include file="wizTCPPage.jsp" %>
		    </uix:case>
		    <uix:case name="IPC">
			  <%@ include file="wizIPCPage.jsp" %>
		    </uix:case>
		    <uix:case name="NMP">
			  <%@ include file="wizNMPPage.jsp" %>
		    </uix:case>
	    </uix:switcher>

	    <uix:pageButtons>
	      <uix:pageButtonBar>
                        <uix:contents>
	    	          <uix:submitButton textBinding="CANCEL@defaultMsgBundle@servletRequest" name="event" value="cancel"/>
	                  <uix:navigationBar
	                    name="netNav"
	                    blockSize="-1"
	                    formSubmitted="true"
	                    formName="wizardForm"
	                    maxValueBinding="navMaxValue@defaultBean@servletRequest"
	                    minValue="1"
	                    valueBinding="navValue@defaultBean@servletRequest"/>
                        </uix:contents>
	      </uix:pageButtonBar>
	    </uix:pageButtons>

   </uix:pageLayout> 
  </uix:form>
 </uix:document> 
</uix:renderingContext> 
