<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/> 
<uix:document> 

    <uix:metaContainer>
      <uix:head titleBinding="TITLE_PROTOCOL@NetServiceBundle@servletRequest"/>
    </uix:metaContainer>


      <uix:form name="wizardForm" method="post" destinationBinding="defaultControllerURL@controllerIDBean@servletRequest">
      <uix:formValue name="pageName" value="/net/netService/wizardProtocolPage"/>
	<uix:pageLayout titleBinding="TITLE_PROTOCOL@NetServiceBundle@servletRequest">	
        <%@ include file="/oemGlobal.jspf" %>
	      <oem:messageBox messageType="info" 
	                           errorTableBinding="info@servletRequest"
	                           titleTextKey="titleText" mainTextKey="mainText"/>
	      <oem:messageBox messageType="error"
	                           errorTableBinding="errors@servletRequest"
	                           titleTextKey="titleText" mainTextKey="mainText"/>

            <uix:train selectedIndexBinding="selectedIndex@defaultBean@servletRequest">
              <uix:contents childDataBinding="trainLinks@defaultBean@servletRequest">
                <uix:link textBinding="."/>
              </uix:contents>
            </uix:train>


     
	        <uix:styledText styleClass="OraInstructionText" textBinding="PROTOCOL_DESC@NetServiceBundle@servletRequest"  />
    	        <oem:choice 	name="selectedProtocol"
			optionsBinding = "protocols@defaultBean@servletRequest" 
			selectedValueBinding = "selectedProtocol@defaultBean@servletRequest" />

	    <uix:pageButtons>
             <uix:contents>
	      <uix:pageButtonBar>
                        <uix:contents>
	    	          <uix:submitButton textBinding="CANCEL@defaultMsgBundle@servletRequest" name="event" value="cancel"/>
	                  <uix:navigationBar
	                    name="netNav"
	                    blockSize="-1"
	                    formSubmitted="true"
	                    formName="wizardForm"
	                    maxValueBinding="navMaxValue@defaultBean@servletRequest"
	                    minValue="1"
	                    valueBinding="navValue@defaultBean@servletRequest"/>
                        </uix:contents>
	      </uix:pageButtonBar>
             </uix:contents>
	    </uix:pageButtons>

   </uix:pageLayout> 
  </uix:form>
 </uix:document> 
</uix:renderingContext> 
