<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/> 
<uix:document> 

    <uix:metaContainer>
      <uix:head titleBinding="TITLE_SERVICE@NetServiceBundle@servletRequest"/>
    </uix:metaContainer>


      <uix:form name="wizardForm" method="post" destinationBinding="defaultControllerURL@controllerIDBean@servletRequest">
      <uix:formValue name="pageName" value="/net/netService/wizardServicePage"/>
	<uix:pageLayout titleBinding="TITLE_SERVICE@NetServiceBundle@servletRequest">	
        <%@ include file="/oemGlobal.jspf" %>
	      <oem:messageBox messageType="info" 
	                           errorTableBinding="info@servletRequest"
	                           titleTextKey="titleText" mainTextKey="mainText"/>
	      <oem:messageBox messageType="error"
	                           errorTableBinding="errors@servletRequest"
	                           titleTextKey="titleText" mainTextKey="mainText"/>

            <uix:train selectedIndexBinding="selectedIndex@defaultBean@servletRequest">
              <uix:contents childDataBinding="trainLinks@defaultBean@servletRequest">
                <uix:link textBinding="."/>
              </uix:contents>
            </uix:train>


     
		<uix:tableLayout cellSpacing="5">

		  <uix:rowLayout>
     	          <uix:cellFormat hAlign="left">
			<uix:styledText styleClass="OraDataText" textBinding="SERVICE_DESC@NetServiceBundle@servletRequest" />
 	          </uix:cellFormat>
		  </uix:rowLayout>

		  <uix:rowLayout>
     	          <uix:cellFormat hAlign="left">
			<oem:radioButton
			  name="useServiceName"
			  selectedValueBinding="useServiceName@defaultBean@servletRequest"
			  textBinding="WIZ_SERVICE_NAME@NetServiceBundle@servletRequest"
			  value="false"/>
		    </uix:cellFormat>
		    <uix:cellFormat>
		      <uix:stackLayout>
                                <uix:textInput name="serviceName" shortDescBinding="WIZ_SERVICE_NAME@NetServiceBundle@servletRequest" textBinding="serviceName@defaultBean@servletRequest"
						columns="16"/>			
		               <uix:messageText messageType="error" messageBinding="SERVICE_NAME@errors@servletRequest"/>
		      </uix:stackLayout>
		    </uix:cellFormat>
		  </uix:rowLayout>

     	          <uix:cellFormat hAlign="left">
			<oem:radioButton
			  name="useServiceName"
			  selectedValueBinding="useServiceName@defaultBean@servletRequest"
			  textBinding="SID@NetServiceBundle@servletRequest"
			  value="true"/>
		    </uix:cellFormat>
		    <uix:cellFormat>
			      <uix:stackLayout>
	                               <uix:textInput name="SID" shortDescBinding="SID@NetServiceBundle@servletRequest" textBinding="SID@defaultBean@servletRequest"
						columns="16"/>			
			               <uix:messageText messageType="error" messageBinding="SID@errors@servletRequest"/>
			      </uix:stackLayout>
		    </uix:cellFormat>
          </uix:tableLayout>


	    <uix:pageButtons>
	      <uix:pageButtonBar>
                        <uix:contents>
	    	          <uix:submitButton textBinding="CANCEL@defaultMsgBundle@servletRequest" name="event" value="cancel"/>
	                  <uix:submitButton formName="exportForm" textBinding="FINISH@defaultMsgBundle@servletRequest" name="event" value="finish"/>
	                  <uix:navigationBar
	                    name="netNav"
	                    blockSize="-1"
	                    formSubmitted="true"
	                    formName="wizardForm"
	                    maxValueBinding="navMaxValue@defaultBean@servletRequest"
	                    minValue="1"
	                    valueBinding="navValue@defaultBean@servletRequest"/>
                        </uix:contents>
	      </uix:pageButtonBar>
	    </uix:pageButtons>

   </uix:pageLayout> 
  </uix:form>
 </uix:document> 
</uix:renderingContext> 
