<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ include file="/oemNoscript.jspf"%>
<%@ page import="oracle.sysman.db.rsc.net.profile.ProfileMsg"%>
<%@ page import="oracle.sysman.db.rsc.net.NetMsg"%>
<%@ page import="oracle.cabo.ui.data.BundleDataObject"%>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil"%>
<% 
  request.setAttribute("profileBundle", new BundleDataObject(NLSUtil.getBundle(ProfileMsg.class.getName(), request)));
  request.setAttribute("netBundle", new BundleDataObject(NLSUtil.getBundle(NetMsg.class.getName(), request)));
%>
<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %> 
    <uix:metaContainer>
      <uix:head titleBinding="TITLE@servletRequest"/>
    </uix:metaContainer>
    <uix:body>
      
       <uix:form name="authForm" method="post" destinationBinding="defaultControllerURL@defaultBean@servletRequest">
       <uix:formValue name="pageName" value="/net/profile/authentication"/>
       
         <uix:pageLayout titleBinding="AUTH_TITLE@profileBundle@servletRequest"
                       styleClass="OraInstructionText">
         <%@ include file="/oemGlobal.jspf" %>
         <oem:messageBox messageType = "error" 
                         msgBundleBinding="profileMsg@servletRequest" 
                         errorTableBinding="errors@servletRequest"
                         titleTextKey="titleText" mainTextKey="mainText"/>

			  <uix:tableLayout>
                
                  <uix:rowLayout >
                    
                      <uix:cellFormat>
                        
                          <oem:shuttle name="methods"
                                      leadingHeaderBinding="AVAILABLE_METHODS@profileBundle@servletRequest"
                                      trailingHeaderBinding="SELECTED_METHODS@profileBundle@servletRequest"
                                      size="5"
                                      reorderable="true">
                            <uix:leading>
                              <oem:list name="availableMethods"
                                        shortDescBinding="AVAILABLE_METHODS@profileBundle@servletRequest"
                                        optionsBinding="availableMethods@AUTH_ADMIN_BEAN@servletRequest"/>
                            </uix:leading>
                            <uix:trailing>
                              <oem:list name="authMethods"
                                        shortDescBinding="SELECTED_METHODS@profileBundle@servletRequest"
                                        optionsBinding="authMethods@AUTH_ADMIN_BEAN@servletRequest"/>
                            </uix:trailing>
                          </oem:shuttle>
                        
                      </uix:cellFormat>
                    
                  </uix:rowLayout>
                
              </uix:tableLayout>
            
        
          <uix:pageButtons>
            <uix:pageButtonBar>
              
                <uix:submitButton textBinding="CANCEL@defaultMsgBundle@servletRequest"
                          name="event" value="cancel" shortDescBinding="CANCEL@netBundle@servletRequest"/>
                <uix:submitButton textBinding="CONTINUE@profileBundle@servletRequest"
                          name="event" value="continue" shortDescBinding="CONTINUE@profileBundle@servletRequest"/>
              
            </uix:pageButtonBar>
          </uix:pageButtons>
          <uix:pageStatus>
            <uix:styledText textBinding="AUTH_INST_TEXT@profileBundle@servletRequest"
                            styleClass="OraInstructionText"/>
          </uix:pageStatus>
        </uix:pageLayout>
       
      </uix:form>
    
   </uix:body>
  </uix:document>
</uix:renderingContext>
