 <%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%@ include file="/oemNoscript.jspf"%>
<%@ page import="oracle.sysman.db.rsc.net.profile.ProfileMsg"%>
<%@ page import="oracle.cabo.ui.data.BundleDataObject"%>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil"%>
<% 
  request.setAttribute("profileBundle", new BundleDataObject(NLSUtil.getBundle(ProfileMsg.class.getName(), request)));
%>

<db:script src="/net/netUtil.js"/>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %> 
    <uix:metaContainer>
      <uix:head titleBinding="TITLE@servletRequest"/>
    </uix:metaContainer>
<uix:body>
  
    <uix:form name="authParamForm" method="post" destinationBinding="defaultControllerURL@defaultBean@servletRequest">
     <uix:formValue name="pageName" value="/net/profile/authenticationparam"/>
	 <uix:formValue name="lovName"/>
	 <uix:formValue name="listingType"/>
		<uix:formValue  name="curDir"/>
		<uix:formValue  name="defaultMethod"/>

      
        <uix:pageLayout titleBinding="AUTH_PARAM_TITLE@profileBundle@servletRequest"
                    styleClass="OraInstructionText">
        <%@ include file="/oemGlobal.jspf" %>
        <oem:messageBox messageType = "error" msgBundleBinding="profileMsg@servletRequest" errorTableBinding="errors@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>          
           
             <uix:switcher childNameBinding="kerberos@AUTH_ADMIN_BEAN@servletRequest">  
              <uix:case name="true">
                <uix:header textBinding="KERBEROS5_AUTH_PARAM@profileBundle@servletRequest">
                  
                    <uix:tableLayout cellSpacing="2" width="100%">
                    
                        <uix:rowLayout>
                    	
                            <uix:cellFormat width="55%" hAlign="left">
                            
                    <uix:tableLayout cellSpacing="10" width="100%">
                      
                        <uix:rowLayout>
                          
                            <uix:cellFormat hAlign="right">
                              
                                <uix:messagePrompt promptBinding="KERBEROS_SERVICE_NAME@profileBundle@servletRequest"
                                                     labeledNodeId="kerberosService"/>
                              
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="left">
                              
                                <uix:messageTextInput columns="35" 
                                       name="kerberosService" id="kerberosService"
                                       textBinding="kerberosService@AUTH_ADMIN_BEAN@servletRequest"
                                       tipBinding="defaultKerberosService@AUTH_ADMIN_BEAN@servletRequest"
									   shortDescBinding="KERBEROS_SERVICE_NAME@profileBundle@servletRequest"
									   />
                              
                            </uix:cellFormat>
                          
                        </uix:rowLayout>
                        <uix:rowLayout>
                          
                            <uix:cellFormat hAlign="right">
                              
                                <uix:messagePrompt promptBinding="CREDENTIAL_CACHE_FILE@profileBundle@servletRequest"
                                                     labeledNodeId="cacheFile"/>
                              
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="left">
                              
                                <uix:stackLayout>
                                  
                                    <uix:messageLovField 
										 columns="35"
                                    	 name="cacheFile" id="cacheFile"
                                    	 tipBinding="defaultCacheFile@AUTH_ADMIN_BEAN@servletRequest"
                                    	 textBinding="cacheFile@AUTH_ADMIN_BEAN@servletRequest"
										 shortDescBinding="CREDENTIAL_CACHE_FILE@profileBundle@servletRequest"
										 onClick = "openRFSWindow('cacheFile','LIST_FILES','defaultCacheFile');"/>
                                  
                                </uix:stackLayout>
                              
                            </uix:cellFormat>
                          
                        </uix:rowLayout>
                        <uix:rowLayout>
                          
                            <uix:cellFormat hAlign="right">
                              
                                <uix:messagePrompt promptBinding="CONFIGURATION_FILE@profileBundle@servletRequest" 
                                                     labeledNodeId="configFile"/>
                              
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="left">
                              
                                <uix:stackLayout>
                                  
                                    <uix:messageLovField columns="35"
                                        name="configFile" id="configFile"
                                        tipBinding="defaultConfigFile@AUTH_ADMIN_BEAN@servletRequest"
                                        textBinding="configFile@AUTH_ADMIN_BEAN@servletRequest"
										shortDescBinding="CONFIGURATION_FILE@profileBundle@servletRequest"
										onClick="openRFSWindow('configFile','LIST_FILES','defaultConfigFile');"/>
                                  
                                </uix:stackLayout>
                              
                            </uix:cellFormat>
                          
                        </uix:rowLayout>
                        <uix:rowLayout>
                          
                            <uix:cellFormat hAlign="right">
                              
                                <uix:messagePrompt promptBinding="REALM_TRANSLATION_FILE@profileBundle@servletRequest"
                                                     labeledNodeId="translationFile"/>
                              
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="left">
                              
                                <uix:stackLayout>
                                  
                                    <uix:messageLovField columns="35" 
                                     name="translationFile" id ="translationFile"
                                     tipBinding="defaultTranslationFile@AUTH_ADMIN_BEAN@servletRequest"
                                     textBinding="translationFile@AUTH_ADMIN_BEAN@servletRequest"
									 shortDescBinding="REALM_TRANSLATION_FILE@profileBundle@servletRequest"
									 onClick="openRFSWindow('translationFile','LIST_FILES','defaultTranslationFile');"/>
                                  
                                </uix:stackLayout>
                              
                            </uix:cellFormat>
                          
                        </uix:rowLayout>
                        <uix:rowLayout>
                          
                            <uix:cellFormat hAlign="right">
                              
                                <uix:messagePrompt promptBinding="KEY_TABLE@profileBundle@servletRequest"
                                                     labeledNodeId="keyTable"/>
                              
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="left">
                              
                                <uix:stackLayout>
                                  
                                    <uix:messageLovField columns="35"
                                       name="keyTable" id="keyTable"
                                       textBinding="keyTable@AUTH_ADMIN_BEAN@servletRequest"
                                       tipBinding="defaultKeyTable@AUTH_ADMIN_BEAN@servletRequest"
									   shortDescBinding="KEY_TABLE@profileBundle@servletRequest"
									   onClick="openRFSWindow('keyTable','LIST_FILES','defaultKeyTable');"/>
                                  
                                </uix:stackLayout>
                              
                            </uix:cellFormat>
                          
                        </uix:rowLayout>
                        <uix:rowLayout>
                          
                            <uix:cellFormat hAlign="right">
                              
                                <uix:messagePrompt promptBinding="CLOCK_SKEW@profileBundle@servletRequest"
                                                     labeledNodeId="clockSkew"/>
                              
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="left">
                              
                                <uix:stackLayout>
                                  
                                    <uix:messageTextInput columns="35"
                                          name = "clockSkew" id="clockSkew"
                                          tipBinding="defaultClockSkew@AUTH_ADMIN_BEAN@servletRequest"
                                          textBinding="clockSkew@AUTH_ADMIN_BEAN@servletRequest"
										  shortDescBinding="CLOCK_SKEW@profileBundle@servletRequest"/>
                                  
                                </uix:stackLayout>
                              
                            </uix:cellFormat>
                          
                        </uix:rowLayout>
                      
                    </uix:tableLayout>
                    
                    
                    </uix:cellFormat>
                    
                    <uix:cellFormat width="45%" hAlign="right">
                       
                            
						<uix:contentContainer width="100%" textBinding ="OVERVIEW@profileBundle@servletRequest" background="light">
							
								<uix:stackLayout>
									 

										<uix:rowLayout>
										<uix:styledText styleClass="OraHeaderSubSub" 
											textBinding="KERBEROS_SERVICE_NAME@profileBundle@servletRequest"/>
										</uix:rowLayout>
										<uix:rowLayout>
										<uix:styledText styleClass="OraInlineInfoText"
											textBinding="SERVICE_NAME_TIP@profileBundle@servletRequest"/> 
										</uix:rowLayout>

										<uix:rowLayout>
										<uix:styledText styleClass="OraHeaderSubSub" 
											textBinding="CREDENTIAL_CACHE_FILE@profileBundle@servletRequest"/>
										</uix:rowLayout>
										<uix:rowLayout>
										<uix:styledText styleClass="OraInlineInfoText"
											textBinding="CACHE_FILE_TIP@profileBundle@servletRequest"/> 
										</uix:rowLayout>

										<uix:rowLayout>
										<uix:styledText styleClass="OraHeaderSubSub" 
											textBinding="CONFIGURATION_FILE@profileBundle@servletRequest"/>
										</uix:rowLayout>
										<uix:rowLayout>
										<uix:styledText styleClass="OraInlineInfoText"
											textBinding="CONFIG_FILE_TIP@profileBundle@servletRequest"/> 
										</uix:rowLayout>

										<uix:rowLayout>
										<uix:styledText styleClass="OraHeaderSubSub" 
											textBinding="REALM_TRANSLATION_FILE@profileBundle@servletRequest"/>
										</uix:rowLayout>
										<uix:rowLayout>
										<uix:styledText styleClass="OraInlineInfoText"
											textBinding="TRANS_FILE_TIP@profileBundle@servletRequest"/> 
										</uix:rowLayout>

										<uix:rowLayout>
										<uix:styledText styleClass="OraHeaderSubSub" 
											textBinding="KEY_TABLE@profileBundle@servletRequest"/>
										</uix:rowLayout>
										<uix:rowLayout>
										<uix:styledText styleClass="OraInlineInfoText"
											textBinding="KEY_TABLE_TIP@profileBundle@servletRequest"/> 
										</uix:rowLayout>

										<uix:rowLayout>
										<uix:styledText styleClass="OraHeaderSubSub" 
											textBinding="CLOCK_SKEW@profileBundle@servletRequest"/>
										</uix:rowLayout>
										<uix:rowLayout>
										<uix:styledText styleClass="OraInlineInfoText"
											textBinding="CLOCK_SKEW_TIP@profileBundle@servletRequest"/> 
										</uix:rowLayout>

									
								</uix:stackLayout>
							
						</uix:contentContainer>                             
                            
                            
                            
                    </uix:cellFormat>
                    
                    
                    </uix:rowLayout>
                    
                    </uix:tableLayout>
                    
                  
                </uix:header>
                </uix:case>
               </uix:switcher> 
               <uix:switcher childNameBinding="radius@AUTH_ADMIN_BEAN@servletRequest">  
                <uix:case name="true">  
                 <uix:header textBinding="RADIUS_AUTH_PARAM@profileBundle@servletRequest">
                  
                    <uix:tableLayout cellSpacing="2" width="100%">
						
                        <uix:rowLayout>
                    	
                            <uix:cellFormat width="55%" hAlign="left">
                            
                    <uix:tableLayout cellSpacing="10" width="100%">                      
                    	
                        <uix:rowLayout>
                          
                            <uix:cellFormat hAlign="right">
                              
                                <uix:messagePrompt promptBinding="HOST_NAME@profileBundle@servletRequest"
                                                     labeledNodeId="hostName"/>
                              
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="left">
                              
                                <uix:stackLayout>
                                  
                                    <uix:messageTextInput name="hostName" id="hostName"
                                         textBinding="hostName@AUTH_ADMIN_BEAN@servletRequest"
                                         tipBinding="defaultHostName@AUTH_ADMIN_BEAN@servletRequest"
                                         columns="35"
										 shortDescBinding="HOST_NAME@profileBundle@servletRequest"/>
                                  
                                </uix:stackLayout>
                              
                            </uix:cellFormat>
                          
                        </uix:rowLayout>
                        <uix:rowLayout>
                          
                            <uix:cellFormat hAlign="right">
                              
                                <uix:messagePrompt promptBinding="PORT_NUMBER@profileBundle@servletRequest"
                                                     labeledNodeId="portNumber"/>
                              
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="left">
                              
                                <uix:stackLayout>
                                  
                                    <uix:messageTextInput name="portNumber"  id="portNumber"
                                         textBinding="portNumber@AUTH_ADMIN_BEAN@servletRequest"
										 shortDescBinding="PORT_NUMBER@profileBundle@servletRequest" 
                                         tipBinding="defaultPortNumber@AUTH_ADMIN_BEAN@servletRequest"
                                         columns="10"/>
                                  
                                </uix:stackLayout>
                              
                            </uix:cellFormat>
                          
                        </uix:rowLayout>
                        <uix:rowLayout>
                          
                            <uix:cellFormat hAlign="right">
                              
                                <uix:messagePrompt promptBinding="TIMEOUT@profileBundle@servletRequest"
                                                     labeledNodeId="timeout"/>
                              
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="left">
                              
                                <uix:stackLayout>
                                  
                                    <uix:messageTextInput name="timeout" id="timeout" 
                                    	   textBinding="timeout@AUTH_ADMIN_BEAN@servletRequest"
                                    	   tipBinding="defaultTimeout@AUTH_ADMIN_BEAN@servletRequest"
										   shortDescBinding="TIMEOUT@profileBundle@servletRequest" 
                                    	   columns="10"/>
                                  
                                </uix:stackLayout>
                              
                            </uix:cellFormat>
                          
                        </uix:rowLayout>
                        <uix:rowLayout>
                          
                            <uix:cellFormat hAlign="right">
                              
                                <uix:messagePrompt promptBinding="NUMBER_OF_RETRIES@profileBundle@servletRequest"
                                                     labeledNodeId="noOfRetries"/>
                              
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="left">
                              
                                <uix:stackLayout>
                                  
                                    <uix:messageTextInput name="noOfRetries" id="noOfRetries"
                                           textBinding="noOfRetries@AUTH_ADMIN_BEAN@servletRequest" 
                                           tipBinding="defaultNoOfRetries@AUTH_ADMIN_BEAN@servletRequest" 
										   shortDescBinding="NUMBER_OF_RETRIES@profileBundle@servletRequest"
                                           columns="10"/>
                                  
                                </uix:stackLayout>
                              
                            </uix:cellFormat>
                          
                        </uix:rowLayout>
                        <uix:rowLayout>
                          
                            <uix:cellFormat hAlign="right">
                              
                                <uix:messagePrompt promptBinding="SECRET_FILE@profileBundle@servletRequest"
                                                     labeledNodeId="secretFile"/>
                              
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="left">
                              
                                <uix:stackLayout>
                                  
                                    <uix:messageLovField name="secretFile" id="secretFile"
                                       textBinding="secretFile@AUTH_ADMIN_BEAN@servletRequest"
                                       tipBinding="defaultSecretFile@AUTH_ADMIN_BEAN@servletRequest"
									   shortDescBinding="SECRET_FILE@profileBundle@servletRequest"
                                       columns="35"
									   onClick="openRFSWindow('secretFile','LIST_FILES','defaultSecretFile');"/>
                                  
                                </uix:stackLayout>
                              
                            </uix:cellFormat>
                          
                        </uix:rowLayout>
                        <uix:rowLayout>
                          
                            <uix:cellFormat hAlign="right">
                              
                                <uix:messagePrompt promptBinding="ENABLE_SEND_ACCOUNTING@profileBundle@servletRequest"
                                                    />
                              
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="left">
                              
                                    <uix:radioButton textBinding="YES@profileBundle@servletRequest" 
										 name="sendAccounting"
										 selectedValueBinding="sendAccounting@AUTH_ADMIN_BEAN@servletRequest"
										 shortDescBinding="ENABLE_SEND_ACCOUNTING@profileBundle@servletRequest"
										 value ="ON"/>
                                    <uix:radioButton textBinding="NO@profileBundle@servletRequest"
										 name="sendAccounting"
										 selectedValueBinding="sendAccounting@AUTH_ADMIN_BEAN@servletRequest"
										 shortDescBinding="ENABLE_SEND_ACCOUNTING@profileBundle@servletRequest"
										 value="OFF"/>
 
                              
                            </uix:cellFormat>
                          
                        </uix:rowLayout>
						
                        <uix:rowLayout>
							
							<uix:cellFormat hAlign="right">
								<uix:spacer width="20"/>
							</uix:cellFormat>
							<uix:cellFormat hAlign="right">
								<uix:spacer width="20"/>
							</uix:cellFormat>							
							
						</uix:rowLayout>
						
						<uix:rowLayout>
                          
                           <uix:cellFormat hAlign="right">
                              
                                <uix:messagePrompt promptBinding="ENABLE_CHALLENGE_RESPONSE@profileBundle@servletRequest"
                                                    />
                              
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="left" vAlign="bottom">
                              
                                
                                    <uix:radioButton textBinding="YES@profileBundle@servletRequest"
									  name="challengeResponse" 
									  selectedValueBinding="challengeResponse@AUTH_ADMIN_BEAN@servletRequest"
									  shortDescBinding="ENABLE_CHALLENGE_RESPONSE@profileBundle@servletRequest"
									  onClick="submitForm('authParamForm', true, {event:'enableChlgResp'})" 
									  value="ON"/>
                                    <uix:radioButton textBinding="NO@profileBundle@servletRequest"
									   name="challengeResponse" 
									   selectedValueBinding="challengeResponse@AUTH_ADMIN_BEAN@servletRequest"
									   shortDescBinding="ENABLE_CHALLENGE_RESPONSE@profileBundle@servletRequest"
									   onClick="submitForm('authParamForm', true, {event:'disableChlgResp'})"
									   value="OFF"/>
                              
                                
                            </uix:cellFormat>
                           
                           </uix:rowLayout>
                          
				</uix:tableLayout>
				
				<uix:tableLayout cellSpacing="10" width="100%">
						
						 <uix:rowLayout>
							  <uix:cellFormat hAlign="left">
								<uix:styledText styleClass="OraDataText" 
									textBinding="CHALLENGE_RESP_SETTINGS@profileBundle@servletRequest"/>
							  </uix:cellFormat>
					  </uix:rowLayout>
				</uix:tableLayout>
				
				<uix:tableLayout  cellSpacing="10" width="100%">
					<uix:rowLayout>
							<uix:cellFormat hAlign="right">
                                <uix:messagePrompt promptBinding="DEFAULT_KEYWORD@profileBundle@servletRequest"
                                                     labeledNodeId="defaultKeyword"/> 
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="left">                                  
								<uix:messageTextInput name="defaultKeyword" id="defaultKeyword"
								   textBinding="defaultKeyword@AUTH_ADMIN_BEAN@servletRequest"
								   tipBinding="defaultDefaultKeyword@AUTH_ADMIN_BEAN@servletRequest"
								   shortDescBinding="DEFAULT_KEYWORD@profileBundle@servletRequest"
								   columns="35" 
								   disabledBinding="disabledChallengeResponse@AUTH_ADMIN_BEAN@servletRequest"/>
                            </uix:cellFormat>	
					</uix:rowLayout>
                        
					  <uix:rowLayout>
                            <uix:cellFormat hAlign="right">
                                <uix:messagePrompt promptBinding="INTERFACE_CLASS_NAME@profileBundle@servletRequest"
                                                     labeledNodeId="interfaceClassName"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="left">
								<uix:messageTextInput name="interfaceClassName" id="interfaceClassName"
								   textBinding="interfaceClassName@AUTH_ADMIN_BEAN@servletRequest"
								   tipBinding="defaultInterfaceClassName@AUTH_ADMIN_BEAN@servletRequest"
								   shortDescBinding="INTERFACE_CLASS_NAME@profileBundle@servletRequest"
								   columns="35"
								   disabledBinding="disabledChallengeResponse@AUTH_ADMIN_BEAN@servletRequest"/>
                            </uix:cellFormat>
						</uix:rowLayout>
						
					  <uix:rowLayout>
                            <uix:cellFormat hAlign="right">
                                <uix:messagePrompt promptBinding="INTERFACE_CLASS_PATH@profileBundle@servletRequest"
                                                     labeledNodeId="interfaceClassPath"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="left">
								<uix:messageTextInput name="interfaceClassPath" id="interfaceClassPath"
								   textBinding="interfaceClassPath@AUTH_ADMIN_BEAN@servletRequest"
								   tipBinding="defaultInterfaceClassPath@AUTH_ADMIN_BEAN@servletRequest"
								   shortDescBinding="INTERFACE_CLASS_PATH@profileBundle@servletRequest" 
								   rows="4"
                                   columns="70" 
								   disabledBinding="disabledChallengeResponse@AUTH_ADMIN_BEAN@servletRequest"/>
                            </uix:cellFormat>
                        </uix:rowLayout>
                      
                    </uix:tableLayout>

                    
                    </uix:cellFormat>
                    
                    <uix:cellFormat width="45%" hAlign="right">
                       
                            
						<uix:contentContainer 
							width="100%" 
							textBinding ="OVERVIEW@profileBundle@servletRequest" 
							background="light">
							
								<uix:stackLayout>
									 

										<uix:rowLayout>
										<uix:styledText styleClass="OraHeaderSubSub" 
											textBinding="HOST_NAME@profileBundle@servletRequest"/>
										</uix:rowLayout>
										<uix:rowLayout>
										<uix:styledText styleClass="OraInlineInfoText"
											textBinding="HOSTNAME_TIP@profileBundle@servletRequest"/> 
										</uix:rowLayout>

										<uix:rowLayout>
										<uix:styledText styleClass="OraHeaderSubSub" 
											textBinding="PORT_NUMBER@profileBundle@servletRequest"/>
										</uix:rowLayout>
										<uix:rowLayout>
										<uix:styledText styleClass="OraInlineInfoText"
											textBinding="PORT_NUM_TIP@profileBundle@servletRequest"/> 
										</uix:rowLayout>

										<uix:rowLayout>
										<uix:styledText styleClass="OraHeaderSubSub" 
											textBinding="TIMEOUT@profileBundle@servletRequest"/>
										</uix:rowLayout>
										<uix:rowLayout>
										<uix:styledText styleClass="OraInlineInfoText"
											textBinding="TIMEOUT_TIP@profileBundle@servletRequest"/> 
										</uix:rowLayout>

										<uix:rowLayout>
										<uix:styledText styleClass="OraHeaderSubSub" 
											textBinding="NUMBER_OF_RETRIES@profileBundle@servletRequest"/>
										</uix:rowLayout>
										<uix:rowLayout>
										<uix:styledText styleClass="OraInlineInfoText"
											textBinding="NUM_RETRIES_TIP@profileBundle@servletRequest"/> 
										</uix:rowLayout>

										<uix:rowLayout>
										<uix:styledText styleClass="OraHeaderSubSub" 
											textBinding="SECRET_FILE@profileBundle@servletRequest"/>
										</uix:rowLayout>
										<uix:rowLayout>
										<uix:styledText styleClass="OraInlineInfoText"
											textBinding="SECRET_FILE_TIP@profileBundle@servletRequest"/> 
										</uix:rowLayout>

										<uix:rowLayout>
										<uix:styledText styleClass="OraHeaderSubSub" 
											textBinding="ENABLE_SEND_ACCOUNTING@profileBundle@servletRequest"/>
										</uix:rowLayout>
										<uix:rowLayout>
										<uix:styledText styleClass="OraInlineInfoText"
											textBinding="SEND_ACCT_TIP@profileBundle@servletRequest"/> 
										</uix:rowLayout>

										<uix:rowLayout>
										<uix:styledText styleClass="OraHeaderSubSub" 
											textBinding="ENABLE_CHALLENGE_RESPONSE@profileBundle@servletRequest"/>
										</uix:rowLayout>
										<uix:rowLayout>
										<uix:styledText styleClass="OraInlineInfoText"
											textBinding="CHALLENGE_RESP_TIP@profileBundle@servletRequest"/> 
										</uix:rowLayout>

										<uix:rowLayout>
										<uix:styledText styleClass="OraHeaderSubSub" 
											textBinding="DEFAULT_KEYWORD@profileBundle@servletRequest"/>
										</uix:rowLayout>
										<uix:rowLayout>
										<uix:styledText styleClass="OraInlineInfoText"
											textBinding="DEF_KEYWORD_TIP@profileBundle@servletRequest"/> 
										</uix:rowLayout>

										<uix:rowLayout>
										<uix:styledText styleClass="OraHeaderSubSub" 
											textBinding="INTERFACE_CLASS_NAME@profileBundle@servletRequest"/>
										</uix:rowLayout>
										<uix:rowLayout>
										<uix:styledText styleClass="OraInlineInfoText"
											textBinding="IFC_CLASS_TIP@profileBundle@servletRequest"/> 
										</uix:rowLayout>

									
								</uix:stackLayout>
							
						</uix:contentContainer>                             
                            
                            
                            
                    </uix:cellFormat>
                    
                    
                    </uix:rowLayout>
                    
                    </uix:tableLayout>
                    


                  
                </uix:header>
              </uix:case>
            </uix:switcher>
          
          <uix:pageButtons>
            <uix:pageButtonBar>
              
                <uix:submitButton textBinding="CANCEL@defaultMsgBundle@servletRequest"
						shortDescBinding="CANCEL@defaultMsgBundle@servletRequest"
                          name="event" 
                          value="cancel"/>
                <uix:submitButton textBinding="BACK@profileBundle@servletRequest"
						shortDescBinding="BACK@profileBundle@servletRequest"
                          name="event"
                          value="back"/>
                <uix:submitButton textBinding="FINISH@profileBundle@servletRequest" 
						shortDescBinding="FINISH@profileBundle@servletRequest"
                          name="event" 
                          value="apply"/>
              
            </uix:pageButtonBar>
          </uix:pageButtons>
          <uix:pageStatus>
            <uix:styledText textBinding="AUTH_PARAM_INST_TEXT@profileBundle@servletRequest"
                            styleClass="OraInstructionText"/>
          </uix:pageStatus>
        </uix:pageLayout>
      
    </uix:form>
  
</uix:body>
</uix:document>
</uix:renderingContext>
