	<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ include file="/oemNoscript.jspf"%>
<%@ page import="oracle.sysman.db.rsc.net.profile.ProfileMsg"%>
<%@ page import="oracle.sysman.db.rsc.net.NetMsg"%>
<%@ page import="oracle.cabo.ui.data.BundleDataObject"%>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil"%>
<% 
  request.setAttribute("profileBundle", new BundleDataObject(NLSUtil.getBundle(ProfileMsg.class.getName(), request)));
  request.setAttribute("netBundle", new BundleDataObject(NLSUtil.getBundle(NetMsg.class.getName(), request)));
%>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %> 
    <uix:metaContainer>
      <uix:head titleBinding="TITLE@servletRequest"/>
    </uix:metaContainer>
    <uix:body>
      <uix:contents>
       <uix:form name="integrityForm" method="post" destinationBinding="defaultControllerURL@defaultBean@servletRequest">
        <uix:formValue name="pageName" value="/net/profile/integrity"/>
          <uix:contents>
            <uix:pageLayout titleBinding="INTEGRITY@profileBundle@servletRequest" 
                            styleClass="OraInstructionText">
            <%@ include file="/oemGlobal.jspf" %>
            <oem:messageBox messageType = "error" 
                            msgBundleBinding="profileMsg@servletRequest" 
                            errorTableBinding="errors@servletRequest"
                            titleTextKey="titleText" mainTextKey="mainText"/>

      <uix:tableLayout cellSpacing="10" width="100%">
        <uix:rowLayout hAlign="left" width="100%">       
          <uix:cellFormat hAlign="left" vAlign="top" width="55%">

              <uix:contents>
              <uix:switcher childNameBinding="serverConfig@INTEGRITY_ADMIN_BEAN@servletRequest">  
              <uix:case name="true">                                             
                <uix:header textBinding="SERVER_CONFIG@profileBundle@servletRequest">
                  <uix:contents>
                    <uix:tableLayout cellSpacing="5">
                      <uix:contents>
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat hAlign="left">
                              <uix:contents>
                                <uix:messagePrompt promptBinding="CHECKSUM_LEVEL@profileBundle@servletRequest"
                                       labeledNodeId="serverCheckSum"   required="yes"/>
                                <uix:stackLayout>
                                  <uix:choice name="serverCheckSum" id="serverCheckSum"
                                              selectedValueBinding="serverCheckSum@INTEGRITY_ADMIN_BEAN@servletRequest"
                                              shortDescBinding="CHECKSUM_LEVEL@profileBundle@servletRequest"
											  required="yes">
                                    <uix:contents childDataBinding="checkSumInfo@INTEGRITY_ADMIN_BEAN@servletRequest">
                                     <uix:option textBinding="textKey" valueBinding="valueKey"/>
                                  </uix:contents>                      
                                </uix:choice>
                                </uix:stackLayout>
                              </uix:contents>
                            </uix:cellFormat>
                          </uix:contents>
                        </uix:rowLayout>
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat hAlign="left">
                              <uix:contents>
                                 <oem:shuttle name="serverMethods"
                                            leadingHeaderBinding="AVAILABLE_METHODS@profileBundle@servletRequest"
                                            trailingHeaderBinding="SELECTED_METHODS@profileBundle@servletRequest"
                                            size="5" reorderable="true">
                                <uix:leading>
                                 <oem:list name="availableServerAlgorithms"
                                         shortDescBinding="AVAILABLE_METHODS@profileBundle@servletRequest"
                                         optionsBinding="availableServerAlgorithms@INTEGRITY_ADMIN_BEAN@servletRequest"/>
                                </uix:leading>
                                <uix:trailing>
                                 <oem:list name="serverAlgorithms"
                                         shortDescBinding="SELECTED_METHODS@profileBundle@servletRequest"
                                         optionsBinding="serverAlgorithms@INTEGRITY_ADMIN_BEAN@servletRequest"/>
                                </uix:trailing>
                               </oem:shuttle>
                             </uix:contents>
                            </uix:cellFormat>
                            
                            <uix:cellFormat>                        
                              <uix:contents>
                                <uix:spacer height="1" width="1"/>
                              </uix:contents>
                            </uix:cellFormat>

                          </uix:contents>
                        </uix:rowLayout>
                      </uix:contents>
                    </uix:tableLayout>
                  </uix:contents>
                </uix:header>
               </uix:case>
               </uix:switcher> 
             
               <uix:switcher childNameBinding="clientConfig@INTEGRITY_ADMIN_BEAN@servletRequest">  
               <uix:case name="true">                                             
               <uix:header textBinding="CLIENT_CONFIG@profileBundle@servletRequest">
                  <uix:contents>
                    <uix:tableLayout cellSpacing="5">
                      <uix:contents>
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat hAlign="left">
                              <uix:contents>
                                <uix:messagePrompt promptBinding="CHECKSUM_LEVEL@profileBundle@servletRequest"
                                      labeledNodeId="clientCheckSum"    required = "yes"/>
                                <uix:stackLayout>
                                  <uix:choice name="clientCheckSum" id="clientCheckSum"
                                       selectedValueBinding="clientCheckSum@INTEGRITY_ADMIN_BEAN@servletRequest"
                                       shortDescBinding="CHECKSUM_LEVEL@profileBundle@servletRequest"
									   required="yes">
                                    <uix:contents childDataBinding="checkSumInfo@INTEGRITY_ADMIN_BEAN@servletRequest">
                                     <uix:option textBinding="textKey" valueBinding="valueKey"/>
                                  </uix:contents>                      
                                </uix:choice>
                                </uix:stackLayout>
                              </uix:contents>
                            </uix:cellFormat>
                          </uix:contents>
                        </uix:rowLayout>
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat hAlign="left">
                             <uix:contents>
                               <oem:shuttle name="clientMethods"
                                          leadingHeaderBinding="AVAILABLE_METHODS@profileBundle@servletRequest"
                                          trailingHeaderBinding="SELECTED_METHODS@profileBundle@servletRequest"
                                          size="5" reorderable="true">
                              <uix:leading>
                               <oem:list name="availableClientAlgorithms"
                                       shortDescBinding="AVAILABLE_METHODS@profileBundle@servletRequest"
                                       optionsBinding="availableClientAlgorithms@INTEGRITY_ADMIN_BEAN@servletRequest"/>
                              </uix:leading>
                              <uix:trailing>
                               <oem:list name="clientAlgorithms"
                                       shortDescBinding="SELECTED_METHODS@profileBundle@servletRequest"
                                       optionsBinding="clientAlgorithms@INTEGRITY_ADMIN_BEAN@servletRequest"/>
                              </uix:trailing>
                             </oem:shuttle>
                             </uix:contents>
                            </uix:cellFormat>
                            
                            <uix:cellFormat>
                              <uix:contents>
                                <uix:spacer height="1" width="1"/>
                              </uix:contents>
                            </uix:cellFormat>
                            
                          </uix:contents>
                        </uix:rowLayout>
                      </uix:contents>
                    </uix:tableLayout>
                  </uix:contents>
                </uix:header>
              </uix:case>
              </uix:switcher> 
              </uix:contents>
              

            </uix:cellFormat>
            
            <uix:cellFormat hAlign="left" vAlign="top" width="45%">       
              <uix:contents>
              
				<uix:contentContainer width="100%" textBinding ="OVERVIEW@profileBundle@servletRequest" background="light">
					<uix:contents>
						
						<uix:rowLayout>
						<uix:styledText styleClass="OraHeaderSubSub" 
							textBinding="INTEGRITY@profileBundle@servletRequest"/>
						</uix:rowLayout>
						<uix:rowLayout>
						<uix:styledText styleClass="OraInlineInfoText"
							textBinding="TIP_INTEGRITY_PAGE@profileBundle@servletRequest"/> 
						</uix:rowLayout>

						<uix:rowLayout>
						<uix:styledText styleClass="OraHeaderSubSub" 
							textBinding="INTEG_NEGO@profileBundle@servletRequest"/>
						</uix:rowLayout>
						<uix:rowLayout>
						<uix:styledText styleClass="OraInlineInfoText"
							textBinding="TIP_INTEG_NEGO@profileBundle@servletRequest"/> 
						</uix:rowLayout>

						<uix:rowLayout>
						<uix:contents>
						<uix:tableLayout cellSpacing="5" width="100%">
							<uix:contents>

								<uix:rowLayout>
									<uix:contents>

										<uix:cellFormat hAlign="left">
												<uix:spacer width="20"/>
										</uix:cellFormat>


										<uix:cellFormat hAlign="left">
												<uix:styledText styleClass="OraInlineInfoText" 
													textBinding="REJECTED@profileBundle@servletRequest"/>
										</uix:cellFormat>

										<uix:cellFormat hAlign="left">
												<uix:styledText styleClass="OraInlineInfoText" 
													textBinding="ACCEPTED@profileBundle@servletRequest"/>
										</uix:cellFormat>

										<uix:cellFormat hAlign="left">
												<uix:styledText styleClass="OraInlineInfoText" 
													textBinding="REQUESTED@profileBundle@servletRequest"/>
										</uix:cellFormat>

										<uix:cellFormat hAlign="left">
												<uix:styledText styleClass="OraInlineInfoText" 
													textBinding="REQUIRED@profileBundle@servletRequest"/>
										</uix:cellFormat>


									</uix:contents>
								</uix:rowLayout>

								<uix:rowLayout>
									<uix:contents>

										<uix:cellFormat hAlign="right">
												<uix:spacer width="20"/>
										</uix:cellFormat>


										<uix:cellFormat hAlign="left">
												<uix:styledText styleClass="OraInlineInfoText" text="-----------"/>
										</uix:cellFormat>

										<uix:cellFormat hAlign="left">
												<uix:styledText styleClass="OraInlineInfoText" text="-----------"/>
										</uix:cellFormat>

										<uix:cellFormat hAlign="left">
												<uix:styledText styleClass="OraInlineInfoText" text="-----------"/>
										</uix:cellFormat>

										<uix:cellFormat hAlign="left">
												<uix:styledText styleClass="OraInlineInfoText" text="-----------"/>
										</uix:cellFormat>

									</uix:contents>
								</uix:rowLayout>

								<uix:rowLayout>
									<uix:contents>

										<uix:cellFormat hAlign="left">
												<uix:styledText styleClass="OraInlineInfoText" 
													textBinding="REJECTED@profileBundle@servletRequest"/>
										</uix:cellFormat>

										<uix:cellFormat hAlign="left">
												<uix:styledText styleClass="OraInlineInfoText" 
													textBinding="OFF@profileBundle@servletRequest"/>
										</uix:cellFormat>

										<uix:cellFormat hAlign="left">
												<uix:styledText styleClass="OraInlineInfoText" 
													textBinding="OFF@profileBundle@servletRequest"/>
										</uix:cellFormat>

										<uix:cellFormat hAlign="left">
												<uix:styledText styleClass="OraInlineInfoText" 
													textBinding="OFF@profileBundle@servletRequest"/>
										</uix:cellFormat>

										<uix:cellFormat hAlign="left">
												<uix:styledText styleClass="OraInlineInfoText" 
													textBinding="CONN_FAILS@profileBundle@servletRequest"/>
										</uix:cellFormat>


									</uix:contents>
								</uix:rowLayout>

								<uix:rowLayout>
									<uix:contents>

										<uix:cellFormat hAlign="left">
												<uix:styledText styleClass="OraInlineInfoText" 
													textBinding="ACCEPTED@profileBundle@servletRequest"/>
										</uix:cellFormat>

										<uix:cellFormat hAlign="left">
												<uix:styledText styleClass="OraInlineInfoText" 
													textBinding="OFF@profileBundle@servletRequest"/>
										</uix:cellFormat>

										<uix:cellFormat hAlign="left">
												<uix:styledText styleClass="OraInlineInfoText" 
													textBinding="OFF@profileBundle@servletRequest"/>
										</uix:cellFormat>

										<uix:cellFormat hAlign="left">
												<uix:styledText styleClass="OraInlineInfoText" 
													textBinding="ON@profileBundle@servletRequest"/>
										</uix:cellFormat>

										<uix:cellFormat hAlign="left">
												<uix:styledText styleClass="OraInlineInfoText" 
														textBinding="ON@profileBundle@servletRequest"/>
										</uix:cellFormat>


									</uix:contents>
								</uix:rowLayout>

								<uix:rowLayout>
									<uix:contents>

										<uix:cellFormat hAlign="left">
												<uix:styledText styleClass="OraInlineInfoText" 
													textBinding="REQUESTED@profileBundle@servletRequest"/>
										</uix:cellFormat>

										<uix:cellFormat hAlign="left">
												<uix:styledText styleClass="OraInlineInfoText" 
													textBinding="OFF@profileBundle@servletRequest"/>
										</uix:cellFormat>

										<uix:cellFormat hAlign="left">
												<uix:styledText styleClass="OraInlineInfoText" 
													textBinding="ON@profileBundle@servletRequest"/>
										</uix:cellFormat>

										<uix:cellFormat hAlign="left">
												<uix:styledText styleClass="OraInlineInfoText" 
													textBinding="ON@profileBundle@servletRequest"/>
										</uix:cellFormat>

										<uix:cellFormat hAlign="left">
												<uix:styledText styleClass="OraInlineInfoText" 
													textBinding="ON@profileBundle@servletRequest"/>
										</uix:cellFormat>


									</uix:contents>
								</uix:rowLayout>

								<uix:rowLayout>
									<uix:contents>

										<uix:cellFormat hAlign="left">
												<uix:styledText styleClass="OraInlineInfoText" 
													textBinding="REQUIRED@profileBundle@servletRequest"/>
										</uix:cellFormat>				

										<uix:cellFormat hAlign="left">
												<uix:styledText styleClass="OraInlineInfoText" 
													textBinding="CONN_FAILS@profileBundle@servletRequest"/>
										</uix:cellFormat>

										<uix:cellFormat hAlign="left">
												<uix:styledText styleClass="OraInlineInfoText" 
													textBinding="ON@profileBundle@servletRequest"/>
										</uix:cellFormat>

										<uix:cellFormat hAlign="left">
												<uix:styledText styleClass="OraInlineInfoText" 
													textBinding="ON@profileBundle@servletRequest"/>
										</uix:cellFormat>

										<uix:cellFormat hAlign="left">
												<uix:styledText styleClass="OraInlineInfoText" 
													textBinding="ON@profileBundle@servletRequest"/>
										</uix:cellFormat>


									</uix:contents>
								</uix:rowLayout>

							</uix:contents>
						</uix:tableLayout>
						</uix:contents>
					</uix:rowLayout>

					</uix:contents>
				</uix:contentContainer>                                           
              
              </uix:contents>
            </uix:cellFormat>

            
            </uix:rowLayout>
            </uix:tableLayout>

              
              <uix:pageButtons>
                <uix:pageButtonBar>
                  <uix:contents>
                    <uix:submitButton textBinding="CANCEL@defaultMsgBundle@servletRequest" 
                                      name="event" value="cancel" shortDescBinding="CANCEL@netBundle@servletRequest"/>
                    <uix:submitButton textBinding="OK@defaultMsgBundle@servletRequest" 
                                      name="event" value="apply" shortDescBinding="OK@netBundle@servletRequest"/>
                  </uix:contents>
                </uix:pageButtonBar>
              </uix:pageButtons>
              
              <uix:pageStatus>
                <uix:styledText textBinding="INTEGRITY_INST_TEXT@profileBundle@servletRequest"
                                styleClass="OraInstructionText"/>
              </uix:pageStatus>
              
            </uix:pageLayout>
            
            
          </uix:contents>
        </uix:form>
      </uix:contents>
    </uix:body>
  </uix:document>
</uix:renderingContext>
