<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%@ include file="/oemNoscript.jspf" %>
<db:script src="/net/netUtil.js"/>

<%@ page import="oracle.sysman.db.rsc.net.profile.ProfileMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.db.rsc.net.NetMsg" %>
<%
  request.setAttribute("profileBundle", new BundleDataObject(NLSUtil.getBundle(ProfileMsg.class.getName(), request)));
  request.setAttribute("netBundle", new BundleDataObject(NLSUtil.getBundle(NetMsg.class.getName(), request)));
%>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
	
      <uix:metaContainer>
        <uix:head titleBinding="TITLE@servletRequest"/>
      </uix:metaContainer>
      <uix:body>
	  	
        <uix:form name="loggerForm" method="post"
                  destinationBinding="defaultControllerURL@defaultBean@servletRequest">
          <uix:formValue name="pageName" value="/net/profile/logging"/>
  	  	  <uix:formValue name="lovName"/>
		  <uix:formValue name="listingType"/>
		  <uix:formValue  name="curDir"/>
		  <uix:formValue  name="defaultMethod"/>

		<uix:pageLayout titleBinding="LOGGING@profileBundle@servletRequest">
		<%@ include file="/oemGlobal.jspf" %>
			  
              <oem:messageBox messageType="error"
                              errorTableBinding="errors@servletRequest"
                              titleTextKey="titleText" mainTextKey="mainText"/>

			  <%-- Logging Instruction text ---%>
			  <uix:pageStatus>
				  <uix:styledText styleClass="OraInstructionText" textBinding="LOGGING_OVERVIEW@profileBundle@servletRequest"/>
			  </uix:pageStatus>

              <uix:switcher childNameBinding="serverConfig@LOGGER_ADMIN_BEAN@servletRequest">  
              <uix:case name="true">                           
              <uix:header textBinding="SERVER_CONFIG@profileBundle@servletRequest">
                <uix:tableLayout cellSpacing="5">
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                      <uix:messagePrompt promptBinding="LOG_DIRECTORY@profileBundle@servletRequest" 
					  		labeledNodeId="serverDirName" />
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left">
                      <uix:stackLayout>
                          <uix:messageLovField name="serverDirName" 
                                      id="serverDirName"
                                      columns="50"
                                      shortDescBinding="LOG_DIRECTORY@profileBundle@servletRequest"
									  tipBinding="defaultServerDirName@LOGGER_ADMIN_BEAN@servletRequest"
									  textBinding="serverDirName@LOGGER_ADMIN_BEAN@servletRequest"
                                      onClick ="openRFSWindow('serverDirName','LIST_DIRS','defaultServerDirName');"/> 
					    <%--
                        <uix:textInput name="serverDirName" id="serverDirName"
                                       textBinding="serverDirName@LOGGER_ADMIN_BEAN@servletRequest"
									   shortDescBinding="LOG_DIRECTORY@profileBundle@servletRequest"
                                       columns="65"/>
						--%>
						<uix:messageText messageType="error" messageBinding="serverDirName@errors@servletRequest"/>
						
                      </uix:stackLayout>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                      <uix:messagePrompt promptBinding="LOG_FILE@profileBundle@servletRequest" 
					  		labeledNodeId="serverFileName" />
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left">
                      <uix:stackLayout>
                        <uix:messageTextInput name="serverFileName" id="serverFileName"
                                       textBinding="serverFileName@LOGGER_ADMIN_BEAN@servletRequest"
									   tipBinding="defaultServerFileName@LOGGER_ADMIN_BEAN@servletRequest"
									   shortDescBinding="LOG_FILE@profileBundle@servletRequest"
                                       columns="65"/>
						<uix:messageText messageType="error" messageBinding="serverFileName@errors@servletRequest"/>
                      </uix:stackLayout>
                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:tableLayout>
              </uix:header>
              </uix:case>
              </uix:switcher> 

			                <uix:switcher childNameBinding="clientConfig@LOGGER_ADMIN_BEAN@servletRequest">  
              <uix:case name="true">                            
              <uix:header textBinding="CLIENT_CONFIG@profileBundle@servletRequest">
                <uix:tableLayout cellSpacing="5">
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                      <uix:messagePrompt promptBinding="LOG_DIRECTORY@profileBundle@servletRequest" 
					  		labeledNodeId="clientDirName" />
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left">
                      <uix:stackLayout>
                          <uix:messageLovField name="clientDirName" 
                                      id="clientDirName"
                                      columns="50"
                                      shortDescBinding="LOG_DIRECTORY@profileBundle@servletRequest"
									  tipBinding="defaultClientDirName@LOGGER_ADMIN_BEAN@servletRequest"
									  textBinding="clientDirName@LOGGER_ADMIN_BEAN@servletRequest"
                                      onClick = "openRFSWindow('clientDirName','LIST_DIRS','defaultClientDirName');"/> 
					    <%--
                        <uix:textInput name="clientDirName" id="clientDirName"
                                       textBinding="clientDirName@LOGGER_ADMIN_BEAN@servletRequest"
									   shortDescBinding="LOG_DIRECTORY@profileBundle@servletRequest"
                                       columns="65"/>
						--%>
                      	<uix:messageText messageType="error" messageBinding="clientDirName@errors@servletRequest"/>
					  </uix:stackLayout>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                      <uix:messagePrompt promptBinding="LOG_FILE@profileBundle@servletRequest" 
					  		labeledNodeId="clientFileName" />
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left">
                      <uix:stackLayout>
                        <uix:messageTextInput name="clientFileName" id="clientFileName"
                                       textBinding="clientFileName@LOGGER_ADMIN_BEAN@servletRequest"
									   tipBinding = "defaultClientFileName@LOGGER_ADMIN_BEAN@servletRequest"
									   shortDescBinding="LOG_FILE@profileBundle@servletRequest"
                                       columns="65"/>
                      	<uix:messageText messageType="error" messageBinding="clientFileName@errors@servletRequest"/>
					  </uix:stackLayout>
                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:tableLayout>
              </uix:header>
              </uix:case>
              </uix:switcher> 

              <uix:pageButtons>
                <uix:pageButtonBar>
                  <uix:contents>
                    <uix:submitButton textBinding="CANCEL@defaultMsgBundle@servletRequest"
                                      name="event" value="cancel" shortDescBinding="CANCEL@netBundle@servletRequest"/>
                    <uix:submitButton textBinding="OK@defaultMsgBundle@servletRequest"
                                      name="event" value="apply" shortDescBinding="OK@netBundle@servletRequest"/>
                  </uix:contents>
                </uix:pageButtonBar>
              </uix:pageButtons>
  		    </uix:pageLayout>
	      </uix:form>
      </uix:body>
  </uix:document>
</uix:renderingContext>
