<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ page import="oracle.sysman.db.rsc.net.profile.ProfileMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.db.rsc.net.NetMsg" %>
<%
  request.setAttribute("profileBundle", new BundleDataObject(NLSUtil.getBundle(ProfileMsg.class.getName(), request)));
  request.setAttribute("netBundle", new BundleDataObject(NLSUtil.getBundle(NetMsg.class.getName(), request)));
%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>
	  <%@ include file="/oemTitle.jspf" %>
      <uix:metaContainer>
		<uix:head titleBinding="TITLE@servletRequest"/>
      </uix:metaContainer>

      <uix:body>
        <uix:form name="namingForm" method="post"
                  destinationBinding="defaultControllerURL@defaultBean@servletRequest">
          <uix:formValue name="pageName" value="/net/profile/naming"/>

          <uix:pageLayout titleBinding="NAMING_METHODS@profileBundle@servletRequest">
            <%@ include file="/oemGlobal.jspf" %>
              <oem:messageBox messageType="error"
                              errorTableBinding="errors@servletRequest"
                              titleTextKey="titleText" mainTextKey="mainText"/>

              <uix:tableLayout cellSpacing="5">
                <uix:stackLayout>
                  <uix:rowLayout>
					<uix:cellFormat hAlign="left">
                    <oem:shuttle name="methods"
                                 leadingHeaderBinding="AVAILABLE_METHODS@profileBundle@servletRequest"
                                 trailingHeaderBinding="SELECTED_METHODS@profileBundle@servletRequest"
                                 size="5" reorderable="true">
                      <uix:leading>
                        <oem:list name="availableMethods"
                                  shortDescBinding="AVAILABLE_METHODS@profileBundle@servletRequest"
                                  optionsBinding="availableMethods@NAMING_ADMIN_BEAN@servletRequest"/>
                      </uix:leading>
                      <uix:trailing>
                        <oem:list name="namingMethods"
                                  shortDescBinding="NAMING_METHODS@profileBundle@servletRequest"
                                  optionsBinding="namingMethods@NAMING_ADMIN_BEAN@servletRequest"/>
                      </uix:trailing>
                    </oem:shuttle>
					</uix:cellFormat>
					
					<%-- Content Container for Naming Methods --%>
					<uix:cellFormat hAlign="right" vAlign="top">
						<uix:contentContainer width="90%" background="light" 		textBinding="OVERVIEW@profileBundle@servletRequest">
							<uix:contents>
								<uix:stackLayout>
								<uix:contents> 
									<uix:rowLayout>
										<uix:styledText styleClass="OraHeaderSubSub" 
										textBinding="SELECTED_METHODS@profileBundle@servletRequest"/>
									</uix:rowLayout>
									<uix:rowLayout>
										<uix:styledText styleClass="OraInlineInfoText" 
										textBinding="NAMING_TIP_METHODS_ORDER@profileBundle@servletRequest"/>
									</uix:rowLayout>
									<uix:rowLayout>
										<uix:styledText styleClass="OraHeaderSubSub" 
										textBinding="DEFAULT_DOMAIN@profileBundle@servletRequest"/>
									</uix:rowLayout>
									<uix:rowLayout>
										<uix:styledText styleClass="OraInlineInfoText" 
										textBinding="NAMING_TIP_DEFAULT_DOMAIN@profileBundle@servletRequest"/>
									</uix:rowLayout>
									<uix:rowLayout>
										<uix:styledText styleClass="OraHeaderSubSub" 
										textBinding="CELL_NAME@profileBundle@servletRequest"/>
									</uix:rowLayout>
									<uix:rowLayout>
										<uix:styledText styleClass="OraInlineInfoText" 
										textBinding="NAMING_TIP_CELL_NAME@profileBundle@servletRequest"/>
									</uix:rowLayout>
									<uix:rowLayout>
										<uix:styledText styleClass="OraHeaderSubSub" 
										textBinding="META_MAP@profileBundle@servletRequest"/>
									</uix:rowLayout>
									<uix:rowLayout>
										<uix:styledText styleClass="OraInlineInfoText" 
										textBinding="NAMING_TIP_META_MAP@profileBundle@servletRequest"/>
									</uix:rowLayout>

								</uix:contents>
								</uix:stackLayout>
							</uix:contents>
						</uix:contentContainer>
					</uix:cellFormat>
                  </uix:rowLayout>

				  <uix:rowLayout>
                    <uix:spacer height="10" width="10"/>
                  </uix:rowLayout>

                </uix:stackLayout>
              </uix:tableLayout>

              <uix:spacer height="20" width="10"/>

			 <%-- Table for Default Domain, CDS, NIS --%>
			 <uix:tableLayout cellSpacing="5">

				  <uix:rowLayout>
					<uix:tableLayout cellSpacing="5">
					<uix:rowLayout>
	                    <uix:cellFormat hAlign="left">
			               <uix:messagePrompt labeledNodeId="defaultDomain"
						  	promptBinding="DEFAULT_DOMAIN@profileBundle@servletRequest"/>
					    </uix:cellFormat>
						<uix:cellFormat hAlign="right">
	                        <uix:textInput name="defaultDomain" id="defaultDomain"
                                       textBinding="defaultDomain@NAMING_ADMIN_BEAN@servletRequest"
									   shortDescBinding="DEFAULT_DOMAIN@profileBundle@servletRequest"
                                       columns="40"/>
						 </uix:cellFormat>
					</uix:rowLayout>
					</uix:tableLayout>
                  </uix:rowLayout>

				<%-- CDS row --%>
				  <uix:rowLayout>
		  			  <uix:styledText styleClass="OraHeaderSub" 				textBinding="CELL_DIRECTORY_SERVICE@profileBundle@servletRequest"/>
				  </uix:rowLayout>

				 <uix:rowLayout>
				    <uix:tableLayout cellSpacing="5">
					<uix:rowLayout>
						<uix:cellFormat hAlign="left">
							<uix:messagePrompt labeledNodeId="cellName"
									promptBinding="CELL_NAME@profileBundle@servletRequest"/>
						</uix:cellFormat>	
						<uix:cellFormat hAlign="right">
							<uix:textInput name="cellName" id="cellName"					textBinding="cellName@NAMING_ADMIN_BEAN@servletRequest"                                        shortDescBinding="CELL_NAME@profileBundle@servletRequest"								 columns="40"/>
						</uix:cellFormat>	
					</uix:rowLayout>
					</uix:tableLayout>
				</uix:rowLayout>

				<%-- NIS row --%>
				<uix:rowLayout>
					<uix:styledText styleClass="OraHeaderSub" textBinding="NETWORK_NAMING_SERVICES@profileBundle@servletRequest"/>
				</uix:rowLayout>
				<uix:rowLayout>
					<uix:tableLayout cellSpacing="5">
					<uix:rowLayout>
						<uix:cellFormat hAlign="left">
		                    <uix:messagePrompt labeledNodeId="metaMap"						promptBinding="META_MAP@profileBundle@servletRequest"/>
						</uix:cellFormat>	
						<uix:cellFormat hAlign="right">
			                <uix:textInput name="metaMap" id="metaMap"                                                textBinding="metaMap@NAMING_ADMIN_BEAN@servletRequest"                                         shortDescBinding="META_MAP@profileBundle@servletRequest"								 columns="40"/>
						</uix:cellFormat>	
					</uix:rowLayout>
					</uix:tableLayout>
				</uix:rowLayout>

			 </uix:tableLayout>

              <uix:pageButtons>
                <uix:pageButtonBar>
                  <uix:contents>
                    <uix:submitButton textBinding="CANCEL@defaultMsgBundle@servletRequest"
                                      name="event" value="cancel" shortDescBinding="CANCEL@netBundle@servletRequest"/>
                    <uix:submitButton textBinding="OK@defaultMsgBundle@servletRequest"
                                      name="event" value="apply" shortDescBinding="OK@netBundle@servletRequest"/>
                  </uix:contents>
                </uix:pageButtonBar>
              </uix:pageButtons>

          </uix:pageLayout>
        </uix:form>
      </uix:body>
  </uix:document>
</uix:renderingContext>