<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ page import="oracle.sysman.db.rsc.net.profile.ProfileMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<%@ page import="oracle.sysman.db.rsc.net.NetMsg"%>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%
  request.setAttribute("profileBundle", new BundleDataObject(NLSUtil.getBundle(ProfileMsg.class.getName(), request)));
  request.setAttribute("netBundle", new BundleDataObject(NLSUtil.getBundle(NetMsg.class.getName(), request)));
%>
<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
  <%@ include file="/oemTitle.jspf" %>
  <uix:metaContainer>
    <uix:head titleBinding="TITLE@servletRequest" />
  </uix:metaContainer>
  <uix:body>
         <uix:form name="profileForm" method="post" destinationBinding="defaultControllerURL@defaultBean@servletRequest">

  <uix:pageLayout>
      <%@ include file="/oemGlobal.jspf" %>
      <oem:messageBox messageType="info"
                      errorTableBinding="info@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
      <oem:messageBox messageType="warn" errorTableBinding="warn@servletRequest" titleTextKey="titleText" mainTextKey="mainText" />

	  <uix:header textBinding="PROFILE_HEADER@profileBundle@servletRequest">
      
	  <uix:tableLayout cellSpacing="5" width="100%">
        <uix:rowLayout hAlign="left" width="100%">
	    	<uix:cellFormat hAlign="left" vAlign="top">
	  			<uix:styledText styleClass="OraInstructionText" 
	  					textBinding="PROFILE_MAIN_TIP@profileBundle@servletRequest"/>
	  		</uix:cellFormat>
	   	 </uix:rowLayout>
	   </uix:tableLayout> 

	  <uix:tableLayout cellSpacing="5" width="50%">
        <uix:rowLayout hAlign="left" width="100%">
   			<uix:cellFormat hAlign="right" vAlign="top">
					<uix:styledText styleClass="OraInstructionText"
					textBinding="ORACLE_HOME@netBundle@servletRequest"/> 
			</uix:cellFormat>
			<uix:cellFormat hAlign="left" vAlign="top">
					<uix:styledText styleClass="OraDataText"
					textBinding="ORACLE_HOME@servletRequest"/> 
			</uix:cellFormat>
	    </uix:rowLayout>
		<uix:rowLayout hAlign="right" width="100%">
   			<uix:cellFormat hAlign="right" vAlign="top">
					<uix:styledText styleClass="OraInstructionText"
					textBinding="PROFILE_LOC@profileBundle@servletRequest"/> 
			</uix:cellFormat>
			<uix:cellFormat hAlign="left" vAlign="top">
					<uix:styledText styleClass="OraDataText"
					textBinding="PROFILE_LOC@servletRequest"/> 
			</uix:cellFormat>
	    </uix:rowLayout>
	   </uix:tableLayout> 

    <uix:header textBinding="GENERAL@profileBundle@servletRequest">
      <uix:tableLayout cellSpacing="2" width="100%">
        <uix:rowLayout hAlign="left" width="100%">
        
          <uix:cellFormat hAlign="left" vAlign="top" width="23%">

              <uix:tableLayout cellSpacing="10" width="100%">
                <uix:rowLayout hAlign="left">
                  <uix:cellFormat hAlign="left">
                    <uix:link destinationBinding="NAMING@servletRequest" 
                              textBinding="NAMING_METHODS@profileBundle@servletRequest"/>
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout hAlign="left">
                  <uix:cellFormat hAlign="left">
                    <uix:link destinationBinding="TRACING@servletRequest" 
                              textBinding="TRACING@profileBundle@servletRequest"/>
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout hAlign="left">
                  <uix:cellFormat hAlign="left">
                    <uix:link destinationBinding="LOGGING@servletRequest"
                              textBinding="LOGGING@profileBundle@servletRequest"/>
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout hAlign="left">
                  <uix:cellFormat hAlign="left">
                    <uix:link destinationBinding="ROUTING@servletRequest"
                              textBinding="ROUTING_ACCESS_RIGHTS@profileBundle@servletRequest"/>
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout hAlign="left">
                  <uix:cellFormat hAlign="left">
                    <uix:link destinationBinding="ADVANCED@servletRequest"
                              textBinding="ADVANCED_OPTIONS@profileBundle@servletRequest"/>
                  </uix:cellFormat>
                </uix:rowLayout>
            </uix:tableLayout>
          </uix:cellFormat>
          
          
          <uix:cellFormat hAlign="left" vAlign="bottom" width="50%">
			<uix:contents>
                            
				<uix:contentContainer width="100%" textBinding ="OVERVIEW@profileBundle@servletRequest" background="light">
					<uix:contents>
						<uix:stackLayout>
							<uix:contents> 

								<uix:rowLayout>
								<uix:styledText styleClass="OraHeaderSubSub" 
									textBinding="NAMING_METHODS@profileBundle@servletRequest"/>
								</uix:rowLayout>
								<uix:rowLayout>
								<uix:styledText styleClass="OraInlineInfoText"
									textBinding="TIP_NAMING_METHODS@profileBundle@servletRequest"/> 
								</uix:rowLayout>

								<uix:rowLayout>
								<uix:styledText styleClass="OraHeaderSubSub" 
									textBinding="TRACING@profileBundle@servletRequest"/>
								</uix:rowLayout>
								<uix:rowLayout>
								<uix:styledText styleClass="OraInlineInfoText"
									textBinding="TIP_TRACING@profileBundle@servletRequest"/> 
								</uix:rowLayout>

								<uix:rowLayout>
								<uix:styledText styleClass="OraHeaderSubSub" 
									textBinding="LOGGING@profileBundle@servletRequest"/>
								</uix:rowLayout>
								<uix:rowLayout>
								<uix:styledText styleClass="OraInlineInfoText"
									textBinding="TIP_LOGGING@profileBundle@servletRequest"/> 
								</uix:rowLayout>

								<uix:rowLayout>
								<uix:styledText styleClass="OraHeaderSubSub" 
									textBinding="ROUTING_ACCESS_RIGHTS@profileBundle@servletRequest"/>
								</uix:rowLayout>
								<uix:rowLayout>
								<uix:styledText styleClass="OraInlineInfoText"
									textBinding="TIP_ROUTING@profileBundle@servletRequest"/> 
								</uix:rowLayout>

								<uix:rowLayout>
								<uix:styledText styleClass="OraHeaderSubSub" 
									textBinding="ADVANCED_OPTIONS@profileBundle@servletRequest"/>
								</uix:rowLayout>
								<uix:rowLayout>
								<uix:styledText styleClass="OraInlineInfoText"
									textBinding="TIP_ADVANCED@profileBundle@servletRequest"/> 
								</uix:rowLayout>

							</uix:contents>
						</uix:stackLayout>
					</uix:contents>
				</uix:contentContainer>                             
                                 
			</uix:contents>    
          </uix:cellFormat>
        </uix:rowLayout>  
        
        </uix:tableLayout>
      </uix:header>


	<uix:hideShowHeader textBinding="ASO@profileBundle@servletRequest" 
						disclosedBinding="showHideOptionForASO@profileAdminBean@servletRequest" formSubmitted="true" id="HSH1">
				
	  <uix:contents>
	   <uix:tableLayout cellSpacing="2" width="100%">
        
        <uix:rowLayout hAlign="left" width="100%">
          <uix:cellFormat hAlign="left" vAlign="top" width="23%">          
            

                <uix:tableLayout cellSpacing="10">
                  <uix:rowLayout hAlign="left">
                    <uix:cellFormat hAlign="left">
                      <uix:link destinationBinding="AUTHENTICATION@servletRequest" 
                                textBinding="AUTHENTICATION@profileBundle@servletRequest"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout hAlign="left">
                    <uix:cellFormat hAlign="left">
                      <uix:link destinationBinding="INTEGRITY@servletRequest" 
                                textBinding="INTEGRITY@profileBundle@servletRequest"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout hAlign="left">
                    <uix:cellFormat hAlign="left">
                      <uix:link destinationBinding="ENCRYPTION@servletRequest" 
                                textBinding="ENCRYPTION@profileBundle@servletRequest"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout hAlign="left">
                    <uix:cellFormat hAlign="left">
                      <uix:link destinationBinding="SSL@servletRequest" 
                                textBinding="SSL@profileBundle@servletRequest"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout hAlign="left">
                    <uix:cellFormat hAlign="left">
                      <uix:link destinationBinding="WALLET@servletRequest" 
                                textBinding="WALLET@profileBundle@servletRequest"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:tableLayout>
      
            </uix:cellFormat>
            
            <uix:cellFormat hAlign="left" vAlign="top" width="50%">

			<uix:contents>
                            
				<uix:contentContainer width="100%" textBinding ="OVERVIEW@profileBundle@servletRequest" background="light">
					<uix:contents>
						<uix:stackLayout>
							<uix:contents> 

								<uix:rowLayout>
								<uix:styledText styleClass="OraHeaderSubSub" 
									textBinding="AUTHENTICATION@profileBundle@servletRequest"/>
								</uix:rowLayout>
								<uix:rowLayout>
								<uix:styledText styleClass="OraInlineInfoText"
									textBinding="TIP_AUTHETICATION@profileBundle@servletRequest"/> 
								</uix:rowLayout>

								<uix:rowLayout>
								<uix:styledText styleClass="OraHeaderSubSub" 
									textBinding="INTEGRITY@profileBundle@servletRequest"/>
								</uix:rowLayout>
								<uix:rowLayout>
								<uix:styledText styleClass="OraInlineInfoText"
									textBinding="TIP_INTEGRITY@profileBundle@servletRequest"/> 
								</uix:rowLayout>

								<uix:rowLayout>
								<uix:styledText styleClass="OraHeaderSubSub" 
									textBinding="ENCRYPTION@profileBundle@servletRequest"/>
								</uix:rowLayout>
								<uix:rowLayout>
								<uix:styledText styleClass="OraInlineInfoText"
									textBinding="TIP_ENCRYPTION@profileBundle@servletRequest"/> 
								</uix:rowLayout>

								<uix:rowLayout>
								<uix:styledText styleClass="OraHeaderSubSub" 
									textBinding="SSL@profileBundle@servletRequest"/>
								</uix:rowLayout>
								<uix:rowLayout>
								<uix:styledText styleClass="OraInlineInfoText"
									textBinding="TIP_SSL@profileBundle@servletRequest"/> 
								</uix:rowLayout>

								<uix:rowLayout>
								<uix:styledText styleClass="OraHeaderSubSub" 
									textBinding="WALLET@profileBundle@servletRequest"/>
								</uix:rowLayout>
								<uix:rowLayout>
								<uix:styledText styleClass="OraInlineInfoText"
									textBinding="TIP_WALLET@profileBundle@servletRequest"/> 
								</uix:rowLayout>

							</uix:contents>
						</uix:stackLayout>
					</uix:contents>
					</uix:contentContainer>                             
                                 
				</uix:contents> 

            </uix:cellFormat>
            
          </uix:rowLayout>
        </uix:tableLayout>
		</uix:contents>
		</uix:hideShowHeader>

		</uix:header>		

      </uix:pageLayout>
	  </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
