<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ include file="/oemNoscript.jspf"%>
<%@ page import="oracle.sysman.db.rsc.net.profile.ProfileMsg"%>
<%@ page import="oracle.cabo.ui.data.BundleDataObject"%>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil"%>
<%@ page import="oracle.sysman.db.rsc.net.NetMsg"%>
<% 
  request.setAttribute("profileBundle", new BundleDataObject(NLSUtil.getBundle(ProfileMsg.class.getName(), request)));
  request.setAttribute("netBundle", new BundleDataObject(NLSUtil.getBundle(NetMsg.class.getName(), request)));
%>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %> 
    <uix:metaContainer>
      <uix:head titleBinding="TITLE@servletRequest"/>
    </uix:metaContainer>
    <uix:body>
      <uix:contents>
       <uix:form name="routingForm" method="post" destinationBinding="defaultControllerURL@defaultBean@servletRequest">
        <uix:formValue name="pageName" value="/net/profile/routing"/>
          <uix:contents>
            <uix:pageLayout titleBinding="ROUTING_ACCESS_RIGHTS@profileBundle@servletRequest" 
                            styleClass="OraInstructionText">
            <%@ include file="/oemGlobal.jspf" %>
            <oem:messageBox messageType = "error" 
                            msgBundleBinding="profileMsg@servletRequest" 
                            errorTableBinding="errors@servletRequest"
                            titleTextKey="titleText" mainTextKey="mainText"/>
                            
      <uix:tableLayout cellSpacing="10" width="100%">
        <uix:rowLayout hAlign="left" width="100%">       
          <uix:cellFormat hAlign="left" vAlign="top" width="55%">
          
              <uix:contents>
                <uix:header textBinding="ROUTING@profileBundle@servletRequest">
                  <uix:contents>
                    <uix:tableLayout>
                      <uix:contents>
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat>
                              <uix:contents>
			              		<uix:checkBox name="useDedicatedServer"
                                     checkedBinding="useDedicatedServer@ROUTING_ADMIN_BEAN@servletRequest"
									 shortDescBinding="ALWAYS_DEDICATED_SERVER@profileBundle@servletRequest"/>

                              </uix:contents>
                            </uix:cellFormat>
                            <uix:cellFormat>
                              <uix:contents>
                                <uix:stackLayout>
                                  <uix:contents>
                                     <uix:messagePrompt 
									 	promptBinding="ALWAYS_DEDICATED_SERVER@profileBundle@servletRequest"/>                              
                                  </uix:contents>
                                </uix:stackLayout>
                              </uix:contents>
                            </uix:cellFormat>
                          </uix:contents>
                        </uix:rowLayout>
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat>
                              <uix:contents>
                                    <uix:checkBox name="useCman"
                                     checkedBinding="useCman@ROUTING_ADMIN_BEAN@servletRequest"
									 shortDescBinding="PREFER_CONMAN_ROUTING@profileBundle@servletRequest"/>
                              </uix:contents>
                            </uix:cellFormat>
                            <uix:cellFormat>
                              <uix:contents>
                                <uix:stackLayout>
                                  <uix:contents>
                                    <uix:messagePrompt 
										promptBinding="PREFER_CONMAN_ROUTING@profileBundle@servletRequest" />      
                                  </uix:contents>
                                </uix:stackLayout>
                              </uix:contents>
                            </uix:cellFormat>
                          </uix:contents>
                        </uix:rowLayout>
                      </uix:contents>
                    </uix:tableLayout>
                  </uix:contents>
                </uix:header>
                <uix:header textBinding="ACCESS_RIGHTS@profileBundle@servletRequest">
                  <uix:contents>
                    <uix:tableLayout>
                      <uix:contents>
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat hAlign="right">
                              <uix:contents>
                                <uix:stackLayout>
                                  <uix:contents>
                                    <uix:checkBox name="tcpValidNodeCheck"
                                      checkedBinding="tcpValidNodeCheck@ROUTING_ADMIN_BEAN@servletRequest" 
                                      shortDescBinding="TCPIP_ACCESS_RIGHTS@profileBundle@servletRequest"
									  onClick="submitForm('routingForm', true, {event:'checktcp'})"/> 
                                  </uix:contents>
                                </uix:stackLayout>
                              </uix:contents>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="left">
                              <uix:contents>
                               <uix:messagePrompt 
							   	promptBinding="TCPIP_ACCESS_RIGHTS@profileBundle@servletRequest"/>
                              </uix:contents>
                            </uix:cellFormat>
                          </uix:contents>
                        </uix:rowLayout>
                      </uix:contents>
                    </uix:tableLayout>
                    <uix:tableLayout cellSpacing="5">
                    <uix:contents>
                    <uix:switcher childNameBinding="tcpAccessRights@ROUTING_ADMIN_BEAN@servletRequest">  
                        <uix:case name="true">                                
                        <uix:rowLayout hAlign="right">
                          <uix:contents>
                            <uix:cellFormat>
                              <uix:contents>
                                <uix:messagePrompt 
									promptBinding="CLIENTS_ALLOWED@profileBundle@servletRequest"/>                              
                              </uix:contents>
                            </uix:cellFormat>
                            <uix:cellFormat>
                              <uix:contents>
                                <uix:messageTextInput name="invitedNodes"
                                   textBinding="invitedNodes@ROUTING_ADMIN_BEAN@servletRequest"
                                   shortDescBinding="CLIENTS_ALLOWED@profileBundle@servletRequest"
								   tipBinding="ACCESS_RIGHTS_TIP@profileBundle@servletRequest"
                                   rows="3"
                                   columns="50" /> 
							  </uix:contents>
                            </uix:cellFormat>
                          </uix:contents>
                        </uix:rowLayout>
                        </uix:case>

                        <uix:case name="false">                                
                        <uix:rowLayout hAlign="right">
                          <uix:contents>
                            <uix:cellFormat>
                              <uix:contents>
                                <uix:messagePrompt 
									promptBinding="CLIENTS_ALLOWED@profileBundle@servletRequest"/>                              
                              </uix:contents>
                            </uix:cellFormat>
                            <uix:cellFormat>
                              <uix:contents>
                                <uix:messageTextInput name="invitedNodes"
                                   textBinding="invitedNodes@ROUTING_ADMIN_BEAN@servletRequest"
                                   shortDescBinding="CLIENTS_ALLOWED@profileBundle@servletRequest"
								   tipBinding="ACCESS_RIGHTS_TIP@profileBundle@servletRequest"
                                   rows="3" readOnly="true" 
                                   columns="50" /> 
							  </uix:contents>
                            </uix:cellFormat>
                          </uix:contents>
                        </uix:rowLayout>
                        </uix:case>

                        </uix:switcher>

                      <uix:switcher childNameBinding="tcpAccessRights@ROUTING_ADMIN_BEAN@servletRequest">  
                      
                      <uix:case name="true">                                             
                        <uix:rowLayout hAlign="right">
                          <uix:contents>
                            <uix:cellFormat>
                              <uix:contents>
                                <uix:messagePrompt 
									promptBinding="CLIENTS_EXCLUDED@profileBundle@servletRequest"/>                              
                              </uix:contents>
                            </uix:cellFormat>
                            <uix:cellFormat>
                              <uix:contents>
                                <uix:messageTextInput name="excludedNodes"
                                   textBinding="excludedNodes@ROUTING_ADMIN_BEAN@servletRequest"
								   shortDescBinding="CLIENTS_EXCLUDED@profileBundle@servletRequest"
                                   tipBinding="ACCESS_RIGHTS_TIP@profileBundle@servletRequest"
                                   rows="3"
                                   columns="50" /> 
                              </uix:contents>
                            </uix:cellFormat>
                          </uix:contents>
                        </uix:rowLayout>
                        </uix:case>
                      <uix:case name="false">                                             
                        <uix:rowLayout hAlign="right">
                          <uix:contents>
                            <uix:cellFormat>
                              <uix:contents>
                                <uix:messagePrompt 
									promptBinding="CLIENTS_EXCLUDED@profileBundle@servletRequest"/>                              
                              </uix:contents>
                            </uix:cellFormat>
                            <uix:cellFormat>
                              <uix:contents>
                                <uix:messageTextInput name="excludedNodes"
                                   textBinding="excludedNodes@ROUTING_ADMIN_BEAN@servletRequest"
								   shortDescBinding="CLIENTS_EXCLUDED@profileBundle@servletRequest"
                                   tipBinding="ACCESS_RIGHTS_TIP@profileBundle@servletRequest"
                                   rows="3" readOnly="true" 
                                   columns="50" /> 
                              </uix:contents>
                            </uix:cellFormat>
                          </uix:contents>
                        </uix:rowLayout>
                        </uix:case>
                        
                        </uix:switcher> 
              
                         
                      
                      </uix:contents>
                    </uix:tableLayout>
                  </uix:contents>
                </uix:header>              
              </uix:contents>
            
            
            </uix:cellFormat>
            
            <uix:cellFormat hAlign="left" vAlign="top" width="45%">       
              <uix:contents>
              
				<uix:contentContainer width="100%" textBinding ="OVERVIEW@profileBundle@servletRequest" background="light">
					<uix:contents>
						<uix:stackLayout>
							<uix:contents> 

								<uix:rowLayout>
								<uix:styledText styleClass="OraHeaderSubSub" 
									textBinding="ALWAYS_DEDICATED_SERVER@profileBundle@servletRequest"/>
								</uix:rowLayout>
								<uix:rowLayout>
								<uix:styledText styleClass="OraInlineInfoText"
									textBinding="TIP_DEDICATED_SERVER@profileBundle@servletRequest"/> 
								</uix:rowLayout>
								
								<uix:rowLayout>
									<uix:spacer width="15"/>
								</uix:rowLayout>
								
								<uix:rowLayout>
								<uix:styledText styleClass="OraHeaderSubSub" 
									textBinding="PREFER_CONMAN_ROUTING@profileBundle@servletRequest"/>
								</uix:rowLayout>
								<uix:rowLayout>
								<uix:styledText styleClass="OraInlineInfoText"
									textBinding="TIP_CMAN_ROUTING@profileBundle@servletRequest"/> 
								</uix:rowLayout>

								<uix:rowLayout>
									<uix:spacer width="15"/>
								</uix:rowLayout>

								<uix:rowLayout>
								<uix:styledText styleClass="OraHeaderSubSub" 
									textBinding="TCPIP_ACCESS_RIGHTS@profileBundle@servletRequest"/>
								</uix:rowLayout>
								<uix:rowLayout>
								<uix:styledText styleClass="OraInlineInfoText"
									textBinding="TIP_ACCESS_RIGHTS@profileBundle@servletRequest"/> 
								</uix:rowLayout>
								
							</uix:contents>
						</uix:stackLayout>
					</uix:contents>
				</uix:contentContainer>                                           
              
              </uix:contents>
            </uix:cellFormat>
            
            </uix:rowLayout>
            </uix:tableLayout>
            
              <uix:pageButtons>
                <uix:pageButtonBar>
                  <uix:contents>
                    <uix:submitButton textBinding="CANCEL@defaultMsgBundle@servletRequest" 
                                      name="event" value="cancel" shortDescBinding="CANCEL@netBundle@servletRequest"/>
                    <uix:submitButton textBinding="OK@defaultMsgBundle@servletRequest" 
                                      name="event" value="apply" shortDescBinding="OK@netBundle@servletRequest"/>
                  </uix:contents>
                </uix:pageButtonBar>
              </uix:pageButtons>
            
            
            </uix:pageLayout>
          </uix:contents>
        </uix:form>
      </uix:contents>
    </uix:body>
  </uix:document>
</uix:renderingContext>
