<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ include file="/oemNoscript.jspf"%>
<%@ page import="oracle.sysman.db.rsc.net.profile.ProfileMsg"%>
<%@ page import="oracle.sysman.db.rsc.net.NetMsg"%>
<%@ page import="oracle.cabo.ui.data.BundleDataObject"%>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil"%>
<% 
  request.setAttribute("profileBundle", new BundleDataObject(NLSUtil.getBundle(ProfileMsg.class.getName(), request)));
  request.setAttribute("netBundle", new BundleDataObject(NLSUtil.getBundle(NetMsg.class.getName(), request)));
%>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %> 
    <uix:metaContainer>
      <uix:head titleBinding="TITLE@servletRequest"/>
    </uix:metaContainer>
    <uix:body>
      <uix:contents>
       <uix:form name="sslform" method="post" destinationBinding="defaultControllerURL@defaultBean@servletRequest">
        <uix:formValue name="pageName" value="/net/profile/sslPage"/>
          <uix:contents>
            <uix:pageLayout titleBinding="SSL@profileBundle@servletRequest" 
                            styleClass="OraInstructionText">
            <%@ include file="/oemGlobal.jspf" %>
            <oem:messageBox messageType = "error" 
                            msgBundleBinding="profileMsg@servletRequest" 
                            errorTableBinding="errors@servletRequest"
                            titleTextKey="titleText" mainTextKey="mainText"/>
              <uix:contents>
                <uix:header textBinding="CONFIGURATION@profileBundle@servletRequest">
                  <uix:contents>
                    <uix:tableLayout cellSpacing="5" width="100%">
                      <uix:contents>
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat>
                              <uix:contents>
                                <uix:radioButton textBinding="SERVER@profileBundle@servletRequest" 
                                                 shortDescBinding="SERVER@profileBundle@servletRequest" 
												 name="config"
                                                 selectedValueBinding="configuration@SSL_ADMIN_BEAN@servletRequest"
                                                 value="SERVER"/>
                              </uix:contents>
                            </uix:cellFormat>
                          </uix:contents>
                        </uix:rowLayout>
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat>
                              <uix:contents>
                                <uix:radioButton textBinding="CLIENT@profileBundle@servletRequest" 
                                                 shortDescBinding="CLIENT@profileBundle@servletRequest" 
												 name="config"
                                                 selectedValueBinding="configuration@SSL_ADMIN_BEAN@servletRequest"
                                                 value="CLIENT"/>
                              </uix:contents>
                            </uix:cellFormat>
                          </uix:contents>
                        </uix:rowLayout>
                      </uix:contents>
                    </uix:tableLayout>
                  </uix:contents>
                </uix:header>
                <uix:header textBinding="SSL_METHODS@profileBundle@servletRequest">
                  <uix:contents>
                    <uix:tableLayout cellSpacing="5" width="100%">
                      <uix:contents>
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat>
                              <uix:contents>
                                <uix:radioButton textBinding="FILE_SYSTEM@profileBundle@servletRequest" 
                                                 shortDescBinding="FILE_SYSTEM@profileBundle@servletRequest"
												 name="method"
                                                 selectedValueBinding="sslMethod@SSL_ADMIN_BEAN@servletRequest"
                                                 value="FILE"/>
                              </uix:contents>
                            </uix:cellFormat>
                          </uix:contents>
                        </uix:rowLayout>
                        <uix:switcher childNameBinding="windows@SSL_ADMIN_BEAN@servletRequest">  
                        <uix:case name="true">                                             
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat>
                              <uix:contents>
                                <uix:radioButton textBinding="MS_CERTIFICATE@profileBundle@servletRequest" 
                                                 shortDescBinding="MS_CERTIFICATE@profileBundle@servletRequest"
												 name="method"
                                                 selectedValueBinding="sslMethod@SSL_ADMIN_BEAN@servletRequest"
                                                 value="MCS"/>
                              </uix:contents>
                            </uix:cellFormat>
                          </uix:contents>
                       </uix:rowLayout>
                       </uix:case>
                       </uix:switcher> 
                       <uix:switcher childNameBinding="windows@SSL_ADMIN_BEAN@servletRequest">  
                       <uix:case name="true">                                             
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat>
                              <uix:contents>
                                <uix:radioButton textBinding="MS_REGISTRY@profileBundle@servletRequest" 
                                                 shortDescBinding="MS_REGISTRY@profileBundle@servletRequest"
												 name="method"
                                                 selectedValueBinding="sslMethod@SSL_ADMIN_BEAN@servletRequest"
                                                 value="REG"/>
                              </uix:contents>
                            </uix:cellFormat>
                          </uix:contents>
                         </uix:rowLayout>
                         </uix:case>
                         </uix:switcher> 
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:radioButton textBinding="ENTRUST@profileBundle@servletRequest" 
                                             shortDescBinding="ENTRUST@profileBundle@servletRequest"
											 name="method"
                                             selectedValueBinding="sslMethod@SSL_ADMIN_BEAN@servletRequest"
                                             value="ENTR"/>
                          </uix:contents>
                        </uix:rowLayout>
                      </uix:contents>
                    </uix:tableLayout>
                  </uix:contents>
                </uix:header>              
              </uix:contents>
              <uix:pageButtons>
                <uix:pageButtonBar>
                  <uix:contents>
                    <uix:submitButton textBinding="CANCEL@defaultMsgBundle@servletRequest" 
                                      name="event" value="cancel" shortDescBinding="CANCEL@netBundle@servletRequest"/>
                    <uix:submitButton textBinding="CONTINUE@profileBundle@servletRequest" 
                                      name="event" value="continue" shortDescBinding="CONTINUE@profileBundle@servletRequest"/>
                  </uix:contents>
                </uix:pageButtonBar>
              </uix:pageButtons>
            </uix:pageLayout>
          </uix:contents>
        </uix:form>
      </uix:contents>
    </uix:body>
  </uix:document>
</uix:renderingContext>
