<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>

<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%-- <db:script src="/database/remoteBrowser/remoteBrowser.js"/> --%>

<%@ include file="/oemNoscript.jspf"%>
<%@ page import="oracle.sysman.db.rsc.net.profile.ProfileMsg"%>
<%@ page import="oracle.sysman.db.rsc.net.NetMsg"%>
<%@ page import="oracle.cabo.ui.data.BundleDataObject"%>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil"%>

<% 
  request.setAttribute("profileBundle", new BundleDataObject(NLSUtil.getBundle(ProfileMsg.class.getName(), request)));
  request.setAttribute("netBundle", new BundleDataObject(NLSUtil.getBundle(NetMsg.class.getName(), request)));
%>

<db:script src="/net/netUtil.js"/>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %> 
    <uix:metaContainer>
      <uix:head titleBinding="TITLE@servletRequest"/>
    </uix:metaContainer>
    <uix:body>
      <uix:contents>
       <uix:form name="sslparamForm" method="post" destinationBinding="defaultControllerURL@defaultBean@servletRequest">
        <uix:formValue name="pageName" value="/net/profile/sslparam"/>
		<uix:formValue name="lovName"/>
		<uix:formValue name="listingType"/>
		<uix:formValue name="curDir"/>
		<uix:formValue name="defaultMethod"/>

          <uix:contents>
            <uix:pageLayout titleBinding="SSL_PARAM@profileBundle@servletRequest" 
                            styleClass="OraInstructionText">
            <%@ include file="/oemGlobal.jspf" %>
            <oem:messageBox messageType = "error" 
                            msgBundleBinding="profileMsg@servletRequest" 
                            errorTableBinding="errors@servletRequest"
                            titleTextKey="titleText" mainTextKey="mainText"/>
              <uix:contents>
                <uix:tableLayout cellSpacing="5">
                  <uix:contents>
                    <uix:rowLayout>
                      <uix:contents>
                        <uix:cellFormat hAlign="right">
                          <uix:contents>
                            <uix:messagePrompt promptBinding="REQUIRE_SSL_VER@profileBundle@servletRequest"
                                               labeledNodeId="sslVersion" required = "yes"/>
                          </uix:contents>
                        </uix:cellFormat>
                        <uix:cellFormat hAlign="left">
                          <uix:contents>
                            <uix:choice name="sslVersion" id="sslVersion"
                                         selectedValueBinding="sslVersion@SSL_ADMIN_BEAN@servletRequest"
										 shortDescBinding="REQUIRE_SSL_VER@profileBundle@servletRequest"
                                         required="yes">
                             <uix:contents childDataBinding="sslVersionList@SSL_ADMIN_BEAN@servletRequest">
                              <uix:option textBinding="textKey" valueBinding="valueKey"/>
                             </uix:contents>                      
                            </uix:choice> 
                          </uix:contents>
                        </uix:cellFormat>
                      </uix:contents>
                    </uix:rowLayout>
                    <uix:switcher childNameBinding="client@SSL_ADMIN_BEAN@servletRequest">  
                    <uix:case name="true">                                             
                    <uix:rowLayout>
                      <uix:contents>
                        <uix:cellFormat hAlign="right">
                          <uix:contents>
                            <uix:messagePrompt promptBinding="MATCH_SERVER_NAME@profileBundle@servletRequest"
								/>
                          </uix:contents>
                        </uix:cellFormat>
                        <uix:cellFormat hAlign="left">
                          <uix:contents>
                            <uix:stackLayout>
                              <uix:contents>
                                <uix:radioButton textBinding="YES@profileBundle@servletRequest" 
                                                 name="matchSeverName"
                                                 selectedValueBinding="matchSeverName@SSL_ADMIN_BEAN@servletRequest"
												 shortDescBinding="MATCH_SERVER_NAME@profileBundle@servletRequest"
                                                 value="YES"/>
                                <uix:radioButton textBinding="NO@profileBundle@servletRequest" 
                                                 name="matchSeverName"
                                                 selectedValueBinding="matchSeverName@SSL_ADMIN_BEAN@servletRequest"
												 shortDescBinding="MATCH_SERVER_NAME@profileBundle@servletRequest"
                                                 value="NO"/>
                              </uix:contents>
                            </uix:stackLayout>
                          </uix:contents>
                        </uix:cellFormat>
                      </uix:contents>
                    </uix:rowLayout>
                    </uix:case>
                    </uix:switcher> 
                    <uix:switcher childNameBinding="server@SSL_ADMIN_BEAN@servletRequest">  
                    <uix:case name="true">                                             
                    <uix:rowLayout>
                      <uix:contents>
                        <uix:cellFormat hAlign="right">
                          <uix:contents>
                            <uix:messagePrompt promptBinding="REQUIRE_CLIENT_AUTH@profileBundle@servletRequest"
								labeledNodeId="clientAuthentication"/>
                          </uix:contents>
                        </uix:cellFormat>
                        <uix:cellFormat hAlign="left">
                          <uix:contents>
                             <uix:checkBox name="clientAuthentication" id="clientAuthentication"
                                           checkedBinding="clientAuthentication@SSL_ADMIN_BEAN@servletRequest"
										   shortDescBinding="REQUIRE_CLIENT_AUTH@profileBundle@servletRequest"/>
                          </uix:contents>
                        </uix:cellFormat>
                      </uix:contents>
                    </uix:rowLayout>
                    </uix:case>
                    </uix:switcher> 
                    <uix:rowLayout>
                      <uix:contents>
                        <uix:cellFormat hAlign="right">
                          <uix:contents>
                            <uix:messagePrompt promptBinding="REVOCATION_CHECK@profileBundle@servletRequest"
									labeledNodeId="revocationCheck"/>
                          </uix:contents>
                        </uix:cellFormat>
                        <uix:cellFormat hAlign="left">
                          <uix:contents>
                            <uix:choice name="revocationCheck" id="revocationCheck"
                                         selectedValueBinding="revocationCheck@SSL_ADMIN_BEAN@servletRequest"
										 shortDescBinding="REVOCATION_CHECK@profileBundle@servletRequest"
										  required="yes">
                             <uix:contents childDataBinding="revocationCheckList@SSL_ADMIN_BEAN@servletRequest">
                              <uix:option textBinding="textKey" valueBinding="valueKey"/>
                             </uix:contents>                      
                            </uix:choice> 
                          </uix:contents>
                        </uix:cellFormat>
                      </uix:contents>
                    </uix:rowLayout>
                    <uix:rowLayout>
                      <uix:contents>
                        <uix:cellFormat hAlign="right">
                          <uix:contents>
                            <uix:messagePrompt promptBinding="CRL_DIR@profileBundle@servletRequest"
									labeledNodeId="revocationDir"/>
                          </uix:contents>
                        </uix:cellFormat>
                        <uix:cellFormat hAlign="left">
                          <uix:contents>
	                          <uix:messageLovField name="revocationDir" 
	                                  id="revocationDir"
                                      columns="50"
                                      shortDescBinding="CRL_DIR@profileBundle@servletRequest"
									  textBinding="revocationDir@SSL_ADMIN_BEAN@servletRequest"
                                      onClick = "openRFSWindow('revocationDir','LIST_DIRS','');"/>

						   <%--
                           <uix:textInput columns="50" 
                                          name="revocationDir" 
                                          textBinding="revocationDir@SSL_ADMIN_BEAN@servletRequest"/>
							--%>                                          
                          </uix:contents>
                        </uix:cellFormat>
                      </uix:contents>
                    </uix:rowLayout>
                    <uix:rowLayout>
                      <uix:contents>
                        <uix:cellFormat hAlign="right">
                          <uix:contents>
                            <uix:messagePrompt promptBinding="CRL_FILE@profileBundle@servletRequest"
									labeledNodeId="revocationFile"/>
                          </uix:contents>
                        </uix:cellFormat>
                        <uix:cellFormat hAlign="left">
                          <uix:contents>
 	                          <uix:messageLovField name="revocationFile" 
	                                  id="revocationFile"
                                      columns="50"
                                      shortDescBinding="CRL_FILE@profileBundle@servletRequest"
									  textBinding="revocationFile@SSL_ADMIN_BEAN@servletRequest"
                                      onClick = "openRFSWindow('revocationFile','LIST_FILES','');"/>
						    <%--
                            <uix:textInput columns="50" 
                                           name="revocationFile" 
                                           textBinding="revocationFile@SSL_ADMIN_BEAN@servletRequest"/> 
							--%>
                          </uix:contents>
                        </uix:cellFormat>
                      </uix:contents>
                    </uix:rowLayout>
                  </uix:contents>
                </uix:tableLayout>
                <uix:header textBinding="CREDENTIAL_CONFIG@profileBundle@servletRequest">
                  <uix:contents>
                    <uix:tableLayout cellSpacing="5">
                      <uix:contents>
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat hAlign="right">
                              <uix:contents>
                                <uix:messagePrompt promptBinding="CONFIG_METHOD@profileBundle@servletRequest"/>
                              </uix:contents>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="left">
                              <uix:contents>
                                <uix:messagePrompt promptBinding="configMethod@SSL_ADMIN_BEAN@servletRequest" 
                                                   styleClass="OraDataText"/>
                              </uix:contents>
                            </uix:cellFormat>
                          </uix:contents>
                        </uix:rowLayout>
                        <uix:switcher childNameBinding="fileSystem@SSL_ADMIN_BEAN@servletRequest">  
                        <uix:case name="true"> 
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat hAlign="right">
                              <uix:contents>
                                <uix:messagePrompt promptBinding="WALLET_DIR@profileBundle@servletRequest"/>
                              </uix:contents>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="left">
                              <uix:contents>
	                              <uix:messageLovField name="walletDir" 
	                                  id="walletDir"
                                      columns="50"
                                      shortDescBinding="WALLET_DIR@profileBundle@servletRequest"
									  tipBinding="defaultWalletLocation@SSL_ADMIN_BEAN@servletRequest"
									  textBinding="walletDir@SSL_ADMIN_BEAN@servletRequest"
                                      onClick = "openRFSWindow('walletDir','LIST_DIRS','defaultWalletLocation');"/>

							   <%--
							   <uix:textInput columns="50" 
                                               name="walletDir" 
	                                           textBinding="walletDir@SSL_ADMIN_BEAN@servletRequest"/> 
							   --%>
								</uix:contents>
                            </uix:cellFormat>
                          </uix:contents>
                        </uix:rowLayout>
                        </uix:case>
                        </uix:switcher>

                        <uix:switcher childNameBinding="msRegistry@SSL_ADMIN_BEAN@servletRequest">  
                        <uix:case name="true"> 
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat hAlign="right">
                              <uix:contents>
                                <uix:messagePrompt promptBinding="REGISTERY_KEY@profileBundle@servletRequest" 
                                      labeledNodeId ="registryKey" required="yes"/>
                              </uix:contents>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="left">
                              <uix:contents>
                                <uix:textInput columns="50" 
                                               name="registryKey" id="registryKey"
                                               textBinding="registryKey@SSL_ADMIN_BEAN@servletRequest"
											   shortDescBinding="REGISTERY_KEY@profileBundle@servletRequest"/>
                              </uix:contents>
                            </uix:cellFormat>
                          </uix:contents>
                        </uix:rowLayout>
                        </uix:case>
                        </uix:switcher>
                        <uix:switcher childNameBinding="entrust@SSL_ADMIN_BEAN@servletRequest">  
                        <uix:case name="true"> 
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat hAlign="right">
                              <uix:contents>
                                <uix:messagePrompt promptBinding="PROFILE_LOCATION@profileBundle@servletRequest" 
                                      labeledNodeId ="profileLocation"/>
                              </uix:contents>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="left">
                              <uix:contents>
 	                             <uix:messageLovField name="profileLocation"
									  id="profileLocation"
                                      columns="50"
                                      shortDescBinding="PROFILE_LOCATION@profileBundle@servletRequest"
									  tipBinding="defaultProfileLocation@SSL_ADMIN_BEAN@servletRequest"
									  textBinding="profileLocation@SSL_ADMIN_BEAN@servletRequest"
                                      onClick = "openRFSWindow('profileLocation','LIST_FILES','defaultProfileLocation');"/>
								<%--
                                <uix:textInput columns="50"
                                               name="profileLocation" 
                                               textBinding="profileLocation@SSL_ADMIN_BEAN@servletRequest"/>
								--%>
                              </uix:contents>
                            </uix:cellFormat>
                          </uix:contents>
                        </uix:rowLayout>
                        </uix:case>
                        </uix:switcher>
                        <uix:switcher childNameBinding="entrust@SSL_ADMIN_BEAN@servletRequest">  
                        <uix:case name="true"> 
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat hAlign="right">
                              <uix:contents>
                                <uix:messagePrompt promptBinding="INIFILE_LOCATION@profileBundle@servletRequest" 
                                     labeledNodeId ="inifileLocation"/>
                              </uix:contents>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="left">
                              <uix:contents>
  							    <uix:messageLovField name="inifileLocation" 
									  id="inifileLocation"
                                      columns="50"
                                      shortDescBinding="INIFILE_LOCATION@profileBundle@servletRequest"
									  tipBinding="defaultInifileLocation@SSL_ADMIN_BEAN@servletRequest"
									  textBinding="inifileLocation@SSL_ADMIN_BEAN@servletRequest"
                                      onClick = "openRFSWindow('inifileLocation','LIST_FILES','defaultInifileLocation');"/>
								<%--
                                <uix:textInput columns="50" 
                                               name="inifileLocation"
                                               textBinding="inifileLocation@SSL_ADMIN_BEAN@servletRequest"/>
								--%>
                              </uix:contents>
                            </uix:cellFormat>
                          </uix:contents>
                        </uix:rowLayout>
                        </uix:case>
                        </uix:switcher>
                      </uix:contents>
                    </uix:tableLayout>
                  </uix:contents>
                </uix:header>
                <uix:switcher childNameBinding="msCertificate@SSL_ADMIN_BEAN@servletRequest">  
                <uix:case name="false">
                <uix:header textBinding="CIPHER_SUITE_CONFIG@profileBundle@servletRequest">
                  <uix:contents>
                    <uix:styledText textBinding="CHIPER_INST_TEXT@profileBundle@servletRequest"
                               styleClass="OraInstructionText">
                    </uix:styledText>
                    <uix:spacer width="5" height="5"/>
                    <uix:tableLayout cellSpacing="5">
                      <uix:contents>
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat hAlign="right">
                              <uix:contents>
                                 <%-- 
                                
                                <uix:shuttle name="shuttle1" leadingHeader="Available Methods"
                                         trailingHeader="Selected Methods">
                                  
                                  <uix:filter>
                                    <uix:rowLayout>
                                      <uix:contents>
                                
                                        <uix:styledText text="Filter"/>
                                        <uix:spacer width="5" height="1"/>
                                        <uix:choice name="binkyLovesWinky">
                                          <uix:contents>
                                            <uix:option text="Avaliable in US only" value="no"/>
                                            <uix:option text="Available globally" value="yes"/>
                                          </uix:contents>
                                        </uix:choice>
                                        <uix:spacer width="5" height="1"/>
                                        <uix:button text="Go" destination="#"/>
                                      </uix:contents>
                                    </uix:rowLayout>
                                  </uix:filter> 
                                  <uix:leading>
                                    <uix:list name="c1" multiple="true">
                                      <uix:contents>
                                        <uix:option text="RSA_WITH_3DES_EDE_CBC_SHA"/>
                                        <uix:option text="RSA_WITH_RC4_128_SHA"/>
                                        <uix:option text="RSA_WITH_RC4_128_MD5"/>
                                        <uix:option text="RSA_WITH_DES_CBC_SHA"/>
                                        <uix:option text="DH_anon_WITH_3DES_EDE_CBC_SHA"/>
                                        <uix:option text="DH_anon_WITH_RC4_128_MD5"/>
                                        <uix:option text="DH_anon_WITH_DES_CBC_SHA"/>
                                        <uix:option text="RSA_EXPORT_WITH_RC4_40_MD5"/>
                                        <uix:option text="RSA_EXPORT_WITH_DES40_CBC_SHA"/>
                                        <uix:option text="RSA_WITH_AES_128_CBC_SHA"/>
                                        <uix:option text="RSA_WITH_AES_256_CBC_SHA"/>
                                      </uix:contents>
                                    </uix:list>
                                  </uix:leading>
                                  <uix:trailing>
                                    <uix:list name="c2" multiple="true">
                                      <uix:contents>
                                      </uix:contents>
                                    </uix:list>
                                  </uix:trailing>
                                </uix:shuttle>
                                  --%>
                                 <oem:shuttle name="chiperSuites"
                                              leadingHeaderBinding="AVAILABLE_SUITES@profileBundle@servletRequest"
                                              trailingHeaderBinding="SELECTED_SUITES@profileBundle@servletRequest"
                                              size="5" reorderable="true">
                                    <uix:leading>
                                      <oem:list name="availableChiperSuites"
                                                shortDescBinding="AVAILABLE_SUITES@profileBundle@servletRequest"
                                                optionsBinding="availableChiperSuites@SSL_ADMIN_BEAN@servletRequest"/>
                                    </uix:leading>
                                    <uix:trailing>
                                      <oem:list name="selectedChiperSuites"
                                                shortDescBinding="SELECTED_SUITES@profileBundle@servletRequest"
                                                optionsBinding="chiperSuites@SSL_ADMIN_BEAN@servletRequest"/>
                                    </uix:trailing>
                                </oem:shuttle>
                                
                              </uix:contents>
                            </uix:cellFormat>
                          </uix:contents>
                        </uix:rowLayout>
                      </uix:contents>
                    </uix:tableLayout>
                  </uix:contents>
                </uix:header>
                </uix:case>
                </uix:switcher>
              </uix:contents>
              <uix:pageButtons>
                <uix:pageButtonBar>
                  <uix:contents>
                    <uix:submitButton textBinding="CANCEL@defaultMsgBundle@servletRequest" 
                                      name="event" value="cancel" shortDescBinding="CANCEL@netBundle@servletRequest"/>
                    <uix:submitButton textBinding="BACK@profileBundle@servletRequest" 
                                      name="event" value="back" shortDescBinding="BACK@profileBundle@servletRequest"/>
                    <uix:submitButton textBinding="FINISH@profileBundle@servletRequest" 
                                      name="event" value="apply" shortDescBinding="FINISH@profileBundle@servletRequest"/>                     
                  </uix:contents>
                </uix:pageButtonBar>
              </uix:pageButtons>
            </uix:pageLayout>
          </uix:contents>
        </uix:form>
      </uix:contents>
    </uix:body>
  </uix:document>
</uix:renderingContext>
