<%@ page contentType="text/html; charset=UTF-8" %>

<%--
  -- Page        :  tracing.jsp
  -- Controller  :  oracle/sysman/db/net/profile/LogTraceController.java
  -- Description :  Tracing configuration page for Net Admin Profile
  --                
  -- 
  -- MODIFIED   (MM/DD/YY)
  --  vivsharm    05/27/05 - 
  --  jpegu       05/23/05 - Add remote browse widget
  --  vivsharm    05/04/05 - for ADA 
  --  jpegu       01/03/05 - Net Admin UI Fix 
  --  vivsharm    12/22/04 - bug 4074028 
  --  xadaicka    12/09/04 - added the page title 
  --  xadaicka    09/15/04 - 
  --  xadaicka    08/31/04 - changed the ui
  --  xadaicka    04/20/04 - creation
 --%>

<%--  Includes  --%>

<%@ include file="/oemNoscript.jspf" %>

<%-- Tag Libraries --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>

<%@ page import="oracle.sysman.db.rsc.net.profile.ProfileMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.db.rsc.net.NetMsg" %>

<db:script src="/net/netUtil.js"/>

<%-- Message Bundles --%>

<%
  request.setAttribute("profileBundle", new BundleDataObject(NLSUtil.getBundle(ProfileMsg.class.getName(), request)));
  request.setAttribute("netBundle", new BundleDataObject(NLSUtil.getBundle(NetMsg.class.getName(), request)));
%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
      <uix:metaContainer>
        <uix:head titleBinding="TITLE@servletRequest"/>
      </uix:metaContainer>
      <uix:body>
        <uix:form name="tracerForm" method="post"
                  destinationBinding="defaultControllerURL@defaultBean@servletRequest">
          <uix:formValue name="pageName" value="/net/profile/tracing"/>
	  	  <uix:formValue name="lovName"/>
		  <uix:formValue name="listingType"/>
		  <uix:formValue  name="curDir"/>
		  <uix:formValue  name="defaultMethod"/>

          <uix:pageLayout titleBinding="TRACING@profileBundle@servletRequest">
            <%@ include file="/oemGlobal.jspf" %>
	          <oem:messageBox messageType="error"
                              errorTableBinding="errors@servletRequest"
                              titleTextKey="titleText" mainTextKey="mainText"/>

			  <%-- Tracing Instruction text ---%>
			  <uix:pageStatus>
				  <uix:styledText styleClass="OraInstructionText" textBinding="TRACING_OVERVIEW@profileBundle@servletRequest"/>
			  </uix:pageStatus>

              <uix:switcher childNameBinding="serverConfig@TRACER_ADMIN_BEAN@servletRequest">  
              <uix:case name="true">                                             
              <uix:header textBinding="SERVER_CONFIG@profileBundle@servletRequest">
                <uix:stackLayout>
                    <uix:tableLayout cellSpacing="5">
                        <uix:rowLayout>
						  <uix:cellFormat hAlign="right">
				              <uix:styledText styleClass="OraInstructionText"										textBinding="SELECT_TRC_LEVEL@profileBundle@servletRequest"  />
						  </uix:cellFormat>
						  <uix:cellFormat hAlign="left">
		                      <uix:messageRadioButton textBinding="TRC_DISABLED@profileBundle@servletRequest" 
                                             name="serverTraceLevel"
                                             selectedValueBinding="serverTraceLevel@TRACER_ADMIN_BEAN@servletRequest"
											 shortDescBinding="SELECT_TRC_LEVEL@profileBundle@servletRequest"
                                             value="OFF"/>
					      </uix:cellFormat>
						</uix:rowLayout>

                        <uix:rowLayout>
							<uix:cellFormat hAlign="right"/>
							<uix:cellFormat hAlign="left">
								<uix:messageRadioButton textBinding="TRC_LEVEL_USER@profileBundle@servletRequest" 
                                     name="serverTraceLevel"
                                     selectedValueBinding="serverTraceLevel@TRACER_ADMIN_BEAN@servletRequest"
									 shortDescBinding="SELECT_TRC_LEVEL@profileBundle@servletRequest"
									 tipBinding="TRC_LEVEL_USER_MSG@profileBundle@servletRequest"
                                     value="USER"/>
							</uix:cellFormat>
                        </uix:rowLayout>

                        <uix:rowLayout>
							<uix:cellFormat hAlign="right"/>
							<uix:cellFormat hAlign="left">
			                    <uix:messageRadioButton textBinding="TRC_LEVEL_ADMIN@profileBundle@servletRequest" 
                                name="serverTraceLevel"
								tipBinding="TRC_LEVEL_ADMIN_MSG@profileBundle@servletRequest"
                                selectedValueBinding="serverTraceLevel@TRACER_ADMIN_BEAN@servletRequest"
  							    shortDescBinding="SELECT_TRC_LEVEL@profileBundle@servletRequest"
                                value="ADMIN"/>
						    </uix:cellFormat>
                        </uix:rowLayout>

	                    <uix:rowLayout>
							<uix:cellFormat hAlign="right"/>
							<uix:cellFormat hAlign="left">
							<uix:stackLayout>
								<uix:messageRadioButton textBinding="TRC_LEVEL_SUPPORT@profileBundle@servletRequest" 
                                     name="serverTraceLevel"
                                     selectedValueBinding="serverTraceLevel@TRACER_ADMIN_BEAN@servletRequest"
									 shortDescBinding="SELECT_TRC_LEVEL@profileBundle@servletRequest"
									 tipBinding="TRC_LEVEL_SUPPORT_MSG@profileBundle@servletRequest"
                                     value="SUPPORT"/>
							 </uix:stackLayout>
							</uix:cellFormat>
                        </uix:rowLayout>

                        <uix:rowLayout>
							<uix:cellFormat hAlign="right">
								<uix:messagePrompt promptBinding="TRACE_DIRECTORY@profileBundle@servletRequest"
						  		labeledNodeId="serverDirName"/>
							</uix:cellFormat>
							<uix:cellFormat hAlign="left">
								<uix:stackLayout>
									<uix:messageLovField name="serverDirName" 
                                      id="serverDirName"
                                      columns="50"
                                      shortDescBinding="TRACE_DIRECTORY@profileBundle@servletRequest"
									  tipBinding="defaultServerDirName@TRACER_ADMIN_BEAN@servletRequest"
									  textBinding="serverDirName@TRACER_ADMIN_BEAN@servletRequest"
									  onClick = "openRFSWindow('serverDirName','LIST_DIRS','defaultServerDirName');"/> 
		                        	<uix:messageText messageType="error" messageBinding="serverDirName@errors@servletRequest"/>
								</uix:stackLayout>
							</uix:cellFormat>
                        </uix:rowLayout>

	                    <uix:rowLayout>
							<uix:cellFormat hAlign="right">
								<uix:messagePrompt promptBinding="TRACE_FILE@profileBundle@servletRequest"
						   		labeledNodeId="serverFileName"/>
							</uix:cellFormat>
							<uix:cellFormat hAlign="left">
								<uix:stackLayout>
									<uix:messageTextInput name="serverFileName" id="serverFileName"
                                       textBinding="serverFileName@TRACER_ADMIN_BEAN@servletRequest"
									   tipBinding="defaultServerFileName@TRACER_ADMIN_BEAN@servletRequest"
									   shortDescBinding="TRACE_FILE@profileBundle@servletRequest"
                                       columns="25"/>
									<uix:messageText messageType="error" messageBinding="serverFileName@errors@servletRequest"/>
							   </uix:stackLayout>
							</uix:cellFormat>
                        </uix:rowLayout>
                    </uix:tableLayout>
                 </uix:stackLayout>
              </uix:header>
              </uix:case>
              </uix:switcher> 

			  <uix:switcher childNameBinding="clientConfig@TRACER_ADMIN_BEAN@servletRequest">  
              <uix:case name="true">                                             
              <uix:header textBinding="CLIENT_CONFIG@profileBundle@servletRequest">

                <uix:stackLayout>
                    <uix:tableLayout cellSpacing="5">
                        <uix:rowLayout>
						  <uix:cellFormat hAlign="right">
				              <uix:styledText styleClass="OraInstructionText"										textBinding="SELECT_TRC_LEVEL@profileBundle@servletRequest"  />
						  </uix:cellFormat>
						  <uix:cellFormat hAlign="left">
                            <uix:radioButton textBinding="TRC_DISABLED@profileBundle@servletRequest" 
                                     name="clientTraceLevel"
                                     selectedValueBinding="clientTraceLevel@TRACER_ADMIN_BEAN@servletRequest"
									 shortDescBinding="SELECT_TRC_LEVEL@profileBundle@servletRequest"
                                     value="OFF"/>
					      </uix:cellFormat>
						</uix:rowLayout>

                        <uix:rowLayout>
							<uix:cellFormat hAlign="right"/>
							<uix:cellFormat hAlign="left">
                            <uix:radioButton textBinding="TRC_LEVEL_USER@profileBundle@servletRequest" 
                                     name="clientTraceLevel"
                                     selectedValueBinding="clientTraceLevel@TRACER_ADMIN_BEAN@servletRequest"
									 shortDescBinding="SELECT_TRC_LEVEL@profileBundle@servletRequest"
                                     value="USER"/>
							</uix:cellFormat>
                        </uix:rowLayout>

                        <uix:rowLayout>
							<uix:cellFormat hAlign="right"/>
							<uix:cellFormat hAlign="left">
								<uix:radioButton textBinding="TRC_LEVEL_ADMIN@profileBundle@servletRequest" 
                                     name="clientTraceLevel"
                                     selectedValueBinding="clientTraceLevel@TRACER_ADMIN_BEAN@servletRequest"
									 shortDescBinding="SELECT_TRC_LEVEL@profileBundle@servletRequest"
                                     value="ADMIN"/>
						    </uix:cellFormat>
                        </uix:rowLayout>

	                    <uix:rowLayout>
							<uix:cellFormat hAlign="right"/>
							<uix:cellFormat hAlign="left">
	                            <uix:radioButton textBinding="TRC_LEVEL_SUPPORT@profileBundle@servletRequest" 
                                     name="clientTraceLevel"
                                     selectedValueBinding="clientTraceLevel@TRACER_ADMIN_BEAN@servletRequest"
									 shortDescBinding="SELECT_TRC_LEVEL@profileBundle@servletRequest"
                                     value="SUPPORT"/>
							</uix:cellFormat>
                        </uix:rowLayout>

	                  <uix:rowLayout>
		                  <uix:cellFormat hAlign="right">
				            <uix:messagePrompt promptBinding="TRACE_DIRECTORY@profileBundle@servletRequest"
							labeledNodeId="clientDirName"/>
                          </uix:cellFormat>
						  <uix:cellFormat hAlign="left">
						  <uix:stackLayout>
							<uix:messageLovField name="clientDirName" 
                                      id="clientDirName"
                                      columns="50"
                                      shortDescBinding="TRACE_DIRECTORY@profileBundle@servletRequest"
									  tipBinding="defaultClientDirName@TRACER_ADMIN_BEAN@servletRequest"
									  textBinding="clientDirName@TRACER_ADMIN_BEAN@servletRequest"
                                      onClick = "openRFSWindow('clientDirName','LIST_DIRS','defaultClientDirName');"/> 
		                    <uix:messageText messageType="error" messageBinding="clientDirName@errors@servletRequest"/>
						</uix:stackLayout>
						</uix:cellFormat>
	                 </uix:rowLayout>

                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right">
                        <uix:messagePrompt promptBinding="TRACE_FILE@profileBundle@servletRequest"
								labeledNodeId="clientFileName"/>
                                          
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="left">
                        <uix:stackLayout>
                          <uix:messageTextInput name="clientFileName" id="clientFileName"
                                         textBinding="clientFileName@TRACER_ADMIN_BEAN@servletRequest"
										 tipBinding="defaultClientFileName@TRACER_ADMIN_BEAN@servletRequest"
										 shortDescBinding="TRACE_FILE@profileBundle@servletRequest"
                                         columns="25"/>
                        <uix:messageText messageType="error" messageBinding="clientFileName@errors@servletRequest"/>
						</uix:stackLayout>
                      </uix:cellFormat>
                    </uix:rowLayout>

                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right">
                        <uix:messagePrompt promptBinding="UNIQUE_TRACE_FILE_NAME@profileBundle@servletRequest"
								labeledNodeId="uniqueTrcFileName"/>
                                          
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="left">
                        <uix:stackLayout>
                          <uix:messageCheckBox name="uniqueTrcFileName" id="uniqueTrcFileName"
                                        checkedBinding="uniqueTrcFileName@TRACER_ADMIN_BEAN@servletRequest"
										shortDescBinding="UNIQUE_TRACE_FILE_NAME@profileBundle@servletRequest"
										tipBinding="TIP_UNIQUE_TRACE_FILE@profileBundle@servletRequest"/>
                        </uix:stackLayout>
                      </uix:cellFormat>
                    </uix:rowLayout>

                    </uix:tableLayout>
                 </uix:stackLayout>
              </uix:header>
              </uix:case>
              </uix:switcher> 

              <uix:pageButtons>
                <uix:pageButtonBar>
                  <uix:contents>
                    <uix:submitButton textBinding="CANCEL@defaultMsgBundle@servletRequest"
                                      name="event" value="cancel" shortDescBinding="CANCEL@netBundle@servletRequest"/>
                    <uix:submitButton textBinding="OK@defaultMsgBundle@servletRequest"
                                      name="event" value="apply" shortDescBinding="OK@netBundle@servletRequest"/>
                  </uix:contents>
                </uix:pageButtonBar>
              </uix:pageButtons>
          </uix:pageLayout>
        </uix:form>
      </uix:body>
  </uix:document>
</uix:renderingContext>
