<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- <%@ include file="/oemNoscript.jspf"%> --%>
<%@ page import="oracle.sysman.db.rsc.net.profile.ProfileMsg"%>
<%@ page import="oracle.sysman.db.rsc.net.NetMsg"%>
<%@ page import="oracle.cabo.ui.data.BundleDataObject"%>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil"%>

<% 
  request.setAttribute("profileBundle", new BundleDataObject(NLSUtil.getBundle(ProfileMsg.class.getName(), request)));
  request.setAttribute("netBundle", new BundleDataObject(NLSUtil.getBundle(NetMsg.class.getName(), request)));
%>

<db:script src="/net/netUtil.js"/>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>

<uix:document>
    <%@ include file="/oemTitle.jspf" %> 

	<uix:metaContainer>
      <uix:head titleBinding="TITLE@servletRequest"/>
    </uix:metaContainer>
    
	<uix:body>
      <uix:contents>
       <uix:form name="walletForm" method="post" destinationBinding="defaultControllerURL@defaultBean@servletRequest">
			<uix:formValue	name="pageName" value="/net/profile/wallet"/>
			<uix:formValue	name="lovName"/>
			<uix:formValue  name="listingType"/>
			<uix:formValue  name="curDir"/>
			<uix:formValue  name="defaultMethod"/>

            <uix:pageLayout titleBinding="WALLET@profileBundle@servletRequest" 
                            styleClass="OraInstructionText">

			<%@ include file="/oemGlobal.jspf" %>
            <oem:messageBox messageType = "error" 
                            msgBundleBinding="profileMsg@servletRequest" 
                            errorTableBinding="errors@servletRequest"
                            titleTextKey="titleText" mainTextKey="mainText"/>
			<uix:spacer width="20"/>

			<uix:tableLayout cellSpacing="5">
				<uix:contents>
                       <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat hAlign="right">
                              <uix:contents>
                                <uix:messagePrompt promptBinding ="CONFIG_METHOD@profileBundle@servletRequest" />
                              </uix:contents>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="left">
                              <uix:contents>
                                <uix:choice name="sslMethod"
                                            selectedValueBinding="sslMethod@SSL_ADMIN_BEAN@servletRequest"
                                            onChange='submitForm(\'walletForm\',1,{\'event\':\'ChangeMethod\'})'>
                                  <uix:contents childDataBinding="sslMethodList@SSL_ADMIN_BEAN@servletRequest">
                                    <uix:option textBinding="textKey" valueBinding="valueKey"/>
                                  </uix:contents>                      
                                </uix:choice> 
                              </uix:contents>
                            </uix:cellFormat>
                          </uix:contents>
                        </uix:rowLayout>

						<%-- Wallet Dir Location row --%>
		                <uix:switcher childNameBinding="TDEMode@SSL_ADMIN_BEAN@servletRequest">  
			            <uix:case name="false">
							<uix:switcher childNameBinding="fileSystem@SSL_ADMIN_BEAN@servletRequest">  
							<uix:case name="true"> 
							<uix:rowLayout>
								<uix:contents>
									<uix:cellFormat hAlign="right">
										<uix:messagePrompt promptBinding="WALLET_DIR@profileBundle@servletRequest" 
														   labeledNodeId="walletDir"/>
									</uix:cellFormat>
									<uix:cellFormat hAlign="left">
										 <uix:messageLovField name="walletDir" 
											  id="walletDir"
											  columns="50"
											  shortDescBinding="WALLET_DIR@profileBundle@servletRequest"
											  tipBinding="defaultWalletLocation@SSL_ADMIN_BEAN@servletRequest"
											  textBinding="walletDir@SSL_ADMIN_BEAN@servletRequest"
											  onClick = "openRFSWindow('walletDir','LIST_DIRS','defaultWalletLocation');"/>
									</uix:cellFormat>
								</uix:contents>
							</uix:rowLayout>
								</uix:case>
							</uix:switcher>
                                </uix:case>
						</uix:switcher>

		                <uix:switcher childNameBinding="fileSystem@SSL_ADMIN_BEAN@servletRequest">  
			            <uix:case name="true"> 
                                                
                                               	<uix:rowLayout>
							<uix:contents>
								<uix:cellFormat hAlign="right">
									<uix:messagePrompt promptBinding="ENCRYPT_WALLET_DIR@profileBundle@servletRequest" 
													   labeledNodeId="encryptWalletDir"/>
								</uix:cellFormat>
								<uix:cellFormat hAlign="left">
									 <uix:messageLovField name="encryptWalletDir" 
										  id="encryptWalletDir"
										  columns="50"
										  shortDescBinding="ENCRYPT_WALLET_DIR@profileBundle@servletRequest"
										  tipBinding="defaultEncryptWalletLocation@SSL_ADMIN_BEAN@servletRequest"
										  textBinding="encryptWalletDir@SSL_ADMIN_BEAN@servletRequest"
										  onClick = "openRFSWindow('encryptWalletDir','LIST_DIRS','defaultEncryptWalletLocation');"/>
								</uix:cellFormat>
							</uix:contents>
						</uix:rowLayout>
                                                
						</uix:case>
						</uix:switcher>
						<%-- HSM Dir Location row --%>
		                <uix:switcher childNameBinding="hsm@SSL_ADMIN_BEAN@servletRequest">  
			            <uix:case name="true"> 
						<uix:rowLayout>
							<uix:contents>
								<uix:cellFormat hAlign="right">
									<uix:messagePrompt promptBinding="ENCRYPT_WALLET_DIR@profileBundle@servletRequest" 
													   labeledNodeId="encryptWalletDir"/>
								</uix:cellFormat>
								<uix:cellFormat hAlign="left">
									 <uix:messageLovField name="encryptWalletDirHSM" 
										  id="encryptWalletDirHSM"
										  columns="50"
										  shortDesc="ENCRYPT_WALLET_DIR@profileBundle@servletRequest"
										  tipBinding="defaultEncryptWalletLocation@SSL_ADMIN_BEAN@servletRequest"
										  textBinding="encryptWalletDirHSM@SSL_ADMIN_BEAN@servletRequest"
										  onClick = "openRFSWindow('encryptWalletDirHSM','LIST_DIRS','defaultEncryptWalletLocation');"/>
								</uix:cellFormat>
							</uix:contents>
						</uix:rowLayout>
						</uix:case>
						</uix:switcher>
						<%-- Profile Location row --%>
		                <uix:switcher childNameBinding="entrust@SSL_ADMIN_BEAN@servletRequest">  
			            <uix:case name="true"> 
						<uix:rowLayout>
							<uix:contents>
								<uix:cellFormat hAlign="right">
									<uix:messagePrompt promptBinding="PROFILE_LOCATION@profileBundle@servletRequest" 
													   labeledNodeId="profileLocation"/>
								</uix:cellFormat>
								<uix:cellFormat hAlign="left">
									 <uix:messageLovField name="profileLocation" 
										  id="profileLocation"
										  columns="50"
										  shortDescBinding="PROFILE_LOCATION@profileBundle@servletRequest"
										  tipBinding="defaultProfileLocation@SSL_ADMIN_BEAN@servletRequest"
										  textBinding="profileLocation@SSL_ADMIN_BEAN@servletRequest"
										  onClick = "openRFSWindow('profileLocation','LIST_FILES','defaultProfileLocation');"/>
								</uix:cellFormat>
							</uix:contents>
						</uix:rowLayout>
						</uix:case>
						</uix:switcher>

						<%-- Inifile Location row --%>
		                <uix:switcher childNameBinding="entrust@SSL_ADMIN_BEAN@servletRequest">  
			            <uix:case name="true"> 
						<uix:rowLayout>
							<uix:contents>
								<uix:cellFormat hAlign="right">
									<uix:messagePrompt promptBinding="INIFILE_LOCATION@profileBundle@servletRequest" 
													   labeledNodeId="inifileLocation"/>
								</uix:cellFormat>
								<uix:cellFormat hAlign="left">
									 <uix:messageLovField name="inifileLocation" 
										  id="inifileLocation"
										  columns="50"
										  shortDescBinding="INIFILE_LOCATION@profileBundle@servletRequest"
										  tipBinding="defaultInifileLocation@SSL_ADMIN_BEAN@servletRequest"
										  textBinding="inifileLocation@SSL_ADMIN_BEAN@servletRequest"
										  onClick = "openRFSWindow('inifileLocation','LIST_FILES','defaultInifileLocation');"/>
								</uix:cellFormat>
							</uix:contents>
						</uix:rowLayout>
						</uix:case>
						</uix:switcher>

						<%-- Windows registry Key Row --%>
						<uix:switcher childNameBinding="msRegistry@SSL_ADMIN_BEAN@servletRequest">  
			            <uix:case name="true"> 
						<uix:rowLayout>
							<uix:contents>
								<uix:cellFormat hAlign="right">
								  <uix:contents>
									<uix:messagePrompt promptBinding="REGISTERY_KEY@profileBundle@servletRequest" 
											labeledNodeId="registryKey"           required="yes"/>
								  </uix:contents>
								</uix:cellFormat>
								<uix:cellFormat hAlign="left">
								  <uix:contents>
									<uix:textInput columns="50" 
												   name="registryKey" id="registryKey"
												   textBinding="registryKey@SSL_ADMIN_BEAN@servletRequest"
												   shortDescBinding="REGISTERY_KEY@profileBundle@servletRequest" />
								  </uix:contents>
								</uix:cellFormat>
							</uix:contents>
						 </uix:rowLayout>
						 </uix:case>
						 </uix:switcher>

					</uix:contents>
				</uix:tableLayout>

			<uix:pageButtons>
              <uix:pageButtonBar>
                <uix:contents>
                    <uix:submitButton textBinding="CANCEL@defaultMsgBundle@servletRequest" 
                                      name="event" value="cancel" shortDescBinding="CANCEL@netBundle@servletRequest"/>
                    <uix:submitButton textBinding="OK@defaultMsgBundle@servletRequest" 
                                      name="event" value="apply" shortDescBinding="OK@netBundle@servletRequest"/>                     
               </uix:contents>
              </uix:pageButtonBar>
             </uix:pageButtons>

            </uix:pageLayout>
        </uix:form>
      </uix:contents>
    </uix:body>
  </uix:document>
</uix:renderingContext>