<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.db.rsc.net.NetMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<%
  request.setAttribute("netBundle", new BundleDataObject(NLSUtil.getBundle(NetMsg.class.getName(), request)));
%>



<uix:buildTree scope="request" nodeID="AlertsTable">
  <uix:header textBinding="sectionHeaderText@"
              renderedBinding="showAlertsSection@">

  <uix:stackLayout>
    <uix:tableLayout>
      <uix:rowLayout vAlign="center">

        <uix:rowLayout
              renderedBinding="showErrorCount@">
          <uix:styledText 
                  styleClass="OraPromptText"
                  textBinding="METRIC_COLLECTION_ERRORS@sdkMsg"/>
          <uix:spacer width="5"/>
          <uix:image shortDescBinding="METRIC_COLLECTION_ERRORS@sdkMsg" 
                  sourceBinding="metricErrorImage@" />
          <uix:spacer width="5"/>
          <uix:link 
                  textBinding="errorCount@"
                  destinationBinding="errorDest@" />
        </uix:rowLayout>
        <uix:spacer width="10" />

      </uix:rowLayout>
    </uix:tableLayout>
    <oem:table name="alertsTable" 
				summaryBinding="ALERTS_LIST@netBundle@servletRequest"
				shortDescBinding="ALERTS_LIST@netBundle@servletRequest"
	        	renderedBinding="showAlertsTable@"
				partialRenderMode="self"
				beanKey="viewModel"
				dataSourceProp="lsnrAlertsUIDataSource"
				blockSize="5"
				formSubmitted="true"
	        	alternateTextBinding="ALERTS_ALT@sdkMsg"
	        	width="100%" >

        <uix:tableFormat tableBanding="rowBanding"/>

        

    </oem:table>

  </uix:stackLayout>
  </uix:header>



</uix:buildTree>





