<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 

<uix:renderingContext id="renderingContext">  
  <oem:setURLEncoder id="renderingContext"/> 
  
  <uix:document> 
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <db:form name="instForm" method="post" destinationBinding="formDest@servletRequest"
               copyParams="target,type">
        <uix:formValue name="event"/>
        <uix:formValue name="advisorURL" valueBinding="advisorURL@servletRequest"/>
        
        <uix:pageLayout>
          <%@ include file="/oemGlobal.jspf" %>

          <uix:header textBinding = "ACTIVE_INSTANCES@racMsgBundle@servletRequest">

          <uix:stackLayout>

            <uix:tableLayout width="100%">
              <uix:cellFormat hAlign="right">
            <uix:pageButtonBar>
                <uix:button textBinding="CANCEL@DBMsgBundle@servletRequest"
                            shortDescBinding="CANCEL@DBMsgBundle@servletRequest"
                            destinationBinding="advisoryCentralURL@servletRequest" />
              <uix:submitButton textBinding="CONTINUE@DBMsgBundle@servletRequest"
                                shortDescBinding="CONTINUE@DBMsgBundle@servletRequest"
                                name="event"
                                value="launchAdvisor"/>
              </uix:pageButtonBar>
              </uix:cellFormat>
            </uix:tableLayout>

          <uix:styledText styleClass="OraPromptText" textBinding="ADVISOR_INTRO_TEXT@@racMsgBundle@servletRequest"/>
          <uix:spacer height="10"/>
            <oem:table name="racInstsDS" 
                       summaryBinding="ACTIVE_INSTANCES@racMsgBundle@servletRequest"
                       width="80%" beanKey="defaultBean" blockSize="25"
                       dataSourceProp="racInstsDS"
                       formSubmitted="true"
                       alternateTextBinding="NO_DATA_ALT@racMsgBundle@servletRequest">
              <uix:tableSelection>
                <uix:singleSelection selectedIndexBinding="selectedIndex@defaultBean@servletRequest">
                </uix:singleSelection>
              </uix:tableSelection>
            </oem:table>
          </uix:stackLayout>
          </uix:header>

          <uix:contentFooter>
            <uix:pageButtonBar>
                <uix:button textBinding="CANCEL@DBMsgBundle@servletRequest"
                            shortDescBinding="CANCEL@DBMsgBundle@servletRequest"
                            destinationBinding="advisoryCentralURL@servletRequest" />
              <uix:submitButton textBinding="CONTINUE@DBMsgBundle@servletRequest"
                                shortDescBinding="CONTINUE@DBMsgBundle@servletRequest"
                                name="event"
                                value="launchAdvisor"/>
              </uix:pageButtonBar>
          </uix:contentFooter>

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
