<%-- 
 * Copyright (c) 2007, 2008, Oracle. All rights reserved.  
 *
 * NAME
 *    selectInstance.jsp 
 *
 * NOTES
 *    Launched from AWR Baselines when the current target is a
 *    RAC database to let the user select an instance.
 *       
 * MODIFIED
 *    kmckeen    12/13/07 - Initial creation
--%>

<%@ page contentType="text/html; charset=UTF-8" %>
<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 
<%@ page import="oracle.sysman.db.rac.RacConstants" %>

<uix:renderingContext id="renderingContext">  
  <oem:setURLEncoder id="renderingContext"/> 

  <uix:document> 
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>

      <db:form 
          name="selectInstance" 
          method="post" 
          destinationBinding="dest@servletRequest"
          copyParams="target,type">

        <uix:pageLayout titleBinding="title@servletRequest">
          <%@ include file="/database/global.jspf" %>

          <uix:styledText 
              styleClass="OraPromptText" 
              textBinding="tip@servletRequest"/>
          <uix:spacer height="5"/>
          <oem:table 
              name="racInstsDS" 
              dataSourceProp="racInstsDS"
              beanKey="defaultBean" 
              width="100%" 
              formSubmitted="true"
              blockSize="<%= RacConstants.BLOCKSIZE_UNLIMITED %>"
              summaryBinding="ACTIVE_INSTANCES@racMsgBundle@servletRequest"
              alternateTextBinding="NO_DATA_ALT@racMsgBundle@servletRequest">
            <uix:tableSelection>
              <uix:singleSelection 
                  selectedIndexBinding="selectedIndex@defaultBean@servletRequest">
              </uix:singleSelection>
            </uix:tableSelection>
          </oem:table>

          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:button
                  textBinding="CANCEL@DBMsgBundle@servletRequest"
                  destinationBinding="cancelURL@servletRequest"/>
              <uix:submitButton
                  textBinding="CONTINUE@DBMsgBundle@servletRequest"
                  name="event"
                  valueBinding="continueEvent@servletRequest"/>
            </uix:pageButtonBar>
          </uix:pageButtons>

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
