<%-- 
 * Copyright (c) 2006, 2009, Oracle and/or its affiliates.All rights reserved. 
 *
 *      NAME
 *        cccDrillDown.jsp 
 *
 *      NOTES
 *        tbd
 *       
 * MODIFIED
 *    pboopath   05/05/08 - swf path change from databae/flex to rac/flex
 *    gapadman   04/03/08 - historical enable 
 *    pboopath   01/30/08 - Flex summary chart change to avoid full page
 *                          refresh
 *    pboopath   01/22/08 - XbranchMerge pboopath_bug-6759170 from main
 *    pboopath   01/21/08 - XbranchMerge pboopath_flex_rac_txn2 from main
 *    pboopath   01/17/08 - flex tile chart changes
 *    pboopath   11/14/07 - Flex chart changes
 *    kmckeen    11/13/07 - Bug 6499189 - fix breadcrumbs
 *    rsamaved   05/16/07 - bug 6051327
 *    rsamaved   03/21/07 - 
 *    pboopath   03/26/07 - Cleanup
 *    pboopath   03/23/07 - oem:chart for min/max/avg
 *    kmckeen    02/23/07 - Implement Customize button
 *    rsamaved   02/13/07 - 
 *    kmckeen    12/21/06 - UI review - switch tile/top radio buttons
--%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 
<%@ page import="oracle.sysman.db.rac.RacConstants" %>

<uix:renderingContext id="renderingContext">  
  <oem:setURLEncoder id="renderingContext"/> 

    
      <uix:switcher childNameBinding="manualSelected@servletRequest">
        <uix:case name="false">
          <uix:rawText>
            <meta http-equiv="Refresh" 
                content="<%=request.getAttribute("refreshChoiceGIF")%>; URL=<%=request.getAttribute("refreshDest") %>" >
          </uix:rawText>
        </uix:case>
      </uix:switcher>


  <uix:document> 
  
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>  
    <%@ include file="/oemGlobal.jspf"%>

    <uix:body>
    
 

             <db:form name="waitForm" method="post" destination="/console/rac/racClusterDrillDown"
               copyParams="target,type,drillDown,wait,instNum,waitEvent">
               
             <uix:formValue name="waitClass" valueBinding="waitClass@waitDetailsBean@servletRequest"/>
               
          <uix:pageLayout titleBinding = "waitTitle@servletRequest" >
            <%@ include file="/database/global.jspf" %> 
            
        <uix:messages>
          <uix:switcher childNameBinding="showWarning@servletRequest">
            <uix:case name="true">
            
              <oem:messageBox messageTypeBinding="messageType@servletRequest" 
                              errorTableBinding="msgBox@servletRequest"
                              destTableBinding="msgUrls@servletRequest"
                              titleTextKey="titleText" mainTextKey="mainText"/>
                                      
            </uix:case>
          </uix:switcher>    
        </uix:messages>          

               
          <uix:stackLayout>
          
          
          
          
              <uix:tableLayout width="100%" >
                <uix:rowLayout hAlign="right">
                  
                <uix:cellFormat
                    hAlign="left" vAlign="top" wrappingDisabled="true"
                    renderedBinding="renderDetailsMetricsDropdown@servletRequest">
                  <uix:flowLayout>
                    <uix:styledText
                        styleClass="OraFieldText"
                        textBinding="detailsMetricsLabel@servletRequest"/>
                    <uix:choice
                        id="detailsMetric"
                        name="detailsMetric"
                        selectedValueBinding="detailsMetric@servletRequest"
                        shortDescBinding="detailsMetricsLabel@servletRequest"
                        onChange="submitForm(document.forms[0], true, {'event':'switchDetailsMetric'})">
                      <uix:contents
                          childDataBinding="waitEvents@waitDetailsBean@servletRequest">
                        <uix:option 
                            textBinding="text"
                            valueBinding="value"/>
                      </uix:contents>
                    </uix:choice>
                  </uix:flowLayout>
                </uix:cellFormat>
		
                  <uix:cellFormat>
                    <uix:flowLayout>
                      <uix:styledText styleClass="OraFieldText" 
                                      textBinding="VIEW_DATA@DBMsgBundle@servletRequest"
                                      labeledNodeId="refreshChoice"/>
                      <uix:choice name="refreshChoice" id="refreshChoice"
                                  shortDescBinding="VIEW_DATA@DBMsgBundle@servletRequest"
                                  onChange="submitForm('waitForm', true, {'event':'updateRefreshChoice'})"
                                  selectedValueBinding="refreshChoiceSelected@servletRequest"> 
                        <uix:option textBinding="REAL_TIME_AUTO_15_SEC@DBMsgBundle@servletRequest"
                                    value="RT_15"/>

                        <uix:option textBinding="REAL_TIME_MANUAL@DBMsgBundle@servletRequest"
                                    value="RT_MAN"/>
                        <uix:option textBinding="HISTORICAL@DBMsgBundle@servletRequest"
                                    value="HIST_CUST"/> 

                      </uix:choice>
                    </uix:flowLayout>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:tableLayout>
              
             <uix:tableLayout width="100%">
		<uix:rowLayout>
		   <uix:spacer height="5"/>
		</uix:rowLayout>
	    </uix:tableLayout>	
              
	    <uix:tableLayout width="100%">
		<uix:rowLayout>
		  <uix:cellFormat hAlign="left" vAlign="top" wrappingDisabled="true">
		   <uix:flowLayout>
		     <uix:radioSet>
			<uix:radioButton
			     name="chartType"
			     value="topChart"
			     selectedValueBinding="chartType@servletRequest"
			     textBinding="TOP_CHART_VIEW@racMsgBundle@servletRequest"
			     onClick="submitForm(document.forms[0],true,{'event':'switchChartType','chartType':'topChart'})"/>
		       <uix:radioButton
			     name="chartType"
			     value="tileChart"
			     selectedValueBinding="chartType@servletRequest"
			     textBinding="TILE_CHART_VIEW@racMsgBundle@servletRequest"
			     onClick="submitForm(document.forms[0],true,{'event':'switchChartType','chartType':'tileChart'})"/>
		  </uix:radioSet> 
        	 </uix:flowLayout>
          </uix:cellFormat>
          <uix:cellFormat hAlign="right" vAlign="top" wrappingDisabled="true">
            <uix:flowLayout>
              <uix:submitButton 
                  textBinding="CUSTOMIZE_BUTTON@racMsgBundle@servletRequest"
                  name="event" 
                  value="customizeDetails"/>
            </uix:flowLayout>
          </uix:cellFormat>
		</uix:rowLayout>
		</uix:tableLayout>
          

	<uix:switcher childNameBinding="chartType@servletRequest">
	 <uix:case name="tileChart">
            <uix:switcher childNameBinding="useSVG@servletRequest">
                <uix:case name="false">
                    <%@ include file="tileChart.jspf" %>
                 </uix:case>
                  <uix:case name="true">
                      <uix:stackLayout>
                          <db:flexRegion
                            swfName="/rac/flex/clusterWaitDetailsTileChart.swf"
                            dataSrcKeyBinding="flexKey@servletRequest"
                            windowHeightBinding="flexWindowHeightForTileChart@flexTileRacClusterDrillBean@servletRequest"                            
                            windowWidth="100%"
                           optionsBinding="flexRacClusterDrillBean@servletRequest"
                          idBase="flexRacClusterWaitDetailsChart"/>
                       </uix:stackLayout>
                    </uix:case>
              </uix:switcher>




	</uix:case>
	<uix:case name="topChart">  

 <uix:switcher childNameBinding ="useSVG@servletRequest">
              <uix:case name="true">
               <db:flexRegion
                    swfName="/rac/flex/clusterWaitDetails.swf"
                    dataSrcKeyBinding="flexKey@servletRequest"
                    windowHeight="270"
                    windowWidth="100%"
                    optionsBinding="flexRacClusterDrillBean@servletRequest"
                    idBase="flexRacClusterWaitDetailsChart"/>
            </uix:case>
            <uix:case name="false">
           
             <uix:stackLayout>     
          <uix:header textBinding="topChartHdr@servletRequest">
            <uix:stackLayout>
            
              <uix:styledText
                  styleClass="OraInstructionText"
                  textBinding="topChartTip@servletRequest"/> 
		  
                <oem:chart 
                     chartType="timeSeriesChart" 
                     width="825" height="175" 
                     timeGranularity="SECOND" 
                     orientation="vertical" 
                     fill="cumulative" 
                     yAxisLabelBinding="ACTIVE_SESSIONS@DBMsgBundle@servletRequest" 
                     legendPosition="east" 
                     legendVisible="external" 
                     titleBinding="ACTIVE_SESSIONS@DBMsgBundle@servletRequest" 
                     titleVisible="false" 
                     seriesColorsAutomatic="true" 
                     format="svg" 
                     svgUpdateFrequencyBinding="svgUpdateRate@servletRequest" 
                     xAxisMinBinding="beginDate@waitAreaChart@waitDetailsBean@servletRequest" 
                     xAxisMaxBinding="endDate@waitAreaChart@waitDetailsBean@servletRequest" 
                     yAxisWidth="30" 
                     yAxisNumberFormatBinding="waitChartYAxisFormat@servletRequest"
                    axisMin="0" 
                    axisMaxBinding="actualMaxValue@waitAreaChart@waitDetailsBean@servletRequest" 
                    svgHighlightLegend="true" 
                    colorPaletteBinding="waitColorsTable@waitAreaChart@waitDetailsBean@servletRequest">
                  <uix:contents>
                    <oem:boundChartDataSource 
                         dataClass="oracle.sysman.db.rac.RacClusterDrillDownController" 
                         dataMethod="updateChartData"/>
                    <oem:imageMap 
                         imageMapDataSourceBinding="legendLinks@waitAreaChart@waitDetailsBean@servletRequest"/>
                    <oem:chartColumn 
                         isKey="true" 
                         displayLabel="" 
                         sourceIndex="0"/>
                    <oem:chartColumn 
                         isTimeColumn="true" 
                         displayLabel="Time" 
                         sourceIndex="1"/>
                    <oem:chartColumn 
                         displayLabel="" 
                         sourceIndex="2"/>
                  </uix:contents>
                </oem:chart>
		
         
         </uix:stackLayout>
          </uix:header>                
          
        <uix:header textBinding="minMaxAvgHdr@servletRequest">          
            <uix:stackLayout>
             <uix:styledText
                  styleClass="OraInstructionText"
                  textBinding="minMaxAvgTip@servletRequest"/>            
          <oem:chart
                  titleVisible="false"
                  chartType="timeSeriesChart"
                  width="825"
                  height="175"
                  timeGranularity="SECOND"
                  orientation="vertical"
                  fill="none"
                  yAxisLabelBinding="ACTIVE_SESSIONS@DBMsgBundle@servletRequest"
                  legendPosition="east"
                  legendVisible="external"
                  seriesColorsAutomatic="true" format="svg" svgUpdateFrequencyBinding="svgUpdateRate@servletRequest"
		  xAxisMinBinding="beginDate@waitAreaChart@waitDetailsBean@servletRequest" xAxisMaxBinding="endDate@waitAreaChart@waitDetailsBean@servletRequest" yAxisWidth="30" yAxisNumberFormatBinding="waitChartYAxisFormat@servletRequest" axisMin="0" axisMaxBinding="actualMaxValue@waitAreaChart@waitDetailsBean@servletRequest" svgHighlightLegend="true" colorPaletteBinding="waitColorsTable@waitAreaChart@waitDetailsBean@servletRequest"
                  >
                <oem:boundChartDataSource dataClass="oracle.sysman.db.rac.RacClusterDrillDownController" dataMethod="updateMinMaxAvgChart"/>
                
                <oem:chartColumn isKey="true" displayLabel="" sourceIndex="0"/>
                <oem:chartColumn isTimeColumn="true" displayLabel="Time" sourceIndex="1"/>
                <oem:chartColumn displayLabel="" sourceIndex="2"/>
              </oem:chart>
                </uix:stackLayout>
          
         </uix:header> 
          
          </uix:stackLayout>    		
</uix:case>
</uix:switcher>
	   </uix:case>
	  </uix:switcher>
          
      <uix:header textBinding="INSTANCES_DATA_HDR@racMsgBundle@servletRequest">
        <oem:table
          name="racTopNInstsDS"
          width="100%"
          beanKey="waitDetailsBean"
          dataSourceProp="racTopNInstsDS"
          partialRenderMode="self"
          id="racTopNInstsTable"
          formSubmitted="true"
          blockSize="<%= RacConstants.BLOCKSIZE_UNLIMITED %>"
          summaryBinding="INSTANCES_DATA_HDR@racMsgBundle@servletRequest"
          alternateTextBinding="NO_DATA_ALT@racMsgBundle@servletRequest"/>
      </uix:header>

          </uix:stackLayout>
        </uix:pageLayout>
               </db:form>
 
    </uix:body>
  </uix:document>
</uix:renderingContext>




