<%@ include file="/sdk/oemTop.jspf" %>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
<uix:bundle name="racMsgBundle" class="oracle.sysman.db.rsc.rac.RacCommonMsg"/>
      
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>      
    <uix:body>  
     <db:form name="foo" method="POST" destination="racClusterConfig"
            copyParams="target,type,ctxType">

     <uix:switcher childNameBinding="showPage@servletRequest">
      <uix:case name="false">
      <uix:pageLayout>
         <%@ include file="/database/global.jspf" %>
          <oem:messageBox messageType="error" 
                      errorTableBinding="errors@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
      </uix:pageLayout>
      </uix:case>

     <uix:default>
     <uix:pageLayout>
      <%@ include file="/oemGlobal.jspf" %>     

      <oem:messageBox messageType="info" 
                      errorTableBinding="info@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
      <oem:messageBox messageType="error" 
                      errorTableBinding="errors@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>

      <uix:header textBinding="PageTitle@servletRequest">        
      <uix:stackLayout>
      
      <uix:tableLayout>
      
       <uix:rowLayout renderedBinding="inAddMode@CLSCFGBEAN@servletRequest">
           <uix:cellFormat>
                <uix:messagePrompt promptBinding="targetNameLabel@servletRequest" required="yes"/>
           </uix:cellFormat>     
           <uix:cellFormat/>
           <uix:cellFormat hAlign="left">
                <uix:textInput name="clusterName" 
                     textBinding="clusterName@CLSCFGBEAN@servletRequest"
                     shortDescBinding="targetNameLabel@servletRequest"/>
           </uix:cellFormat>     
       </uix:rowLayout> 

       <uix:rowLayout renderedBinding="inUpdateMode@CLSCFGBEAN@servletRequest">
           <uix:cellFormat>
                <uix:messagePrompt promptBinding="CLUSTER_NAME@racMsgBundle" required="yes"/>
           </uix:cellFormat>     
           <uix:cellFormat/>
           <uix:cellFormat hAlign="left">
                <uix:styledText styleClass="OraDataText"
                     textBinding="clusterName@CLSCFGBEAN@servletRequest"/>
           </uix:cellFormat>     
       </uix:rowLayout> 

       <uix:rowLayout>
         <uix:cellFormat>
            <uix:spacer height="5"/>
         </uix:cellFormat>   
         <uix:cellFormat>
            <uix:spacer width="5"/>
         </uix:cellFormat>   
         <uix:cellFormat/>
       </uix:rowLayout>
       
       <uix:rowLayout>
           <uix:cellFormat>
                <uix:messagePrompt promptBinding="targetHomeLabel@servletRequest"/>
           </uix:cellFormat>     
           <uix:cellFormat/>
           <uix:cellFormat hAlign="left">
                <uix:textInput name="CRSHome" 
                     textBinding="CRSHome@CLSCFGBEAN@servletRequest"
                     shortDescBinding="targetHomeLabel@servletRequest"/>
           </uix:cellFormat>     
       </uix:rowLayout> 

       <uix:rowLayout>
           <uix:cellFormat/>
           <uix:cellFormat/>
           <uix:cellFormat hAlign="left">
                <uix:styledText styleClass="OraInlineInfoText" 
                     textBinding="targetHomeTip@servletRequest"/>
           </uix:cellFormat>     
       </uix:rowLayout> 

       <uix:rowLayout>
           <uix:cellFormat>
                <uix:messagePrompt promptBinding="SCAN_NAME@racMsgBundle"/>
           </uix:cellFormat>     
           <uix:cellFormat/>
           <uix:cellFormat hAlign="left">
                <uix:textInput name="ScanName" 
                     textBinding="scanName@CLSCFGBEAN@servletRequest"
                     shortDescBinding="SCAN_NAME@racMsgBundle"/>
           </uix:cellFormat>     
       </uix:rowLayout> 
       <uix:spacer height="2"/>
       <uix:rowLayout>
           <uix:cellFormat/>
           <uix:cellFormat/>
           <uix:cellFormat hAlign="left">
                <uix:styledText styleClass="OraInlineInfoText" 
                     textBinding="SCAN_NAME_TIP@racMsgBundle"/>
           </uix:cellFormat>     
       </uix:rowLayout> 

       <uix:rowLayout>
           <uix:cellFormat>
                <uix:messagePrompt promptBinding="SCAN_PORT@racMsgBundle"/>
           </uix:cellFormat>     
           <uix:cellFormat/>
           <uix:cellFormat hAlign="left">
                <uix:textInput name="ScanPort" 
                     textBinding="scanPort@CLSCFGBEAN@servletRequest"
                     shortDescBinding="SCAN_PORT@racMsgBundle"/>
           </uix:cellFormat>     
       </uix:rowLayout> 
       <uix:spacer height="2"/>
       <uix:rowLayout>
           <uix:cellFormat/>
           <uix:cellFormat/>
           <uix:cellFormat hAlign="left">
                <uix:styledText styleClass="OraInlineInfoText" 
                     textBinding="SCAN_PORT_TIP@racMsgBundle"/>
           </uix:cellFormat>     
       </uix:rowLayout> 

       <uix:rowLayout> 
           <uix:cellFormat>
                <uix:messagePrompt promptBinding="EONS_PORT@racMsgBundle"/>
           </uix:cellFormat>     
           <uix:cellFormat/>
           <uix:cellFormat hAlign="left">
                <uix:textInput name="EONSPort" 
                     textBinding="EONSPort@CLSCFGBEAN@servletRequest"
                     shortDescBinding="EONS_PORT@racMsgBundle"/>
           </uix:cellFormat>     
       </uix:rowLayout> 
       <uix:rowLayout> 
           <uix:cellFormat/>
           <uix:cellFormat/>
           <uix:cellFormat hAlign="left">
                <uix:styledText styleClass="OraInlineInfoText" 
                     textBinding="EONS_PORT_TIP@racMsgBundle"/>
           </uix:cellFormat>     
       </uix:rowLayout> 

     <uix:switcher childNameBinding="clusterTarget@servletRequest" defaultCase="doNothing">
<uix:case name="has">
       <uix:rowLayout>
           <uix:cellFormat>
                <uix:messagePrompt promptBinding="HOST_NAME@racMsgBundle"/>
           </uix:cellFormat>     
           <uix:cellFormat/>
           <uix:cellFormat hAlign="left">
                <oem:choice name="hasTargetHost"
                      shortDescBinding="HOST_NAME@racMsgBundle"
                       optionsBinding="allHosts@CLSCFGBEAN@servletRequest"
                       selectedValueBinding="hasTargetHost@CLSCFGBEAN@servletRequest"/>
           </uix:cellFormat>     
       </uix:rowLayout> 
</uix:case>
<uix:case name="doNothing">
</uix:case>
</uix:switcher>

       <uix:rowLayout>
         <uix:cellFormat columnSpan="3">
            <uix:spacer height="5"/>
         </uix:cellFormat>   
       </uix:rowLayout>         
     </uix:tableLayout>
     
     <uix:switcher childNameBinding="clusterTarget@servletRequest" defaultCase="doNothing">
<uix:case name="cluster">
     <uix:tableLayout cellSpacing="5">
       <uix:rowLayout>
         <uix:cellFormat columnSpan="2">
            <uix:styledText styleClass="OraFieldText" 
                    textBinding="SEL_HOST_MSG@racMsgBundle"/>
         </uix:cellFormat>
       </uix:rowLayout>

       <uix:rowLayout> 
       <uix:cellFormat columnSpan="2">
        <oem:shuttle name="hostList" 
            leadingHeaderBinding="AVAIL_HOSTS@racMsgBundle"
            trailingHeaderBinding="SEL_HOSTS@racMsgBundle">
            <uix:leading>
                <oem:list name="notMatter" optionsBinding="availHosts@CLSCFGBEAN@servletRequest"
                        shortDescBinding="AVAIL_HOSTS@racMsgBundle"/>
            </uix:leading>
            <uix:trailing> 
                <oem:list name="notMatterToo" optionsBinding="selHosts@CLSCFGBEAN@servletRequest"
                        shortDescBinding="SEL_HOSTS@racMsgBundle"/>
            </uix:trailing>
        </oem:shuttle>
       </uix:cellFormat>
       </uix:rowLayout>
       </uix:tableLayout>    
</uix:case>
<uix:case name="has">
</uix:case>
<uix:case name="doNothing">
</uix:case>
</uix:switcher>

     <uix:switcher childNameBinding="clusterTarget@servletRequest" defaultCase="doNothing">
<uix:case name="cluster">
     <uix:tableLayout >
       <uix:rowLayout>
           <uix:cellFormat>
            <uix:tip>
                <uix:styledText textBinding="MASTER_AGENT_CLU_TIP@racMsgBundle"/>
            </uix:tip>
           </uix:cellFormat>     
          <uix:spacer width="8"/>
           <uix:cellFormat hAlign="left" >
            <db:link copyParams="target,type,returnUrl"
                     textBinding="SWITCH_MASTER_AGENT_LABEL@racMsgBundle"
                  destination="/console/rac/cluster/racClusterSwitch?event=viewProperties" />
           </uix:cellFormat>     
       </uix:rowLayout> 
       </uix:tableLayout>    
</uix:case>
<uix:case name="doNothing">
</uix:case>
</uix:switcher>

      </uix:stackLayout>
     </uix:header>
     
      <uix:pageButtons>
          <uix:pageButtonBar>
                  <uix:submitButton textBinding="CANCEL_BUTTON@racMsgBundle" 
                        name="event" value="cancel"/>
                  <uix:submitButton textBinding="ADD@racMsgBundle" 
                    name="event" value="apply" renderedBinding="inAddMode@CLSCFGBEAN@servletRequest"/>
                  <uix:submitButton textBinding="UPDATE@racMsgBundle" 
                       name="event" value="apply" renderedBinding="inUpdateMode@CLSCFGBEAN@servletRequest"/>
           </uix:pageButtonBar>
      </uix:pageButtons>
    </uix:pageLayout>
   </uix:default>
   </uix:switcher>    
    </db:form>
  </uix:body>      
  </uix:document> 
</uix:renderingContext> 
