<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- ---------------------------------------------------------------------- --%>
<%-- Progress meter during target discovery                                 --%>
<%-- ---------------------------------------------------------------------- --%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/> 
<uix:bundle name="racMsgBundle" class="oracle.sysman.db.rsc.rac.RacCommonMsg"/>

  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>
    <%@ include file="/setRefreshRate.jspf" %>

    <uix:metaContainer> 
      <uix:head 
        titleBinding="PageTitle@ServletRequest"
        />
    </uix:metaContainer>

    <uix:body>

      <db:form 
        name="savingProgress" 
        method="post" 
        destination="racClusterConfig" 
        copyParams="target,type,ctxType"
        >

        <%-------------------------
         -  Header
         ---------------------------%>
        <uix:pageLayout 
          titleBinding="PageTitle@pageContext"
          messageType="processing"
          >

          <%@ include file="/oemGlobal.jspf" %>

          <%-------------------------
           -  Progress description
           ---------------------------%>
          <uix:pageStatus>
            <uix:stackLayout>
              <uix:styledText 
                styleClass="OraInstructionTextStrong" 
                textBinding="TARGET_ADDING_IN_PROGRESS@racMsgBundle"
                renderedBinding="inAddMode@CLSCFGBEAN@servletRequest"
                />
             <uix:styledText 
                styleClass="OraInstructionTextStrong" 
                textBinding="TARGET_UPDATING_IN_PROGRESS@racMsgBundle"
                renderedBinding="inUpdateMode@CLSCFGBEAN@servletRequest"
                />
             <uix:styledText 
                styleClass="OraInstructionTextStrong" 
                textBinding="TARGET_DELETING_IN_PROGRESS@racMsgBundle"
                renderedBinding="inDeleteMode@CLSCFGBEAN@servletRequest"
                />
            </uix:stackLayout>
          </uix:pageStatus>

          <uix:stackLayout>
            <uix:spacer height="5" />

            <%-------------------------
             -  May take several minutes
             ---------------------------%>
            <uix:styledText styleClass="OraInstructionText"
              textBinding="OPER_MAY_TAKE_LONG@racMsgBundle"
              />

            <uix:spacer height="20" /> 

            <%-------------------------
             -  Progress meter
             ---------------------------%>
            <uix:processing 
              timeInterval="<%=processingPageInterval%>">
              <uix:contents>
              <uix:styledText 
                styleClass="OraInstructionText" 
                textBinding="TARGET_ADDING_IN_PROGRESS@racMsgBundle"
                renderedBinding="inAddMode@CLSCFGBEAN@servletRequest"
                />
             <uix:styledText 
                styleClass="OraInstructionText" 
                textBinding="TARGET_UPDATING_IN_PROGRESS@racMsgBundle"
                renderedBinding="inUpdateMode@CLSCFGBEAN@servletRequest"
                />
             <uix:styledText 
                styleClass="OraInstructionText" 
                textBinding="TARGET_DELETING_IN_PROGRESS@racMsgBundle"
                renderedBinding="inDeleteMode@CLSCFGBEAN@servletRequest"
                />
              </uix:contents>
            </uix:processing>

            <uix:spacer width="10"/>

            <%-------------------------
             -  Operation cannot be cancelled
             ---------------------------%>
            <uix:tip>
              <uix:styledText 
                textBinding="OPER_CANNOT_CANCEL@racMsgBundle"
                styleClass="OraInstructionText"
                />
            </uix:tip>

          </uix:stackLayout>
        </uix:pageLayout> 
      </db:form>  
    </uix:body>

  </uix:document> 
</uix:renderingContext> 

<%-- --------------------------  End of File  ----------------------------- --%>
