<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">  
  <oem:setURLEncoder id="renderingContext"/> 
  
  <uix:document> 

    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
      <uix:pageLayout>
        <%@ include file="/oemGlobal.jspf" %>

          <uix:messages>
            
              <oem:messageBox messageTypeBinding="messageType@servletRequest"
                                errorTableBinding="msgBox@servletRequest"
                                destTableBinding="msgUrls@servletRequest"
                                titleTextKey="titleText"
                                mainTextKey="mainText"/>

          </uix:messages>
          
        <db:form name="alertsForm" method="post" destination="/console/rac/cluster/racClusterSitemap"
            copyParams="target,type,pageNum,cancelURL">
        <uix:formValue name="crsHome" valueBinding="CRSHome@racClusterBean@servletRequest"/>

        <uix:header textBinding="header@racClusterBean@servletRequest"
                    icon="<%= request.getContextPath() + \"/images/database/rac/hostcluster.gif\" %>" >
         
         
            <!-- ============== show update time =========== -->
        <uix:tableLayout width="100%" >
           <uix:rowLayout hAlign="right">
                  <%@ include file="../refreshTime.jspf" %>
            </uix:rowLayout>
          </uix:tableLayout>

          <uix:subTabLayout>
            <uix:subTabs>
              <uix:subTabBar selectedIndex="3">
                <uix:link textBinding="HOME@DBMsgBundle@servletRequest" 
                          destinationBinding="overviewDest@servletRequest" disabledBinding="repDown@racClusterBean@servletRequest"/>
                <oem:license>
                <uix:link textBinding="PERFORMANCE_HEADER@DBMsgBundle@servletRequest"
                          destinationBinding="performDest@servletRequest" 
                          />
                </oem:license>
                <uix:link textBinding="TARGETS_TAB@racMsgBundle@servletRequest" destinationBinding="targetsDest@servletRequest" disabledBinding="repDown@racClusterBean@servletRequest"/>
                <uix:link textBinding="ADMINISTRATION@racMsgBundle@servletRequest"/>
                <oem:license>
                <uix:link textBinding="IC_INTERCONNECTS@racMsgBundle@servletRequest"
                          destinationBinding="interconnsDest@servletRequest"
                          renderedBinding="agentVersion10104OrHiger@racClusterBean@servletRequest" disabledBinding="repDown@racClusterBean@servletRequest"/>  
                </oem:license>
                <uix:link textBinding="TOPOLOGY@racMsgBundle@servletRequest"
                          destinationBinding="topologyDest@servletRequest" disabledBinding="repDown@racClusterBean@servletRequest"/>  

              </uix:subTabBar>
            </uix:subTabs>


  <uix:tableLayout width="100%" cellSpacing="3"  >   
    <uix:rowLayout vAlign="top">     
        <uix:cellFormat vAlign="top" width="33%">
            <uix:header textBinding="SERVER_GROUPS@racMsgBundle@servletRequest">
              <uix:stackLayout>
                        <db:link textBinding="VIEW_SERVER_GROUPS@racMsgBundle@servletRequest"
                                    destination="/console/has/serverGroups?event=doLoad" copyParams="target,type,isRepDown"/>

                        <db:link textBinding="ADD_SERVER_GROUPS@racMsgBundle@servletRequest"
                                    destination="/console/has/serverGroups?event=addNewSP&return2dbPage=false" copyParams="target,type,isRepDown"/>



              </uix:stackLayout>
          </uix:header>

        </uix:cellFormat>
         <uix:cellFormat vAlign="top" width="33%">
          <uix:header textBinding="RESOURCES@racMsgBundle@servletRequest">
          <uix:rowLayout vAlign="top">
          <uix:cellFormat vAlign="top" width="33%"> 
            <uix:stackLayout>
                      <db:link textBinding="VIEW_RESOURCES@racMsgBundle@servletRequest"
                                  destinationBinding="viewResourcesDestination@racClusterBean@servletRequest"
                                  copyParams="target,type,isRepDown"/>
                      <db:link textBinding="ADD_RESOURCE@racMsgBundle@servletRequest"
                                  destinationBinding="addResourceDestination@racClusterBean@servletRequest"
                                  copyParams="target,type,isRepDown"/>

            </uix:stackLayout>
          </uix:cellFormat> 
        
          </uix:rowLayout>
          </uix:header>
         </uix:cellFormat> 

        <uix:cellFormat vAlign="top" width="33%">
         <uix:header textBinding="RESOURCE_TYPES@racMsgBundle@servletRequest">
         <uix:rowLayout vAlign="top">
         <uix:cellFormat vAlign="top" width="33%">
           <uix:stackLayout>
                     <db:link textBinding="MANAGE_RESOURCE_TYPES@racMsgBundle@servletRequest"
                                 destinationBinding="viewResourceTypesDestination@racClusterBean@servletRequest"
                                 copyParams="target,type,isRepDown"/>
                     <db:link textBinding="ADD_RESOURCE_TYPE@racMsgBundle@servletRequest"
                                 destinationBinding="addResourceTypeDestination@racClusterBean@servletRequest"
                                 copyParams="target,type,isRepDown"/>

           </uix:stackLayout>
         </uix:cellFormat>

         </uix:rowLayout>
         </uix:header>
        </uix:cellFormat>

</uix:rowLayout>
</uix:tableLayout>


<uix:switcher childNameBinding="SHOW_WLM@servletRequest">
<uix:case name = "true">
<uix:switcher childNameBinding="isDisplayWLM@servletRequest">
<uix:case name="true">
<uix:stackLayout>

  <uix:tableLayout width="33%" cellSpacing="3" >   
    <uix:rowLayout vAlign="top">
            
            <uix:cellFormat vAlign="top" width="33%">
            <uix:header textBinding="WLM_LINK@racMsgBundle@servletRequest" >
            <uix:stackLayout>
            
               <db:link textBinding="WLM_RECO_LINK@racMsgBundle@servletRequest"
                destinationBinding="wlmBottleNexk@servletRequest"
                copyParams="target,type,isRepDown,cancelURL"/>

               <db:link textBinding="WLM_METRIC_LINK@racMsgBundle@servletRequest"
                        destinationBinding="wlmMetrics@servletRequest"
                        copyParams="target,type,isRepDown,cancelURL"/> 

              <db:link textBinding="WLM_CREATE_POLICY_LINK@racMsgBundle@servletRequest"
                       destinationBinding="wlmCreatePolicy@servletRequest"
                       copyParams="target,type,isRepDown,cancelURL"/>
                       
              <db:link textBinding="WLM_POLICY_LINK@racMsgBundle@servletRequest"
                       destinationBinding="wlmPolicy@servletRequest"
                       copyParams="target,type,isRepDown,cancelURL"/>  
         
<%--
              <db:link textBinding="APPQOS_MANAGE_USERS_LINK@racMsgBundle@servletRequest"
                       destinationBinding="wlmManageUsers@servletRequest"
                       copyParams="target,type,isRepDown,cancelURL"/>          
                     
  --%>
  
            </uix:stackLayout>
            </uix:header>
            </uix:cellFormat>
       </uix:rowLayout>      
 </uix:tableLayout>            
 
 
<%--

<uix:header textBinding="WLM_LINK@racMsgBundle@servletRequest" >
    <uix:tableLayout width="100%" cellSpacing = "3"   >
        <uix:contents>
        
       <uix:rowLayout vAlign="top"  >
       
         <uix:cellFormat vAlign="top" width="34%" >
                   <db:link textBinding="WLM_DB_CONFIG_LINK@racMsgBundle@servletRequest"
                            destinationBinding="wlmConfig@servletRequest"
                            copyParams="target,type,isRepDown,cancelURL"/>
         </uix:cellFormat> 
         
        <uix:cellFormat vAlign="top" width="34%">
                  <db:link textBinding="WLM_CREATE_POLICY_LINK@racMsgBundle@servletRequest"
                           destinationBinding="wlmCreatePolicy@servletRequest"
                           copyParams="target,type,isRepDown,cancelURL"/>

         </uix:cellFormat>  
         
        <uix:cellFormat vAlign="top" width="32%">
     
                    <db:link textBinding="WLM_RECO_LINK@racMsgBundle@servletRequest"
                        destinationBinding="wlmBottleNexk@servletRequest"
 			copyParams="target,type,isRepDown,cancelURL"/>

         </uix:cellFormat> 
        </uix:rowLayout>
        
        <uix:rowLayout vAlign="top"  >
            <uix:cellFormat vAlign="top" width="34%" >
        
            </uix:cellFormat> 
            
            
            <uix:cellFormat vAlign="top" width="34%" >
                  <db:link textBinding="WLM_POLICY_LINK@racMsgBundle@servletRequest"
                           destinationBinding="wlmPolicy@servletRequest"
                           copyParams="target,type,isRepDown,cancelURL"/>  
             </uix:cellFormat>
            
            
            <uix:cellFormat vAlign="top" width="32%" >
               <db:link textBinding="WLM_METRIC_LINK@racMsgBundle@servletRequest"
                        destinationBinding="wlmMetrics@servletRequest"
                        copyParams="target,type,isRepDown,cancelURL"/>          
             
            </uix:cellFormat>             
        </uix:rowLayout>
        </uix:contents>
    </uix:tableLayout>
</uix:header>   

--%>

</uix:stackLayout>
</uix:case>
</uix:switcher> 
</uix:case>
</uix:switcher>

              <%-- oem:table name="racClusterTargetsDataSource" width="100%"  
                         summaryBinding="TARGETS_TAB@racMsgBundle@servletRequest"
                         partialRenderMode="self"
                         formSubmitted="true"                           
                         beanKey="racClusterBean"                           
                         dataSourceProp="racClusterTargetsDataSource"
                         blockSize="25"                           
                         alternateText="No targets found.">
              </oem:table --%>            


          </uix:subTabLayout>
          <uix:spacer height="5"/>

        </uix:header>
         <uix:switcher childNameBinding="repDown@racClusterBean@servletRequest">
          <uix:case name="false"> 
          <uix:stackLayout>
           <%@ include file="comp.jspf" %>
            <oem:relatedLinks />
          </uix:stackLayout>  
          </uix:case>  
         </uix:switcher>    

        </db:form>
      </uix:pageLayout>
    </uix:body>

  </uix:document> 
</uix:renderingContext> 
