<%-- 
 * Copyright (c) 2006, 2008, Oracle. All rights reserved.  
 *
 *      NAME
 *        racDBProperties.jsp - To view RacDB properties page.
 *
 *      NOTES
 *          This jsp is to show the properties of rac database on 
 *          click of view properties from the rac home page.
 *       
 * MODIFIED
 *    pboopath    05/20/08 - Hosts,clusterwarestatus links change
 *    rsamaved    05/11/08 - add cluster breadcrumb
 *    pboopath    05/05/08 - 
 *    shasingh    07/15/07 - scan changes
 *    gallison    05/16/07 - 
 *    rsamaved    03/20/07 - 
 *    gapadman    03/01/07 - Initial creation of module.
--%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>
    
    
    <uix:body>
          <db:form name="alertsForm" method="post" destination="/console/rac/cluster/clusterProps"
               copyParams="target,type">

        <uix:pageLayout>
          <%@ include file="/database/global.jspf" %>
          
        <uix:header textBinding="header@racClusterBean@servletRequest" 
                    icon="<%= request.getContextPath() + \"/images/database/rac/hostcluster.gif\" %>" >
        
      <uix:tableLayout width="100%" cellSpacing="5">
      <uix:rowLayout vAlign="top">
      <uix:stackLayout>
      <uix:rowLayout>
      <uix:cellFormat hAlign="center">
      <uix:borderLayout>
      <uix:tableLayout hAlign="left" width="50%">   
      
                            <uix:rowLayout>
                              <uix:cellFormat hAlign="right" vAlign="top" wrappingDisabled="true">
                                <uix:styledText styleClass="OraPromptText" textBinding="CURRENT_STATUS@racMsgBundle@servletRequest"/>
                              </uix:cellFormat>
                              <uix:cellFormat>
                              <uix:spacer width="8"/>
                                <oem:license>
                                <uix:link destinationBinding="availDest@servletRequest"
                                          textBinding="trafficStatusStr@racClusterBean@servletRequest"/>
                                </oem:license>
                                </uix:cellFormat>  
                              
                            </uix:rowLayout>

                            <uix:rowLayout>
                              <uix:cellFormat hAlign="right" vAlign="top"  wrappingDisabled="true">
                                <uix:styledText styleClass="OraPromptText" 
                                                textBinding="HOST_COMPONENTS@racMsgBundle@servletRequest"
                                                />
                              </uix:cellFormat>
                              
                              <uix:cellFormat hAlign="left">
                              <uix:spacer width="8"/>
                              <uix:link  textBinding="totalInstanceCount@racClusterBean@servletRequest"
                           destinationBinding="homePageURL@servletRequest"/>
                              
                              <uix:spacer width="8"/>
                              <uix:styledText styleClass="OraDataText" text="( "/>
                                    
                              <uix:flowLayout renderedBinding="showUpInstCount@racClusterBean@servletRequest">
                                <uix:image sourceBinding="upInstIconSource@racClusterBean@servletRequest"
                                           shortDescBinding="upStatusShortDesc@racClusterBean@servletRequest" />
                                <uix:styledText styleClass="OraDataText"
                                                textBinding="upInstCount@racClusterBean@servletRequest"/>
                              </uix:flowLayout>

                              <uix:flowLayout renderedBinding="showDownInstCount@racClusterBean@servletRequest">
                                <uix:image sourceBinding="downInstIconSource@racClusterBean@servletRequest"
                                           shortDescBinding="downStatusShortDesc@racClusterBean@servletRequest" />
                                <uix:styledText styleClass="OraDataText"
                                                textBinding="downInstCount@racClusterBean@servletRequest"/>
                                </uix:flowLayout>

                              <uix:flowLayout renderedBinding="showUnreachableInstCount@racClusterBean@servletRequest">
                                <uix:image sourceBinding="unreachableInstIconSource@racClusterBean@servletRequest"
                                           shortDescBinding="unreachableStatusShortDesc@racClusterBean@servletRequest" />
                                <uix:spacer width="3"/>
                                <uix:styledText styleClass="OraDataText"
                                                textBinding="unreachableInstCount@racClusterBean@servletRequest"/>
                              </uix:flowLayout>

                              <uix:flowLayout renderedBinding="showErrorInstCount@racClusterBean@servletRequest">
                                <uix:image sourceBinding="errorInstIconSource@racClusterBean@servletRequest"
                                           shortDescBinding="errorStatusShortDesc@racClusterBean@servletRequest" />
                                <uix:spacer width="3"/>
                                <uix:styledText styleClass="OraDataText"
                                                textBinding="errorInstCount@racClusterBean@servletRequest"/>
                              </uix:flowLayout>

                              <uix:flowLayout renderedBinding="showBlackoutInstCount@racClusterBean@servletRequest">
                                <uix:image sourceBinding="blackoutInstIconSource@racClusterBean@servletRequest"
                                           shortDescBinding="blackoutStatusShortDesc@racClusterBean@servletRequest" />
                                <uix:spacer width="3"/>
                                <uix:styledText styleClass="OraDataText"
                                                textBinding="blackoutInstCount@racClusterBean@servletRequest"/>
                              </uix:flowLayout>

                              
                              <uix:flowLayout renderedBinding="showAgentDownInstCount@racClusterBean@servletRequest">
                                <uix:image sourceBinding="agentDownInstIconSource@racClusterBean@servletRequest"
                                           shortDescBinding="agentDownStatusShortDesc@racClusterBean@servletRequest" />
                                <uix:spacer width="3"/>
                                <uix:styledText styleClass="OraDataText"
                                                textBinding="agentDownInstCount@racClusterBean@servletRequest"/>
                              </uix:flowLayout>

                              <uix:flowLayout renderedBinding="showUnknownInstCount@racClusterBean@servletRequest">
                                <uix:image sourceBinding="unknownInstIconSource@racClusterBean@servletRequest"
                                           shortDescBinding="unknownStatusShortDesc@racClusterBean@servletRequest" />
                                <uix:spacer width="3"/>
                                <uix:styledText styleClass="OraDataText"
                                                textBinding="unknownInstCount@racClusterBean@servletRequest"/>
                              </uix:flowLayout> 
                              <uix:styledText styleClass="OraDataText" text=" )"/>
                              </uix:cellFormat>  
                            </uix:rowLayout>

<%--
                            <uix:rowLayout>
                              <uix:cellFormat hAlign="right" vAlign="top">
                                <uix:styledText styleClass="OraPromptText" 
                                                textBinding="UP_NODES@racMsgBundle@servletRequest"/>
                              </uix:cellFormat>
                              
                              <uix:cellFormat>
                              <uix:spacer width="8"/>
                              <uix:styledText styleClass="OraDataText" 
                                              textBinding="upNodes@racClusterBean@servletRequest"/>
                               </uix:cellFormat> 
                            </uix:rowLayout>
--%>
                            <uix:rowLayout>
                              <uix:cellFormat hAlign="right" vAlign="top"  wrappingDisabled="true">
                                <uix:styledText styleClass="OraPromptText" 
                                                textBinding="AVAILABILITY@DBMsgBundle@servletRequest"/>
                              </uix:cellFormat>
                              <uix:cellFormat>
                              <uix:spacer width="8"/>
                                <oem:license>
                                <uix:link textBinding="trafficAvailStr@racClusterBean@servletRequest"
                                            destinationBinding="availDest@servletRequest"/>
                                </oem:license>
                              </uix:cellFormat>
                              </uix:rowLayout>

                            <uix:rowLayout>
                              <uix:cellFormat/>

                              <uix:cellFormat> 
                                  <uix:spacer width="8"/>
                                  <uix:styledText styleClass="OraInlineInfoText"
                                    text="(" />
                                  <uix:styledText styleClass="OraInlineInfoText"
                                    textBinding="LAST_DAY@SDKBundle@servletRequest" />
                                  <uix:styledText styleClass="OraInlineInfoText"
                                    text=")" />
                              </uix:cellFormat>  
                            </uix:rowLayout>

                            <uix:rowLayout renderedBinding="CRSHomeSet@racClusterBean@servletRequest">
                              <uix:cellFormat hAlign="right" vAlign="top"  wrappingDisabled="true">
                                <uix:styledText styleClass="OraPromptText" 
                                                textBinding="CLUSTER_NAME@racMsgBundle@servletRequest"/>
                              </uix:cellFormat>
                              <uix:cellFormat>
                              <uix:spacer width="8"/>
                              <uix:styledText styleClass="OraDataText" 
                                              textBinding="clusterName@racClusterBean@servletRequest"/>
                              </uix:cellFormat>
                            </uix:rowLayout>

                          <!-- CRS Status -->
                            <uix:rowLayout renderedBinding="crsStatusShowing@racClusterBean@servletRequest">
                              <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                <uix:styledText styleClass="OraPromptText" 
                                                textBinding="CLUSTERWARE_STATUS@racMsgBundle@servletRequest"/>
                              </uix:cellFormat>
                              <uix:cellFormat>
                              <uix:spacer width="8"/>
                                <uix:include nodeBinding="CRSStatusUINode@servletRequest"/>
                              </uix:cellFormat>
                            </uix:rowLayout>

                            <uix:rowLayout renderedBinding="CRSHomeSet@racClusterBean@servletRequest">
                              <uix:cellFormat hAlign="right" vAlign="top"  wrappingDisabled="true">
                                <uix:styledText styleClass="OraPromptText" 
                                                textBinding="CRS_VERSION@racMsgBundle@servletRequest"/>
                              </uix:cellFormat>
                              <uix:cellFormat>
                              <uix:spacer width="8"/>
                              <uix:styledText styleClass="OraDataText" 
                                              textBinding="CRSVersion@racClusterBean@servletRequest"/>
                              </uix:cellFormat>
                            </uix:rowLayout>

                            <uix:rowLayout renderedBinding="CRSHomeSet@racClusterBean@servletRequest">
                              <uix:cellFormat hAlign="right"  wrappingDisabled="true">
                                <uix:styledText styleClass="OraPromptText" 
                                                textBinding="CRS_HOME@racMsgBundle@servletRequest"/>
                              </uix:cellFormat>
                              <uix:cellFormat  vAlign="top"  wrappingDisabled="true">
                              <uix:spacer width="8"/>
                              <uix:styledText styleClass="OraDataText"  
                                              textBinding="CRSHome@racClusterBean@servletRequest"/>
                               </uix:cellFormat> 
                            </uix:rowLayout>
                            
                            <%--- SCAN DETAILS --%>
                            <uix:switcher childNameBinding="crsVersion11gTBOrHigher@racClusterBean@servletRequest" 
                                       renderedBinding="CRSHomeSet@racClusterBean@servletRequest">
                             <uix:case name="true">
                             <uix:rowLayout >
                               <uix:cellFormat hAlign="right"  wrappingDisabled="true">
                                 <uix:styledText styleClass="OraPromptText" 
                                                 textBinding="SCAN_NAME@racMsgBundle@servletRequest"/>
                               </uix:cellFormat>
                               <uix:cellFormat  vAlign="top"  wrappingDisabled="true">
                               <uix:spacer width="8"/>
                               <uix:styledText styleClass="OraDataText"  
                                               textBinding="scanName@racClusterBean@servletRequest"/>
                                </uix:cellFormat> 
                             </uix:rowLayout>
                         </uix:case>
                        </uix:switcher>
                        <uix:switcher childNameBinding="crsVersion11gTBOrHigher@racClusterBean@servletRequest" 
                                       renderedBinding="CRSHomeSet@racClusterBean@servletRequest">
                             <uix:case name="true">
                             <uix:rowLayout >
                               <uix:cellFormat hAlign="right"  wrappingDisabled="true">
                                 <uix:styledText styleClass="OraPromptText" 
                                                 textBinding="SCAN_PORT@racMsgBundle@servletRequest"/>
                               </uix:cellFormat>
                               <uix:cellFormat  vAlign="top"  wrappingDisabled="true">
                               <uix:spacer width="8"/>
                               <uix:styledText styleClass="OraDataText"  
                                               textBinding="scanPort@racClusterBean@servletRequest"/>
                                </uix:cellFormat> 
                             </uix:rowLayout>
                         </uix:case>
                        </uix:switcher>         
                            
			<uix:rowLayout >
			  <uix:cellFormat hAlign="right"  wrappingDisabled="true">
			    <uix:styledText styleClass="OraPromptText" 
		                    textBinding="MASTER_AGENT_LABEL@racMsgBundle@servletRequest"/>
			  </uix:cellFormat>
                          <uix:cellFormat>
			  <uix:spacer width="8"/>
			    <uix:link destinationBinding="masterAgentURL@servletRequest"
		              textBinding="masterAgentHost@servletRequest"/>
		             </uix:cellFormat> 
			</uix:rowLayout>

<%--
                        <uix:rowLayout >
                          <uix:cellFormat hAlign="right"   wrappingDisabled="true">
                            <uix:styledText styleClass="OraPromptText"  
                                    textBinding="MASTER_AGENT_SINCE_LABEL@racMsgBundle@servletRequest"/>
                          </uix:cellFormat>
                          <uix:cellFormat wrappingDisabled="true">
                          <uix:spacer width="8"/>
                              <uix:styledText styleClass="OraDataText" 
                                              textBinding="masterAgentSince@servletRequest"/>              
                          </uix:cellFormat>
                        </uix:rowLayout>
--%>
                                                    

                          <uix:rowLayout renderedBinding="showSvcsImpacted@svcImpBean@servletRequest">         		      
                            <uix:cellFormat hAlign="right" wrappingDisabled="true">
                              <uix:styledText styleClass="OraPromptText" textBinding="label@svcImpBean@servletRequest" />
                            </uix:cellFormat>
                            <uix:spacer width="8"/>
                            <uix:link textBinding="value@svcImpBean@servletRequest" 
                                      destinationBinding="destination@svcImpBean@servletRequest" />
                          </uix:rowLayout>

       </uix:tableLayout>             
      </uix:borderLayout>
      </uix:cellFormat>
      </uix:rowLayout>
      </uix:stackLayout>
      </uix:rowLayout>      

     <uix:tableLayout >
       <uix:rowLayout>
           <uix:cellFormat>
            <uix:tip>
                <uix:styledText textBinding="MASTER_AGENT_CLU_TIP@racMsgBundle@servletRequest"/>
            </uix:tip>
           </uix:cellFormat>     
          <uix:spacer width="8"/>
           <uix:cellFormat hAlign="left" >
            <db:link copyParams="target,type"
                     textBinding="SWITCH_MASTER_AGENT_LABEL@racMsgBundle@servletRequest"
                  destination="/console/rac/cluster/racClusterSwitch?event=viewProperties" />
           </uix:cellFormat>     
       </uix:rowLayout> 
       </uix:tableLayout>    

        </uix:tableLayout>                    
        </uix:header> 
          
        </uix:pageLayout>
        
        </db:form>
    </uix:body>


  </uix:document>
</uix:renderingContext>
