<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">  
  <oem:setURLEncoder id="renderingContext"/> 

  <uix:switcher childNameBinding="manualSelected@servletRequest">
    <uix:case name="false">
      <uix:rawText>
        <meta http-equiv="Refresh" 
              content="<%=request.getAttribute("refreshChoice")%>; URL=<%=request.getAttribute("ClusterIntrconnRefreshURL") %>" >
        </uix:rawText>
      </uix:case>
    </uix:switcher>
  
  <uix:document> 

    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
      <uix:pageLayout>
        <%@ include file="/oemGlobal.jspf" %>

          <uix:switcher childNameBinding="validClusterwareVersion@racClusterBean@servletRequest">
            <uix:case name="false">
            <uix:messageBox messageType="warning" messageBinding="MISSING_VERSION_MESSAGE@racMsgBundle@servletRequest"/>
            </uix:case>
          </uix:switcher>

        <db:form name="alertsForm" method="post" destination="/console/rac/cluster/racClusterSitemap"
            copyParams="target,type,pageNum,filterDB">
         
        <uix:header textBinding="header@racClusterBean@servletRequest"
                    icon="<%= request.getContextPath() + \"/images/database/rac/hostcluster.gif\" %>" >

            <!-- ============== show update time =========== -->
            <uix:tableLayout width="100%" >
              <uix:rowLayout hAlign="right">
                  <%@ include file="../refreshTime.jspf" %>
              </uix:rowLayout>
            </uix:tableLayout>


          <uix:subTabLayout>
            <uix:subTabs>
              <uix:subTabBar selectedIndex="4">
                <uix:link textBinding="HOME@DBMsgBundle@servletRequest" 
                          destinationBinding="overviewDest@servletRequest"/>
                <oem:license>
                <uix:link textBinding="PERFORMANCE_HEADER@DBMsgBundle@servletRequest"
                          destinationBinding="performDest@servletRequest"/>
                </oem:license>
                <uix:link textBinding="TARGETS_TAB@racMsgBundle@servletRequest"
                          destinationBinding="targetsDest@servletRequest"/>  
                  
			<uix:link textBinding="ADMINISTRATION@racMsgBundle@servletRequest"
                          destinationBinding="adminDest@servletRequest" 
			  renderedBinding="CRSVersion112OrHigher@racClusterBean@servletRequest" />
                  
                <uix:link textBinding="IC_INTERCONNECTS@racMsgBundle@servletRequest"
		       destinationBinding="interconnsDest@servletRequest" 
		       renderedBinding="agentVersion10104OrHiger@racClusterBean@servletRequest" />

                <uix:link textBinding="TOPOLOGY@racMsgBundle@servletRequest"
                          destinationBinding="topologyDest@servletRequest"/>  
              </uix:subTabBar>
            </uix:subTabs>

            <uix:stackLayout>
            <uix:switcher childNameBinding="CRSVersion102OrHigher@racClusterBean@servletRequest">
            <uix:case name="true">
                <uix:styledText styleClass="OraPromptText" 
                        textBinding="IC_PAGE_DESC@racMsgBundle@servletRequest"/>
            </uix:case>
            <uix:case name="false">
                <uix:styledText styleClass="OraPromptText" 
                        textBinding="IC_PAGE_DESC_9I@racMsgBundle@servletRequest"/>
            </uix:case>
            </uix:switcher>
            
            <uix:spacer height="5"/>

              <uix:tableLayout width="100%">
              <uix:rowLayout>
              <uix:cellFormat hAlign="right">
                <uix:flowLayout>
                  <uix:styledText styleClass="OraFieldText" 
                                  textBinding="VIEW_DATA@DBMsgBundle@servletRequest" 
                                  labeledNodeId="refreshChoice"/>
    
                  <uix:choice name="refreshChoice" id="refreshChoice"
                              onChange="submitForm('alertsForm', true, 
                                        {'event':'doLoad'})"> 
    
                    <uix:option textBinding="AUTOMATICALLY_REFRESH_1MIN@DBMsgBundle@servletRequest"
                                value="60"/>
                    <uix:option textBinding="MANUALLY_REFRESH@DBMsgBundle@servletRequest"
                                value="-1" selectedBinding="manualSelected@servletRequest"/>
                  </uix:choice>
                </uix:flowLayout>
              </uix:cellFormat>
              </uix:rowLayout>
              </uix:tableLayout>
            
              <uix:tableLayout width="100%" 
                    renderedBinding="CRSVersion10iOrHigher@racClusterBean@servletRequest">
              <uix:rowLayout>
              <uix:cellFormat width="50%" hAlign="right">
                <uix:styledText styleClass="OraPromptText" 
                    textBinding="IC_PRIVATE_RATE@racMsgBundle@servletRequest"/>
               </uix:cellFormat>
               
               <uix:cellFormat width="50%"  hAlign="left">
               <uix:spacer width="5"/>
                <uix:link 
                    textBinding="privateInterconnectTraffic@racClusterBean@servletRequest"
                    destinationBinding="privateInterconnectTrafficUrl@racClusterBean@servletRequest"/>
               </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
              <uix:cellFormat width="50%" hAlign="right"/>
               <uix:cellFormat width="50%"  hAlign="left">
               <uix:spacer width="5"/>
                <uix:styledText styleClass="OraInlineInfoText" 
                    textBinding="IC_PRIVATE_TRANS_RATE_TIP@racMsgBundle@servletRequest"/>
               </uix:cellFormat>
              </uix:rowLayout>
              </uix:tableLayout>

              <uix:header textBinding="IC_CONF_IC@racMsgBundle@servletRequest">
              <uix:stackLayout>
              <uix:tableLayout width="100%">
              <uix:rowLayout>
              <uix:cellFormat hAlign="left">
                <uix:styledText styleClass="OraPromptText" 
                    textBinding="VIEW@racMsgBundle@servletRequest"/>
                <uix:spacer width="5"/>
                <uix:choice name="filterType" selectedValueBinding="filterType@racClusterBean@servletRequest"
                   onChange="submitForm('alertsForm', true, {'event':'filterByType'})"
                   shortDescBinding="IC_TYPE@racMsgBundle@servletRequest">
                     <uix:option textBinding="IC_TYPE_ALL@racMsgBundle@servletRequest" value="ALL"/>
                     <uix:option textBinding="IC_PRIVATE@racMsgBundle@servletRequest" value="NO"/>
                     <uix:option textBinding="IC_PUBLIC@racMsgBundle@servletRequest" value="YES"/>
                </uix:choice> 
              </uix:cellFormat>
              </uix:rowLayout>
              </uix:tableLayout>

<%--                    
              <oem:table name="racClusterInterconnsDataSource" width="100%"                          
                         partialRenderMode="self"
                         formSubmitted="true"                           
                         beanKey="racClusterBean"                           
                         dataSourceProp="racClusterInterconnsDataSource"
                         blockSize="10"                           
                         alternateTextBinding="IC_NO_DATA@racMsgBundle@servletRequest">
              </oem:table>          
--%>

               <uix:hGrid id="racClusterInterconnsHgrid"
                           width="100%"
                           summaryBinding="IC_CONF_IC@racMsgBundle@servletRequest"
                           formSubmitted="true"   
                           treeDataBinding="hgridDataTree@clsInterconnsHgridDS@racClusterBean@servletRequest"
                           columnHeaderDataBinding="clsIntrConnHgridHeader@racClusterBean@servletRequest"
                           columnFormatsBinding="clsIntrConnHgridHeader@racClusterBean@servletRequest" 
                           proxyBinding="proxy@servletRequest"
                           alternateTextBinding="IC_NO_DATA@racMsgBundle@servletRequest">  
                  <uix:nodeStamp>
                    <uix:column>
                      <uix:columnHeader>
                        <uix:styledText textBinding="NAME@racMsgBundle@servletRequest"/>
                      </uix:columnHeader>                     
                      
                      <uix:link textBinding="col1" destinationBinding="col1dest"/>
                        
                    </uix:column>
                  </uix:nodeStamp>

                  <uix:columnHeaderStamp>
                    <uix:text textBinding="text"/>
                  </uix:columnHeaderStamp>

                  <uix:styledText textBinding="objType"/> 
                  <uix:styledText textBinding="col2"/> 
                  <uix:styledText textBinding="col3"/>               

                  <uix:rowLayout vAlign="middle" styleClass="OraPromptText">
                      <uix:link textBinding="col4_0" destinationBinding="col4_0dest"/> 
                      <uix:spacer width="5"/>
                      <uix:image sourceBinding="col4_1image"/>
                  </uix:rowLayout>

                  <uix:rowLayout vAlign="middle" styleClass="OraPromptText">
                      <uix:link textBinding="col5_0" destinationBinding="col5_0dest"/> 
                      <uix:spacer width="5"/>
                      <uix:image sourceBinding="col5_1image"/>
                  </uix:rowLayout>
                                                                                                        
                </uix:hGrid>                      
              </uix:stackLayout>
              </uix:header>
              
              <uix:header textBinding="interconnUsageHeader@racClusterBean@servletRequest"
                    renderedBinding="CRSVersion102OrHigher@racClusterBean@servletRequest">  
              <uix:stackLayout>


             <uix:rawText>
                <a name="dbintr"/>
             </uix:rawText>
                           
<%--              
              <oem:table name="racClusterDBInterconnsDataSource" width="100%"                          
                         partialRenderMode="self" id="clsdbintcontbl"
                         formSubmitted="true"                           
                         beanKey="racClusterBean"                           
                         dataSourceProp="racClusterDBInterconnsDataSource"
                         blockSize="10"                           
                         alternateTextBinding="IC_NO_DATA@racMsgBundle@servletRequest">
              </oem:table>        
--%>
               <uix:hGrid id="racClusterDBInterconnsHgrid"
                           width="100%"
                           summaryBinding="interconnUsageHeader@racClusterBean@servletRequest"
                           formSubmitted="true"   
                           treeDataBinding="hgridDataTree@clsDBInterconnsHgridDS@racClusterBean@servletRequest"
                           columnHeaderDataBinding="clsDBIntrConnHgridHeader@racClusterBean@servletRequest"
                           columnFormatsBinding="clsDBIntrConnHgridHeader@racClusterBean@servletRequest"
                           proxyBinding="proxy2@servletRequest"
                           alternateTextBinding="IC_NO_DATA@racMsgBundle@servletRequest">  
                  <uix:nodeStamp>
                    <uix:column>
                      <uix:columnHeader>
                        <uix:styledText textBinding="NAME@racMsgBundle@servletRequest"/>
                      </uix:columnHeader>                     
                      
                      <uix:link textBinding="col1" destinationBinding="col1dest"/>
                        
                    </uix:column>
                  </uix:nodeStamp>

                  <uix:columnHeaderStamp>
                    <uix:text textBinding="text"/>
                  </uix:columnHeaderStamp>

                  <uix:styledText textBinding="objType"/> 
                  <uix:link textBinding="col2" destinationBinding="col2dest"/> 
                  <uix:link textBinding="col3" destinationBinding="col3dest"/>
                  <uix:styledText textBinding="col4"/> 
                  <uix:rowLayout vAlign="middle" styleClass="OraPromptText">
                      <uix:link textBinding="col5_0" destinationBinding="col5_0dest"/> 
                      <uix:spacer width="5"/>
                      <uix:image sourceBinding="col5_1image"/>
                  </uix:rowLayout>
                  <uix:styledText textBinding="col6"/> 

                  <uix:rowLayout vAlign="middle" styleClass="OraPromptText">
                      <uix:link textBinding="col7_0" destinationBinding="col7_0dest"/> 
                      <uix:spacer width="5"/>
                      <uix:image sourceBinding="col7_1image"/>
                  </uix:rowLayout>
                  
                </uix:hGrid>
                
              <uix:spacer height="5"/>
              <uix:tip textBinding="IC_INST_RATE_TIP@racMsgBundle@servletRequest"/>
              <uix:spacer height="10"/>
              </uix:stackLayout>
              </uix:header>
            
            <uix:tip textBinding="OLD_DATA_TIP@racMsgBundle@servletRequest" 
                    renderedBinding="hasOldData@racClusterBean@servletRequest"/>
                    
           </uix:stackLayout>   
          </uix:subTabLayout>
          <uix:spacer height="5"/>

        </uix:header>

          <%@ include file="comp.jspf" %>
            <oem:relatedLinks/> 

        </db:form>
      </uix:pageLayout>
    </uix:body>

  </uix:document> 
</uix:renderingContext> 

