<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 
<%@ page import="oracle.sysman.emo.rac.cluster.RacCluster" %>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %>
<%@ page import="oracle.sysman.emo.rac.cluster.RacClusterOFSDataSource" %>

                          
<uix:renderingContext id="renderingContext">  
  <oem:setURLEncoder id="renderingContext"/> 

  <uix:switcher childNameBinding="autoRefresh@servletRequest">
    <uix:case name="true">
      <uix:rawText>
        <meta http-equiv="Refresh"
              content="<%=request.getAttribute("refreshChoiceValue")%>; URL=<%=request.getAttribute("interconnDest") %>" >
        </uix:rawText>
      </uix:case>
    </uix:switcher>

<script language="javascript">
    function setFocus()
    {
      <%
      boolean focusServices = ((RacCluster)request.getAttribute("racClusterBean")).getFocusServices();
      if(focusServices)
      {
      %> 
           window.location.href = "#SERVICES";
      <%
      }     
      %>
    }
</script>

  <uix:bundle name="JobsResourceBundle"
              class="oracle.sysman.resources.emSDK.job.JobSDKMsg"/>
  <uix:bundle name="ofsMsg" 
              class="oracle.sysman.db.rsc.osm.ofs.OfsObjectMsg" />
  

  <%-- CPF (Bug#3256443) --%>
  <uix:bundle name="mntrResourceBundle"
      class="oracle.sysman.resources.MntrResourceBundle"/>
      
  <uix:bundle name="racMsgBundle" class="oracle.sysman.db.rsc.rac.RacCommonMsg"/> 
      
  
  <uix:document> 

    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body onLoad="setFocus()">
      <uix:pageLayout>

        <%@ include file="/oemGlobal.jspf" %> 

        <db:form name="alertsForm" method="post" destination="/console/rac/cluster/racClusterSitemap"
                   copyParams="target,type,pageNum">
       
        <uix:header textBinding="header@racClusterBean@servletRequest"
                    icon="<%= request.getContextPath() + \"/images/database/rac/hostcluster.gif\" %>" >

            <!-- ============== show update time =========== -->
            <uix:tableLayout width="100%" >
              <uix:rowLayout hAlign="right">
                  <%@ include file="../refreshTime.jspf" %>
              </uix:rowLayout>
            </uix:tableLayout>


          <uix:subTabLayout>
            <uix:subTabs>
              <uix:subTabBar selectedIndex="0">
                <uix:link textBinding="HOME@DBMsgBundle@servletRequest"/>
                <oem:license>
                <uix:link textBinding="PERFORMANCE_HEADER@DBMsgBundle@servletRequest"
                          destinationBinding="performDest@servletRequest"/>
                </oem:license>
                <uix:link textBinding="TARGETS_TAB@racMsgBundle@servletRequest"
                          destinationBinding="targetsDest@servletRequest"/>
	        <uix:link textBinding="ADMINISTRATION@racMsgBundle@servletRequest"
                          destinationBinding="adminDest@servletRequest"
                          renderedBinding="CRSVersion112OrHigher@racClusterBean@servletRequest" />
                <oem:license>
                <uix:link textBinding="IC_INTERCONNECTS@racMsgBundle@servletRequest"
                          destinationBinding="interconnsDest@servletRequest"
                          renderedBinding="agentVersion10104OrHiger@racClusterBean@servletRequest"/>  
                </oem:license>
                <uix:link textBinding="TOPOLOGY@racMsgBundle@servletRequest"
                          destinationBinding="topologyDest@servletRequest"/>  
              </uix:subTabBar>
            </uix:subTabs>

 	   <uix:spacer height="5"/>

              <uix:tableLayout width="100%">
              <uix:rowLayout>
              <uix:cellFormat hAlign="right">
                <uix:flowLayout>
                  <uix:styledText styleClass="OraFieldText"
                                  textBinding="VIEW_DATA@DBMsgBundle@servletRequest"
                                  labeledNodeId="refreshChoice"/>

                  <uix:choice name="refreshChoice" id="refreshChoice"
                              onChange="submitForm('alertsForm', true,
                                        {'event':'doLoad'})"
			      selectedValueBinding="refreshChoice@servletRequest">
                    <uix:option textBinding="AUTOMATICALLY_REFRESH_1MIN@DBMsgBundle@servletRequest"
                                value="RT_60"/>
                    <uix:option textBinding="MANUALLY_REFRESH@DBMsgBundle@servletRequest"
                                value="RT_MAN"/>
                  </uix:choice>
                </uix:flowLayout>
              </uix:cellFormat>
              </uix:rowLayout>
              </uix:tableLayout>

            <uix:tableLayout width="100%" cellSpacing="2">
              <uix:rowLayout vAlign="top">
                <!-- ==================  General Section ============= -->

                  <uix:header textBinding="GENERAL@DBMsgBundle@servletRequest">
                    <uix:rowLayout>
                        <uix:cellFormat hAlign="left" vAlign="top">
                            <uix:image sourceBinding="trafficImage@racClusterBean@servletRequest"/> 
                        </uix:cellFormat>

                        <uix:cellFormat>
                        <uix:tableLayout hAlign="left" cellSpacing="1">
                            <uix:rowLayout>
                              <uix:cellFormat hAlign="right" vAlign="top" wrappingDisabled="true">
                                <uix:styledText styleClass="OraPromptText" textBinding="CURRENT_STATUS@racMsgBundle@servletRequest"/>
                              </uix:cellFormat>
                              <uix:cellFormat>
                              <uix:spacer width="8"/>
                                <oem:license>
                                <uix:link destinationBinding="availDest@servletRequest"
                                          textBinding="trafficStatusStr@racClusterBean@servletRequest"/>
                                </oem:license>
                                </uix:cellFormat>  
                              
                                <uix:cellFormat hAlign="right" vAlign="top">
                                    <uix:button textBinding="changeStateButtonLabel@servletRequest"
                                                shortDescBinding="changeStateButtonLabel@servletRequest"
                                                destinationBinding="changeStateURL@servletRequest"
                                                renderedBinding="CRSVersion112OrHigher@racClusterBean@servletRequest" />
                                    <uix:spacer width="5"/>
                                  <oem:license>
                                   <uix:button textBinding="END_BLACKOUT@SDKBundle@servletRequest"
                                    shortDescBinding="END_BLACKOUT@SDKBundle@servletRequest"
                                    destinationBinding="blackoutsLinkDest@servletRequest"
                                    renderedBinding="isStopBlackout@servletRequest"/>
                                  </oem:license>
                                  <oem:license>
                                  <uix:button textBinding="CREATE_BLACKOUT@SDKBundle@servletRequest"
                                    shortDescBinding="CREATE_BLACKOUT@SDKBundle@servletRequest"
                                    destinationBinding="blackoutsLinkDest@servletRequest"
                                    renderedBinding="isCreateBlackout@servletRequest" />
                                  </oem:license>
                                </uix:cellFormat>
                            </uix:rowLayout>

                            <uix:rowLayout>
                              <uix:cellFormat hAlign="right" vAlign="top"  wrappingDisabled="true">
                                <uix:styledText styleClass="OraPromptText" 
                                                textBinding="HOST_COMPONENTS@racMsgBundle@servletRequest"
                                                />
                              </uix:cellFormat>
                              
                              <uix:cellFormat hAlign="left">
                              <uix:spacer width="8"/>
                              <uix:link  textBinding="totalInstanceCount@racClusterBean@servletRequest"
                                         destination="#instances"/>
                              
                              <uix:spacer width="8"/>
                              <uix:styledText styleClass="OraDataText" text="( "/>
                                    
                              <uix:flowLayout renderedBinding="showUpInstCount@racClusterBean@servletRequest">
                                <uix:image sourceBinding="upInstIconSource@racClusterBean@servletRequest"
                                           shortDescBinding="upStatusShortDesc@racClusterBean@servletRequest" />
                                <uix:styledText styleClass="OraDataText"
                                                textBinding="upInstCount@racClusterBean@servletRequest"/>
                              </uix:flowLayout>

                              <uix:flowLayout renderedBinding="showDownInstCount@racClusterBean@servletRequest">
                                <uix:image sourceBinding="downInstIconSource@racClusterBean@servletRequest"
                                           shortDescBinding="downStatusShortDesc@racClusterBean@servletRequest" />
                                <uix:styledText styleClass="OraDataText"
                                                textBinding="downInstCount@racClusterBean@servletRequest"/>
                                </uix:flowLayout>

                              <uix:flowLayout renderedBinding="showUnreachableInstCount@racClusterBean@servletRequest">
                                <uix:image sourceBinding="unreachableInstIconSource@racClusterBean@servletRequest"
                                           shortDescBinding="unreachableStatusShortDesc@racClusterBean@servletRequest" />
                                <uix:spacer width="3"/>
                                <uix:styledText styleClass="OraDataText"
                                                textBinding="unreachableInstCount@racClusterBean@servletRequest"/>
                              </uix:flowLayout>

                              <uix:flowLayout renderedBinding="showErrorInstCount@racClusterBean@servletRequest">
                                <uix:image sourceBinding="errorInstIconSource@racClusterBean@servletRequest"
                                           shortDescBinding="errorStatusShortDesc@racClusterBean@servletRequest" />
                                <uix:spacer width="3"/>
                                <uix:styledText styleClass="OraDataText"
                                                textBinding="errorInstCount@racClusterBean@servletRequest"/>
                              </uix:flowLayout>

                              <uix:flowLayout renderedBinding="showBlackoutInstCount@racClusterBean@servletRequest">
                                <uix:image sourceBinding="blackoutInstIconSource@racClusterBean@servletRequest"
                                           shortDescBinding="blackoutStatusShortDesc@racClusterBean@servletRequest" />
                                <uix:spacer width="3"/>
                                <uix:styledText styleClass="OraDataText"
                                                textBinding="blackoutInstCount@racClusterBean@servletRequest"/>
                              </uix:flowLayout>

                              
                              <uix:flowLayout renderedBinding="showAgentDownInstCount@racClusterBean@servletRequest">
                                <uix:image sourceBinding="agentDownInstIconSource@racClusterBean@servletRequest"
                                           shortDescBinding="agentDownStatusShortDesc@racClusterBean@servletRequest" />
                                <uix:spacer width="3"/>
                                <uix:styledText styleClass="OraDataText"
                                                textBinding="agentDownInstCount@racClusterBean@servletRequest"/>
                              </uix:flowLayout>

                              <uix:flowLayout renderedBinding="showUnknownInstCount@racClusterBean@servletRequest">
                                <uix:image sourceBinding="unknownInstIconSource@racClusterBean@servletRequest"
                                           shortDescBinding="unknownStatusShortDesc@racClusterBean@servletRequest" />
                                <uix:spacer width="3"/>
                                <uix:styledText styleClass="OraDataText"
                                                textBinding="unknownInstCount@racClusterBean@servletRequest"/>
                              </uix:flowLayout> 
                              <uix:styledText styleClass="OraDataText" text=" )"/>
                              </uix:cellFormat>  
                            </uix:rowLayout>

<%--
                            <uix:rowLayout>
                              <uix:cellFormat hAlign="right" vAlign="top">
                                <uix:styledText styleClass="OraPromptText" 
                                                textBinding="UP_NODES@racMsgBundle@servletRequest"/>
                              </uix:cellFormat>
                              
                              <uix:cellFormat>
                              <uix:spacer width="8"/>
                              <uix:styledText styleClass="OraDataText" 
                                              textBinding="upNodes@racClusterBean@servletRequest"/>
                               </uix:cellFormat> 
                            </uix:rowLayout>
--%>
                            <uix:rowLayout>
                              <uix:cellFormat hAlign="right" vAlign="top"  wrappingDisabled="true">
                                <uix:styledText styleClass="OraPromptText" 
                                                textBinding="AVAILABILITY@DBMsgBundle@servletRequest"/>
                              </uix:cellFormat>
                              <uix:cellFormat>
                              <uix:spacer width="8"/>
                                <oem:license>
                                <uix:link textBinding="trafficAvailStr@racClusterBean@servletRequest"
                                            destinationBinding="availDest@servletRequest"/>
                                </oem:license>
                              </uix:cellFormat>
                              </uix:rowLayout>

                            <uix:rowLayout>
                              <uix:cellFormat/>

                              <uix:cellFormat> 
                                  <uix:spacer width="8"/>
                                  <uix:styledText styleClass="OraInlineInfoText"
                                    text="(" />
                                  <uix:styledText styleClass="OraInlineInfoText"
                                    textBinding="LAST_DAY@SDKBundle@servletRequest" />
                                  <uix:styledText styleClass="OraInlineInfoText"
                                    text=")" />
                              </uix:cellFormat>  
                            </uix:rowLayout>

                            <uix:rowLayout renderedBinding="CRSHomeSet@racClusterBean@servletRequest">
                              <uix:cellFormat hAlign="right" vAlign="top"  wrappingDisabled="true">
                                <uix:styledText styleClass="OraPromptText" 
                                                textBinding="CLUSTER_NAME@racMsgBundle@servletRequest"/>
                              </uix:cellFormat>
                              <uix:cellFormat>
                              <uix:spacer width="8"/>
                              <uix:styledText styleClass="OraDataText" 
                                              textBinding="clusterName@racClusterBean@servletRequest"/>
                              </uix:cellFormat>
                            </uix:rowLayout>

                          <!-- CRS Status -->
                            <uix:rowLayout renderedBinding="crsStatusShowing@racClusterBean@servletRequest">
                              <uix:cellFormat hAlign="right" vAlign="top"  wrappingDisabled="true">
                                <uix:styledText styleClass="OraPromptText" 
                                                textBinding="CLUSTERWARE_STATUS@racMsgBundle@servletRequest"/>
                              </uix:cellFormat>
                              <uix:cellFormat>
                              <uix:spacer width="8"/>
                                <uix:include nodeBinding="CRSStatusUINode@servletRequest"/>
                              </uix:cellFormat>
                            </uix:rowLayout>

                            <uix:rowLayout renderedBinding="CRSHomeSet@racClusterBean@servletRequest">
                              <uix:cellFormat hAlign="right" vAlign="top"  wrappingDisabled="true">
                                <uix:styledText styleClass="OraPromptText" 
                                                textBinding="CRS_VERSION@racMsgBundle@servletRequest"/>
                              </uix:cellFormat>
                              <uix:cellFormat>
                              <uix:spacer width="8"/>
                              <uix:styledText styleClass="OraDataText" 
                                              textBinding="CRSVersion@racClusterBean@servletRequest"/>
                              </uix:cellFormat>
                            </uix:rowLayout>

                            <uix:rowLayout renderedBinding="CRSHomeSet@racClusterBean@servletRequest">
                              <uix:cellFormat hAlign="right" vAlign="top">
                                <uix:styledText styleClass="OraPromptText" 
                                                textBinding="CRS_HOME@racMsgBundle@servletRequest"/>
                              </uix:cellFormat>
                              <uix:cellFormat>
                              <uix:spacer width="8"/>
                              <uix:styledText styleClass="OraDataText" 
                                              textBinding="CRSHome@racClusterBean@servletRequest"/>
                               </uix:cellFormat> 
                            </uix:rowLayout>

                          <uix:rowLayout renderedBinding="showSvcsImpacted@svcImpBean@servletRequest">         		      
                            <uix:cellFormat hAlign="right" wrappingDisabled="true">
                              <uix:styledText styleClass="OraPromptText" textBinding="label@svcImpBean@servletRequest" />
                            </uix:cellFormat>
                            <uix:spacer width="8"/>
                            <uix:link textBinding="value@svcImpBean@servletRequest" 
                                      destinationBinding="destination@svcImpBean@servletRequest" />
                          </uix:rowLayout>
                          
                            <!-- Link Reconfiguration  activity Info -->
                          <uix:rowLayout renderedBinding="reconfigActivityExist@servletRequest">
                            <uix:cellFormat hAlign="right">
                             <uix:styledText styleClass="OraPromptText" textBinding="RECONFIGURATION_ACTIVITY@racMsgBundle"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                            <uix:spacer width="8"/>
                             <uix:link textBinding="reconfigActivityCount@servletRequest" destinationBinding="reconfigActivityPageURL@servletRequest" shortDescBinding="RECONFIGURATION_ACTIVITY@racMsgBundle"/>
                            <uix:spacer width="8"/>
                              <uix:flowLayout renderedBinding="pendingNodeExist@servletRequest">
                                  <uix:styledText styleClass="OraDataText" text="( "/>
                                  <uix:link textBinding="pendingNodeCount@servletRequest"  shortDescBinding="CONFIG_HOST@racMsgBundle"
                                            destinationBinding="pendingNodeAddPage@servletRequest"/>
                                  <uix:styledText styleClass="OraDataText" text=" )"/>
                                   
                              </uix:flowLayout>
                            </uix:cellFormat>
                           </uix:rowLayout> 
                           <uix:spacer height="15"/> 
                          <uix:rowLayout >
                          <uix:cellFormat hAlign="right"  vAlign="top"  />
                          <uix:cellFormat>
                          <uix:spacer width="8"/>
                          <uix:link 
                          textBinding="VIEW_ALL_PROPERTIES@DBMsgBundle@servletRequest"
                           destinationBinding="viewPropDest@servletRequest"
                           /> 
                            </uix:cellFormat>
                         </uix:rowLayout>
                         </uix:tableLayout>

                      <!-- ================= end of table of General info ============= -->
                    </uix:cellFormat>  

                    </uix:rowLayout>
                  </uix:header>  
                  
                  <uix:header textBinding="CONFIGURATION@DBMsgBundle@servletRequest">
                      <uix:tableLayout hAlign="left">

                        <uix:rowLayout renderedBinding="showVendorCW@racClusterBean@servletRequest" >
                        <uix:tableLayout>
                              <uix:rowLayout>
                              <uix:cellFormat hAlign="right" vAlign="top"  wrappingDisabled="true">
                                <uix:styledText styleClass="OraPromptText" 
                                                textBinding="CLUSTER_VER@racMsgBundle@servletRequest"/>
                              </uix:cellFormat>
                              <uix:cellFormat>
                                <uix:spacer width="8"/>
                              </uix:cellFormat>  
                              <uix:styledText styleClass="OraDataText" 
                                              textBinding="CWVersion@racClusterBean@servletRequest"/>
                            </uix:rowLayout>
                       </uix:tableLayout>  
                        </uix:rowLayout>
                        
                        <uix:rowLayout>
                            <uix:spacer height="5"/>
                        </uix:rowLayout>

                        <uix:rowLayout>
                        <uix:cellFormat columnSpan="3">
                            <uix:include nodeBinding="configTable@racClusterBean@servletRequest"/>
                        </uix:cellFormat>    
                        </uix:rowLayout>    

                      </uix:tableLayout>
                  </uix:header>
              </uix:rowLayout>

              <uix:rowLayout>

                <%-- Diagnostic Summary --%>
                <uix:cellFormat vAlign="top">
                <uix:header textBinding="DIAGNOSTIC_SUMMARY@DBMsgBundle@servletRequest"
                    renderedBinding="agentVersion10104OrHiger@racClusterBean@servletRequest">
                  <uix:stackLayout>
                    <uix:tableLayout>
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right"  vAlign="top"  wrappingDisabled="true">
                        <uix:styledText styleClass="OraPromptText" 
                                        textBinding="IC_FINDINGS@racMsgBundle@servletRequest"/>
                      </uix:cellFormat>

                         <uix:cellFormat>
                         <uix:spacer width="10"/>
                         </uix:cellFormat>
                         <uix:cellFormat>
                         <uix:image 
                           sourceBinding="intrconnFlag@servletRequest" 
                           renderedBinding="showRacIntrconnStatus@racClusterBean@servletRequest"/>
                         </uix:cellFormat>
                         <uix:cellFormat>
                         <uix:spacer width="10"/>
                         </uix:cellFormat>
                      
                      <uix:cellFormat>
                      <oem:license>
                        <uix:link textBinding="racInterconnectAlerts@racClusterBean@servletRequest" 
                                destinationBinding="interconnDest@servletRequest" />
                      </oem:license>
                      </uix:cellFormat>          
                    </uix:rowLayout>
                  </uix:tableLayout>
                </uix:stackLayout>
               </uix:header>
              </uix:cellFormat>  


              <uix:cellFormat>  

                <%-- Resource Summary --%>
                <uix:header textBinding="RESOURCE_SUMMARY@racMsgBundle@servletRequest"
                    renderedBinding="crsVersion11gTBOrHigher@racClusterBean@servletRequest">
                  <uix:stackLayout>
                    <uix:tableLayout>

                    <uix:rowLayout>

                      <uix:cellFormat hAlign="right"  vAlign="top"  wrappingDisabled="true">
                       <uix:styledText styleClass="OraPromptText" textBinding="RESOURCE_PROBLEM@racMsgBundle@servletRequest"/>
                      </uix:cellFormat>

                      <uix:cellFormat renderedBinding="noResourceProblems@racClusterBean@servletRequest">
                       <uix:spacer width="10"/>
                       <uix:image sourceBinding="intrconnFlag@servletRequest"
                                           shortDescBinding="resourcesNoProblemShortDesc@racClusterBean@servletRequest" />
                       <uix:link destinationBinding="manageResUrl@servletRequest" text="0"/>
                      </uix:cellFormat>

                      <uix:cellFormat renderedBinding="resourceCritical@racClusterBean@servletRequest">
                       <uix:spacer width="10"/>
                       <uix:image sourceBinding="criticalImage@servletRequest"
                                           shortDescBinding="resourcesCriticalShortDesc@racClusterBean@servletRequest" />
                       <uix:link destinationBinding="manageResUrl@servletRequest"
                                 textBinding="resourcesCriticalSummary@racClusterBean@servletRequest"/>
                      </uix:cellFormat>

                      <uix:cellFormat renderedBinding="resourceWarning@racClusterBean@servletRequest">
                       <uix:spacer width="10"/>
                       <uix:image sourceBinding="warningImage@servletRequest"
                                           shortDescBinding="resourcesWarningShortDesc@racClusterBean@servletRequest" />
                       <uix:spacer width="2"/>
                       <uix:link destinationBinding="manageResUrl@servletRequest"
                                 textBinding="resourcesWarningSummary@racClusterBean@servletRequest"/>
                      </uix:cellFormat>

                    </uix:rowLayout>

                  </uix:tableLayout>
                </uix:stackLayout>
               </uix:header>

              </uix:cellFormat>  

              </uix:rowLayout>  

            </uix:tableLayout>


            <uix:header textBinding="CLUSTER_DATABASE_LIST@racMsgBundle@servletRequest">
              <uix:tableLayout width="100%" >       
<uix:rowLayout renderedBinding="CRSVersion10iOrHigher@racClusterBean@servletRequest">
<uix:cellFormat hAlign="left">
                   <uix:flowLayout>
                     <uix:messagePrompt promptBinding="VIEW@DBMsgBundle@servletRequest" 
                                        labeledNodeId="dbServicesViewSwitcherID" />
          
                     <uix:choice name="dbServicesView" id="dbServiceViewSwitcherID"
                                 selectedValueBinding="dbServicesView@racClusterBean@servletRequest"
                                 shortDescBinding="VIEW@DBMsgBundle@servletRequest"
                                 onChange="submitForm('alertsForm', true, {'event':'changeDbServiceView'})">
                         <uix:option textBinding="DB_VIEW@racMsgBundle@servletRequest" value="DB_VIEW" />
                         <uix:option textBinding="SERVICES_VIEW@racMsgBundle@servletRequest" value="SERVICES_VIEW" />
                     </uix:choice>
</uix:flowLayout>
</uix:cellFormat>
</uix:rowLayout>
<uix:rowLayout>
      <uix:rawText>
        <a name="FRA" id="SERVICES"/>
      </uix:rawText>    
</uix:rowLayout>
                <uix:rowLayout>              
<uix:switcher childNameBinding="dbServicesView@racClusterBean@servletRequest">
<uix:case name="DB_VIEW">

                  <oem:table name="racDBDataSource" width="100%"                          
                             summaryBinding="CLUSTER_DATABASE_LIST@racMsgBundle@servletRequest"
                             partialRenderMode="self"
                             id="racdbsTable"
                             formSubmitted="true"                           
                             beanKey="racClusterBean"                           
                             dataSourceProp="racDBDataSource"
                             blockSize="5"                           
                             alternateText="No Cluster Databases.">
                  </oem:table>            
</uix:case>
<uix:case name="SERVICES_VIEW">
                      <uix:hGrid id="clusterDatabases"
                           width="100%"
			   alternateTextBinding="NO_DATA_ALT@racMsgBundle@servletRequest"
			   treeDataBinding="racDBsTree@racClusterBean@servletRequest"
			   formSubmitted="true"
			   proxyBinding="proxy@racClusterBean@servletRequest"
         summaryBinding="CLUSTER_DATABASE_LIST@racMsgBundle@servletRequest">

			  <uix:nodeStamp>
			    <uix:column>
			      <uix:columnHeader>
      				<uix:styledText textBinding="DBNAME_SERVICENAME@racMsgBundle@servletRequest"/>
			      </uix:columnHeader>
            <uix:styledText textBinding="name" destinationBinding="name_url" inlineStyleBinding="warningStyleText"/> 
			    </uix:column>
			  </uix:nodeStamp>
			  
			  <uix:column>
<uix:columnFormat/>
			    <uix:columnHeader>
			      <uix:styledText textBinding="STATUS@racMsgBundle@servletRequest"/>
			    </uix:columnHeader>
          <uix:image sourceBinding="statusIconUri" destinationBinding="statusIconUrl" hAlign="center"/>
			  </uix:column>
			  <uix:column>
			    <uix:columnHeader>
			      <uix:styledText textBinding="NUM_OF_ALERTS@racMsgBundle@servletRequest"/>
			    </uix:columnHeader>
             <uix:include nodeBinding="alerts"/>
			  </uix:column>	

			  <%-- uix:column>
			    <uix:columnHeader>
			      <uix:styledText textBinding="VIOLATIONS@racMsgBundle@servletRequest"/>
			    </uix:columnHeader>
             <uix:include nodeBinding="policy_violations"/>
			  </uix:column>	

			  <uix:column>
			    <uix:columnHeader>
			      <uix:styledText textBinding="POLICY_COMPLIANCE@racMsgBundle@servletRequest"/>
			    </uix:columnHeader>
             <uix:styledText textBinding="compliance"/>
			  </uix:column>	

			  <uix:column>
			    <uix:columnHeader>
			      <uix:styledText textBinding="VERSION@racMsgBundle@servletRequest"/>
			    </uix:columnHeader>
             <uix:styledText textBinding="version"/>
			  </uix:column --%>	

</uix:hGrid>
</uix:case>
</uix:switcher>


                  </uix:rowLayout>               
                </uix:tableLayout>           
            </uix:header>     

            <%-- ........... Oracle File Systems ............... --%>
            <uix:dataScope currentDataBinding="racOFSDataSource@racClusterBean@servletRequest">
            <uix:header textBinding="ORACLE_FILE_SYSTEMS@ofsMsg"
                        renderedBinding="<%= RacClusterOFSDataSource.S_SHOW_SERVICED_OFS %>">
              <uix:tableLayout width="100%"> 
                <uix:rowLayout>
                  <uix:table summaryBinding="ORACLE_FILE_SYSTEMS@ofsMsg" 
		      		               width="100%" 
                             formSubmitted="true"
                             id="racOFSDataSource"
                             tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                             valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                             maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                             blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>"
                             partialRenderMode="self"
                             showAll="yes"
                             alternateText="No OFS Found">
      
                    <uix:tableFormat tableBanding="rowBanding"/>
                    <%--
                    <uix:tableSelection>
                      <uix:singleSelection shortDesc="Select" selectedIndex="0"/>
                    </uix:tableSelection>
                    --%>
                    <%-- Mount Point --%>
                    <uix:column>
                      <uix:columnHeader>
                        <uix:sortableHeader textBinding="MOUNT_POINT@ofsMsg"
                                            sortableBinding="<%= RacClusterOFSDataSource.S_SORT_MPT_COL%>" />
                      </uix:columnHeader>
                      <uix:columnFormat columnDataFormat="textFormat"/>
                        <uix:link textBinding="<%= RacClusterOFSDataSource.S_MPT_COL %>"
                                  destinationBinding="<%= RacClusterOFSDataSource.S_MOUNT_POINT_DEST %>"/>
                    </uix:column>

                    <%-- Availability --%>
                    <uix:columnGroup>
                      <uix:columnHeader>
                        <uix:styledText textBinding="AVAILABILITY@ofsMsg"/>
                      </uix:columnHeader>
                      <uix:contents>
                    
                        <%-- Up column --%>
                        <uix:column>
                          <uix:columnHeader>
                            <uix:sortableHeader textBinding="UP@ofsMsg"
                                                sortableBinding="<%= RacClusterOFSDataSource.S_SORT_UP_AVAIL_COL%>">
                              <uix:contents>
                                <uix:image source="/em/images/up.gif"
                                           height="15"
                                           shortDesc="Up"/>
                              </uix:contents>
                            </uix:sortableHeader>

                          </uix:columnHeader>
                          <uix:columnFormat columnDataFormat="numberFormat"/>
                          <uix:styledText textBinding="<%= RacClusterOFSDataSource.S_UP_AVAIL_COL%>"/>
                        </uix:column>
          
                        <%-- Down column --%>
                        <uix:column>
                          <uix:columnHeader>
                            <uix:sortableHeader textBinding="DOWN@ofsMsg"
                                                sortableBinding="<%= RacClusterOFSDataSource.S_SORT_DOWN_AVAIL_COL %>">
                              <uix:contents>
                                <uix:image source="/em/images/down.gif"
                                           height="15"
                                           shortDesc="Down"/>
                              </uix:contents>
                            </uix:sortableHeader>
                          </uix:columnHeader>
                          <uix:columnFormat columnDataFormat="numberFormat"/>
                          <uix:styledText textBinding="<%= RacClusterOFSDataSource.S_DOWN_AVAIL_COL %>"/>
                        </uix:column>
                      </uix:contents>
                    </uix:columnGroup>
      
      
                    <uix:columnGroup>
                      <uix:columnHeader>
                        <uix:styledText textBinding="STATE@ofsMsg"/>
                      </uix:columnHeader>
                      <uix:contents>
                        <%-- Mounted column --%>
                        <uix:column>
                          <uix:columnHeader>
                            <uix:sortableHeader textBinding="MOUNTED@ofsMsg"
                                                sortableBinding="<%= RacClusterOFSDataSource.S_SORT_STATE_MNT_COL %>" />
                          </uix:columnHeader>
                          <uix:columnFormat columnDataFormat="numberFormat"/>
                          <uix:styledText textBinding="<%= RacClusterOFSDataSource.S_STATE_MNT_COL %>"/>
                        </uix:column>
      
                        <%-- Dismounted column --%>
                        <uix:column>
                          <uix:columnHeader>
                            <uix:sortableHeader textBinding="DISMOUNTED@ofsMsg"
                                                sortableBinding="<%= RacClusterOFSDataSource.S_SORT_STATE_DMNT_COL %>" />
                          </uix:columnHeader>
                          <uix:columnFormat columnDataFormat="numberFormat"/>
                          <uix:contents>
                            <uix:flowLayout>
                              <uix:styledText textBinding="<%= RacClusterOFSDataSource.S_STATE_DMNT_COL %>"/>
                                        <%-- destination="<%= RacClusterOFSDataSource.S_ASM_DEST %>"/ --%>
                            </uix:flowLayout>
                          </uix:contents>
                        </uix:column>
                      </uix:contents>
                    </uix:columnGroup>
      
      
                    <%-- Alerts --%>
                    <uix:columnGroup>
                      <uix:columnHeader>
                        <uix:styledText textBinding="ALERTS@ofsMsg"/>
                      </uix:columnHeader>
                      <uix:contents>
                        <uix:column>
                          <uix:columnHeader>
                            <uix:sortableHeader textBinding="MESSAGE_TYPE_WARNING@ofsMsg"
                                                sortableBinding="<%= RacClusterOFSDataSource.S_SORT_WNG_ALERT_COL %>" />
                          </uix:columnHeader>
                          <uix:columnFormat columnDataFormat="numberFormat"/>
                            <uix:styledText textBinding="<%= RacClusterOFSDataSource.S_WNG_ALERT_COL %>"/>
                        </uix:column>

                        <uix:column>
                         <uix:columnHeader>
                           <uix:sortableHeader textBinding="MESSAGE_TYPE_CRITICAL@ofsMsg"
                                               sortableBinding="<%= RacClusterOFSDataSource.S_SORT_CRT_ALERT_COL %>" />
                         </uix:columnHeader>
                         <uix:columnFormat columnDataFormat="numberFormat"/>
                           <uix:styledText textBinding="<%= RacClusterOFSDataSource.S_CRT_ALERT_COL %>"/>
                       </uix:column>
                     </uix:contents>
                   </uix:columnGroup>


                    <uix:columnGroup>
                      <uix:columnHeader>
                        <uix:styledText textBinding="SPACE_USAGE@ofsMsg"/>
                      </uix:columnHeader>
                      <uix:contents>

                    <%-- Size (GB)--%>
                    <uix:column>
                      <uix:columnHeader>
                        <uix:sortableHeader textBinding="SIZE_GB@ofsMsg"
                                            sortableBinding="<%= RacClusterOFSDataSource.S_SORT_SIZE_GB_COL %>" />
                      </uix:columnHeader>
                      <uix:columnFormat columnDataFormat="numberFormat"/>
                      <uix:styledText textBinding="<%= RacClusterOFSDataSource.S_SIZE_GB_COL %>"/>
                    </uix:column>
      
      
                    <%-- Used (GB) --%>
                    <uix:column>
                      <uix:columnHeader>
                        <uix:sortableHeader textBinding="USED_GB@ofsMsg"
                                            sortableBinding="<%= RacClusterOFSDataSource.S_SORT_USED_GB_COL %>" />
                      </uix:columnHeader>
                      <uix:columnFormat columnDataFormat="numberFormat"/>
                      <uix:styledText textBinding="<%= RacClusterOFSDataSource.S_USED_GB_COL %>"/>
                    </uix:column>
      
                    <%-- Used (%) --%>
                    <uix:column>
                      <uix:columnHeader>
                        <uix:sortableHeader textBinding="USED_PERCENTAGE@ofsMsg"
                                            sortableBinding="<%= RacClusterOFSDataSource.S_SORT_USED_PCT_COL %>" />
                      </uix:columnHeader>
                      <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                      <uix:flowLayout>
                        <uix:separator>
                          <uix:spacer width="1" height="0"/>
                        </uix:separator>
                        <uix:contents>
                          <uix:include nodeBinding="<%= RacClusterOFSDataSource.S_USED_PCT_COL_IMG %>"/>
                          <uix:styledText textBinding="<%= RacClusterOFSDataSource.S_USED_PCT_COL %>"/>
                        </uix:contents>
                      </uix:flowLayout>
                    </uix:column>

                    </uix:contents>
                    </uix:columnGroup>
      
                  </uix:table>
                  
                </uix:rowLayout>
              </uix:tableLayout>
            </uix:header>
            </uix:dataScope> 

            <%-- END: Oracle File Systems --%>
      
      
      
        <%--
        <uix:header textBinding="ALERTS_HEADER@DBMsgBundle@servletRequest" >
        --%>

        <uix:hideShowHeader textBinding="ALERTS_HEADER@DBMsgBundle@servletRequest" 
                            id="clshideShowAlertsTableHeader" 
                            partialRenderMode="self"
                            formSubmitted="true"
                            disclosedBinding="ClsDiscloseHideShowAlerts@servletRequest" >
         
         <uix:tableLayout width="100%">
              <uix:rowLayout >
                <uix:cellFormat hAlign ="left">

                   <uix:flowLayout>
                     <uix:messagePrompt promptBinding="CATEGORY@DBMsgBundle@servletRequest" 
                                        labeledNodeId="alersFilterID" />
          
                     <uix:choice name="alertsFilter" id="alersFilterID"
                                 shortDescBinding="CATEGORY@DBMsgBundle@servletRequest"
                                 selectedValueBinding="alertsFilter@racClusterBean@servletRequest" 
                                 onChange="submitForm('alertsForm', true, {'event':'filterAlerts'})">
                       <uix:contents childDataBinding="alertsFilterList@racClusterBean@servletRequest">
                         <uix:option textBinding="text" valueBinding="value" />
                       </uix:contents>
                     </uix:choice>  

                     <uix:spacer width="10"/>

                  <%-- Critical Alert Count --%>
                      <uix:styledText 
                        styleClass="OraPromptText"
                        textBinding="ALERT_CRITICAL@DBMsgBundle@servletRequest" />
           
                     <uix:spacer width="10"/>
            
                     <uix:switcher childNameBinding="hasAlertCritical@servletRequest">
                       <uix:case name="true">
                         <uix:image 
                           sourceBinding="criticalImage@servletRequest" />
                       </uix:case>
                       <uix:case name="false">
                         <uix:image sourceBinding="nothing@servletRequest"/>
                       </uix:case>
                     </uix:switcher>
            
                     <uix:spacer width="10"/>

                     <uix:link 
                       textBinding="alertCriticalCount@servletRequest"
                       destinationBinding="alertCriticalLink@servletRequest" />

                     <uix:spacer width="10"/>

                   <%-- Warning Alert Count --%>
                     <uix:styledText 
                         styleClass="OraPromptText"
                         textBinding="ALERT_WARNINGS@DBMsgBundle@servletRequest" />
            
                     <uix:spacer width="10"/>
            
                     <uix:switcher childNameBinding="hasAlertWarning@servletRequest">
                       <uix:case name="true">
                         <uix:image 
                           sourceBinding="warningImage@servletRequest" />
                       </uix:case>
                       <uix:case name="false">
                         <uix:image sourceBinding="nothing@servletRequest"/>
                       </uix:case>
                     </uix:switcher>
            
                     <uix:spacer width="10"/>

                     <uix:link 
                       textBinding="alertWarningCount@servletRequest"
                       destinationBinding="alertWarningLink@servletRequest" />
                   </uix:flowLayout>    
                </uix:cellFormat>
                <uix:cellFormat hAlign="right">
                </uix:cellFormat>
              </uix:rowLayout>
              </uix:tableLayout>

            
              <uix:tableLayout width="100%" >       

                <uix:rowLayout>              
                  <oem:table name="racAlertsDataSource" width="100%"    
                             summaryBinding="ALERTS_HEADER@DBMsgBundle@servletRequest"                         
                             formSubmitted="true"                        
                             partialRenderMode="self"   
                             id="alertsTable"
                             beanKey="racClusterBean"                           
                             dataSourceProp="racAlertsDataSource"
                             blockSize="10"                           
                             alternateText="(No Alerts!)">
                  </oem:table>            
                  </uix:rowLayout>               
                </uix:tableLayout>           
            </uix:hideShowHeader>   

            <%-- Security section --%>
	    <uix:include nodeBinding="secNode@servletRequest"/>


	    

            <uix:tableLayout width="100%"  cellSpacing="2">
              <uix:rowLayout vAlign="top"> 
                <uix:cellFormat>
                  <uix:tableLayout>
              <uix:rowLayout> 
            <!-- Job Activity Table -->      
                <uix:ref refID="JOB_ACTIVITY_SEGMENT" />
                    </uix:rowLayout>
                  </uix:tableLayout>
                </uix:cellFormat>

	    <!--  CPF (Bug#3256443) -->
                 <uix:cellFormat>
	        <uix:header textBinding="CRITICAL_PATCH@mntrResourceBundle">
        	  <uix:contents>
        	    <uix:include nodeBinding="EcmPatch@servletRequest"/>
		  </uix:contents>
		</uix:header>
</uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>
            
            <uix:spacer height="15"/>
          </uix:subTabLayout>
          <uix:spacer height="5"/>

        </uix:header>

       <uix:rawText>
          <a name="instances">
       </uix:rawText>

          <%@ include file="comp.jspf" %>
          <oem:relatedLinks/> 

        </db:form>
      </uix:pageLayout>
    </uix:body>

  </uix:document> 
</uix:renderingContext> 

