<%-- 
 * Copyright (c) 2006, 2009, Oracle and/or its affiliates.All rights reserved. 
 *
 *      NAME
 *        perform.jsp 
 *
 *      NOTES
 *        tbd
 *       
 * MODIFIED
 *    shasingh   12/22/08 - bug 7658666
 *    gapadman   10/03/08 - remove admintab
 *    rsamaved   08/11/08 - 
 *    gapadman   07/17/08 - 
 *    pboopath   03/18/08 - Flex to avoid full page refresh
 *    dchakumk   03/10/08 - XbranchMerge dchakumk_6752_xbmsrc from
 *                          st_emdbsa_11.1
 *    pboopath   02/27/08 - 
 *    gapadman   02/13/08 - remove cluster verion check
 *    pboopath   01/21/08 - XbranchMerge pboopath_bug-6737679 from main
 *    aime       01/20/08 - 
 *    gapadman   01/14/08 - remove related links
 *    pboopath   01/10/08 - adding flex only for svg
 *    pboopath   12/12/07 - Flex changes
 *    kramarat   10/18/07 - Remove tabs
 *    kmckeen    01/22/07 - Add summary chart customize option
 *    kmckeen    12/21/06 - UI review - switch tile/top radio buttons
 *    kmckeen    12/06/06 - Fix various ui issues - refresh URL
 *    kmckeen    11/30/06 - Fix oac/ui issues
 *    pboopath   11/21/06 - SVG in IE(5663821)
 *    pboopath   11/16/06 - Bug 5663821
 *    kramarat   09/12/06 - Admin tab for crs 11gTB or higher
 *    ezeng      09/14/06 - Switch from oem:lineGraph to db:lineGraph
 *    kmckeen    09/06/06 - Fix refresh problem with summary chart
 *    kmckeen    06/03/06 - Updates to support tile charts
--%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 

<uix:renderingContext id="renderingContext">  
  <oem:setURLEncoder id="renderingContext"/> 

<uix:switcher childNameBinding="chartType@servletRequest">
  <uix:case name="topChart">
    <uix:switcher childNameBinding ="useSVG@servletRequest">
      <uix:case name="false">
        <uix:switcher childNameBinding="manualSelected@servletRequest">
          <uix:case name="false">
            <uix:rawText>
              <meta http-equiv="Refresh" 
               content="<%=request.getAttribute("refreshChoice")%>; URL=<%=request.getAttribute("refreshDest")%>" >
            </uix:rawText>
          </uix:case>
        </uix:switcher>
      </uix:case>
    </uix:switcher>
  </uix:case>
  <uix:case name="tileChart">
    <uix:switcher childNameBinding ="useSVG@servletRequest">
      <uix:case name="false">
        <uix:switcher childNameBinding="manualSelected@servletRequest">
          <uix:case name="false">
            <uix:rawText>
              <meta http-equiv="Refresh" 
               content="<%=request.getAttribute("refreshChoice") %>" >
            </uix:rawText>
          </uix:case>
        </uix:switcher>
      </uix:case>
    </uix:switcher>
  </uix:case>
</uix:switcher>

  <uix:document> 

    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>

      <db:form name="cperfForm" method="post" destination="/console/rac/cluster/racClusterSitemap"
               copyParams="target,type,isRepDown">
        <uix:formValue name="pageNum" value="2" />
                
        <uix:pageLayout>
          <%@ include file="/oemGlobal.jspf" %>
          <uix:header textBinding="header@racClusterBean@servletRequest"
                      icon="<%= request.getContextPath() + \"/images/database/rac/hostcluster.gif\" %>" >
            <uix:stackLayout>

            <uix:tableLayout width="100%" >
              <uix:rowLayout hAlign="right">
                <%@ include file="../refreshTime.jspf" %>
              </uix:rowLayout>
            </uix:tableLayout>

            <uix:subTabLayout>
              <uix:subTabs>
                <uix:subTabBar selectedIndex="1">
                  <uix:link textBinding="HOME@DBMsgBundle@servletRequest"
                            destinationBinding="overviewDest@servletRequest"
                            disabledBinding="repDown@racClusterBean@servletRequest"/>
                  <uix:link textBinding="PERFORMANCE_HEADER@DBMsgBundle@servletRequest"    
                            disabledBinding="repDown@racClusterBean@servletRequest"/>
                  <uix:link textBinding="TARGETS_TAB@racMsgBundle@servletRequest"
                            destinationBinding="targetsDest@servletRequest"
                            disabledBinding="repDown@racClusterBean@servletRequest"/>
				  <uix:link textBinding="ADMINISTRATION@racMsgBundle@servletRequest"
                            destinationBinding="adminDest@servletRequest"/>
                  <uix:link textBinding="IC_INTERCONNECTS@racMsgBundle@servletRequest"
                            destinationBinding="interconnsDest@servletRequest"
                            renderedBinding="agentVersion10104OrHiger@racClusterBean@servletRequest"
                            disabledBinding="repDown@racClusterBean@servletRequest"/>
                  <uix:link textBinding="TOPOLOGY@racMsgBundle@servletRequest"
                            destinationBinding="topologyDest@servletRequest"
                            disabledBinding="repDown@racClusterBean@servletRequest"/>
                </uix:subTabBar>
              </uix:subTabs>

<uix:tableLayout width="100%">
  <uix:rowLayout>
    <uix:cellFormat
        hAlign="left" vAlign="top" wrappingDisabled="true"
        renderedBinding="renderDetailsMetricsDropdown@servletRequest">
      <uix:flowLayout>
        <uix:styledText
            styleClass="OraFieldText"
            textBinding="detailsMetricsLabel@servletRequest"/>
        <uix:choice
            id="detailsMetric"
            name="detailsMetric"
            selectedValueBinding="detailsMetric@servletRequest"
            shortDescBinding="detailsMetricsLabel@servletRequest"
            onChange="submitForm(document.forms[0], true, {'event':'switchDetailsMetric'})">
          <uix:contents
              childDataBinding="detailsMetrics@servletRequest">
            <uix:option 
                textBinding="text"
                valueBinding="value"/>
          </uix:contents>
        </uix:choice>
      </uix:flowLayout>
    </uix:cellFormat>
    <uix:cellFormat hAlign="right" vAlign="top" wrappingDisabled="true">
      <uix:flowLayout>
        <uix:styledText
            styleClass="OraFieldText"
            textBinding="VIEW_DATA@DBMsgBundle@servletRequest"
            labeledNodeId="refreshChoice"/>
        <uix:choice
            name="refreshChoice"
            id="refreshChoice"
            shortDescBinding="VIEW_DATA@DBMsgBundle@servletRequest"
            onChange="submitForm(document.forms[0], true, {'event':'doLoad','pageNum':'2'})">
          <uix:option
              textBinding="REAL_TIME_AUTO_15_SEC@DBMsgBundle@servletRequest"
              value="15"/>
          <uix:option
              textBinding="REAL_TIME_MANUAL@DBMsgBundle@servletRequest"
              value="-1" selectedBinding="manualSelected@servletRequest"/>
        </uix:choice>
        <%--
        <uix:choice
            name="refreshChoice"
            id="refreshChoice"
            shortDescBinding="VIEW_DATA@DBMsgBundle@servletRequest"
            onChange="submitForm(document.forms[0], true, {'event':'doLoad'})"
            selectedValueBinding="refreshChoiceSelected@servletRequest">
          <uix:option
              textBinding="REAL_TIME_AUTO_15_SEC@DBMsgBundle@servletRequest"
              value="RT_15"/>
          <uix:option
              textBinding="REAL_TIME_1_MIN@DBMsgBundle@servletRequest"
              value="RT_60"/>
          <uix:option
              textBinding="REAL_TIME_MANUAL@DBMsgBundle@servletRequest"
              value="RT_MAN"/>
        </uix:choice>
        --%>
      </uix:flowLayout>
    </uix:cellFormat>
  </uix:rowLayout>
</uix:tableLayout>

<uix:tableLayout width="100%">
  <uix:rowLayout>
    <uix:spacer height="5"/>
  </uix:rowLayout>
</uix:tableLayout>

<uix:tableLayout width="100%">
  <uix:rowLayout>
    <uix:cellFormat hAlign="left" vAlign="top" wrappingDisabled="true">
      <uix:flowLayout>
        <uix:radioSet>
          <uix:radioButton
              name="chartType"
              value="topChart"
              selectedValueBinding="chartType@servletRequest"
              textBinding="TOP_CHART_VIEW@racMsgBundle@servletRequest"
              onClick="submitForm(document.forms[0], true, {'event':'switchChartType', 'chartType':'topChart'})"/>
          <uix:radioButton
              name="chartType"
              value="tileChart"
              selectedValueBinding="chartType@servletRequest"
              textBinding="TILE_CHART_VIEW@racMsgBundle@servletRequest"
              onClick="submitForm(document.forms[0], true, {'event':'switchChartType', 'chartType':'tileChart'})"/>
        </uix:radioSet>
      </uix:flowLayout>
    </uix:cellFormat>
    <uix:cellFormat hAlign="right" vAlign="top" wrappingDisabled="true">
      <uix:flowLayout>
        <uix:submitButton 
            textBinding="CUSTOMIZE_BUTTON@racMsgBundle@servletRequest"
            name="event" 
            value="customizeDetails" 
            shortDescBinding="CUSTOMIZE_BUTTON@racMsgBundle@servletRequest"/>
      </uix:flowLayout>
    </uix:cellFormat>
  </uix:rowLayout>
</uix:tableLayout>

<uix:tableLayout width="100%">
  <uix:rowLayout>
    <uix:spacer height="5"/>
  </uix:rowLayout>
</uix:tableLayout>


<uix:switcher childNameBinding="chartType@servletRequest">
  <uix:case name="tileChart">
  
  <uix:switcher childNameBinding ="useSVG@servletRequest">
    <uix:case name ="false"> 
        <%@ include file="../tileChart.jspf" %>
    </uix:case>
    <uix:case name="true">
            <uix:stackLayout>
                     <db:flexRegion
                            swfName="/rac/flex/racClusterPerfTileChart.swf"
                            dataSrcKeyBinding="flexKey@racClusterBean@servletRequest"
                            optionsBinding="flexClusterMetricChartKeys@servletRequest"
                             windowHeightBinding="flexWindowHeight@racClusterBean@servletRequest"                            
                            windowWidth="100%"
                            idBase="flexClusterMetricChart"/>
            </uix:stackLayout>
    </uix:case>
  </uix:switcher>
  
  </uix:case>
  <uix:case name="topChart">
              <uix:switcher childNameBinding ="useSVG@servletRequest">
                <uix:case name ="false"> 
                  <uix:stackLayout  renderedBinding="notUseSVG@servletRequest">
                    <%@ include file="cpu.jspf" %>
                    <%@ include file="mem.jspf" %>
                    <%@ include file="io.jspf" %>
                  </uix:stackLayout>
                </uix:case>
                <uix:case name="true">
                  <uix:stackLayout>
                     <db:flexRegion
                            swfName="/rac/flex/racClusterPerf.swf"
                            dataSrcKeyBinding="flexKey@racClusterBean@servletRequest"
                            optionsBinding="flexClusterMetricChartKeys@servletRequest"
                            windowHeight="630"
                            windowWidth="100%"
                            idBase="flexClusterMetricChart"/>
                  </uix:stackLayout>
                </uix:case>
              </uix:switcher>
  </uix:case>
</uix:switcher>

              </uix:subTabLayout>
            </uix:stackLayout>
          </uix:header>

         <uix:switcher childNameBinding="repDown@racClusterBean@servletRequest">
           <uix:case name="false">
             <uix:stackLayout>
               <%@ include file="comp.jspf" %>
               <oem:relatedLinks />
             </uix:stackLayout>
           </uix:case>
         </uix:switcher>

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document> 
</uix:renderingContext> 
